/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.bootstrap;

import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.BytecodeTransformer;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.platform.bootstrap.BytecodeTransformerAdapter;
import com.intellij.platform.bootstrap.SimpleVersion;
import com.intellij.platform.ide.bootstrap.StartupErrorReporter;
import com.intellij.util.lang.PathClassLoader;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.system.OS;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"MARKETPLACE_PLUGIN_DIR", "", "MARKETPLACE_BOOTSTRAP_JAR", "findMarketplaceBootDir", "Ljava/nio/file/Path;", "pluginDir", "isMarketplacePluginCompatible", "", "homePath", "mpBoot", "initMarketplace", "", "parseVersion", "Lcom/intellij/platform/bootstrap/SimpleVersion;", "rawText", "parseMinor", "", "text", "intellij.platform.bootstrap"})
public final class MarketplaceKt {
    @NotNull
    private static final String MARKETPLACE_PLUGIN_DIR = "marketplace";
    @NotNull
    private static final String MARKETPLACE_BOOTSTRAP_JAR = "marketplace-bootstrap.jar";

    private static final Path findMarketplaceBootDir(Path pluginDir) {
        Path path = pluginDir.resolve(MARKETPLACE_PLUGIN_DIR).resolve("lib/boot");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isMarketplacePluginCompatible(Path homePath, Path pluginDir, Path mpBoot) {
        block25: {
            if (Files.notExists(mpBoot, new LinkOption[0])) {
                return false;
            }
            try {
                Closeable closeable;
                BufferedReader reader;
                Throwable throwable;
                Closeable closeable2;
                SimpleVersion ideVersion = null;
                try {
                    closeable2 = Files.newBufferedReader(homePath.resolve("build.txt"));
                    throwable = null;
                    try {
                        reader = (BufferedReader)closeable2;
                        boolean bl = false;
                        ideVersion = MarketplaceKt.parseVersion(reader.readLine());
                        reader = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ideVersion == null && OS.CURRENT == OS.macOS) {
                    closeable2 = Files.newBufferedReader(homePath.resolve("Resources/build.txt"));
                    throwable = null;
                    try {
                        reader = (BufferedReader)closeable2;
                        boolean bl = false;
                        ideVersion = MarketplaceKt.parseVersion(reader.readLine());
                        closeable = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                    }
                }
                if (ideVersion == null) break block25;
                SimpleVersion sinceVersion = null;
                SimpleVersion untilVersion = null;
                try {
                    closeable = Files.newBufferedReader(pluginDir.resolve(MARKETPLACE_PLUGIN_DIR).resolve("platform-build.txt"));
                    Throwable throwable3 = null;
                    try {
                        BufferedReader reader2 = (BufferedReader)closeable;
                        boolean bl = false;
                        sinceVersion = MarketplaceKt.parseVersion(reader2.readLine());
                        untilVersion = MarketplaceKt.parseVersion(reader2.readLine());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable3);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ideVersion.isCompatible(sinceVersion, untilVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    public static final void initMarketplace() {
        Path preinstalledPluginDir;
        Path pluginDir;
        Path path = PathManager.getHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getHomeDir(...)");
        Path distDir = path;
        Path path2 = pluginDir = (preinstalledPluginDir = distDir.resolve("plugins"));
        Intrinsics.checkNotNull((Object)path2);
        Path marketPlaceBootDir = MarketplaceKt.findMarketplaceBootDir(path2);
        Path mpBoot = marketPlaceBootDir.resolve(MARKETPLACE_BOOTSTRAP_JAR);
        boolean installMarketplace = Files.exists(mpBoot, new LinkOption[0]);
        if (!installMarketplace) {
            pluginDir = PathManager.getPluginsDir();
            marketPlaceBootDir = MarketplaceKt.findMarketplaceBootDir(pluginDir);
            Path path3 = mpBoot = marketPlaceBootDir.resolve(MARKETPLACE_BOOTSTRAP_JAR);
            Intrinsics.checkNotNull((Object)path3);
            installMarketplace = MarketplaceKt.isMarketplacePluginCompatible(distDir, pluginDir, path3);
            if (!installMarketplace) {
                return;
            }
        }
        Path marketplaceImpl = marketPlaceBootDir.resolve("marketplace-impl.jar");
        ClassLoader classLoader = AppMode.class.getClassLoader();
        PathClassLoader pathClassLoader = classLoader instanceof PathClassLoader ? (PathClassLoader)classLoader : null;
        if (pathClassLoader == null) {
            throw new RuntimeException("You must run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
        }
        PathClassLoader classLoader2 = pathClassLoader;
        if (!Files.exists(marketplaceImpl, new LinkOption[0])) {
            return;
        }
        classLoader2.getClassPath().addFiles((Collection)CollectionsKt.listOf((Object)marketplaceImpl));
        try {
            PathClassLoader spiLoader = new PathClassLoader(UrlClassLoader.build().files(CollectionsKt.listOf((Object)mpBoot)).parent((ClassLoader)classLoader2));
            Iterator<BytecodeTransformer> iterator = ServiceLoader.load(BytecodeTransformer.class, (ClassLoader)spiLoader).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<BytecodeTransformer> transformers = iterator;
            if (transformers.hasNext()) {
                BytecodeTransformer bytecodeTransformer = transformers.next();
                Intrinsics.checkNotNullExpressionValue((Object)bytecodeTransformer, (String)"next(...)");
                classLoader2.setTransformer((PathClassLoader.BytecodeTransformer)new BytecodeTransformerAdapter(bytecodeTransformer));
            }
        }
        catch (Throwable e) {
            String path4 = ((Object)pluginDir.resolve(MARKETPLACE_PLUGIN_DIR)).toString();
            Object[] objectArray = new Object[]{path4};
            String string = BootstrapBundle.message((String)"bootstrap.error.message.marketplace", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            StartupErrorReporter.showError((String)BootstrapBundle.message((String)"bootstrap.error.title.marketplace", (Object[])new Object[0]), (Throwable)new Exception(message, e));
        }
    }

    private static final SimpleVersion parseVersion(String rawText) {
        String text2 = rawText;
        CharSequence charSequence = text2;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        try {
            int dot;
            text2 = ((Object)StringsKt.trim((CharSequence)text2)).toString();
            int dash = StringsKt.lastIndexOf$default((CharSequence)text2, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (dash >= 0) {
                String string = text2.substring(dash + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                text2 = string;
            }
            if ((dot = StringsKt.indexOf$default((CharSequence)text2, (char)'.', (int)0, (boolean)false, (int)6, null)) >= 0) {
                int n = Integer.parseInt(StringsKt.take((String)text2, (int)dot));
                String string = text2.substring(dot + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return new SimpleVersion(n, MarketplaceKt.parseMinor(string));
            }
            return new SimpleVersion(Integer.parseInt(text2), 0);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static final int parseMinor(String text2) {
        try {
            if (Intrinsics.areEqual((Object)"*", (Object)text2) || Intrinsics.areEqual((Object)"SNAPSHOT", (Object)text2)) {
                return Integer.MAX_VALUE;
            }
            int dot = StringsKt.indexOf$default((CharSequence)text2, (char)'.', (int)0, (boolean)false, (int)6, null);
            return Integer.parseInt(dot >= 0 ? StringsKt.take((String)text2, (int)dot) : text2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

