/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.ActionBasedFeedbackConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.FeedbackSurveyUtilsKt;
import com.intellij.platform.feedback.impl.state.CommonFeedbackSurveyService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"isSuitableToShow", "", "Lcom/intellij/platform/feedback/ActionBasedFeedbackConfig;", "project", "Lcom/intellij/openapi/project/Project;", "showFeedbackDialog", "", "forTest", "intellij.platform.feedback"})
public final class ActionBasedFeedbackConfigKt {
    @RequiresBackgroundThread
    public static final boolean isSuitableToShow(@NotNull ActionBasedFeedbackConfig $this$isSuitableToShow, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuitableToShow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean commonConditionsForAllSurveys = Registry.Companion.is("platform.feedback.ignore.common.conditions.for.all.surveys", false) ? true : $this$isSuitableToShow.checkIdeIsSuitable() && FeedbackSurveyUtilsKt.checkIsFeedbackCollectionDeadlineNotPast($this$isSuitableToShow.getLastDayOfFeedbackCollection()) && FeedbackSurveyUtilsKt.checkIsIdeEAPIfRequired($this$isSuitableToShow.getRequireIdeEAP());
        return commonConditionsForAllSurveys && $this$isSuitableToShow.checkExtraConditionSatisfied(project) && $this$isSuitableToShow.checkExtraConditionSatisfiedForAction(project);
    }

    @RequiresEdt
    public static final void showFeedbackDialog(@NotNull ActionBasedFeedbackConfig $this$showFeedbackDialog, @NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackDialog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> dialog2 = $this$showFeedbackDialog.createFeedbackDialog(project, forTest);
        boolean isOk = dialog2.showAndGet();
        if (isOk && !forTest) {
            $this$showFeedbackDialog.updateStateAfterDialogClosedOk(project);
            CommonFeedbackSurveyService.Companion.feedbackSurveyAnswerSent($this$showFeedbackDialog.getSurveyId());
        }
    }
}

