/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.csat;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.csat.CsatFeedbackBundle;
import com.intellij.platform.feedback.csat.CsatFeedbackDialog;
import com.intellij.platform.feedback.csat.CsatFeedbackSurveyKt;
import com.intellij.platform.feedback.csat.CsatGlobalSettings;
import com.intellij.platform.feedback.csat.CsatNewUserTrackerKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\rH\u0016J \u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/feedback/csat/CsatFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "isIndefinite", "checkIdeIsSuitable", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "updateStateAfterDialogClosedOk", "", "checkExtraConditionSatisfied", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nCsatFeedbackSurvey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsatFeedbackSurvey.kt\ncom/intellij/platform/feedback/csat/CsatFeedbackSurveyConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class CsatFeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final kotlinx.datetime.LocalDate lastDayOfFeedbackCollection = new kotlinx.datetime.LocalDate(2050, Month.JANUARY, 1);
    private final boolean requireIdeEAP;
    private final boolean isIndefinite;

    public CsatFeedbackSurveyConfig() {
        this.surveyId = "csat_feedback";
        this.isIndefinite = true;
    }

    @Override
    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @Override
    @NotNull
    public kotlinx.datetime.LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    @Override
    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    @Override
    public boolean isIndefinite() {
        return this.isIndefinite;
    }

    @Override
    public boolean checkIdeIsSuitable() {
        return Registry.Companion.is("csat.survey.enabled") && !AppMode.isRemoteDevHost() && !ScreenReader.isActive();
    }

    @Override
    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new CsatFeedbackDialog(project, forTest);
    }

    @Override
    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CsatGlobalSettings.Companion.getInstance().setLastFeedbackDate(CsatFeedbackSurveyKt.getCsatToday().format(DateTimeFormatter.ISO_LOCAL_DATE));
    }

    @Override
    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        int daysHash;
        int surveyPeriod;
        int productHash;
        boolean isNewUser;
        LocalDate lastFeedbackDate;
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClientProjectSession clientProjectSession = ClientSessionsUtil.getCurrentSessionOrNull((Project)project);
        boolean bl = clientProjectSession != null ? clientProjectSession.isGuest() : false;
        if (bl) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("We are a CWM guest, do not really need CSAT");
            return false;
        }
        if (!((Collection)ClientSessionsUtil.sessions((Project)project, (ClientKind)ClientKind.GUEST)).isEmpty()) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("We are the CWM host at the moment, not the perfect time for CSAT");
            return false;
        }
        if (InitialConfigImportState.isFirstSession()) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("It's a first user session, skip the survey");
            return false;
        }
        LocalDate today = CsatFeedbackSurveyKt.getCsatToday();
        CsatFeedbackSurveyKt.access$getLOG$p().debug("Today is " + today.format(DateTimeFormatter.ISO_LOCAL_DATE));
        String string = CsatGlobalSettings.Companion.getInstance().getLastNotificationDate();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            object = CsatFeedbackSurveyKt.tryParseDate((String)it);
            if (object != null) {
                it = object;
                boolean bl3 = false;
                if (((LocalDate)it).isEqual(today)) {
                    CsatFeedbackSurveyKt.access$getLOG$p().debug("Already notified today, skip the survey");
                    return false;
                }
            }
        }
        if ((object = CsatGlobalSettings.Companion.getInstance().getLastFeedbackDate()) != null) {
            it = object;
            boolean bl4 = false;
            v2 = CsatFeedbackSurveyKt.tryParseDate((String)it);
        } else {
            v2 = lastFeedbackDate = null;
        }
        if (lastFeedbackDate != null && lastFeedbackDate.plusDays(97L).isAfter(today)) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("User recently filled the survey, vacation period is in progress");
            return false;
        }
        LocalDate userCreatedDate = CsatNewUserTrackerKt.getCsatUserCreatedDate();
        CsatFeedbackSurveyKt.access$getLOG$p().debug("User created date is " + userCreatedDate);
        LocalDate localDate = userCreatedDate;
        if (localDate != null) {
            LocalDate it2 = localDate;
            boolean bl5 = false;
            v4 = CsatFeedbackSurveyKt.isNewUser(today, userCreatedDate);
        } else {
            v4 = isNewUser = false;
        }
        if (isNewUser) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("User is a new user");
        }
        if ((productHash = CsatFeedbackSurveyKt.access$getProductHash(surveyPeriod = CsatFeedbackSurveyKt.access$getSurveyPeriod(isNewUser))) != (daysHash = CsatFeedbackSurveyKt.access$getDaysHash(today, surveyPeriod))) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("Periods do not match: " + productHash + " / " + daysHash + ", is not yet suitable date for the survey");
            return false;
        }
        String string2 = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        boolean show = CsatFeedbackSurveyKt.flipACoin(string2, isNewUser);
        if (!show) {
            CsatFeedbackSurveyKt.access$getLOG$p().debug("Coin flipped to NOT show the survey this time");
        }
        return show;
    }

    @Override
    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = CsatFeedbackBundle.INSTANCE.message("feedback.notification.title", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationInfo.getInstance().getVersionName(), (String)"getVersionName(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, CsatFeedbackBundle.INSTANCE.message("feedback.notification.text", objectArray));
    }

    @Override
    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CsatGlobalSettings.Companion.getInstance().setLastNotificationDate(CsatFeedbackSurveyKt.getCsatToday().format(DateTimeFormatter.ISO_LOCAL_DATE));
        PropertiesComponent.getInstance().setValue("evaluation.feedback.enabled", "false");
    }
}

