/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.dialog;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.FeedbackUIUtilsKt;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.dialog.uiBlocks.EmailBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextDescriptionProvider;
import com.intellij.platform.feedback.impl.FeedbackRequestDataWithDetailedAnswer;
import com.intellij.platform.feedback.impl.FeedbackRequestType;
import com.intellij.platform.feedback.impl.GeneralFeedbackSubmitKt;
import com.intellij.platform.feedback.impl.bundle.CommonFeedbackBundle;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001f\u001a\u00020\u0007H\u0014J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u0017H\u0014J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020\u000fH\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R'\u0010\u0014\u001a\u001b\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialogWithEmail;", "T", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "myProject", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackJsonVersion", "", "getMyFeedbackJsonVersion", "()I", "zendeskTicketTitle", "", "getZendeskTicketTitle", "()Ljava/lang/String;", "zendeskFeedbackType", "getZendeskFeedbackType", "feedbackAgreementBlock", "Lkotlin/Function2;", "Lcom/intellij/ui/dsl/builder/Row;", "", "Lkotlin/ExtensionFunctionType;", "emailBlockWithAgreement", "Lcom/intellij/platform/feedback/dialog/uiBlocks/EmailBlock;", "getEmailBlockWithAgreement", "()Lcom/intellij/platform/feedback/dialog/uiBlocks/EmailBlock;", "setEmailBlockWithAgreement", "(Lcom/intellij/platform/feedback/dialog/uiBlocks/EmailBlock;)V", "shouldAutoCloseZendeskTicket", "computeZendeskTicketTags", "", "collectedData", "Lkotlinx/serialization/json/JsonObject;", "sendFeedbackData", "addFooterToPanel", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "collectDataToPlainText", "intellij.platform.feedback"})
public abstract class BlockBasedFeedbackDialogWithEmail<T extends SystemDataJsonSerializable>
extends BlockBasedFeedbackDialog<T> {
    private final int myFeedbackJsonVersion = super.getMyFeedbackJsonVersion() + 1;
    @NotNull
    private final Function2<Row, Project, Unit> feedbackAgreementBlock = (arg_0, arg_1) -> BlockBasedFeedbackDialogWithEmail.feedbackAgreementBlock$lambda$0(this, arg_0, arg_1);
    @NotNull
    private EmailBlock emailBlockWithAgreement;

    public BlockBasedFeedbackDialogWithEmail(@Nullable Project myProject, boolean forTest) {
        super(myProject, forTest);
        this.emailBlockWithAgreement = new EmailBlock(myProject, this.feedbackAgreementBlock);
    }

    @Override
    protected int getMyFeedbackJsonVersion() {
        return this.myFeedbackJsonVersion;
    }

    @NotNull
    public abstract String getZendeskTicketTitle();

    @NotNull
    public abstract String getZendeskFeedbackType();

    @NotNull
    protected final EmailBlock getEmailBlockWithAgreement() {
        return this.emailBlockWithAgreement;
    }

    protected final void setEmailBlockWithAgreement(@NotNull EmailBlock emailBlock) {
        Intrinsics.checkNotNullParameter((Object)emailBlock, (String)"<set-?>");
        this.emailBlockWithAgreement = emailBlock;
    }

    protected boolean shouldAutoCloseZendeskTicket() {
        return true;
    }

    @NotNull
    protected List<String> computeZendeskTicketTags(@NotNull JsonObject collectedData) {
        Intrinsics.checkNotNullParameter((Object)collectedData, (String)"collectedData");
        return CollectionsKt.emptyList();
    }

    @Override
    protected void sendFeedbackData() {
        JsonObject collectedData = this.collectDataToJsonObject();
        List<String> zendeskTicketTags = this.computeZendeskTicketTags(collectedData);
        FeedbackRequestDataWithDetailedAnswer feedbackData = new FeedbackRequestDataWithDetailedAnswer(this.emailBlockWithAgreement.getEmailAddressIfSpecified(), this.getZendeskTicketTitle(), this.collectDataToPlainText(), "rsch.statistics.feedback.common", this.shouldAutoCloseZendeskTicket(), zendeskTicketTags, this.getZendeskFeedbackType(), collectedData);
        GeneralFeedbackSubmitKt.submitFeedback(feedbackData, (Function0<Unit>)((Function0)() -> BlockBasedFeedbackDialogWithEmail.sendFeedbackData$lambda$0(this)), (Function0<Unit>)((Function0)BlockBasedFeedbackDialogWithEmail::sendFeedbackData$lambda$1), this.getMyForTest() ? FeedbackRequestType.TEST_REQUEST : FeedbackRequestType.PRODUCTION_REQUEST);
    }

    @Override
    protected void addFooterToPanel(@NotNull Panel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.emailBlockWithAgreement.addToPanel(panel2);
    }

    @NotNull
    protected String collectDataToPlainText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (FeedbackBlock block : this.getMyBlocks()) {
            if (!(block instanceof TextDescriptionProvider)) continue;
            ((TextDescriptionProvider)((Object)block)).collectBlockTextDescription(stringBuilder);
        }
        stringBuilder.append('\n');
        stringBuilder.append('\n');
        stringBuilder.append(this.getMySystemInfoDataComputation$intellij_platform_feedback().getComputationResult().toString()).append('\n');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit feedbackAgreementBlock$lambda$0(BlockBasedFeedbackDialogWithEmail this$0, Row row, Project project) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"<this>");
        FeedbackUIUtilsKt.feedbackAgreement(row, project, CommonFeedbackBundle.INSTANCE.message("dialog.feedback.consent.withEmail", new Object[0]), (Function0<Unit>)((Function0)() -> BlockBasedFeedbackDialogWithEmail.feedbackAgreementBlock$lambda$0$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit feedbackAgreementBlock$lambda$0$0(BlockBasedFeedbackDialogWithEmail this$0) {
        this$0.showFeedbackSystemInfoDialog(this$0.getMySystemInfoDataComputation$intellij_platform_feedback().getComputationResult());
        return Unit.INSTANCE;
    }

    private static final Unit sendFeedbackData$lambda$0(BlockBasedFeedbackDialogWithEmail this$0) {
        this$0.showThanksNotification();
        return Unit.INSTANCE;
    }

    private static final Unit sendFeedbackData$lambda$1() {
        return Unit.INSTANCE;
    }
}

