/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.dialog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.frontend.HostIdeInfoService;
import com.intellij.frontend.HostInfo;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData$;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.bundle.CommonFeedbackBundle;
import com.intellij.ui.LicensingFacade;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 L2\u00020\u0001:\u0002LMB\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u0012\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0016B\u00b5\u0001\b\u0010\u0012\u0006\u0010\u0017\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0014\u001a\u00020\n\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\b\u0015\u0010\u001aJ\u0006\u0010\"\u001a\u00020\u0003J\u000b\u0010#\u001a\u00070\u0003\u00a2\u0006\u0002\b$J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u0003J\u0006\u0010)\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0003H\u0016J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c2\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\u0010\u00103\u001a\u0004\u0018\u00010\nH\u00c2\u0003\u00a2\u0006\u0002\u00104J\u000f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c2\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c2\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c2\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c2\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u00c2\u0003J\t\u0010;\u001a\u00020\nH\u00c2\u0003J\t\u0010<\u001a\u00020\u0003H\u00c2\u0003J\t\u0010=\u001a\u00020\nH\u00c2\u0003J\u00b4\u0001\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\n2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\b\b\u0002\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010?J\u0013\u0010@\u001a\u00020\n2\b\u0010A\u001a\u0004\u0018\u00010BH\u00d6\u0003J\t\u0010C\u001a\u00020\u0007H\u00d6\u0001J%\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0001\u00a2\u0006\u0002\bKR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/platform/feedback/dialog/CommonFeedbackSystemData;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "osVersion", "", "memorySize", "", "coresNumber", "", "appVersionWithBuild", "isEvaluationLicense", "", "licenseRestrictions", "", "runtimeVersion", "isInternalModeEnabled", "registry", "disabledBundledPlugins", "nonBundledPlugins", "isRemoteDevelopmentHost", "license", "isEAP", "<init>", "(Ljava/lang/String;JILjava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/String;Z)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JILjava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/String;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getOsVersion", "()Ljava/lang/String;", "getCoresNumber", "()I", "getAppVersionWithBuild", "Ljava/lang/Boolean;", "getRuntimeVersion", "getMemorySizeForDialog", "getLicenseRestrictionsForDialog", "Lorg/jetbrains/annotations/Nls;", "getIsLicenseEvaluationForDialog", "getIsInternalModeForDialog", "getRegistryKeysForDialog", "getDisabledBundledPluginsForDialog", "getNonBundledPluginsForDialog", "serializeToJson", "Lkotlinx/serialization/json/JsonElement;", "json", "Lkotlinx/serialization/json/Json;", "toString", "component1", "component2", "component3", "component4", "component5", "()Ljava/lang/Boolean;", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "copy", "(Ljava/lang/String;JILjava/lang/String;Ljava/lang/Boolean;Ljava/util/List;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/String;Z)Lcom/intellij/platform/feedback/dialog/CommonFeedbackSystemData;", "equals", "other", "", "hashCode", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_feedback", "Companion", "$serializer", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nCommonFeedbackSystemData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonFeedbackSystemData.kt\ncom/intellij/platform/feedback/dialog/CommonFeedbackSystemData\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,240:1\n324#2:241\n*S KotlinDebug\n*F\n+ 1 CommonFeedbackSystemData.kt\ncom/intellij/platform/feedback/dialog/CommonFeedbackSystemData\n*L\n207#1:241\n*E\n"})
public final class CommonFeedbackSystemData
implements SystemDataJsonSerializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String osVersion;
    private final long memorySize;
    private final int coresNumber;
    @NotNull
    private final String appVersionWithBuild;
    @Nullable
    private final Boolean isEvaluationLicense;
    @NotNull
    private final List<String> licenseRestrictions;
    @NotNull
    private final String runtimeVersion;
    private final boolean isInternalModeEnabled;
    @NotNull
    private final List<String> registry;
    @NotNull
    private final List<String> disabledBundledPlugins;
    @NotNull
    private final List<String> nonBundledPlugins;
    private final boolean isRemoteDevelopmentHost;
    @NotNull
    private final String license;
    private final boolean isEAP;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public CommonFeedbackSystemData(@NotNull String osVersion, long memorySize, int coresNumber, @NotNull String appVersionWithBuild, @Nullable Boolean isEvaluationLicense, @NotNull List<String> licenseRestrictions, @NotNull String runtimeVersion, boolean isInternalModeEnabled, @NotNull List<String> registry, @NotNull List<String> disabledBundledPlugins, @NotNull List<String> nonBundledPlugins, boolean isRemoteDevelopmentHost, @NotNull String license, boolean isEAP) {
        Intrinsics.checkNotNullParameter((Object)osVersion, (String)"osVersion");
        Intrinsics.checkNotNullParameter((Object)appVersionWithBuild, (String)"appVersionWithBuild");
        Intrinsics.checkNotNullParameter(licenseRestrictions, (String)"licenseRestrictions");
        Intrinsics.checkNotNullParameter((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter(disabledBundledPlugins, (String)"disabledBundledPlugins");
        Intrinsics.checkNotNullParameter(nonBundledPlugins, (String)"nonBundledPlugins");
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        this.osVersion = osVersion;
        this.memorySize = memorySize;
        this.coresNumber = coresNumber;
        this.appVersionWithBuild = appVersionWithBuild;
        this.isEvaluationLicense = isEvaluationLicense;
        this.licenseRestrictions = licenseRestrictions;
        this.runtimeVersion = runtimeVersion;
        this.isInternalModeEnabled = isInternalModeEnabled;
        this.registry = registry;
        this.disabledBundledPlugins = disabledBundledPlugins;
        this.nonBundledPlugins = nonBundledPlugins;
        this.isRemoteDevelopmentHost = isRemoteDevelopmentHost;
        this.license = license;
        this.isEAP = isEAP;
    }

    @NotNull
    public final String getOsVersion() {
        return this.osVersion;
    }

    public final int getCoresNumber() {
        return this.coresNumber;
    }

    @NotNull
    public final String getAppVersionWithBuild() {
        return this.appVersionWithBuild;
    }

    @NotNull
    public final String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @NotNull
    public final String getMemorySizeForDialog() {
        return this.memorySize + "M";
    }

    @NotNull
    public final String getLicenseRestrictionsForDialog() {
        return this.licenseRestrictions.isEmpty() ? CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.license.no.info", new Object[0]) : CollectionsKt.joinToString$default((Iterable)this.licenseRestrictions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String getIsLicenseEvaluationForDialog() {
        String string;
        Boolean bl = this.isEvaluationLicense;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            string = "True";
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            string = "False";
        } else if (bl == null) {
            string = "No Info";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String getIsInternalModeForDialog() {
        String string;
        boolean bl = this.isInternalModeEnabled;
        if (bl) {
            string = "True";
        } else if (!bl) {
            string = "False";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String getRegistryKeysForDialog() {
        String registryKeys = CollectionsKt.joinToString$default((Iterable)this.registry, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return !StringUtil.isEmpty((String)registryKeys) ? registryKeys : CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.registry.empty", new Object[0]);
    }

    @NotNull
    public final String getDisabledBundledPluginsForDialog() {
        String disabledPlugins = CollectionsKt.joinToString$default((Iterable)this.disabledBundledPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return !StringUtil.isEmpty((String)disabledPlugins) ? disabledPlugins : CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.disabled.plugins.empty", new Object[0]);
    }

    @NotNull
    public final String getNonBundledPluginsForDialog() {
        String nonBundledPluginsString = CollectionsKt.joinToString$default((Iterable)this.nonBundledPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return !StringUtil.isEmpty((String)nonBundledPluginsString) ? nonBundledPluginsString : CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.nonbundled.plugins.empty", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonElement serializeToJson(@NotNull Json json) {
        void $this$encodeToJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Json json2 = json;
        CommonFeedbackSystemData value$iv = this;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        return $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)Companion.serializer(), (Object)value$iv);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.title", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.os.version", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.osVersion).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.memory", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getMemorySizeForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.cores", new Object[0])).append('\n');
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append(this.coresNumber);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        stringBuilder2.append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.app.version", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.appVersionWithBuild).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.license.evaluation", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getIsLicenseEvaluationForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.license.restrictions", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getLicenseRestrictionsForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.runtime.version", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.runtimeVersion).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.internal.mode.enabled", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.isInternalModeEnabled).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.registry", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getRegistryKeysForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.disabled.plugins", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getDisabledBundledPluginsForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.nonbundled.plugins", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(this.getNonBundledPluginsForDialog()).append('\n');
        $this$toString_u24lambda_u240.append(CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.remote.dev.host", new Object[0])).append('\n');
        $this$toString_u24lambda_u240.append(String.valueOf(this.isRemoteDevelopmentHost)).append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final String component1() {
        return this.osVersion;
    }

    private final long component2() {
        return this.memorySize;
    }

    public final int component3() {
        return this.coresNumber;
    }

    @NotNull
    public final String component4() {
        return this.appVersionWithBuild;
    }

    private final Boolean component5() {
        return this.isEvaluationLicense;
    }

    private final List<String> component6() {
        return this.licenseRestrictions;
    }

    @NotNull
    public final String component7() {
        return this.runtimeVersion;
    }

    private final boolean component8() {
        return this.isInternalModeEnabled;
    }

    private final List<String> component9() {
        return this.registry;
    }

    private final List<String> component10() {
        return this.disabledBundledPlugins;
    }

    private final List<String> component11() {
        return this.nonBundledPlugins;
    }

    private final boolean component12() {
        return this.isRemoteDevelopmentHost;
    }

    private final String component13() {
        return this.license;
    }

    private final boolean component14() {
        return this.isEAP;
    }

    @NotNull
    public final CommonFeedbackSystemData copy(@NotNull String osVersion, long memorySize, int coresNumber, @NotNull String appVersionWithBuild, @Nullable Boolean isEvaluationLicense, @NotNull List<String> licenseRestrictions, @NotNull String runtimeVersion, boolean isInternalModeEnabled, @NotNull List<String> registry, @NotNull List<String> disabledBundledPlugins, @NotNull List<String> nonBundledPlugins, boolean isRemoteDevelopmentHost, @NotNull String license, boolean isEAP) {
        Intrinsics.checkNotNullParameter((Object)osVersion, (String)"osVersion");
        Intrinsics.checkNotNullParameter((Object)appVersionWithBuild, (String)"appVersionWithBuild");
        Intrinsics.checkNotNullParameter(licenseRestrictions, (String)"licenseRestrictions");
        Intrinsics.checkNotNullParameter((Object)runtimeVersion, (String)"runtimeVersion");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter(disabledBundledPlugins, (String)"disabledBundledPlugins");
        Intrinsics.checkNotNullParameter(nonBundledPlugins, (String)"nonBundledPlugins");
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        return new CommonFeedbackSystemData(osVersion, memorySize, coresNumber, appVersionWithBuild, isEvaluationLicense, licenseRestrictions, runtimeVersion, isInternalModeEnabled, registry, disabledBundledPlugins, nonBundledPlugins, isRemoteDevelopmentHost, license, isEAP);
    }

    public static /* synthetic */ CommonFeedbackSystemData copy$default(CommonFeedbackSystemData commonFeedbackSystemData, String string, long l, int n, String string2, Boolean bl, List list2, String string3, boolean bl2, List list3, List list4, List list5, boolean bl3, String string4, boolean bl4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = commonFeedbackSystemData.osVersion;
        }
        if ((n2 & 2) != 0) {
            l = commonFeedbackSystemData.memorySize;
        }
        if ((n2 & 4) != 0) {
            n = commonFeedbackSystemData.coresNumber;
        }
        if ((n2 & 8) != 0) {
            string2 = commonFeedbackSystemData.appVersionWithBuild;
        }
        if ((n2 & 0x10) != 0) {
            bl = commonFeedbackSystemData.isEvaluationLicense;
        }
        if ((n2 & 0x20) != 0) {
            list2 = commonFeedbackSystemData.licenseRestrictions;
        }
        if ((n2 & 0x40) != 0) {
            string3 = commonFeedbackSystemData.runtimeVersion;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = commonFeedbackSystemData.isInternalModeEnabled;
        }
        if ((n2 & 0x100) != 0) {
            list3 = commonFeedbackSystemData.registry;
        }
        if ((n2 & 0x200) != 0) {
            list4 = commonFeedbackSystemData.disabledBundledPlugins;
        }
        if ((n2 & 0x400) != 0) {
            list5 = commonFeedbackSystemData.nonBundledPlugins;
        }
        if ((n2 & 0x800) != 0) {
            bl3 = commonFeedbackSystemData.isRemoteDevelopmentHost;
        }
        if ((n2 & 0x1000) != 0) {
            string4 = commonFeedbackSystemData.license;
        }
        if ((n2 & 0x2000) != 0) {
            bl4 = commonFeedbackSystemData.isEAP;
        }
        return commonFeedbackSystemData.copy(string, l, n, string2, bl, list2, string3, bl2, list3, list4, list5, bl3, string4, bl4);
    }

    public int hashCode() {
        int result2 = this.osVersion.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.memorySize);
        result2 = result2 * 31 + Integer.hashCode(this.coresNumber);
        result2 = result2 * 31 + this.appVersionWithBuild.hashCode();
        result2 = result2 * 31 + (this.isEvaluationLicense == null ? 0 : ((Object)this.isEvaluationLicense).hashCode());
        result2 = result2 * 31 + ((Object)this.licenseRestrictions).hashCode();
        result2 = result2 * 31 + this.runtimeVersion.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isInternalModeEnabled);
        result2 = result2 * 31 + ((Object)this.registry).hashCode();
        result2 = result2 * 31 + ((Object)this.disabledBundledPlugins).hashCode();
        result2 = result2 * 31 + ((Object)this.nonBundledPlugins).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isRemoteDevelopmentHost);
        result2 = result2 * 31 + this.license.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isEAP);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommonFeedbackSystemData)) {
            return false;
        }
        CommonFeedbackSystemData commonFeedbackSystemData = (CommonFeedbackSystemData)other;
        if (!Intrinsics.areEqual((Object)this.osVersion, (Object)commonFeedbackSystemData.osVersion)) {
            return false;
        }
        if (this.memorySize != commonFeedbackSystemData.memorySize) {
            return false;
        }
        if (this.coresNumber != commonFeedbackSystemData.coresNumber) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appVersionWithBuild, (Object)commonFeedbackSystemData.appVersionWithBuild)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.isEvaluationLicense, (Object)commonFeedbackSystemData.isEvaluationLicense)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.licenseRestrictions, commonFeedbackSystemData.licenseRestrictions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runtimeVersion, (Object)commonFeedbackSystemData.runtimeVersion)) {
            return false;
        }
        if (this.isInternalModeEnabled != commonFeedbackSystemData.isInternalModeEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.registry, commonFeedbackSystemData.registry)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.disabledBundledPlugins, commonFeedbackSystemData.disabledBundledPlugins)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nonBundledPlugins, commonFeedbackSystemData.nonBundledPlugins)) {
            return false;
        }
        if (this.isRemoteDevelopmentHost != commonFeedbackSystemData.isRemoteDevelopmentHost) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.license, (Object)commonFeedbackSystemData.license)) {
            return false;
        }
        return this.isEAP == commonFeedbackSystemData.isEAP;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_platform_feedback(CommonFeedbackSystemData self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeStringElement(serialDesc, 0, self.osVersion);
        output.encodeLongElement(serialDesc, 1, self.memorySize);
        output.encodeIntElement(serialDesc, 2, self.coresNumber);
        output.encodeStringElement(serialDesc, 3, self.appVersionWithBuild);
        output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)BooleanSerializer.INSTANCE, (Object)self.isEvaluationLicense);
        output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.licenseRestrictions);
        output.encodeStringElement(serialDesc, 6, self.runtimeVersion);
        output.encodeBooleanElement(serialDesc, 7, self.isInternalModeEnabled);
        output.encodeSerializableElement(serialDesc, 8, (SerializationStrategy)lazyArray[8].getValue(), self.registry);
        output.encodeSerializableElement(serialDesc, 9, (SerializationStrategy)lazyArray[9].getValue(), self.disabledBundledPlugins);
        output.encodeSerializableElement(serialDesc, 10, (SerializationStrategy)lazyArray[10].getValue(), self.nonBundledPlugins);
        output.encodeBooleanElement(serialDesc, 11, self.isRemoteDevelopmentHost);
        output.encodeStringElement(serialDesc, 12, self.license);
        output.encodeBooleanElement(serialDesc, 13, self.isEAP);
    }

    public /* synthetic */ CommonFeedbackSystemData(int seen0, String osVersion, long memorySize, int coresNumber, String appVersionWithBuild, Boolean isEvaluationLicense, List licenseRestrictions, String runtimeVersion, boolean isInternalModeEnabled, List registry, List disabledBundledPlugins, List nonBundledPlugins, boolean isRemoteDevelopmentHost, String license, boolean isEAP, SerializationConstructorMarker serializationConstructorMarker) {
        if (16383 != (0x3FFF & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)16383, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.osVersion = osVersion;
        this.memorySize = memorySize;
        this.coresNumber = coresNumber;
        this.appVersionWithBuild = appVersionWithBuild;
        this.isEvaluationLicense = isEvaluationLicense;
        this.licenseRestrictions = licenseRestrictions;
        this.runtimeVersion = runtimeVersion;
        this.isInternalModeEnabled = isInternalModeEnabled;
        this.registry = registry;
        this.disabledBundledPlugins = disabledBundledPlugins;
        this.nonBundledPlugins = nonBundledPlugins;
        this.isRemoteDevelopmentHost = isRemoteDevelopmentHost;
        this.license = license;
        this.isEAP = isEAP;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), null, null, null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00100\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/feedback/dialog/CommonFeedbackSystemData$Companion;", "", "<init>", "()V", "getCurrentData", "Lcom/intellij/platform/feedback/dialog/CommonFeedbackSystemData;", "getOsVersion", "", "getMemorySize", "", "getCoresNumber", "", "getAppVersionWithBuild", "getLicenseRestrictionsInfo", "", "getLicenseEvaluationInfo", "", "()Ljava/lang/Boolean;", "getRuntimeVersion", "getIsInternalMode", "getRegistryKeys", "getDisabledPlugins", "getNonBundledPlugins", "getPluginsNamesWithVersion", "filter", "Lkotlin/Function1;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getLicenseMetadata", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.platform.feedback"})
    @SourceDebugExtension(value={"SMAP\nCommonFeedbackSystemData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonFeedbackSystemData.kt\ncom/intellij/platform/feedback/dialog/CommonFeedbackSystemData$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n42#2,3:241\n774#3:244\n865#3,2:245\n1563#3:247\n1634#3,3:248\n774#3:251\n865#3,2:252\n1563#3:254\n1634#3,3:255\n*S KotlinDebug\n*F\n+ 1 CommonFeedbackSystemData.kt\ncom/intellij/platform/feedback/dialog/CommonFeedbackSystemData$Companion\n*L\n98#1:241,3\n120#1:244\n120#1:245,2\n125#1:247\n125#1:248,3\n135#1:251\n135#1:252,2\n136#1:254\n136#1:255,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonFeedbackSystemData getCurrentData() {
            return new CommonFeedbackSystemData(this.getOsVersion(), this.getMemorySize(), this.getCoresNumber(), this.getAppVersionWithBuild(), this.getLicenseEvaluationInfo(), this.getLicenseRestrictionsInfo(), this.getRuntimeVersion(), this.getIsInternalMode(), this.getRegistryKeys(), this.getDisabledPlugins(), this.getNonBundledPlugins(), AppMode.isRemoteDevHost(), this.getLicenseMetadata(), ApplicationManager.getApplication().isEAP());
        }

        private final String getOsVersion() {
            return SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION;
        }

        private final long getMemorySize() {
            return Runtime.getRuntime().maxMemory() / (long)0x100000;
        }

        private final int getCoresNumber() {
            return Runtime.getRuntime().availableProcessors();
        }

        private final String getAppVersionWithBuild() {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String string = appInfo.getFullApplicationName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullApplicationName(...)");
            Object appVersion = string;
            String edition = ApplicationNamesInfo.getInstance().getEditionName();
            if (edition != null) {
                appVersion = (String)appVersion + " (" + edition + ")";
            }
            BuildNumber buildNumber = appInfo.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            BuildNumber appBuild = buildNumber;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)appBuild.asString(), (String)"asString(...)");
            appVersion = (String)appVersion + CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.app.version.build", objectArray);
            Date date = appInfo.getBuildDate().getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getTime(...)");
            Date timestamp = date;
            if (appBuild.isSnapshot()) {
                time = new SimpleDateFormat("HH:mm").format(timestamp);
                Object[] objectArray2 = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)NlsMessages.formatDateLong((Date)timestamp), (String)"formatDateLong(...)");
                Intrinsics.checkNotNull((Object)time);
                objectArray2[1] = time;
                appVersion = (String)appVersion + CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.app.version.build.date.time", objectArray2);
            } else {
                time = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)NlsMessages.formatDateLong((Date)timestamp), (String)"formatDateLong(...)");
                appVersion = (String)appVersion + CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.app.version.build.date", time);
            }
            if (Intrinsics.areEqual((Object)appInfo.getBuild().getProductCode(), (Object)"JBC")) {
                boolean $i$f$service = false;
                Class<HostIdeInfoService> serviceClass$iv = HostIdeInfoService.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                HostInfo hostInfo = ((HostIdeInfoService)object).getHostInfo();
                if (hostInfo != null) {
                    Object[] objectArray3 = new Object[]{hostInfo.getProductCode()};
                    appVersion = (String)appVersion + CommonFeedbackBundle.INSTANCE.message("dialog.feedback.system.info.panel.app.version.host", objectArray3);
                }
            }
            return appVersion;
        }

        private final List<String> getLicenseRestrictionsInfo() {
            Object object = LicensingFacade.getInstance();
            if (object == null || (object = object.getLicenseRestrictionsMessages()) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private final Boolean getLicenseEvaluationInfo() {
            LicensingFacade licensingFacade = LicensingFacade.getInstance();
            return licensingFacade != null ? Boolean.valueOf(licensingFacade.isEvaluationLicense()) : null;
        }

        private final String getRuntimeVersion() {
            return SystemInfo.JAVA_RUNTIME_VERSION + SystemInfo.OS_ARCH;
        }

        private final boolean getIsInternalMode() {
            return ApplicationManager.getApplication().isInternal();
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getRegistryKeys() {
            void $this$mapTo$iv$iv;
            RegistryValue value;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = Registry.Companion.getAll();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String pluginId;
                value = (RegistryValue)element$iv$iv;
                boolean bl = false;
                String string = pluginId = value.getPluginId();
                PluginInfo pluginInfo = string != null ? PluginInfoDetectorKt.getPluginInfoById((PluginId)PluginId.Companion.getId(string)) : PluginInfoDetectorKt.getPlatformPlugin();
                if (!(value.isChangedFromDefault() && pluginInfo.isSafeToReport())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void v;
                value = (RegistryValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(v.getKey() + "=" + v.asString());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        private final List<String> getDisabledPlugins() {
            return this.getPluginsNamesWithVersion((Function1<? super IdeaPluginDescriptor, Boolean>)((Function1)Companion::getDisabledPlugins$lambda$0));
        }

        private final List<String> getNonBundledPlugins() {
            return this.getPluginsNamesWithVersion((Function1<? super IdeaPluginDescriptor, Boolean>)((Function1)Companion::getNonBundledPlugins$lambda$0));
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getPluginsNamesWithVersion(Function1<? super IdeaPluginDescriptor, Boolean> filter) {
            void $this$mapTo$iv$iv;
            IdeaPluginDescriptor it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PluginManagerCore.getLoadedPlugins();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IdeaPluginDescriptor)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)filter.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PluginId pluginId;
                void p;
                it = (IdeaPluginDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)p.getPluginId(), (String)"getPluginId(...)");
                PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoById((PluginId)pluginId);
                collection.add(pluginInfo.isSafeToReport() ? pluginId.getIdString() + " (" + p.getVersion() + ")" : "third.party");
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        private final String getLicenseMetadata() {
            Object object = LicensingFacade.getInstance();
            if (object == null || (object = object.metadata) == null) {
                object = "null";
            }
            return object;
        }

        @NotNull
        public final KSerializer<CommonFeedbackSystemData> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        private static final boolean getDisabledPlugins$lambda$0(IdeaPluginDescriptor p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return !p.isEnabled();
        }

        private static final boolean getNonBundledPlugins$lambda$0(IdeaPluginDescriptor p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return !p.isBundled();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

