/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.eap;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.eap.EAPFeedbackUrlProvider;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0010\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n\u001a\r\u0010\u000b\u001a\u00070\u0001\u00a2\u0006\u0002\b\fH\u0002\u001a\r\u0010\r\u001a\u00070\u0001\u00a2\u0006\u0002\b\fH\u0002\u001a\b\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"timerStartedKey", "", "eapFeedbackRegistryKey", "executeEAPFeedbackAction", "", "isEAPEnv", "", "isEAPFeedbackAvailable", "setEAPFeedbackShown", "propComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "getProductName", "Lcom/intellij/openapi/util/NlsSafe;", "getProductVersion", "getTimerStartedKey", "getParseTimerStarted", "", "(Lcom/intellij/ide/util/PropertiesComponent;)Ljava/lang/Long;", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nEAPApplicationInitializedListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EAPApplicationInitializedListener.kt\ncom/intellij/platform/feedback/eap/EAPApplicationInitializedListenerKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n30#2,2:133\n*S KotlinDebug\n*F\n+ 1 EAPApplicationInitializedListener.kt\ncom/intellij/platform/feedback/eap/EAPApplicationInitializedListenerKt\n*L\n97#1:133,2\n*E\n"})
public final class EAPApplicationInitializedListenerKt {
    @NotNull
    private static final String timerStartedKey = "eap.feedback.scheduled";
    @NotNull
    private static final String eapFeedbackRegistryKey = "eap.feedback.notification.enabled";

    public static final void executeEAPFeedbackAction() {
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<EAPFeedbackUrlProvider> serviceClass$iv = EAPFeedbackUrlProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BrowserUtil.browse((String)((EAPFeedbackUrlProvider)object).surveyUrl(), null);
    }

    public static final boolean isEAPEnv() {
        Application app = ApplicationManager.getApplication();
        return !app.isUnitTestMode() && !app.isHeadlessEnvironment() && app.isEAP();
    }

    public static final boolean isEAPFeedbackAvailable() {
        if (!Registry.Companion.is(eapFeedbackRegistryKey)) {
            return false;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        Long l = EAPApplicationInitializedListenerKt.getParseTimerStarted(propertiesComponent);
        long l2 = -1L;
        return l == null || l != l2;
    }

    public static final void setEAPFeedbackShown(@NotNull PropertiesComponent propComponent) {
        Intrinsics.checkNotNullParameter((Object)propComponent, (String)"propComponent");
        propComponent.setValue(EAPApplicationInitializedListenerKt.getTimerStartedKey(), "-1");
    }

    public static /* synthetic */ void setEAPFeedbackShown$default(PropertiesComponent propertiesComponent, int n, Object object) {
        if ((n & 1) != 0) {
            PropertiesComponent propertiesComponent2 = PropertiesComponent.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent2, (String)"getInstance(...)");
            propertiesComponent = propertiesComponent2;
        }
        EAPApplicationInitializedListenerKt.setEAPFeedbackShown(propertiesComponent);
    }

    private static final String getProductName() {
        String string = ApplicationNamesInfo.getInstance().getProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
        return string;
    }

    private static final String getProductVersion() {
        String string = ApplicationInfo.getInstance().getShortVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortVersion(...)");
        return string;
    }

    private static final String getTimerStartedKey() {
        String productName = EAPApplicationInitializedListenerKt.getProductName();
        return productName + ".eap.feedback.scheduled." + EAPApplicationInitializedListenerKt.getProductVersion();
    }

    private static final Long getParseTimerStarted(PropertiesComponent propComponent) {
        Long l;
        String string = propComponent.getValue(EAPApplicationInitializedListenerKt.getTimerStartedKey());
        if (string == null) {
            return null;
        }
        String value = string;
        try {
            l = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            EAPApplicationInitializedListenerKt.setEAPFeedbackShown(propComponent);
            l = -1L;
        }
        return l;
    }

    public static final /* synthetic */ Long access$getParseTimerStarted(PropertiesComponent propComponent) {
        return EAPApplicationInitializedListenerKt.getParseTimerStarted(propComponent);
    }

    public static final /* synthetic */ String access$getTimerStartedKey() {
        return EAPApplicationInitializedListenerKt.getTimerStartedKey();
    }
}

