/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.ExternalFeedbackSurveyConfig;
import com.intellij.platform.feedback.ExternalFeedbackSurveyType;
import com.intellij.platform.feedback.FeedbackSurveyType;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.InIdeFeedbackSurveyType;
import com.intellij.platform.feedback.NotificationBasedFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.platform.feedback.impl.state.CommonFeedbackSurveyService;
import com.intellij.platform.feedback.impl.state.DontShowAgainFeedbackService;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ClockKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0001\u001a$\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\n*\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"MAX_FEEDBACK_SURVEY_NUMBER_SHOWS", "", "checkIsFeedbackCollectionDeadlineNotPast", "", "Lcom/intellij/platform/feedback/NotificationBasedFeedbackSurveyConfig;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "checkIsIdeEAPIfRequired", "requireIdeEAP", "showNotification", "", "feedbackSurveyType", "Lcom/intellij/platform/feedback/FeedbackSurveyType;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "isSuitableToShow", "feedbackSurveyConfig", "invokeRespondNotificationAction", "showFeedbackDialog", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "updateCommonFeedbackSurveysStateAfterSent", "browseToSurvey", "Lcom/intellij/platform/feedback/ExternalFeedbackSurveyConfig;", "checkNumberShowsNotExceeded", "intellij.platform.feedback"})
public final class FeedbackSurveyUtilsKt {
    public static final int MAX_FEEDBACK_SURVEY_NUMBER_SHOWS = 2;

    private static final boolean checkIsFeedbackCollectionDeadlineNotPast(NotificationBasedFeedbackSurveyConfig $this$checkIsFeedbackCollectionDeadlineNotPast) {
        return FeedbackSurveyUtilsKt.checkIsFeedbackCollectionDeadlineNotPast($this$checkIsFeedbackCollectionDeadlineNotPast.getLastDayOfFeedbackCollection());
    }

    public static final boolean checkIsFeedbackCollectionDeadlineNotPast(@NotNull LocalDate lastDayOfFeedbackCollection) {
        Intrinsics.checkNotNullParameter((Object)lastDayOfFeedbackCollection, (String)"lastDayOfFeedbackCollection");
        return ClockKt.todayIn((Clock)((Clock)Clock.System.INSTANCE), (TimeZone)TimeZone.Companion.currentSystemDefault()).compareTo(lastDayOfFeedbackCollection) < 0;
    }

    private static final boolean checkIsIdeEAPIfRequired(NotificationBasedFeedbackSurveyConfig $this$checkIsIdeEAPIfRequired) {
        return FeedbackSurveyUtilsKt.checkIsIdeEAPIfRequired($this$checkIsIdeEAPIfRequired.getRequireIdeEAP());
    }

    public static final boolean checkIsIdeEAPIfRequired(boolean requireIdeEAP) {
        if (requireIdeEAP) {
            return ApplicationInfo.getInstance().isEAP();
        }
        return true;
    }

    public static final void showNotification(@NotNull FeedbackSurveyType<?> feedbackSurveyType, @NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter(feedbackSurveyType, (String)"feedbackSurveyType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object feedbackSurveyConfig = feedbackSurveyType.getFeedbackSurveyConfig$intellij_platform_feedback();
        RequestFeedbackNotification notification = feedbackSurveyConfig.createNotification(project, forTest);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)feedbackSurveyConfig.getRespondNotificationActionLabel(), () -> FeedbackSurveyUtilsKt.showNotification$lambda$0(forTest, feedbackSurveyConfig, feedbackSurveyType, project)));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)feedbackSurveyConfig.getCancelNotificationActionLabel(), () -> FeedbackSurveyUtilsKt.showNotification$lambda$1(forTest, feedbackSurveyConfig, project)));
        notification.notify(project);
        if (!forTest) {
            CommonFeedbackSurveyService.Companion.feedbackSurveyShowed(feedbackSurveyConfig.getSurveyId());
            feedbackSurveyConfig.updateStateAfterNotificationShowed(project);
        }
    }

    @RequiresBackgroundThread
    public static final boolean isSuitableToShow(@NotNull NotificationBasedFeedbackSurveyConfig feedbackSurveyConfig, @NotNull Project project) {
        boolean commonConditionsForAllSurveys;
        Intrinsics.checkNotNullParameter((Object)feedbackSurveyConfig, (String)"feedbackSurveyConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = Registry.Companion.is("platform.feedback.ignore.common.conditions.for.all.surveys", false) ? true : (commonConditionsForAllSurveys = !CommonFeedbackSurveyService.Companion.checkIsFeedbackSurveyAnswerSent(feedbackSurveyConfig) && feedbackSurveyConfig.checkIdeIsSuitable() && FeedbackSurveyUtilsKt.checkIsFeedbackCollectionDeadlineNotPast(feedbackSurveyConfig) && FeedbackSurveyUtilsKt.checkIsIdeEAPIfRequired(feedbackSurveyConfig) && FeedbackSurveyUtilsKt.checkNumberShowsNotExceeded(feedbackSurveyConfig));
        if (!commonConditionsForAllSurveys) {
            return false;
        }
        return feedbackSurveyConfig.checkExtraConditionSatisfied(project) && feedbackSurveyConfig.checkExtraConditionSatisfiedForNotification(project);
    }

    private static final void invokeRespondNotificationAction(FeedbackSurveyType<?> feedbackSurveyType, Project project, boolean forTest) {
        FeedbackSurveyType<?> feedbackSurveyType2 = feedbackSurveyType;
        if (feedbackSurveyType2 instanceof InIdeFeedbackSurveyType) {
            FeedbackSurveyUtilsKt.showFeedbackDialog((InIdeFeedbackSurveyConfig)((InIdeFeedbackSurveyType)feedbackSurveyType).getFeedbackSurveyConfig$intellij_platform_feedback(), project, forTest);
        } else if (feedbackSurveyType2 instanceof ExternalFeedbackSurveyType) {
            NotificationBasedFeedbackSurveyConfig notificationBasedFeedbackSurveyConfig = ((ExternalFeedbackSurveyType)feedbackSurveyType).getFeedbackSurveyConfig$intellij_platform_feedback();
            Intrinsics.checkNotNull((Object)notificationBasedFeedbackSurveyConfig, (String)"null cannot be cast to non-null type com.intellij.platform.feedback.ExternalFeedbackSurveyConfig");
            NotificationBasedFeedbackSurveyConfig externalFeedbackSurveyConfig = notificationBasedFeedbackSurveyConfig;
            FeedbackSurveyUtilsKt.browseToSurvey(project, (ExternalFeedbackSurveyConfig)externalFeedbackSurveyConfig);
            if (!forTest) {
                externalFeedbackSurveyConfig.updateStateAfterRespondActionInvoked(project);
                FeedbackSurveyUtilsKt.updateCommonFeedbackSurveysStateAfterSent(externalFeedbackSurveyConfig);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void showFeedbackDialog(InIdeFeedbackSurveyConfig $this$showFeedbackDialog, Project project, boolean forTest) {
        BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> dialog2 = $this$showFeedbackDialog.createFeedbackDialog(project, forTest);
        boolean isOk = dialog2.showAndGet();
        if (isOk && !forTest) {
            $this$showFeedbackDialog.updateStateAfterDialogClosedOk(project);
            CommonFeedbackSurveyService.Companion.feedbackSurveyAnswerSent($this$showFeedbackDialog.getSurveyId());
        }
    }

    private static final void updateCommonFeedbackSurveysStateAfterSent(NotificationBasedFeedbackSurveyConfig feedbackSurveyConfig) {
        CommonFeedbackSurveyService.Companion.feedbackSurveyAnswerSent(feedbackSurveyConfig.getSurveyId());
    }

    private static final void browseToSurvey(Project project, ExternalFeedbackSurveyConfig feedbackSurveyConfig) {
        BrowserUtil.browse((String)feedbackSurveyConfig.getUrlToSurvey(project), (Project)project);
    }

    private static final boolean checkNumberShowsNotExceeded(NotificationBasedFeedbackSurveyConfig feedbackSurveyConfig) {
        if (feedbackSurveyConfig.isIndefinite()) {
            return true;
        }
        return CommonFeedbackSurveyService.Companion.getNumberShowsOfFeedbackSurvey(feedbackSurveyConfig.getSurveyId()) < 2;
    }

    private static final void showNotification$lambda$0(boolean $forTest, NotificationBasedFeedbackSurveyConfig $feedbackSurveyConfig, FeedbackSurveyType $feedbackSurveyType, Project $project) {
        if (!$forTest) {
            CommonFeedbackSurveyService.Companion.feedbackSurveyRespondActionInvoked($feedbackSurveyConfig.getSurveyId());
        }
        FeedbackSurveyUtilsKt.invokeRespondNotificationAction($feedbackSurveyType, $project, $forTest);
    }

    private static final void showNotification$lambda$1(boolean $forTest, NotificationBasedFeedbackSurveyConfig $feedbackSurveyConfig, Project $project) {
        if (!$forTest) {
            DontShowAgainFeedbackService.Companion.dontShowFeedbackInCurrentVersion();
            CommonFeedbackSurveyService.Companion.feedbackSurveyDisableActionInvoked($feedbackSurveyConfig.getSurveyId());
        }
        $feedbackSurveyConfig.getCancelNotificationAction($project).invoke();
    }
}

