/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.impl;

import com.intellij.ide.RegionUrlMapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.feedback.impl.FeedbackRequestData;
import com.intellij.platform.feedback.impl.FeedbackRequestDataHolder;
import com.intellij.platform.feedback.impl.FeedbackRequestType;
import com.intellij.platform.feedback.impl.statistics.FeedbackSendActionCountCollector;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\b\b\u0002\u0010$\u001a\u00020%\u001a4\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002\u001a\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)\u001a\b\u0010+\u001a\u00020\u0001H\u0000\u001a\b\u0010,\u001a\u00020-H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"TEST_FEEDBACK_URL", "", "PRODUCTION_FEEDBACK_URL", "FEEDBACK_FORM_ID_ONLY_DATA", "FEEDBACK_FORM_ID_WITH_DETAILED_ANSWER", "FEEDBACK_REPORT_ID_KEY", "FEEDBACK_FROM_ID_KEY", "FEEDBACK_AUTO_SOLVE_TICKET_KEY", "FEEDBACK_INTELLIJ_PRODUCT_KEY", "FEEDBACK_TYPE_KEY", "FEEDBACK_PRIVACY_CONSENT_KEY", "FEEDBACK_PRIVACY_CONSENT_TYPE_KEY", "FEEDBACK_COLLECTED_DATA_KEY", "FEEDBACK_EMAIL_KEY", "FEEDBACK_SUBJECT_KEY", "FEEDBACK_COMMENT_KEY", "FEEDBACK_TAGS_KEY", "DEFAULT_FEEDBACK_CONSENT_ID", "REQUEST_ID_KEY", "EMAIL_PLACEHOLDER", "EMAIL_REGEX", "Lkotlin/text/Regex;", "getEMAIL_REGEX", "()Lkotlin/text/Regex;", "SPACE_SYMBOL_REGEX", "getSPACE_SYMBOL_REGEX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "submitFeedback", "", "feedbackData", "Lcom/intellij/platform/feedback/impl/FeedbackRequestDataHolder;", "onDone", "Lkotlin/Function0;", "onError", "feedbackRequestType", "Lcom/intellij/platform/feedback/impl/FeedbackRequestType;", "sendFeedback", "feedbackUrl", "cleanFeedbackFromEmails", "Lkotlinx/serialization/json/JsonElement;", "jsonElement", "getProductTag", "isCLionNova", "", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nGeneralFeedbackSubmit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralFeedbackSubmit.kt\ncom/intellij/platform/feedback/impl/GeneralFeedbackSubmitKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n29#2,2:237\n31#2:241\n52#2,2:242\n54#2:246\n216#3,2:239\n1869#4,2:244\n*S KotlinDebug\n*F\n+ 1 GeneralFeedbackSubmit.kt\ncom/intellij/platform/feedback/impl/GeneralFeedbackSubmitKt\n*L\n185#1:237,2\n185#1:241\n192#1:242,2\n192#1:246\n186#1:239,2\n193#1:244,2\n*E\n"})
public final class GeneralFeedbackSubmitKt {
    @NotNull
    private static final String TEST_FEEDBACK_URL = "https://forms-stgn.w3jbcom-nonprod.aws.intellij.net/feedback";
    @NotNull
    private static final String PRODUCTION_FEEDBACK_URL = "https://forms-service.jetbrains.com/feedback";
    @NotNull
    private static final String FEEDBACK_FORM_ID_ONLY_DATA = "feedback/ide";
    @NotNull
    private static final String FEEDBACK_FORM_ID_WITH_DETAILED_ANSWER = "v2/feedback/ide_with_detailed_answer";
    @NotNull
    public static final String FEEDBACK_REPORT_ID_KEY = "feedback_id";
    @NotNull
    private static final String FEEDBACK_FROM_ID_KEY = "formid";
    @NotNull
    private static final String FEEDBACK_AUTO_SOLVE_TICKET_KEY = "autosolve";
    @NotNull
    private static final String FEEDBACK_INTELLIJ_PRODUCT_KEY = "intellij_product";
    @NotNull
    private static final String FEEDBACK_TYPE_KEY = "feedback_type";
    @NotNull
    private static final String FEEDBACK_PRIVACY_CONSENT_KEY = "privacy_consent";
    @NotNull
    private static final String FEEDBACK_PRIVACY_CONSENT_TYPE_KEY = "privacy_consent_type";
    @NotNull
    private static final String FEEDBACK_COLLECTED_DATA_KEY = "collected_data";
    @NotNull
    private static final String FEEDBACK_EMAIL_KEY = "email";
    @NotNull
    private static final String FEEDBACK_SUBJECT_KEY = "subject";
    @NotNull
    private static final String FEEDBACK_COMMENT_KEY = "comment";
    @NotNull
    private static final String FEEDBACK_TAGS_KEY = "tags";
    @NotNull
    public static final String DEFAULT_FEEDBACK_CONSENT_ID = "rsch.statistics.feedback.common";
    @NotNull
    private static final String REQUEST_ID_KEY = "Request-Id";
    @NotNull
    private static final String EMAIL_PLACEHOLDER = "<EMAIL>";
    @NotNull
    private static final Regex EMAIL_REGEX = new Regex("^[a-zA-Z0-9\\\\._%+!$&*=^|~#{}-]+@([a-zA-Z0-9\\\\-]+\\.)+([a-zA-Z]{2,22})$");
    @NotNull
    private static final Regex SPACE_SYMBOL_REGEX = new Regex("\\s");
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Regex getEMAIL_REGEX() {
        return EMAIL_REGEX;
    }

    @NotNull
    public static final Regex getSPACE_SYMBOL_REGEX() {
        return SPACE_SYMBOL_REGEX;
    }

    public static final void submitFeedback(@NotNull FeedbackRequestDataHolder feedbackData, @NotNull Function0<Unit> onDone, @NotNull Function0<Unit> onError, @NotNull FeedbackRequestType feedbackRequestType) {
        Intrinsics.checkNotNullParameter((Object)feedbackData, (String)"feedbackData");
        Intrinsics.checkNotNullParameter(onDone, (String)"onDone");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)((Object)feedbackRequestType), (String)"feedbackRequestType");
        ApplicationManager.getApplication().executeOnPooledThread(() -> GeneralFeedbackSubmitKt.submitFeedback$lambda$0(feedbackRequestType, feedbackData, onDone, onError));
    }

    public static /* synthetic */ void submitFeedback$default(FeedbackRequestDataHolder feedbackRequestDataHolder, Function0 function0, Function0 function02, FeedbackRequestType feedbackRequestType, int n, Object object) {
        if ((n & 8) != 0) {
            feedbackRequestType = FeedbackRequestType.TEST_REQUEST;
        }
        GeneralFeedbackSubmitKt.submitFeedback(feedbackRequestDataHolder, (Function0<Unit>)function0, (Function0<Unit>)function02, feedbackRequestType);
    }

    private static final void sendFeedback(String feedbackUrl, FeedbackRequestDataHolder feedbackData, Function0<Unit> onDone, Function0<Unit> onError) {
        String requestData = feedbackData.toJsonObject().toString();
        try {
            Unit cfr_ignored_0 = (Unit)HttpRequests.post((String)feedbackUrl, (String)"application/json; charset=utf-8").productNameAsUserAgent().accept("application/json").connect(arg_0 -> GeneralFeedbackSubmitKt.sendFeedback$lambda$0(requestData, onError, feedbackData, onDone, arg_0));
        }
        catch (IOException e) {
            LOG.info("Failed to submit feedback. Feedback data:\n" + requestData + "\nError message:\n" + e.getMessage());
            onError.invoke();
            FeedbackSendActionCountCollector.INSTANCE.logFeedbackSendFail$intellij_platform_feedback();
            return;
        }
    }

    @NotNull
    public static final JsonElement cleanFeedbackFromEmails(@NotNull JsonElement jsonElement) {
        JsonElement jsonElement2;
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
        JsonElement jsonElement3 = jsonElement;
        if (jsonElement3 instanceof JsonObject) {
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$cleanFeedbackFromEmails_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            Map $this$forEach$iv = (Map)jsonElement;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                $this$cleanFeedbackFromEmails_u24lambda_u240.put(key, GeneralFeedbackSubmitKt.cleanFeedbackFromEmails(element));
            }
            jsonElement2 = (JsonElement)builder$iv.build();
        } else if (jsonElement3 instanceof JsonArray) {
            JsonArrayBuilder builder$iv;
            boolean $i$f$buildJsonArray = false;
            JsonArrayBuilder $this$cleanFeedbackFromEmails_u24lambda_u241 = builder$iv = new JsonArrayBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)jsonElement;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement element = (JsonElement)element$iv;
                boolean bl3 = false;
                $this$cleanFeedbackFromEmails_u24lambda_u241.add(GeneralFeedbackSubmitKt.cleanFeedbackFromEmails(element));
            }
            jsonElement2 = (JsonElement)builder$iv.build();
        } else if (jsonElement3 instanceof JsonPrimitive) {
            jsonElement2 = (JsonElement)(Regex.find$default((Regex)EMAIL_REGEX, (CharSequence)((JsonPrimitive)jsonElement).getContent(), (int)0, (int)2, null) != null ? JsonElementKt.JsonPrimitive((String)EMAIL_REGEX.replace((CharSequence)((JsonPrimitive)jsonElement).getContent(), EMAIL_PLACEHOLDER)) : (JsonPrimitive)jsonElement);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonElement2;
    }

    @NotNull
    public static final String getProductTag() {
        return PlatformUtils.isIntelliJ() ? "ij_idea1" : (PlatformUtils.isPhpStorm() ? "ij_phpstorm1" : (PlatformUtils.isWebStorm() ? "ij_webstorm1" : (PlatformUtils.isPyCharm() ? "ij_pycharm1" : (PlatformUtils.isRubyMine() ? "ij_rubymine1" : (PlatformUtils.isAppCode() ? "ij_appcode1" : (PlatformUtils.isCLion() && !GeneralFeedbackSubmitKt.isCLionNova() ? "ij_clion1" : (PlatformUtils.isCLion() && GeneralFeedbackSubmitKt.isCLionNova() ? "ij_clion_nova1" : (PlatformUtils.isDataGrip() ? "ij_datagrip1" : (PlatformUtils.isGoIde() ? "ij_goland1" : (PlatformUtils.isJetBrainsClient() ? "ij_code_with_me1" : (PlatformUtils.isDataSpell() ? "ij_dataspell1" : (PlatformUtils.isRider() ? "ij_rider1" : (PlatformUtils.isRustRover() ? "ij_rustrover1" : (PlatformUtils.isAqua() ? "ij_aqua1" : "undefined"))))))))))))));
    }

    private static final boolean isCLionNova() {
        String string = ApplicationNamesInfo.getInstance().getFullProductNameWithEdition();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductNameWithEdition(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Nova", (boolean)false, (int)2, null);
    }

    private static final void submitFeedback$lambda$0(FeedbackRequestType $feedbackRequestType, FeedbackRequestDataHolder $feedbackData, Function0 $onDone, Function0 $onError) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$feedbackRequestType.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                string = TEST_FEEDBACK_URL;
                break;
            }
            case 3: {
                string = PRODUCTION_FEEDBACK_URL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String feedbackUrl = string;
        String string2 = RegionUrlMapper.tryMapUrlBlocking((String)feedbackUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tryMapUrlBlocking(...)");
        String regionalFeedbackUrl = string2;
        LOG.info("Feedback sent to " + regionalFeedbackUrl);
        GeneralFeedbackSubmitKt.sendFeedback(regionalFeedbackUrl, $feedbackData, (Function0<Unit>)$onDone, (Function0<Unit>)$onError);
    }

    private static final Unit sendFeedback$lambda$0(String $requestData, Function0 $onError, FeedbackRequestDataHolder $feedbackData, Function0 $onDone, HttpRequests.Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            it.write($requestData);
            URLConnection uRLConnection = it.getConnection();
            Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
            URLConnection connection = uRLConnection;
            if (connection instanceof HttpsURLConnection && ((HttpsURLConnection)connection).getResponseCode() != 200) {
                String requestId = it.getConnection().getHeaderField(REQUEST_ID_KEY);
                String errorResponse = it.readError();
                LOG.info("Failed to submit feedback. Feedback data:\n" + $requestData + "\nStatus code:" + ((HttpsURLConnection)connection).getResponseCode() + "\nServer response:" + errorResponse + "\nRequest ID:" + requestId);
                $onError.invoke();
                FeedbackSendActionCountCollector.INSTANCE.logFeedbackSendFail$intellij_platform_feedback();
                return Unit.INSTANCE;
            }
            byte[] bytes = it.getInputStream().readAllBytes();
            Intrinsics.checkNotNull((Object)bytes);
            LOG.info(new String(bytes, Charsets.UTF_8));
            String requestId = it.getConnection().getHeaderField(REQUEST_ID_KEY);
            LOG.info("Feedback submitted successfully. Record ID is " + requestId);
        }
        catch (IOException e) {
            byte[] byArray;
            URLConnection uRLConnection = it.getConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            InputStream inputStream = ((HttpURLConnection)uRLConnection).getErrorStream();
            String errorResponse = inputStream != null && (byArray = inputStream.readAllBytes()) != null ? new String(byArray, Charsets.UTF_8) : null;
            LOG.info("Failed to submit feedback. Feedback data:\n" + $requestData + "\nServer response:\n" + errorResponse + "\nException: " + ExceptionsKt.stackTraceToString((Throwable)e));
            $onError.invoke();
            FeedbackSendActionCountCollector.INSTANCE.logFeedbackSendFail$intellij_platform_feedback();
            return Unit.INSTANCE;
        }
        if ($feedbackData instanceof FeedbackRequestData) {
            FeedbackSendActionCountCollector.INSTANCE.logFeedbackSendSuccess$intellij_platform_feedback();
        }
        $onDone.invoke();
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(FeedbackRequestDataHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeedbackRequestType.values().length];
            try {
                nArray[FeedbackRequestType.NO_REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeedbackRequestType.TEST_REQUEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeedbackRequestType.PRODUCTION_REQUEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

