/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.FeedbackSurvey;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.platform.feedback.impl.state.DontShowAgainFeedbackService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/feedback/impl/IdleFeedbackResolver;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "showFeedbackNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "showFeedbackNotification$intellij_platform_feedback", "Companion", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nIdleFeedbackResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdleFeedbackResolver.kt\ncom/intellij/platform/feedback/impl/IdleFeedbackResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n23#2:73\n23#2:74\n*S KotlinDebug\n*F\n+ 1 IdleFeedbackResolver.kt\ncom/intellij/platform/feedback/impl/IdleFeedbackResolver\n*L\n48#1:73\n55#1:74\n*E\n"})
public final class IdleFeedbackResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private static final ExtensionPointName<FeedbackSurvey> IDLE_FEEDBACK_SURVEY = new ExtensionPointName("com.intellij.feedback.idleFeedbackSurvey");

    public IdleFeedbackResolver(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
    }

    public final void showFeedbackNotification$intellij_platform_feedback(@Nullable Project project) {
        if (!DontShowAgainFeedbackService.Companion.checkIsAllowedToShowFeedback() || !Registry.Companion.is("platform.feedback", true) || project == null) {
            return;
        }
        if (AppMode.isRemoteDevHost()) {
            IdleFeedbackResolver $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IdleFeedbackResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Not showing idle feedback notification on remote-dev host");
            return;
        }
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(RequestFeedbackNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        RequestFeedbackNotification[] feedbackNotifications = (RequestFeedbackNotification[])notificationArray;
        if (!(feedbackNotifications.length == 0)) {
            IdleFeedbackResolver $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(IdleFeedbackResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("There is already another request feedback notification shown, not showing more feedback notifications");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            Object L$0;
            int I$0;
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = IdleFeedbackResolver.Companion.getJbIdleFeedbackSurveyExtensionList$intellij_platform_feedback();
                        Project project = this.$project;
                        boolean $i$f$filter = false;
                        void var6_8 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            FeedbackSurvey it = (FeedbackSurvey)element$iv$iv;
                            boolean bl = false;
                            if (!it.isSuitableToShow$intellij_platform_feedback(project)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List suitableIdleFeedbackSurveys = (List)destination$iv$iv;
                        if (suitableIdleFeedbackSurveys.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        int feedbackIndex = Random.Default.nextInt(suitableIdleFeedbackSurveys.size());
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)suitableIdleFeedbackSurveys);
                        this.I$0 = feedbackIndex;
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends FeedbackSurvey>)suitableIdleFeedbackSurveys, feedbackIndex, this.$project, null){
                            int label;
                            final /* synthetic */ List<FeedbackSurvey> $suitableIdleFeedbackSurveys;
                            final /* synthetic */ int $feedbackIndex;
                            final /* synthetic */ Project $project;
                            {
                                this.$suitableIdleFeedbackSurveys = $suitableIdleFeedbackSurveys;
                                this.$feedbackIndex = $feedbackIndex;
                                this.$project = $project;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        FeedbackSurvey.showNotification$default(this.$suitableIdleFeedbackSurveys.get(this.$feedbackIndex), this.$project, false, 2, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        int feedbackIndex = this.I$0;
                        List suitableIdleFeedbackSurveys = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    @NotNull
    public static final IdleFeedbackResolver getInstance$intellij_platform_feedback() {
        return Companion.getInstance$intellij_platform_feedback();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0006J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/feedback/impl/IdleFeedbackResolver$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/feedback/impl/IdleFeedbackResolver;", "getInstance$intellij_platform_feedback", "IDLE_FEEDBACK_SURVEY", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/platform/feedback/FeedbackSurvey;", "getJbIdleFeedbackSurveyExtensionList", "", "getJbIdleFeedbackSurveyExtensionList$intellij_platform_feedback", "intellij.platform.feedback"})
    @SourceDebugExtension(value={"SMAP\nIdleFeedbackResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdleFeedbackResolver.kt\ncom/intellij/platform/feedback/impl/IdleFeedbackResolver$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n42#2,3:73\n774#3:76\n865#3,2:77\n*S KotlinDebug\n*F\n+ 1 IdleFeedbackResolver.kt\ncom/intellij/platform/feedback/impl/IdleFeedbackResolver$Companion\n*L\n27#1:73,3\n32#1:76\n32#1:77,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IdleFeedbackResolver getInstance$intellij_platform_feedback() {
            boolean $i$f$service = false;
            Class<IdleFeedbackResolver> serviceClass$iv = IdleFeedbackResolver.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (IdleFeedbackResolver)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FeedbackSurvey> getJbIdleFeedbackSurveyExtensionList$intellij_platform_feedback() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = IDLE_FEEDBACK_SURVEY.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                FeedbackSurvey it = (FeedbackSurvey)element$iv$iv;
                boolean bl2 = false;
                if (it.getPluginDescriptor$intellij_platform_feedback() == null) {
                    bl = false;
                } else {
                    PluginDescriptor pluginDescriptor;
                    PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
                    bl = pluginInfo.isDevelopedByJetBrains();
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

