/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.impl.state;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.platform.feedback.NotificationBasedFeedbackSurveyConfig;
import com.intellij.platform.feedback.impl.state.CommonFeedbackSurveysState;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="CommonFeedbackSurveyService", storages={@Storage(value="CommonFeedbackSurveyService.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/feedback/impl/state/CommonFeedbackSurveyService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/platform/feedback/impl/state/CommonFeedbackSurveysState;", "<init>", "()V", "state", "getState", "loadState", "", "Companion", "intellij.platform.feedback"})
public final class CommonFeedbackSurveyService
implements PersistentStateComponent<CommonFeedbackSurveysState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CommonFeedbackSurveysState state = new CommonFeedbackSurveysState(null, null, null, null, 15, null);

    @NotNull
    public CommonFeedbackSurveysState getState() {
        return this.state;
    }

    public void loadState(@NotNull CommonFeedbackSurveysState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    @JvmStatic
    public static final int getNumberShowsOfFeedbackSurvey(@NotNull String surveyId) {
        return Companion.getNumberShowsOfFeedbackSurvey(surveyId);
    }

    @JvmStatic
    public static final void feedbackSurveyShowed(@NotNull String surveyId) {
        Companion.feedbackSurveyShowed(surveyId);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Integer> getNumberShowsForAllSurveys() {
        return Companion.getNumberShowsForAllSurveys();
    }

    @JvmStatic
    public static final void feedbackSurveyRespondActionInvoked(@NotNull String surveyId) {
        Companion.feedbackSurveyRespondActionInvoked(surveyId);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Integer> getNumberRespondActionInvokedForAllSurveys() {
        return Companion.getNumberRespondActionInvokedForAllSurveys();
    }

    @JvmStatic
    public static final void feedbackSurveyDisableActionInvoked(@NotNull String surveyId) {
        Companion.feedbackSurveyDisableActionInvoked(surveyId);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Integer> getNumberDisableActionInvokedForAllSurveys() {
        return Companion.getNumberDisableActionInvokedForAllSurveys();
    }

    @JvmStatic
    public static final void feedbackSurveyAnswerSent(@NotNull String surveyId) {
        Companion.feedbackSurveyAnswerSent(surveyId);
    }

    @JvmStatic
    public static final boolean checkIsFeedbackSurveyAnswerSent(@NotNull String surveyId) {
        return Companion.checkIsFeedbackSurveyAnswerSent(surveyId);
    }

    @JvmStatic
    public static final boolean checkIsFeedbackSurveyAnswerSent(@NotNull NotificationBasedFeedbackSurveyConfig config) {
        return Companion.checkIsFeedbackSurveyAnswerSent(config);
    }

    @JvmStatic
    @NotNull
    public static final Set<String> getAllAnsweredFeedbackSurveys() {
        return Companion.getAllAnsweredFeedbackSurveys();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/feedback/impl/state/CommonFeedbackSurveyService$Companion;", "", "<init>", "()V", "getNumberShowsOfFeedbackSurvey", "", "surveyId", "", "feedbackSurveyShowed", "", "getNumberShowsForAllSurveys", "", "feedbackSurveyRespondActionInvoked", "getNumberRespondActionInvokedForAllSurveys", "feedbackSurveyDisableActionInvoked", "getNumberDisableActionInvokedForAllSurveys", "feedbackSurveyAnswerSent", "checkIsFeedbackSurveyAnswerSent", "", "config", "Lcom/intellij/platform/feedback/NotificationBasedFeedbackSurveyConfig;", "getAllAnsweredFeedbackSurveys", "", "getInstance", "Lcom/intellij/platform/feedback/impl/state/CommonFeedbackSurveyService;", "increment", "", "key", "intellij.platform.feedback"})
    @SourceDebugExtension(value={"SMAP\nCommonFeedbackSurveyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonFeedbackSurveyService.kt\ncom/intellij/platform/feedback/impl/state/CommonFeedbackSurveyService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,93:1\n42#2,3:94\n*S KotlinDebug\n*F\n+ 1 CommonFeedbackSurveyService.kt\ncom/intellij/platform/feedback/impl/state/CommonFeedbackSurveyService$Companion\n*L\n69#1:94,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getNumberShowsOfFeedbackSurvey(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            return ((Number)this.getInstance().state.getFeedbackSurveyToNumberNotificationShows().getOrDefault(surveyId, 0)).intValue();
        }

        @JvmStatic
        public final void feedbackSurveyShowed(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            this.increment(this.getInstance().state.getFeedbackSurveyToNumberNotificationShows(), surveyId);
        }

        @JvmStatic
        @NotNull
        public final Map<String, Integer> getNumberShowsForAllSurveys() {
            return this.getInstance().state.getFeedbackSurveyToNumberNotificationShows();
        }

        @JvmStatic
        public final void feedbackSurveyRespondActionInvoked(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            this.increment(this.getInstance().state.getFeedbackSurveyToNumberRespondActionInvoked(), surveyId);
        }

        @JvmStatic
        @NotNull
        public final Map<String, Integer> getNumberRespondActionInvokedForAllSurveys() {
            return this.getInstance().state.getFeedbackSurveyToNumberRespondActionInvoked();
        }

        @JvmStatic
        public final void feedbackSurveyDisableActionInvoked(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            this.increment(this.getInstance().state.getFeedbackSurveyToNumberDisableActionInvoked(), surveyId);
        }

        @JvmStatic
        @NotNull
        public final Map<String, Integer> getNumberDisableActionInvokedForAllSurveys() {
            return this.getInstance().state.getFeedbackSurveyToNumberDisableActionInvoked();
        }

        @JvmStatic
        public final void feedbackSurveyAnswerSent(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            this.getInstance().state.getAnsweredFeedbackSurveys().add(surveyId);
        }

        @JvmStatic
        public final boolean checkIsFeedbackSurveyAnswerSent(@NotNull String surveyId) {
            Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
            return this.getInstance().state.getAnsweredFeedbackSurveys().contains(surveyId);
        }

        @JvmStatic
        public final boolean checkIsFeedbackSurveyAnswerSent(@NotNull NotificationBasedFeedbackSurveyConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (config.isIndefinite()) {
                return false;
            }
            return this.checkIsFeedbackSurveyAnswerSent(config.getSurveyId());
        }

        @JvmStatic
        @NotNull
        public final Set<String> getAllAnsweredFeedbackSurveys() {
            return this.getInstance().state.getAnsweredFeedbackSurveys();
        }

        private final CommonFeedbackSurveyService getInstance() {
            boolean $i$f$service = false;
            Class<CommonFeedbackSurveyService> serviceClass$iv = CommonFeedbackSurveyService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CommonFeedbackSurveyService)object;
        }

        private final void increment(Map<String, Integer> $this$increment, String key) {
            $this$increment.put(key, ((Number)$this$increment.getOrDefault(key, 0)).intValue() + 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

