/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.logs;

import com.intellij.platform.ml.LevelSignature;
import com.intellij.platform.ml.Tier;
import com.intellij.platform.ml.logs.AdditionalTierSet;
import com.intellij.platform.ml.logs.CommonKt;
import com.intellij.platform.ml.logs.MainTierSet;
import com.intellij.platform.ml.logs.SessionFields;
import com.intellij.platform.ml.logs.schema.EventField;
import com.intellij.platform.ml.logs.schema.EventPair;
import com.intellij.platform.ml.logs.schema.ObjectEventField;
import com.intellij.platform.ml.session.AnalysedTierData;
import com.intellij.platform.ml.session.AnalysedTierScheme;
import com.intellij.platform.ml.session.DescribedTierScheme;
import com.intellij.platform.ml.session.SessionTree;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004BI\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eB{\b\u0016\u0012J\u0010\u000f\u001aF\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\b\u0012\u0004\u0012\u00020\u0013`\u0014\u0012\u001e\u0012\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00150\u0011j\b\u0012\u0004\u0012\u00020\u0015`\u00140\u0010j\u0002`\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u0017J6\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$2\"\u0010&\u001a\u001e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00028\u00000'j\b\u0012\u0004\u0012\u00028\u0000`*H\u0016J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00010\nH\u00c6\u0003J\u0019\u0010.\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\fH\u00c6\u0003J_\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0018\b\u0002\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\fH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u000206H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/platform/ml/logs/PredictionSessionFields;", "P", "", "F", "Lcom/intellij/platform/ml/logs/SessionFields;", "declarationMainTierSet", "Lcom/intellij/platform/ml/logs/MainTierSet;", "declarationAdditionalTierSet", "Lcom/intellij/platform/ml/logs/AdditionalTierSet;", "fieldPrediction", "Lcom/intellij/platform/ml/logs/schema/EventField;", "serializePrediction", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/platform/ml/logs/MainTierSet;Lcom/intellij/platform/ml/logs/AdditionalTierSet;Lcom/intellij/platform/ml/logs/schema/EventField;Lkotlin/jvm/functions/Function1;)V", "levelScheme", "Lcom/intellij/platform/ml/LevelSignature;", "", "Lcom/intellij/platform/ml/Tier;", "Lcom/intellij/platform/ml/session/AnalysedTierScheme;", "Lcom/intellij/platform/ml/PerTier;", "Lcom/intellij/platform/ml/session/DescribedTierScheme;", "Lcom/intellij/platform/ml/logs/AnalysedLevelScheme;", "(Lcom/intellij/platform/ml/LevelSignature;Lcom/intellij/platform/ml/logs/schema/EventField;Lkotlin/jvm/functions/Function1;)V", "getDeclarationMainTierSet", "()Lcom/intellij/platform/ml/logs/MainTierSet;", "getDeclarationAdditionalTierSet", "()Lcom/intellij/platform/ml/logs/AdditionalTierSet;", "getFieldPrediction", "()Lcom/intellij/platform/ml/logs/schema/EventField;", "getSerializePrediction", "()Lkotlin/jvm/functions/Function1;", "fieldMainInstances", "Lcom/intellij/platform/ml/logs/schema/ObjectEventField;", "fieldAdditionalInstances", "buildEventPairs", "", "Lcom/intellij/platform/ml/logs/schema/EventPair;", "sessionStructure", "Lcom/intellij/platform/ml/session/SessionTree;", "", "Lcom/intellij/platform/ml/session/AnalysedTierData;", "Lcom/intellij/platform/ml/session/AnalysedSessionTree;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ml"})
final class PredictionSessionFields<P, F>
extends SessionFields<P> {
    @NotNull
    private final MainTierSet<P> declarationMainTierSet;
    @NotNull
    private final AdditionalTierSet<P> declarationAdditionalTierSet;
    @NotNull
    private final EventField<F> fieldPrediction;
    @NotNull
    private final Function1<P, F> serializePrediction;
    @NotNull
    private final ObjectEventField fieldMainInstances;
    @NotNull
    private final ObjectEventField fieldAdditionalInstances;

    public PredictionSessionFields(@NotNull MainTierSet<P> declarationMainTierSet, @NotNull AdditionalTierSet<P> declarationAdditionalTierSet, @NotNull EventField<F> fieldPrediction, @NotNull Function1<? super P, ? extends F> serializePrediction) {
        Intrinsics.checkNotNullParameter(declarationMainTierSet, (String)"declarationMainTierSet");
        Intrinsics.checkNotNullParameter(declarationAdditionalTierSet, (String)"declarationAdditionalTierSet");
        Intrinsics.checkNotNullParameter(fieldPrediction, (String)"fieldPrediction");
        Intrinsics.checkNotNullParameter(serializePrediction, (String)"serializePrediction");
        this.declarationMainTierSet = declarationMainTierSet;
        this.declarationAdditionalTierSet = declarationAdditionalTierSet;
        this.fieldPrediction = fieldPrediction;
        this.serializePrediction = serializePrediction;
        this.fieldMainInstances = new ObjectEventField("main", CommonKt.getNO_DESCRIPTION(), this.declarationMainTierSet);
        this.fieldAdditionalInstances = new ObjectEventField("additional", CommonKt.getNO_DESCRIPTION(), this.declarationAdditionalTierSet);
        this.field(this.fieldMainInstances);
        this.field(this.fieldAdditionalInstances);
        this.field(this.fieldPrediction);
    }

    @NotNull
    public final MainTierSet<P> getDeclarationMainTierSet() {
        return this.declarationMainTierSet;
    }

    @NotNull
    public final AdditionalTierSet<P> getDeclarationAdditionalTierSet() {
        return this.declarationAdditionalTierSet;
    }

    @NotNull
    public final EventField<F> getFieldPrediction() {
        return this.fieldPrediction;
    }

    @NotNull
    public final Function1<P, F> getSerializePrediction() {
        return this.serializePrediction;
    }

    public PredictionSessionFields(@NotNull LevelSignature<Map<Tier<?>, AnalysedTierScheme>, Map<Tier<?>, DescribedTierScheme>> levelScheme, @NotNull EventField<F> fieldPrediction, @NotNull Function1<? super P, ? extends F> serializePrediction) {
        Intrinsics.checkNotNullParameter(levelScheme, (String)"levelScheme");
        Intrinsics.checkNotNullParameter(fieldPrediction, (String)"fieldPrediction");
        Intrinsics.checkNotNullParameter(serializePrediction, (String)"serializePrediction");
        this(new MainTierSet(levelScheme.getMain()), new AdditionalTierSet(levelScheme.getAdditional()), fieldPrediction, serializePrediction);
    }

    @Override
    @NotNull
    public List<EventPair<?>> buildEventPairs(@NotNull SessionTree<Unit, AnalysedTierData, P> sessionStructure) {
        List eventPairs;
        block1: {
            Object serializedPrediction;
            Intrinsics.checkNotNullParameter(sessionStructure, (String)"sessionStructure");
            if (!(sessionStructure instanceof SessionTree.PredictionContainer)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Object[] objectArray = new EventPair[]{this.fieldMainInstances.with(this.declarationMainTierSet.buildObjectEventData(sessionStructure)), this.fieldAdditionalInstances.with(this.declarationAdditionalTierSet.buildObjectEventData(sessionStructure))};
            eventPairs = CollectionsKt.mutableListOf((Object[])objectArray);
            Object object = serializedPrediction = this.serializePrediction.invoke(((SessionTree.PredictionContainer)sessionStructure).getPrediction());
            if (object == null) break block1;
            Object it = object;
            boolean bl = false;
            ((Collection)eventPairs).add(this.fieldPrediction.with(it));
        }
        return eventPairs;
    }

    @NotNull
    public final MainTierSet<P> component1() {
        return this.declarationMainTierSet;
    }

    @NotNull
    public final AdditionalTierSet<P> component2() {
        return this.declarationAdditionalTierSet;
    }

    @NotNull
    public final EventField<F> component3() {
        return this.fieldPrediction;
    }

    @NotNull
    public final Function1<P, F> component4() {
        return this.serializePrediction;
    }

    @NotNull
    public final PredictionSessionFields<P, F> copy(@NotNull MainTierSet<P> declarationMainTierSet, @NotNull AdditionalTierSet<P> declarationAdditionalTierSet, @NotNull EventField<F> fieldPrediction, @NotNull Function1<? super P, ? extends F> serializePrediction) {
        Intrinsics.checkNotNullParameter(declarationMainTierSet, (String)"declarationMainTierSet");
        Intrinsics.checkNotNullParameter(declarationAdditionalTierSet, (String)"declarationAdditionalTierSet");
        Intrinsics.checkNotNullParameter(fieldPrediction, (String)"fieldPrediction");
        Intrinsics.checkNotNullParameter(serializePrediction, (String)"serializePrediction");
        return new PredictionSessionFields<P, F>(declarationMainTierSet, declarationAdditionalTierSet, fieldPrediction, serializePrediction);
    }

    public static /* synthetic */ PredictionSessionFields copy$default(PredictionSessionFields predictionSessionFields, MainTierSet mainTierSet, AdditionalTierSet additionalTierSet, EventField eventField, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            mainTierSet = predictionSessionFields.declarationMainTierSet;
        }
        if ((n & 2) != 0) {
            additionalTierSet = predictionSessionFields.declarationAdditionalTierSet;
        }
        if ((n & 4) != 0) {
            eventField = predictionSessionFields.fieldPrediction;
        }
        if ((n & 8) != 0) {
            function1 = predictionSessionFields.serializePrediction;
        }
        return predictionSessionFields.copy(mainTierSet, additionalTierSet, eventField, function1);
    }

    @NotNull
    public String toString() {
        return "PredictionSessionFields(declarationMainTierSet=" + this.declarationMainTierSet + ", declarationAdditionalTierSet=" + this.declarationAdditionalTierSet + ", fieldPrediction=" + this.fieldPrediction + ", serializePrediction=" + this.serializePrediction + ")";
    }

    @Override
    public int hashCode() {
        int result2 = this.declarationMainTierSet.hashCode();
        result2 = result2 * 31 + this.declarationAdditionalTierSet.hashCode();
        result2 = result2 * 31 + this.fieldPrediction.hashCode();
        result2 = result2 * 31 + this.serializePrediction.hashCode();
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PredictionSessionFields)) {
            return false;
        }
        PredictionSessionFields predictionSessionFields = (PredictionSessionFields)other;
        if (!Intrinsics.areEqual(this.declarationMainTierSet, predictionSessionFields.declarationMainTierSet)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.declarationAdditionalTierSet, predictionSessionFields.declarationAdditionalTierSet)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fieldPrediction, predictionSessionFields.fieldPrediction)) {
            return false;
        }
        return Intrinsics.areEqual(this.serializePrediction, predictionSessionFields.serializePrediction);
    }
}

