/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.product.serialization;

import com.intellij.platform.runtime.product.PluginModuleGroup;
import com.intellij.platform.runtime.product.ProductMode;
import com.intellij.platform.runtime.product.ProductModules;
import com.intellij.platform.runtime.product.impl.MainRuntimeModuleGroup;
import com.intellij.platform.runtime.product.impl.PluginModuleGroupImpl;
import com.intellij.platform.runtime.product.impl.ProductModulesImpl;
import com.intellij.platform.runtime.product.serialization.RawIncludedFromData;
import com.intellij.platform.runtime.product.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.product.serialization.RawProductModules;
import com.intellij.platform.runtime.product.serialization.ResourceFileResolver;
import com.intellij.platform.runtime.product.serialization.impl.ProductModulesXmlSerializer;
import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;

public final class ProductModulesSerialization {
    private ProductModulesSerialization() {
    }

    @NotNull
    public static ProductModules loadProductModules(@NotNull Path xmlFile, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (xmlFile == null) {
            ProductModulesSerialization.$$$reportNull$$$0(0);
        }
        if (currentMode == null) {
            ProductModulesSerialization.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            ProductModulesSerialization.$$$reportNull$$$0(2);
        }
        try {
            return ProductModulesSerialization.loadProductModules(Files.newInputStream(xmlFile, new OpenOption[0]), xmlFile.toString(), currentMode, repository);
        }
        catch (IOException e) {
            throw new MalformedRepositoryException("Failed to load module group from " + String.valueOf(xmlFile), (Throwable)e);
        }
    }

    @NotNull
    public static ProductModules loadProductModules(@NotNull InputStream inputStream, @NotNull String filePath, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (inputStream == null) {
            ProductModulesSerialization.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            ProductModulesSerialization.$$$reportNull$$$0(4);
        }
        if (currentMode == null) {
            ProductModulesSerialization.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            ProductModulesSerialization.$$$reportNull$$$0(6);
        }
        return ProductModulesSerialization.loadProductModules(inputStream, filePath, currentMode, repository, ResourceFileResolver.createDefault(repository));
    }

    @NotNull
    public static ProductModules loadProductModules(@NotNull InputStream inputStream, @NotNull String filePath, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository, @NotNull ResourceFileResolver resourceFileResolver) {
        if (inputStream == null) {
            ProductModulesSerialization.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            ProductModulesSerialization.$$$reportNull$$$0(8);
        }
        if (currentMode == null) {
            ProductModulesSerialization.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            ProductModulesSerialization.$$$reportNull$$$0(10);
        }
        if (resourceFileResolver == null) {
            ProductModulesSerialization.$$$reportNull$$$0(11);
        }
        RawProductModules rawProductModules = ProductModulesSerialization.readProductModulesAndMergeIncluded(inputStream, filePath, resourceFileResolver);
        return ProductModulesSerialization.loadProductModules(rawProductModules, filePath, currentMode, repository, resourceFileResolver);
    }

    @NotNull
    public static RawProductModules readProductModulesAndMergeIncluded(@NotNull InputStream inputStream, @NotNull String filePath, @NotNull ResourceFileResolver resolver) {
        RawProductModules rawProductModules;
        block7: {
            if (inputStream == null) {
                ProductModulesSerialization.$$$reportNull$$$0(12);
            }
            if (filePath == null) {
                ProductModulesSerialization.$$$reportNull$$$0(13);
            }
            if (resolver == null) {
                ProductModulesSerialization.$$$reportNull$$$0(14);
            }
            rawProductModules = ProductModulesXmlSerializer.parseModuleXml(inputStream);
            if (!rawProductModules.getIncludedFrom().isEmpty()) break block7;
            RawProductModules rawProductModules2 = rawProductModules;
            if (rawProductModules2 == null) {
                ProductModulesSerialization.$$$reportNull$$$0(15);
            }
            return rawProductModules2;
        }
        try {
            LinkedHashSet<RawIncludedRuntimeModule> allMainGroupModules = new LinkedHashSet<RawIncludedRuntimeModule>(rawProductModules.getMainGroupModules());
            LinkedHashSet<RuntimeModuleId> allBundledPluginMainModules = new LinkedHashSet<RuntimeModuleId>(rawProductModules.getBundledPluginMainModules());
            ProductModulesSerialization.mergeIncludedFiles(rawProductModules, filePath, resolver, allMainGroupModules, allBundledPluginMainModules);
            return new RawProductModules(new ArrayList<RawIncludedRuntimeModule>(allMainGroupModules), new ArrayList<RuntimeModuleId>(allBundledPluginMainModules), Collections.emptyList());
        }
        catch (IOException | XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load module group from " + filePath, (Throwable)e);
        }
    }

    @NotNull
    private static ProductModulesImpl loadProductModules(@NotNull RawProductModules rawProductModules, @NotNull String debugName, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository, @NotNull ResourceFileResolver resourceFileResolver) {
        if (rawProductModules == null) {
            ProductModulesSerialization.$$$reportNull$$$0(16);
        }
        if (debugName == null) {
            ProductModulesSerialization.$$$reportNull$$$0(17);
        }
        if (currentMode == null) {
            ProductModulesSerialization.$$$reportNull$$$0(18);
        }
        if (repository == null) {
            ProductModulesSerialization.$$$reportNull$$$0(19);
        }
        if (resourceFileResolver == null) {
            ProductModulesSerialization.$$$reportNull$$$0(20);
        }
        MainRuntimeModuleGroup mainGroup = new MainRuntimeModuleGroup(rawProductModules.getMainGroupModules(), currentMode, repository);
        ArrayList<PluginModuleGroup> bundledPluginModuleGroups = new ArrayList<PluginModuleGroup>();
        for (RuntimeModuleId pluginMainModule : rawProductModules.getBundledPluginMainModules()) {
            RuntimeModuleDescriptor module = repository.resolveModule(pluginMainModule).getResolvedModule();
            if (module == null) continue;
            bundledPluginModuleGroups.add(new PluginModuleGroupImpl(module, currentMode, repository, resourceFileResolver));
        }
        return new ProductModulesImpl(debugName, mainGroup, bundledPluginModuleGroups);
    }

    private static void mergeIncludedFiles(@NotNull RawProductModules rawProductModules, @NotNull String debugName, @NotNull ResourceFileResolver resolver, @NotNull Set<RawIncludedRuntimeModule> mainGroupModules, @NotNull Set<RuntimeModuleId> bundledPluginMainModules) throws IOException, XMLStreamException {
        if (rawProductModules == null) {
            ProductModulesSerialization.$$$reportNull$$$0(21);
        }
        if (debugName == null) {
            ProductModulesSerialization.$$$reportNull$$$0(22);
        }
        if (resolver == null) {
            ProductModulesSerialization.$$$reportNull$$$0(23);
        }
        if (mainGroupModules == null) {
            ProductModulesSerialization.$$$reportNull$$$0(24);
        }
        if (bundledPluginMainModules == null) {
            ProductModulesSerialization.$$$reportNull$$$0(25);
        }
        for (RawIncludedFromData includedFromData : rawProductModules.getIncludedFrom()) {
            RuntimeModuleId includedId = includedFromData.getFromModule();
            InputStream inputStream = resolver.readResourceFile(includedId, "META-INF/" + includedId.getStringId() + "/product-modules.xml");
            if (inputStream == null) {
                throw new MalformedRepositoryException("'" + includedId.getStringId() + "' included in " + debugName + " doesn't contain product-modules.xml");
            }
            RawProductModules includedModules = ProductModulesXmlSerializer.parseModuleXml(inputStream);
            ProductModulesSerialization.mergeIncludedFiles(includedModules, debugName, resolver, mainGroupModules, bundledPluginMainModules);
            for (RawIncludedRuntimeModule mainGroupModule : includedModules.getMainGroupModules()) {
                if (includedFromData.getWithoutModules().contains(mainGroupModule.getModuleId())) continue;
                mainGroupModules.add(mainGroupModule);
            }
            for (RuntimeModuleId pluginMainModule : includedModules.getBundledPluginMainModules()) {
                if (includedFromData.getWithoutModules().contains(pluginMainModule)) continue;
                bundledPluginMainModules.add(pluginMainModule);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFileResolver";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/product/serialization/ProductModulesSerialization";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawProductModules";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGroupModules";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundledPluginMainModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/product/serialization/ProductModulesSerialization";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readProductModulesAndMergeIncluded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadProductModules";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readProductModulesAndMergeIncluded";
                break;
            }
            case 15: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "mergeIncludedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

