/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class PresentableId
implements Cloneable {
    @Nullable
    private final String myId;
    @Nullable
    private final String myName;

    @Contract(value="null, null -> fail")
    private PresentableId(@Nullable String id, @Nullable String name) {
        if (name == null && id == null) {
            throw new IllegalStateException("Either id or name should be provided");
        }
        this.myId = id;
        this.myName = name;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean hasId() {
        return this.myId != null;
    }

    public boolean hasName() {
        return this.myName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentableId id = (PresentableId)o;
        return Objects.equals(this.myId, id.myId) && Objects.equals(this.myName, id.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myName);
    }

    public PresentableId clone() {
        try {
            return (PresentableId)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "PresentableId{myId='" + this.myId + "', myName='" + this.myName + "'}";
    }

    @Contract(value="_, !null->!null")
    @Nullable
    public static PresentableId createId(@Nullable String id, @Nullable String name) {
        id = StringUtil.nullize((String)id);
        name = StringUtil.nullize((String)name);
        return id == null && name == null ? null : new PresentableId(id, name);
    }
}

