/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionCredentialsWrapper {
    private UserDataHolderBase myCredentialsTypeHolder = new UserDataHolderBase();

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myCredentialsTypeHolder = new UserDataHolderBase();
        this.myCredentialsTypeHolder.putUserData(key, credentials);
    }

    public Object getConnectionKey() {
        return this.getCredentials();
    }

    public void save(Element rootElement) {
        this.getTypeHandler().save(rootElement);
    }

    public void copyTo(RemoteConnectionCredentialsWrapper copy) {
        copy.myCredentialsTypeHolder = new UserDataHolderBase();
        Pair<Object, CredentialsType> credentialsAndProvider = this.getCredentialsAndType();
        ((CredentialsType)credentialsAndProvider.second).putCredentials(copy.myCredentialsTypeHolder, credentialsAndProvider.first);
    }

    @NotNull
    public String getId() {
        String string = this.getTypeHandler().getId();
        if (string == null) {
            RemoteConnectionCredentialsWrapper.$$$reportNull$$$0(0);
        }
        return string;
    }

    public RemoteCredentialsHandler getTypeHandler() {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        return ((CredentialsType)credentialsAndType.second).getHandler(credentialsAndType.first);
    }

    public CredentialsType getRemoteConnectionType() {
        return (CredentialsType)this.getCredentialsAndType().second;
    }

    public Object getCredentials() {
        return this.getCredentialsAndType().first;
    }

    private Pair<Object, CredentialsType> getCredentialsAndType() {
        for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
            Object credentials = this.getCredentials(type);
            if (credentials == null) continue;
            return new Pair(credentials, type);
        }
        UnknownCredentialsHolder credentials = CredentialsType.UNKNOWN.getCredentials(this.myCredentialsTypeHolder);
        if (credentials != null) {
            return new Pair((Object)credentials, CredentialsType.UNKNOWN);
        }
        throw new IllegalStateException("Unknown connection type");
    }

    @Nullable
    public <T> T getCredentials(@NotNull CredentialsType<T> credentialsType) {
        if (credentialsType == null) {
            RemoteConnectionCredentialsWrapper.$$$reportNull$$$0(1);
        }
        return credentialsType.getCredentials(this.myCredentialsTypeHolder);
    }

    public void switchType(CredentialsCase ... cases) {
        Pair<Object, CredentialsType> credentialsAndType = this.getCredentialsAndType();
        CredentialsType type = (CredentialsType)credentialsAndType.second;
        for (CredentialsCase credentialsCase : cases) {
            if (credentialsCase.getType() != type) continue;
            credentialsCase.process(credentialsAndType.first);
            return;
        }
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof RemoteConnectionCredentialsWrapper) {
            RemoteConnectionCredentialsWrapper w = (RemoteConnectionCredentialsWrapper)obj2;
            try {
                Object credentials = this.getCredentials();
                Object counterCredentials = w.getCredentials();
                return credentials.equals(counterCredentials);
            }
            catch (IllegalStateException e) {
                return false;
            }
        }
        return false;
    }

    public String getPresentableDetails(String interpreterPath) {
        return this.getTypeHandler().getPresentableDetails(interpreterPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteConnectionCredentialsWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteConnectionCredentialsWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

