/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.remote.RemoteSdkProperties;
import org.jetbrains.annotations.NotNull;

public final class RemoteFile {
    private final String myPath;
    private final boolean myWin;

    private RemoteFile(String path, boolean isWindows) {
        this.myPath = FileUtil.toSystemIndependentName((String)path).replace('/', RemoteFile.getSeparator(isWindows));
        this.myWin = isWindows;
    }

    private RemoteFile(String parent, String child, boolean isWindows) {
        this(RemoteFile.resolveChild(parent, child, isWindows), isWindows);
    }

    private static char getSeparator(boolean isWindows) {
        return isWindows ? (char)'\\' : '/';
    }

    private static String resolveChild(String parent, String child, boolean win) {
        char separator = RemoteFile.getSeparator(win);
        return parent.endsWith(String.valueOf(separator)) ? parent + child : parent + separator + child;
    }

    @NotNull
    public String getName() {
        int ind = this.myPath.lastIndexOf(RemoteFile.getSeparator(this.myWin));
        if (ind != -1 && ind < this.myPath.length() - 1) {
            String string = this.myPath.substring(ind + 1);
            if (string == null) {
                RemoteFile.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.myPath;
        if (string == null) {
            RemoteFile.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isWin() {
        return RemoteFile.isWindowsPath(this.myPath);
    }

    public static boolean isWindowsPath(@NotNull String path) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(2);
        }
        path = RemoteSdkProperties.getInterpreterPathFromFullPath(path);
        return OSAgnosticPathUtil.startsWithWindowsDrive((String)path);
    }

    @NotNull
    public static RemoteFile createRemoteFile(@NotNull String path) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(3);
        }
        return new RemoteFile(path, RemoteFile.isWindowsPath(path));
    }

    @NotNull
    public static RemoteFile createRemoteFile(@NotNull String path, boolean isWindows) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(4);
        }
        return new RemoteFile(path, isWindows);
    }

    @NotNull
    public static RemoteFile createRemoteFile(@NotNull String parent, @NotNull String child) {
        if (parent == null) {
            RemoteFile.$$$reportNull$$$0(5);
        }
        if (child == null) {
            RemoteFile.$$$reportNull$$$0(6);
        }
        return new RemoteFile(parent, child, RemoteFile.isWindowsPath(parent));
    }

    @NotNull
    public static RemoteFile createRemoteFile(@NotNull String parent, @NotNull String child, boolean isWindows) {
        if (parent == null) {
            RemoteFile.$$$reportNull$$$0(7);
        }
        if (child == null) {
            RemoteFile.$$$reportNull$$$0(8);
        }
        return new RemoteFile(parent, child, isWindows);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

