/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.PathMappingSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RemoteSdkProperties
extends RemoteSdkPropertiesPaths {
    public void setInterpreterPath(String var1);

    public void setHelpersPath(String var1);

    public String getDefaultHelpersName();

    @NotNull
    public PathMappingSettings getPathMappings();

    public void setPathMappings(@Nullable PathMappingSettings var1);

    public boolean isHelpersVersionChecked();

    public void setHelpersVersionChecked(boolean var1);

    public void setSdkId(String var1);

    public String getSdkId();

    public boolean isValid();

    public void setValid(boolean var1);

    public boolean isRunAsRootViaSudo();

    public void setRunAsRootViaSudo(boolean var1);

    @NotNull
    public static String getFullInterpreterPath(@NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties properties) {
        if (credentials == null) {
            RemoteSdkProperties.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            RemoteSdkProperties.$$$reportNull$$$0(1);
        }
        StringBuilder builder = new StringBuilder();
        if (properties.isRunAsRootViaSudo()) {
            builder.append("sudo+");
        }
        builder.append(RemoteCredentialsHolder.getCredentialsString(credentials));
        builder.append(properties.getInterpreterPath());
        String string = builder.toString();
        if (string == null) {
            RemoteSdkProperties.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getInterpreterPathFromFullPath(@NotNull String fullPath) {
        int index;
        if (fullPath == null) {
            RemoteSdkProperties.$$$reportNull$$$0(3);
        }
        if (fullPath.startsWith("ssh://") && (index = (fullPath = fullPath.substring("ssh://".length())).indexOf(":")) != -1) {
            fullPath = fullPath.substring(index + 1);
            for (index = 0; index < fullPath.length() && Character.isDigit(fullPath.charAt(index)); ++index) {
            }
            if (index < fullPath.length()) {
                String string = fullPath.substring(index);
                if (string == null) {
                    RemoteSdkProperties.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        String string = fullPath;
        if (string == null) {
            RemoteSdkProperties.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isRemoteSdk(@Nullable String path) {
        if (path != null) {
            for (CredentialsType<?> type : CredentialsManager.getInstance().getAllTypes()) {
                if (!type.hasPrefix(path)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteSdkProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteSdkProperties";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullInterpreterPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPathFromFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullInterpreterPath";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPathFromFullPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

