/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkPropertiesHolder
implements RemoteSdkProperties {
    public static final String DEFAULT_HELPERS_DIR_NAME = ".idea_helpers";
    private static final String INTERPRETER_PATH = "INTERPRETER_PATH";
    private static final String HELPERS_PATH = "HELPERS_PATH";
    private static final String VALID = "VALID";
    private static final String RUN_AS_ROOT_VIA_SUDO = "RUN_AS_ROOT_VIA_SUDO";
    private String mySdkId;
    private String myInterpreterPath;
    private String myHelpersPath;
    private final String myHelpersDefaultDirName;
    private boolean myHelpersVersionChecked = false;
    private boolean myValid = true;
    private boolean myRunAsRootViaSudo = false;
    private PathMappingSettings myPathMappings = new PathMappingSettings();

    public RemoteSdkPropertiesHolder(String helpersDefaultDirName) {
        this.myHelpersDefaultDirName = helpersDefaultDirName;
    }

    @Override
    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    @Override
    public String getHelpersPath() {
        return this.myHelpersPath;
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myHelpersPath = helpersPath;
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myHelpersDefaultDirName;
    }

    @Override
    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myPathMappings;
        if (pathMappingSettings == null) {
            RemoteSdkPropertiesHolder.$$$reportNull$$$0(0);
        }
        return pathMappingSettings;
    }

    @Override
    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myPathMappings = new PathMappingSettings();
        if (pathMappings != null) {
            this.myPathMappings.addAll(pathMappings);
        }
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myHelpersVersionChecked;
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myHelpersVersionChecked = helpersVersionChecked;
    }

    @Override
    public void setSdkId(String sdkId) {
        this.mySdkId = sdkId;
    }

    @Override
    public String getSdkId() {
        return this.mySdkId;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public boolean isRunAsRootViaSudo() {
        return this.myRunAsRootViaSudo;
    }

    @Override
    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRunAsRootViaSudo = runAsRootViaSudo;
    }

    public void copyTo(RemoteSdkProperties copy) {
        copy.setInterpreterPath(this.getInterpreterPath());
        copy.setHelpersPath(this.getHelpersPath());
        copy.setHelpersVersionChecked(this.isHelpersVersionChecked());
        copy.setValid(this.isValid());
        copy.setRunAsRootViaSudo(this.isRunAsRootViaSudo());
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(INTERPRETER_PATH, StringUtil.notNullize((String)this.getInterpreterPath()));
        rootElement.setAttribute(HELPERS_PATH, StringUtil.notNullize((String)this.getHelpersPath()));
        rootElement.setAttribute(VALID, Boolean.toString(this.isValid()));
        rootElement.setAttribute(RUN_AS_ROOT_VIA_SUDO, Boolean.toString(this.isRunAsRootViaSudo()));
        PathMappingSettings.writeExternal((Element)rootElement, (PathMappingSettings)this.myPathMappings);
    }

    public void load(Element element) {
        this.setInterpreterPath(StringUtil.nullize((String)element.getAttributeValue(INTERPRETER_PATH)));
        this.setHelpersPath(StringUtil.nullize((String)element.getAttributeValue(HELPERS_PATH)));
        this.setValid(Boolean.parseBoolean(element.getAttributeValue(VALID)));
        this.setPathMappings(PathMappingSettings.readExternal((Element)element));
        this.setRunAsRootViaSudo(Boolean.parseBoolean(element.getAttributeValue(RUN_AS_ROOT_VIA_SUDO)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSdkPropertiesHolder holder = (RemoteSdkPropertiesHolder)o;
        if (this.myHelpersVersionChecked != holder.myHelpersVersionChecked) {
            return false;
        }
        if (this.myValid != holder.myValid) {
            return false;
        }
        if (!Objects.equals(this.myHelpersDefaultDirName, holder.myHelpersDefaultDirName)) {
            return false;
        }
        if (!Objects.equals(this.myHelpersPath, holder.myHelpersPath)) {
            return false;
        }
        if (!Objects.equals(this.myInterpreterPath, holder.myInterpreterPath)) {
            return false;
        }
        if (this.myRunAsRootViaSudo != holder.myRunAsRootViaSudo) {
            return false;
        }
        if (!this.myPathMappings.equals((Object)holder.myPathMappings)) {
            return false;
        }
        return Objects.equals(this.mySdkId, holder.mySdkId);
    }

    public int hashCode() {
        int result2 = this.mySdkId != null ? this.mySdkId.hashCode() : 0;
        result2 = 31 * result2 + (this.myInterpreterPath != null ? this.myInterpreterPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myRunAsRootViaSudo ? 1 : 0);
        result2 = 31 * result2 + (this.myHelpersPath != null ? this.myHelpersPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersDefaultDirName != null ? this.myHelpersDefaultDirName.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersVersionChecked ? 1 : 0);
        result2 = 31 * result2 + (this.myValid ? 1 : 0);
        result2 = 31 * result2 + this.myPathMappings.hashCode();
        return result2;
    }

    public String toString() {
        return "RemoteSdkPropertiesHolder{mySdkId='" + this.mySdkId + "', myInterpreterPath='" + this.myInterpreterPath + "', myHelpersPath='" + this.myHelpersPath + "', myHelpersDefaultDirName='" + this.myHelpersDefaultDirName + "', myHelpersVersionChecked=" + this.myHelpersVersionChecked + ", myValid=" + this.myValid + ", myRunAsRootViaSudo=" + this.myRunAsRootViaSudo + ", myPathMappings=" + String.valueOf(this.myPathMappings) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteSdkPropertiesHolder", "getPathMappings"));
    }
}

