/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.OutdatedCredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CannotLoadCredentialsException;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CredentialsManager {
    public static CredentialsManager getInstance() {
        return (CredentialsManager)ApplicationManager.getApplication().getService(CredentialsManager.class);
    }

    public abstract List<CredentialsType<?>> getAllTypes();

    public abstract void loadCredentials(String var1, @Nullable Element var2, RemoteSdkAdditionalData var3);

    public static void updateOutdatedSdk(@NotNull RemoteSdkAdditionalData data, @Nullable Project project) {
        if (data == null) {
            CredentialsManager.$$$reportNull$$$0(0);
        }
        if (!(data.getRemoteConnectionType() instanceof OutdatedCredentialsType)) {
            return;
        }
        Pair pair = ((OutdatedCredentialsType)((Object)data.getRemoteConnectionType())).transformToNewerType(data.connectionCredentials().getCredentials(), project);
        data.setCredentials(((CredentialsType)pair.getFirst()).getCredentialsKey(), pair.getSecond());
    }

    public static void recogniseCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (additionalData == null) {
            CredentialsManager.$$$reportNull$$$0(1);
        }
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(2);
        }
        additionalData.forEach(data -> CredentialsManager.recogniseCredentialType(data, credentialsType));
    }

    private static void recogniseCredentialType(@Nullable SdkAdditionalData additionalData, CredentialsType credentialsType) {
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data = (RemoteSdkAdditionalData)additionalData;
        if (data.getRemoteConnectionType() != CredentialsType.UNKNOWN) {
            return;
        }
        String credentialsId = data.connectionCredentials().getId();
        if (!credentialsType.hasPrefix(credentialsId)) {
            return;
        }
        Element root = new Element("root");
        data.connectionCredentials().save(root);
        Object credentials = credentialsType.createCredentials();
        try {
            credentialsType.getHandler(credentials).load(root);
        }
        catch (CannotLoadCredentialsException e) {
            Logger.getInstance(CredentialsManager.class).warn((Throwable)e);
            return;
        }
        data.setCredentials(credentialsType.getCredentialsKey(), credentials);
    }

    public static void forgetCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (additionalData == null) {
            CredentialsManager.$$$reportNull$$$0(3);
        }
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(4);
        }
        additionalData.forEach(data -> CredentialsManager.forgetCredentialType(data, credentialsType));
    }

    private static void forgetCredentialType(@Nullable SdkAdditionalData additionalData, CredentialsType<?> credentialsType) {
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data = (RemoteSdkAdditionalData)additionalData;
        if (data.getRemoteConnectionType() != credentialsType) {
            return;
        }
        Element root = new Element("root");
        data.connectionCredentials().save(root);
        UnknownCredentialsHolder unknownCredentials = CredentialsType.UNKNOWN.createCredentials();
        unknownCredentials.setSdkId(data.getSdkId());
        try {
            CredentialsType.UNKNOWN.getHandler(unknownCredentials).load(root);
        }
        catch (CannotLoadCredentialsException e) {
            Logger.getInstance(CredentialsManager.class).warn((Throwable)e);
        }
        data.setCredentials(CredentialsType.UNKNOWN.getCredentialsKey(), unknownCredentials);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remote/ext/CredentialsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOutdatedSdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "recogniseCredentialType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "forgetCredentialType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

