/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.connection.JetBrainsClientDownloadInfo;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.EmbeddedClientLauncher;
import com.intellij.remoteDev.downloader.FrontendInstallation;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.downloader.NotificationBasedEmbeddedClientErrorReporter;
import com.intellij.remoteDev.downloader.StandaloneFrontendInstallation;
import com.intellij.remoteDev.downloader.ThinClientSessionInfoFetcher;
import com.intellij.remoteDev.downloader.exceptions.CodeWithMeDownloaderExceptionHandler;
import com.intellij.remoteDev.util.UrlUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJT\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u001aJJ\u0010\u001b\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J:\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\b2\b\b\u0001\u0010\u0017\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0018\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeGuestLauncher;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "alreadyDownloading", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "isUnattendedModeUri", "uri", "Ljava/net/URI;", "downloadCompatibleClientAndLaunch", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "clientBuild", "Lcom/intellij/openapi/util/BuildNumber;", "url", "product", "enableBeforeRunHooks", "onDone", "Lkotlin/Function1;", "runAlreadyDownloadedClient", "aLifetime", "findFrontendInstallation", "Lcom/intellij/remoteDev/downloader/FrontendInstallation;", "runDownloadedFrontend", "frontendInstallation", "urlForThinClient", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "DownloadAndLaunchClientTask", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nCodeWithMeGuestLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeGuestLauncher.kt\ncom/intellij/remoteDev/downloader/CodeWithMeGuestLauncher\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,199:1\n42#2,3:200\n13#3:203\n*S KotlinDebug\n*F\n+ 1 CodeWithMeGuestLauncher.kt\ncom/intellij/remoteDev/downloader/CodeWithMeGuestLauncher\n*L\n168#1:200,3\n29#1:203\n*E\n"})
public final class CodeWithMeGuestLauncher {
    @NotNull
    public static final CodeWithMeGuestLauncher INSTANCE = new CodeWithMeGuestLauncher();
    @NotNull
    private static final Logger LOG;
    private static final ConcurrentHashMap.KeySetView<String, Boolean> alreadyDownloading;

    private CodeWithMeGuestLauncher() {
    }

    public final boolean isUnattendedModeUri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return UriUtilKt.getFragmentParameters((URI)uri).get("jt") != null;
    }

    public final void downloadCompatibleClientAndLaunch(@Nullable Lifetime lifetime, @Nullable Project project, @Nullable BuildNumber clientBuild, @NotNull String url, @NlsContexts.DialogTitle @NotNull String product, boolean enableBeforeRunHooks, @NotNull Function1<? super Lifetime, Unit> onDone) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter(onDone, (String)"onDone");
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            ApplicationKt.getApplication().invokeLater(() -> CodeWithMeGuestLauncher.downloadCompatibleClientAndLaunch$lambda$1(lifetime, project, clientBuild, url, product, enableBeforeRunHooks, onDone), ModalityState.any());
            return;
        }
        URI uRI = UrlUtil.INSTANCE.parseOrShowError(url, product);
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        if (this.runAlreadyDownloadedClient(clientBuild, lifetime, project, url, enableBeforeRunHooks, onDone)) {
            return;
        }
        if (!alreadyDownloading.add(url)) {
            LOG.info("Already downloading a client for " + url);
            return;
        }
        ProgressManager.getInstance().run((Task)new DownloadAndLaunchClientTask(project, uri, lifetime, url, product, enableBeforeRunHooks, onDone));
    }

    public static /* synthetic */ void downloadCompatibleClientAndLaunch$default(CodeWithMeGuestLauncher codeWithMeGuestLauncher, Lifetime lifetime, Project project, BuildNumber buildNumber, String string, String string2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 0x40) != 0) {
            function1 = CodeWithMeGuestLauncher::downloadCompatibleClientAndLaunch$lambda$0;
        }
        codeWithMeGuestLauncher.downloadCompatibleClientAndLaunch(lifetime, project, buildNumber, string, string2, bl, (Function1<? super Lifetime, Unit>)function1);
    }

    private final boolean runAlreadyDownloadedClient(BuildNumber clientBuild, Lifetime aLifetime, Project project, String url, boolean enableBeforeRunHooks, Function1<? super Lifetime, Unit> onDone) {
        if (clientBuild == null) {
            return false;
        }
        EmbeddedClientLauncher embeddedClientLauncher = CodeWithMeClientDownloader.INSTANCE.createEmbeddedClientLauncherIfAvailable$intellij_remoteDev_util(clientBuild);
        if (embeddedClientLauncher != null) {
            Object object = aLifetime;
            if (object == null) {
                Project project2 = project;
                object = project2 != null ? LifetimeDisposableExKt.createLifetime((Disposable)project2) : null;
                if (object == null) {
                    object = Lifetime.Companion.getEternal();
                }
            }
            Lifetime lifetime = object;
            Lifetime clientLifetime = embeddedClientLauncher.launch(url, lifetime, new NotificationBasedEmbeddedClientErrorReporter(project));
            onDone.invoke((Object)clientLifetime);
            return true;
        }
        FrontendInstallation frontendInstallation = this.findFrontendInstallation(clientBuild);
        if (frontendInstallation == null) {
            return false;
        }
        Object object = aLifetime;
        if (object == null) {
            Project project3 = project;
            object = project3 != null ? LifetimeDisposableExKt.createLifetime((Disposable)project3) : null;
            if (object == null) {
                object = Lifetime.Companion.getEternal();
            }
        }
        Lifetime lifetime = object;
        Lifetime clientLifetime = CodeWithMeClientDownloader.INSTANCE.runFrontendProcess(lifetime, url, frontendInstallation, enableBeforeRunHooks);
        onDone.invoke((Object)clientLifetime);
        return true;
    }

    private final FrontendInstallation findFrontendInstallation(BuildNumber clientBuild) {
        FrontendInstallation customSnapshotInstallation;
        FrontendInstallation frontendInstallation = customSnapshotInstallation = CodeWithMeClientDownloader.INSTANCE.createCustomFrontendSnapshotInstallation$intellij_remoteDev_util(clientBuild);
        if (frontendInstallation != null) {
            return frontendInstallation;
        }
        if (!CodeWithMeClientDownloader.INSTANCE.isClientDownloaded(clientBuild)) {
            return null;
        }
        JetBrainsClientDownloadInfo sessionInfo = CodeWithMeClientDownloader.INSTANCE.createSessionInfo(clientBuild, null, true);
        Path tempDir = FileUtil.createTempDirectory((String)"jb-cwm-dl", null).toPath();
        URI clientUrl = new URI(sessionInfo.getCompatibleClientUrl());
        Intrinsics.checkNotNull((Object)tempDir);
        boolean $i$f$service = false;
        Class<JetBrainsClientDownloaderConfigurationProvider> serviceClass$iv = JetBrainsClientDownloaderConfigurationProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CodeWithMeClientDownloader.DownloadableFileData guestData = CodeWithMeClientDownloader.DownloadableFileData.Companion.build(clientUrl, tempDir, ((JetBrainsClientDownloaderConfigurationProvider)object).getClientCachesDir(), CodeWithMeClientDownloader.INSTANCE.getJetBrainsClientManifestFilter(sessionInfo.getClientBuildNumber()));
        return new StandaloneFrontendInstallation(guestData.getTargetPath(), clientBuild, null);
    }

    @NotNull
    public final Lifetime runDownloadedFrontend(@NotNull Lifetime lifetime, @NotNull FrontendInstallation frontendInstallation, @NotNull String urlForThinClient, @NlsContexts.DialogTitle @NotNull String product, @Nullable ProgressIndicator progressIndicator, boolean enableBeforeRunHooks) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)frontendInstallation, (String)"frontendInstallation");
        Intrinsics.checkNotNullParameter((Object)urlForThinClient, (String)"urlForThinClient");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        try {
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(RemoteDevUtilBundle.INSTANCE.message("launcher.launch.client", new Object[0]));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(((Object)frontendInstallation.getInstallationHome()).toString());
            }
            Lifetime thinClientLifetime = CodeWithMeClientDownloader.INSTANCE.runFrontendProcess(lifetime, urlForThinClient, frontendInstallation, enableBeforeRunHooks);
            Thread.sleep(3000L);
            return thinClientLifetime;
        }
        catch (Throwable t) {
            Logger.getInstance(this.getClass()).warn(t);
            ApplicationKt.getApplication().invokeLater(() -> CodeWithMeGuestLauncher.runDownloadedFrontend$lambda$0(t, product));
            return Lifetime.Companion.getTerminated();
        }
    }

    private static final Unit downloadCompatibleClientAndLaunch$lambda$0(Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final void downloadCompatibleClientAndLaunch$lambda$1(Lifetime $lifetime, Project $project, BuildNumber $clientBuild, String $url, String $product, boolean $enableBeforeRunHooks, Function1 $onDone) {
        INSTANCE.downloadCompatibleClientAndLaunch($lifetime, $project, $clientBuild, $url, $product, $enableBeforeRunHooks, (Function1<? super Lifetime, Unit>)$onDone);
    }

    private static final void runDownloadedFrontend$lambda$0(Throwable $t, String $product) {
        Object[] objectArray = new Object[1];
        String string = $t.getMessage();
        if (string == null) {
            string = "Unknown";
        }
        objectArray[0] = string;
        Messages.showErrorDialog((String)RemoteDevUtilBundle.INSTANCE.message("error.guest.run.issue", objectArray), (String)$product);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getAlreadyDownloading$p() {
        return alreadyDownloading;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeGuestLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        alreadyDownloading = ConcurrentHashMap.newKeySet();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BT\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000b\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeGuestLauncher$DownloadAndLaunchClientTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "url", "", "product", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "enableBeforeRunHooks", "", "onDone", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/net/URI;Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "clientLifetime", "run", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "onCancel", "intellij.remoteDev.util"})
    private static final class DownloadAndLaunchClientTask
    extends Task.Backgroundable {
        @Nullable
        private final Project project;
        @NotNull
        private final URI uri;
        @Nullable
        private final Lifetime lifetime;
        @NotNull
        private final String url;
        @NotNull
        private final String product;
        private final boolean enableBeforeRunHooks;
        @NotNull
        private final Function1<Lifetime, Unit> onDone;
        @NotNull
        private Lifetime clientLifetime;

        public DownloadAndLaunchClientTask(@Nullable Project project, @NotNull URI uri, @Nullable Lifetime lifetime, @NotNull String url, @NotNull String product, boolean enableBeforeRunHooks, @NotNull Function1<? super Lifetime, Unit> onDone) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)product, (String)"product");
            Intrinsics.checkNotNullParameter(onDone, (String)"onDone");
            super(project, RemoteDevUtilBundle.INSTANCE.message("launcher.title", new Object[0]), true);
            this.project = project;
            this.uri = uri;
            this.lifetime = lifetime;
            this.url = url;
            this.product = product;
            this.enableBeforeRunHooks = enableBeforeRunHooks;
            this.onDone = onDone;
            this.clientLifetime = Lifetime.Companion.getTerminated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void run(@NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            try {
                block19: {
                    block18: {
                        var3_2 = this.uri.getScheme();
                        if (var3_2 == null) break block18;
                        switch (var3_2.hashCode()) {
                            case 114657: {
                                if (!var3_2.equals("tcp")) {
                                    ** break;
                                }
                                ** GOTO lbl19
                            }
                            case 3213448: {
                                if (var3_2.equals("http")) break;
                                ** break;
                            }
                            case 99617003: {
                                if (var3_2.equals("https")) break;
                                ** break;
                            }
                            case 3186636: {
                                if (!var3_2.equals("gwws")) ** break;
lbl19:
                                // 2 sources

                                v0 = (String)UriUtilKt.getFragmentParameters((URI)this.uri).get("cb");
                                if (v0 == null) {
                                    throw new IllegalStateException("there is no client build in url".toString());
                                }
                                clientBuildString = v0;
                                v1 = (String)UriUtilKt.getFragmentParameters((URI)this.uri).get("jb");
                                if (v1 == null) {
                                    throw new IllegalStateException("there is no jre build in url".toString());
                                }
                                jreBuild = v1;
                                v2 = BuildNumber.fromStringOrNull((String)clientBuildString);
                                if (v2 == null) {
                                    throw new IllegalStateException(("invalid client build: " + clientBuildString).toString());
                                }
                                clientBuild = v2;
                                unattendedMode = CodeWithMeGuestLauncher.INSTANCE.isUnattendedModeUri(this.uri);
                                v3 = CodeWithMeClientDownloader.INSTANCE.createSessionInfo(clientBuild, jreBuild, unattendedMode);
                                break block19;
                            }
                        }
                        progressIndicator.setText(RemoteDevUtilBundle.INSTANCE.message("launcher.get.client.info", new Object[0]));
                        v3 = ThinClientSessionInfoFetcher.INSTANCE.getSessionUrl(this.uri);
                        break block19;
                    }
                    throw new IllegalStateException(("scheme '" + this.uri.getScheme() + " is not supported'").toString());
                }
                sessionInfo = v3;
                v4 /* !! */  = this.lifetime;
                if (v4 /* !! */  == null) {
                    v5 = this.project;
                    v4 /* !! */  = v5 != null ? LifetimeDisposableExKt.createLifetime((Disposable)v5) : null;
                    if (v4 /* !! */  == null) {
                        v4 /* !! */  = Lifetime.Companion.getEternal();
                    }
                }
                parentLifetime = v4 /* !! */ ;
                frontendInstallation = CodeWithMeClientDownloader.INSTANCE.downloadFrontendAndJdk(sessionInfo, progressIndicator);
                this.clientLifetime = CodeWithMeGuestLauncher.INSTANCE.runDownloadedFrontend(parentLifetime, frontendInstallation, this.url, this.product, progressIndicator, this.enableBeforeRunHooks);
            }
            catch (Throwable t) {
                CodeWithMeGuestLauncher.access$getLOG$p().warn(t);
                CodeWithMeDownloaderExceptionHandler.INSTANCE.handle(this.product, t);
            }
            finally {
                CodeWithMeGuestLauncher.access$getAlreadyDownloading$p().remove(this.url);
            }
        }

        public void onSuccess() {
            this.onDone.invoke((Object)this.clientLifetime);
        }

        public void onCancel() {
        }
    }
}

