/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.tests.impl;

import com.intellij.openapi.diagnostic.DelegatingLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.tests.impl.AgentTestLoggerFactory;
import com.intellij.remoteDev.tests.modelGenerated.RdTestSession;
import com.intellij.remoteDev.tests.modelGenerated.RdTestSessionException;
import com.intellij.remoteDev.tests.modelGenerated.RdTestSessionLightException;
import com.intellij.remoteDev.tests.modelGenerated.RdTestSessionStackTraceElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u000f\"\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u000fH\u0004\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u0012\u0010\u001b\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u001a\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/remoteDev/tests/impl/AgentTestLogger;", "Lcom/intellij/openapi/diagnostic/DelegatingLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "logger", "factory", "Lcom/intellij/remoteDev/tests/impl/AgentTestLoggerFactory;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/remoteDev/tests/impl/AgentTestLoggerFactory;)V", "error", "", "message", "", "t", "", "details", "", "(Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/String;)V", "sendToTestRunner", "session", "Lcom/intellij/remoteDev/tests/modelGenerated/RdTestSession;", "getRdtseStackTrace", "", "Lcom/intellij/remoteDev/tests/modelGenerated/RdTestSessionStackTraceElement;", "stackTrace", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/util/List;", "getRdtseMessage", "getRdtseType", "getRdtseCause", "Lcom/intellij/remoteDev/tests/modelGenerated/RdTestSessionLightException;", "getRdtseSuppressedExceptions", "intellij.remoteDev.util"})
@SourceDebugExtension(value={"SMAP\nAgentTestLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentTestLogger.kt\ncom/intellij/remoteDev/tests/impl/AgentTestLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n13#2:63\n11561#3:64\n11896#3,3:65\n774#4:68\n865#4,2:69\n1563#4:71\n1634#4,3:72\n*S KotlinDebug\n*F\n+ 1 AgentTestLogger.kt\ncom/intellij/remoteDev/tests/impl/AgentTestLogger\n*L\n22#1:63\n40#1:64\n40#1:65,3\n48#1:68\n48#1:69,2\n58#1:71\n58#1:72,3\n*E\n"})
public class AgentTestLogger
extends DelegatingLogger<Logger> {
    @NotNull
    private final AgentTestLoggerFactory factory;

    public AgentTestLogger(@NotNull Logger logger, @NotNull AgentTestLoggerFactory factory) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(logger);
        this.factory = factory;
    }

    public void error(@Nullable String message, @Nullable Throwable t, String ... details2) {
        Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
        super.error(message, t, Arrays.copyOf(details2, details2.length));
        String messageToTheTestRunner = !(details2.length == 0) ? message + "\n Details: \n" + ArraysKt.joinToString$default((Object[])details2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : message;
        RdTestSession rdTestSession = this.factory.getTestSession().get();
        if (rdTestSession != null) {
            RdTestSession it = rdTestSession;
            boolean bl = false;
            this.sendToTestRunner(it, messageToTheTestRunner, t);
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AgentTestLogger.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Couldn't send exception to the test session: '" + message + "'.");
        }
    }

    protected void sendToTestRunner(@NotNull RdTestSession session, @Nullable String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        String rdtseMessage = this.getRdtseMessage(message, t);
        String rdtseType = this.getRdtseType(t);
        Throwable throwable = t;
        List<RdTestSessionStackTraceElement> rdtseStackTrace = this.getRdtseStackTrace((StackTraceElement[])(throwable != null ? throwable.getStackTrace() : null));
        RdTestSessionLightException rdtseCause = this.getRdtseCause(t);
        List<RdTestSessionLightException> rdtseSuppressedExceptions = this.getRdtseSuppressedExceptions(t);
        RdTestSessionException rdTestSessionException = new RdTestSessionException(rdtseType, null, rdtseMessage, rdtseStackTrace, rdtseCause, rdtseSuppressedExceptions);
        this.info("Fired ex to the test runner " + rdTestSessionException.getMessage());
        session.getSendException().fire((Object)rdTestSessionException);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<RdTestSessionStackTraceElement> getRdtseStackTrace(@Nullable StackTraceElement[] stackTrace) {
        List list2;
        if (stackTrace != null) {
            void $this$mapTo$iv$iv;
            StackTraceElement[] $this$map$iv = stackTrace;
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                String string2 = it.getMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodName(...)");
                String string3 = it.getFileName();
                if (string3 == null) {
                    string3 = "";
                }
                collection.add(new RdTestSessionStackTraceElement(string, string2, string3, it.getLineNumber()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String getRdtseMessage(@Nullable String message, @Nullable Throwable t) {
        Object object;
        Throwable throwable = t;
        if (Intrinsics.areEqual((Object)message, (Object)(throwable != null ? throwable.getMessage() : null))) {
            object = message;
            if (object == null) {
                Serializable serializable = t;
                object = "There was an error of type " + (serializable != null && (serializable = serializable.getClass()) != null ? ((Class)serializable).getName() : null);
            }
        } else {
            void $this$filterTo$iv$iv;
            Object[] objectArray = new String[2];
            objectArray[0] = message;
            Throwable throwable2 = t;
            objectArray[1] = throwable2 != null ? throwable2.getMessage() : null;
            Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String string = it;
                CharSequence charSequence = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)": ", null, null, (int)0, null, null, (int)62, null);
        }
        return object;
    }

    @NotNull
    protected final String getRdtseType(@Nullable Throwable t) {
        Object object = t;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getTypeName()) == null) {
            object = "<LOG_ERROR>";
        }
        return object;
    }

    @Nullable
    protected final RdTestSessionLightException getRdtseCause(@Nullable Throwable t) {
        RdTestSessionLightException rdTestSessionLightException;
        Throwable throwable = t;
        if (throwable != null && (throwable = throwable.getCause()) != null) {
            Throwable cause = throwable;
            boolean bl = false;
            String string = cause.getClass().getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
            rdTestSessionLightException = new RdTestSessionLightException(string, cause.getMessage(), this.getRdtseStackTrace(cause.getStackTrace()));
        } else {
            rdTestSessionLightException = null;
        }
        return rdTestSessionLightException;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final List<RdTestSessionLightException> getRdtseSuppressedExceptions(@Nullable Throwable t) {
        List list2;
        Object object = t;
        if (object != null && (object = ExceptionsKt.getSuppressedExceptions((Throwable)object)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void suppressedException;
                Throwable throwable = (Throwable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = suppressedException.getClass().getTypeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                collection.add(new RdTestSessionLightException(string, suppressedException.getMessage(), this.getRdtseStackTrace(suppressedException.getStackTrace())));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }
}

