/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0003%&'BX\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\r\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u0016\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004J\u0012\u0010\u0017\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\u0018\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u0019\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u001a\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u001b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0010\u0010\u001c\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003Jf\u0010\u001e\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0016\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0018\u0010\b\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/remoteDev/util/ProductInfo;", "", "buildNumber", "", "Lcom/intellij/openapi/util/NlsSafe;", "productCode", "dataDirectoryName", "version", "versionSuffix", "launch", "", "Lcom/intellij/remoteDev/util/ProductInfo$LaunchData;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBuildNumber", "()Ljava/lang/String;", "getProductCode", "getDataDirectoryName", "getVersion", "getVersionSuffix", "getLaunch", "()Ljava/util/List;", "presentableVersion", "fixVersionSuffix", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "LaunchData", "CustomCommandLaunchData", "intellij.remoteDev.util"})
public final class ProductInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String buildNumber;
    @NotNull
    private final String productCode;
    @NotNull
    private final String dataDirectoryName;
    @NotNull
    private final String version;
    @Nullable
    private final String versionSuffix;
    @NotNull
    private final List<LaunchData> launch;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ProductInfo(@NotNull String buildNumber, @NotNull String productCode, @NotNull String dataDirectoryName, @NotNull String version, @Nullable String versionSuffix, @NotNull List<LaunchData> launch2) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)dataDirectoryName, (String)"dataDirectoryName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(launch2, (String)"launch");
        this.buildNumber = buildNumber;
        this.productCode = productCode;
        this.dataDirectoryName = dataDirectoryName;
        this.version = version;
        this.versionSuffix = versionSuffix;
        this.launch = launch2;
    }

    @NotNull
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final String getProductCode() {
        return this.productCode;
    }

    @NotNull
    public final String getDataDirectoryName() {
        return this.dataDirectoryName;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getVersionSuffix() {
        return this.versionSuffix;
    }

    @NotNull
    public final List<LaunchData> getLaunch() {
        return this.launch;
    }

    @NotNull
    public final String presentableVersion() {
        return this.version + this.fixVersionSuffix(this.versionSuffix);
    }

    private final String fixVersionSuffix(String versionSuffix) {
        CharSequence charSequence = versionSuffix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "";
        }
        charSequence = versionSuffix;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string = ((String)charSequence).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"release", (boolean)false, (int)2, null)) {
            return "";
        }
        return " " + ((Object)StringsKt.trim((CharSequence)versionSuffix)).toString();
    }

    @NotNull
    public final String component1() {
        return this.buildNumber;
    }

    @NotNull
    public final String component2() {
        return this.productCode;
    }

    @NotNull
    public final String component3() {
        return this.dataDirectoryName;
    }

    @NotNull
    public final String component4() {
        return this.version;
    }

    @Nullable
    public final String component5() {
        return this.versionSuffix;
    }

    @NotNull
    public final List<LaunchData> component6() {
        return this.launch;
    }

    @NotNull
    public final ProductInfo copy(@NotNull String buildNumber, @NotNull String productCode, @NotNull String dataDirectoryName, @NotNull String version, @Nullable String versionSuffix, @NotNull List<LaunchData> launch2) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)dataDirectoryName, (String)"dataDirectoryName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(launch2, (String)"launch");
        return new ProductInfo(buildNumber, productCode, dataDirectoryName, version, versionSuffix, launch2);
    }

    public static /* synthetic */ ProductInfo copy$default(ProductInfo productInfo, String string, String string2, String string3, String string4, String string5, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = productInfo.buildNumber;
        }
        if ((n & 2) != 0) {
            string2 = productInfo.productCode;
        }
        if ((n & 4) != 0) {
            string3 = productInfo.dataDirectoryName;
        }
        if ((n & 8) != 0) {
            string4 = productInfo.version;
        }
        if ((n & 0x10) != 0) {
            string5 = productInfo.versionSuffix;
        }
        if ((n & 0x20) != 0) {
            list2 = productInfo.launch;
        }
        return productInfo.copy(string, string2, string3, string4, string5, list2);
    }

    @NotNull
    public String toString() {
        return "ProductInfo(buildNumber=" + this.buildNumber + ", productCode=" + this.productCode + ", dataDirectoryName=" + this.dataDirectoryName + ", version=" + this.version + ", versionSuffix=" + this.versionSuffix + ", launch=" + this.launch + ")";
    }

    public int hashCode() {
        int result2 = this.buildNumber.hashCode();
        result2 = result2 * 31 + this.productCode.hashCode();
        result2 = result2 * 31 + this.dataDirectoryName.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + (this.versionSuffix == null ? 0 : this.versionSuffix.hashCode());
        result2 = result2 * 31 + ((Object)this.launch).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProductInfo)) {
            return false;
        }
        ProductInfo productInfo = (ProductInfo)other;
        if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)productInfo.buildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.productCode, (Object)productInfo.productCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataDirectoryName, (Object)productInfo.dataDirectoryName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)productInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.versionSuffix, (Object)productInfo.versionSuffix)) {
            return false;
        }
        return Intrinsics.areEqual(this.launch, productInfo.launch);
    }

    @JvmStatic
    @NotNull
    public static final ProductInfo fromJson(@NotNull String json) {
        return Companion.fromJson(json);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/remoteDev/util/ProductInfo$Companion;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "fromJson", "Lcom/intellij/remoteDev/util/ProductInfo;", "json", "", "intellij.remoteDev.util"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProductInfo fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object = gson.fromJson(json, ProductInfo.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (ProductInfo)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u000b\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\r\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003H\u00c6\u0003J\u000e\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u00c6\u0003J-\u0010\u000f\u001a\u00020\u00002\u0013\b\u0002\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u00032\r\b\u0002\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u001c\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/remoteDev/util/ProductInfo$CustomCommandLaunchData;", "", "commands", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "vmOptionsFilePath", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "getCommands", "()Ljava/util/List;", "getVmOptionsFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.remoteDev.util"})
    public static final class CustomCommandLaunchData {
        @NotNull
        private final List<String> commands;
        @NotNull
        private final String vmOptionsFilePath;

        public CustomCommandLaunchData(@NotNull List<String> commands, @NotNull String vmOptionsFilePath) {
            Intrinsics.checkNotNullParameter(commands, (String)"commands");
            Intrinsics.checkNotNullParameter((Object)vmOptionsFilePath, (String)"vmOptionsFilePath");
            this.commands = commands;
            this.vmOptionsFilePath = vmOptionsFilePath;
        }

        @NotNull
        public final List<String> getCommands() {
            return this.commands;
        }

        @NotNull
        public final String getVmOptionsFilePath() {
            return this.vmOptionsFilePath;
        }

        @NotNull
        public final List<String> component1() {
            return this.commands;
        }

        @NotNull
        public final String component2() {
            return this.vmOptionsFilePath;
        }

        @NotNull
        public final CustomCommandLaunchData copy(@NotNull List<String> commands, @NotNull String vmOptionsFilePath) {
            Intrinsics.checkNotNullParameter(commands, (String)"commands");
            Intrinsics.checkNotNullParameter((Object)vmOptionsFilePath, (String)"vmOptionsFilePath");
            return new CustomCommandLaunchData(commands, vmOptionsFilePath);
        }

        public static /* synthetic */ CustomCommandLaunchData copy$default(CustomCommandLaunchData customCommandLaunchData, List list2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = customCommandLaunchData.commands;
            }
            if ((n & 2) != 0) {
                string = customCommandLaunchData.vmOptionsFilePath;
            }
            return customCommandLaunchData.copy(list2, string);
        }

        @NotNull
        public String toString() {
            return "CustomCommandLaunchData(commands=" + this.commands + ", vmOptionsFilePath=" + this.vmOptionsFilePath + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.commands).hashCode();
            result2 = result2 * 31 + this.vmOptionsFilePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomCommandLaunchData)) {
                return false;
            }
            CustomCommandLaunchData customCommandLaunchData = (CustomCommandLaunchData)other;
            if (!Intrinsics.areEqual(this.commands, customCommandLaunchData.commands)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.vmOptionsFilePath, (Object)customCommandLaunchData.vmOptionsFilePath);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0010\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0011\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J9\u0010\u0013\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/remoteDev/util/ProductInfo$LaunchData;", "", "launcherPath", "", "Lcom/intellij/openapi/util/NlsSafe;", "vmOptionsFilePath", "customCommands", "", "Lcom/intellij/remoteDev/util/ProductInfo$CustomCommandLaunchData;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getLauncherPath", "()Ljava/lang/String;", "getVmOptionsFilePath", "getCustomCommands", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.remoteDev.util"})
    public static final class LaunchData {
        @NotNull
        private final String launcherPath;
        @NotNull
        private final String vmOptionsFilePath;
        @Nullable
        private final List<CustomCommandLaunchData> customCommands;

        public LaunchData(@NotNull String launcherPath, @NotNull String vmOptionsFilePath, @Nullable List<CustomCommandLaunchData> customCommands) {
            Intrinsics.checkNotNullParameter((Object)launcherPath, (String)"launcherPath");
            Intrinsics.checkNotNullParameter((Object)vmOptionsFilePath, (String)"vmOptionsFilePath");
            this.launcherPath = launcherPath;
            this.vmOptionsFilePath = vmOptionsFilePath;
            this.customCommands = customCommands;
        }

        @NotNull
        public final String getLauncherPath() {
            return this.launcherPath;
        }

        @NotNull
        public final String getVmOptionsFilePath() {
            return this.vmOptionsFilePath;
        }

        @Nullable
        public final List<CustomCommandLaunchData> getCustomCommands() {
            return this.customCommands;
        }

        @NotNull
        public final String component1() {
            return this.launcherPath;
        }

        @NotNull
        public final String component2() {
            return this.vmOptionsFilePath;
        }

        @Nullable
        public final List<CustomCommandLaunchData> component3() {
            return this.customCommands;
        }

        @NotNull
        public final LaunchData copy(@NotNull String launcherPath, @NotNull String vmOptionsFilePath, @Nullable List<CustomCommandLaunchData> customCommands) {
            Intrinsics.checkNotNullParameter((Object)launcherPath, (String)"launcherPath");
            Intrinsics.checkNotNullParameter((Object)vmOptionsFilePath, (String)"vmOptionsFilePath");
            return new LaunchData(launcherPath, vmOptionsFilePath, customCommands);
        }

        public static /* synthetic */ LaunchData copy$default(LaunchData launchData, String string, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = launchData.launcherPath;
            }
            if ((n & 2) != 0) {
                string2 = launchData.vmOptionsFilePath;
            }
            if ((n & 4) != 0) {
                list2 = launchData.customCommands;
            }
            return launchData.copy(string, string2, list2);
        }

        @NotNull
        public String toString() {
            return "LaunchData(launcherPath=" + this.launcherPath + ", vmOptionsFilePath=" + this.vmOptionsFilePath + ", customCommands=" + this.customCommands + ")";
        }

        public int hashCode() {
            int result2 = this.launcherPath.hashCode();
            result2 = result2 * 31 + this.vmOptionsFilePath.hashCode();
            result2 = result2 * 31 + (this.customCommands == null ? 0 : ((Object)this.customCommands).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LaunchData)) {
                return false;
            }
            LaunchData launchData = (LaunchData)other;
            if (!Intrinsics.areEqual((Object)this.launcherPath, (Object)launchData.launcherPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vmOptionsFilePath, (Object)launchData.vmOptionsFilePath)) {
                return false;
            }
            return Intrinsics.areEqual(this.customCommands, launchData.customCommands);
        }
    }
}

