/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConfigurableBase<SC extends CloudConfigurationBase>
extends RemoteServerConfigurable {
    private final ServerType<SC> myCloudType;
    protected final SC myConfiguration;

    public CloudConfigurableBase(ServerType<SC> cloudType, SC configuration) {
        this.myCloudType = cloudType;
        this.myConfiguration = configuration;
    }

    protected final ServerType<SC> getCloudType() {
        return this.myCloudType;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        return !this.getEmailTextField().getText().equals(((CloudConfigurationBase)this.myConfiguration).getEmail()) || !new String(this.getPasswordField().getPassword()).equals(((CloudConfigurationBase)this.myConfiguration).getPasswordSafe()) || !((CloudConfigurationBase)this.myConfiguration).isPasswordSafe();
    }

    public void apply() throws ConfigurationException {
        this.applyCoreTo(this.myConfiguration, false);
    }

    public void reset() {
        this.getEmailTextField().setText(((CloudConfigurationBase)this.myConfiguration).getEmail());
        this.getPasswordField().setText(((CloudConfigurationBase)this.myConfiguration).getPasswordSafe());
    }

    protected void applyCoreTo(SC configuration) throws ConfigurationException {
        this.applyCoreTo(configuration, false);
    }

    protected void applyCoreTo(SC configuration, boolean forComparison) throws ConfigurationException {
        String email = this.getEmailTextField().getText();
        if (StringUtil.isEmpty((String)email)) {
            throw new RuntimeConfigurationError(CloudBundle.message("dialog.message.email.required", new Object[0]));
        }
        String password = new String(this.getPasswordField().getPassword());
        if (StringUtil.isEmpty((String)password)) {
            throw new RuntimeConfigurationError(CloudBundle.message("dialog.message.password.required", new Object[0]));
        }
        ((CloudConfigurationBase)configuration).setEmail(email);
        if (forComparison) {
            ((CloudConfigurationBase)configuration).setPassword(password);
        } else {
            ((CloudConfigurationBase)configuration).setPasswordSafe(password);
        }
    }

    protected boolean isCoreConfigEqual(SC configuration1, SC configuration2) {
        return Objects.equals(((CloudConfigurationBase)configuration1).getEmail(), ((CloudConfigurationBase)configuration2).getEmail()) && Objects.equals(((CloudConfigurationBase)configuration1).getPasswordSafe(), ((CloudConfigurationBase)configuration2).getPasswordSafe());
    }

    protected abstract JComponent getMainPanel();

    protected abstract JTextField getEmailTextField();

    protected abstract JPasswordField getPasswordField();
}

