/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CloudRunConfigurationUtil {
    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(RemoteServer<SC> account, Module module, DC deploymentConfiguration) {
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        ModuleDeploymentSourceImpl deploymentSource = new ModuleDeploymentSourceImpl(modulePointer);
        return CloudRunConfigurationUtil.createRunConfiguration(account, module, deploymentSource, deploymentConfiguration);
    }

    public static <SC extends ServerConfiguration, DC extends DeploymentConfiguration> DeployToServerRunConfiguration<SC, DC> createRunConfiguration(@NotNull RemoteServer<SC> account, @NotNull Module module, @NotNull DeploymentSource deploymentSource, DC deploymentConfiguration) {
        if (account == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        if (deploymentSource == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        RunManager runManager = RunManager.getInstance(module.getProject());
        String name = CloudRunConfigurationUtil.generateRunConfigurationName(account, module);
        ConfigurationFactory configurationFactory = DeployToServerConfigurationTypesRegistrar.getInstance().getConfigurationType(account.getType()).getFactoryForType(deploymentSource.getType());
        RunnerAndConfigurationSettings runSettings = runManager.createConfiguration(name, configurationFactory);
        DeployToServerRunConfiguration result2 = (DeployToServerRunConfiguration)runSettings.getConfiguration();
        result2.setServerName(account.getName());
        result2.setDeploymentSource(deploymentSource);
        result2.setDeploymentConfiguration(deploymentConfiguration);
        RunManagerImplKt.callNewConfigurationCreated((ConfigurationFactory)configurationFactory, (RunConfiguration)runSettings.getConfiguration());
        runManager.addConfiguration(runSettings);
        runManager.setSelectedConfiguration(runSettings);
        return result2;
    }

    private static String generateRunConfigurationName(@NotNull RemoteServer<?> account, Module module) {
        if (account == null) {
            CloudRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        String accountName = account.getName();
        String moduleName = module.getName();
        return CloudBundle.message("run.configuration.name", accountName, moduleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/util/CloudRunConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRunConfigurationName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

