/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.threadDumpParser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.diagnostic.CoroutineDumperKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.threadDumpParser.ThreadOperation;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ThreadDumpParser {
    private static final Pattern ourThreadStartPattern = Pattern.compile("^\"(.+)\".+((?:prio=\\d+ )?(?:os_prio=[^\\s]+ )?.*tid=[^\\s]+(?: nid=[^\\s]+)?|[Ii][Dd]=\\d+) ([^\\[]+)");
    private static final Pattern ourForcedThreadStartPattern = Pattern.compile("^Thread (\\d+): \\(state = (.+)\\)");
    private static final Pattern ourYourkitThreadStartPattern = Pattern.compile("(.+) \\[([A-Z_, ]*)]");
    private static final Pattern ourYourkitThreadStartPattern2 = Pattern.compile("(.+) (?:State:)? (.+) CPU usage on sample: .+");
    private static final Pattern ourJcmdThreadStartPattern = Pattern.compile("#\\d+ \"(.*)\"(.*)");
    private static final Pattern ourJcmdStackTraceElement = Pattern.compile("\\S+\\(.+\\)");
    private static final Pattern ourThreadStatePattern = Pattern.compile("java\\.lang\\.Thread\\.State: (.+) \\((.+)\\)");
    private static final Pattern ourThreadStatePattern2 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+)");
    private static final Pattern ourThreadStateCarryingVirtualPattern = Pattern.compile("Carrying virtual thread #(\\d+)");
    private static final Pattern ourWaitingForLockPattern = Pattern.compile("- waiting (on|to lock) <(.+)>");
    private static final Pattern ourParkingToWaitForLockPattern = Pattern.compile("- parking to wait for {2}<(.+)>");
    @NonNls
    private static final String PUMP_EVENT = "java.awt.EventDispatchThread.pumpOneEventForFilters";
    private static final Pattern ourIdleTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at java\\.util\\.TimerThread\\.mainLoop");
    private static final Pattern ourIdleSwingTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at javax\\.swing\\.TimerQueue\\.run");
    private static final String AT_JAVA_LANG_OBJECT_WAIT = "java.lang.Object.wait(";
    private static final String ourLockedOwnableSynchronizersHeader = "Locked ownable synchronizers";
    private static final Pattern ourLockedOwnableSynchronizersPattern = Pattern.compile("- <(0x[\\da-f]+)> \\(.*\\)");
    private static final String[] IMPORTANT_THREAD_DUMP_WORDS = (String[])ContainerUtil.ar((Object[])new String[]{"tid", "nid", "wait", "parking", "prio", "os_prio", "java"});

    private ThreadDumpParser() {
    }

    @Nullable
    private static ParsingResult tryParseAsJson(String threadDump) {
        JsonNode tree;
        int firstCharPos = StringUtil.skipWhitespaceOrNewLineForward((CharSequence)threadDump, (int)0);
        if (!threadDump.startsWith("{", firstCharPos)) {
            return null;
        }
        try {
            tree = new ObjectMapper().readTree(threadDump);
        }
        catch (JsonProcessingException e) {
            return null;
        }
        ArrayList<ThreadState> result2 = new ArrayList<ThreadState>();
        JsonNode containers = tree.path("threadDump").path("threadContainers");
        containers.elements().forEachRemaining(container -> container.path("threads").elements().forEachRemaining(thread -> {
            boolean virtual;
            String name = thread.path("name").asText();
            ThreadState threadState = new ThreadState(name, "unknown");
            StringBuilder rawStackTrace = new StringBuilder();
            thread.path("stack").elements().forEachRemaining(ste -> {
                String text2 = ste.asText();
                if (!text2.isEmpty()) {
                    rawStackTrace.append("\n      ");
                    rawStackTrace.append(text2);
                }
            });
            boolean emptyStackTrace = rawStackTrace.isEmpty();
            boolean bl = virtual = !emptyStackTrace && rawStackTrace.indexOf("java.lang.VirtualThread.run(") != -1 || emptyStackTrace && name.isEmpty();
            if (virtual) {
                threadState.setVirtual(true);
            }
            String tid = thread.path("tid").asText();
            StringBuilder stackTrace = new StringBuilder();
            stackTrace.append("#").append(tid);
            stackTrace.append(" \"").append(name).append("\"");
            if (virtual) {
                stackTrace.append(" virtual");
            }
            stackTrace.append((CharSequence)rawStackTrace);
            threadState.setStackTrace(stackTrace.toString(), emptyStackTrace);
            result2.add(threadState);
        }));
        return new ParsingResult(result2, null);
    }

    @NotNull
    private static ParsingResult parseAsText(String threadDump) {
        String line;
        ArrayList<ThreadState> threads = new ArrayList<ThreadState>();
        StringBuilder coroutineDump = null;
        StringBuilder lastThreadStack = new StringBuilder();
        ThreadState lastThreadState = null;
        boolean expectingThreadState = false;
        boolean haveNonEmptyStackTrace = false;
        Iterator iterator = StringUtil.tokenize((String)threadDump, (String)"\r\n").iterator();
        while (iterator.hasNext() && !"---------- Event counts ----------".equals(line = (String)iterator.next())) {
            String trimmed;
            if (CoroutineDumperKt.isCoroutineDumpHeader((String)line)) {
                coroutineDump = new StringBuilder();
            }
            if (coroutineDump != null) {
                coroutineDump.append(line).append("\n");
                continue;
            }
            if (line.startsWith("============") || line.contains("Java-level deadlock")) break;
            ThreadState state = ThreadDumpParser.tryParseThreadStart(line.trim());
            if (state != null) {
                if (lastThreadState != null) {
                    lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
                }
                lastThreadState = state;
                threads.add(lastThreadState);
                lastThreadStack.setLength(0);
                haveNonEmptyStackTrace = false;
                lastThreadStack.append(line).append("\n");
                expectingThreadState = true;
                continue;
            }
            boolean parsedThreadState = false;
            if (expectingThreadState) {
                expectingThreadState = false;
                parsedThreadState = ThreadDumpParser.tryParseThreadState(line, lastThreadState);
            }
            lastThreadStack.append(line).append("\n");
            if (parsedThreadState || !(trimmed = line.trim()).startsWith("at") && !ourJcmdStackTraceElement.matcher(trimmed).matches()) continue;
            haveNonEmptyStackTrace = true;
        }
        if (lastThreadState != null) {
            lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
        }
        return new ParsingResult(threads, coroutineDump);
    }

    @NotNull
    public static List<ThreadState> parse(String threadDump) {
        ParsingResult result2 = ThreadDumpParser.tryParseAsJson(threadDump);
        if (result2 == null) {
            result2 = ThreadDumpParser.parseAsText(threadDump);
        }
        List<ThreadState> threads = result2.threads;
        for (ThreadState threadState : threads) {
            ThreadDumpParser.inferThreadStateDetail(threadState);
        }
        for (ThreadState threadState : threads) {
            String lockId = ThreadDumpParser.findWaitingForLock(threadState.getStackTrace());
            ThreadState lockOwner = ThreadDumpParser.findLockOwner(threads, lockId, true);
            if (lockOwner == null) {
                lockOwner = ThreadDumpParser.findLockOwner(threads, lockId, false);
            }
            if (lockOwner == null) continue;
            if (threadState.isAwaitedBy(lockOwner)) {
                threadState.addDeadlockedThread(lockOwner);
                lockOwner.addDeadlockedThread(threadState);
            }
            lockOwner.addWaitingThread(threadState);
        }
        ThreadDumpParser.sortThreads(threads);
        StringBuilder coroutineDump = result2.coroutineDump;
        if (coroutineDump != null) {
            ThreadState coroutineState = new ThreadState("Coroutine dump", "undefined");
            coroutineState.setStackTrace(coroutineDump.toString(), false);
            threads.add(coroutineState);
        }
        List<ThreadState> list2 = threads;
        if (list2 == null) {
            ThreadDumpParser.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    private static ThreadState findLockOwner(List<? extends ThreadState> result2, @Nullable String lockId, boolean ignoreWaiting) {
        if (lockId == null) {
            return null;
        }
        String marker = "- locked <" + lockId + ">";
        for (ThreadState threadState : result2) {
            String trace = threadState.getStackTrace();
            if (!trace.contains(marker) || ignoreWaiting && trace.contains(AT_JAVA_LANG_OBJECT_WAIT)) continue;
            return threadState;
        }
        for (ThreadState threadState : result2) {
            if (threadState.getOwnableSynchronizers() == null || !threadState.getOwnableSynchronizers().equals(lockId)) continue;
            return threadState;
        }
        return null;
    }

    @Contract(mutates="param1")
    public static void sortThreads(List<? extends ThreadState> result2) {
        result2.sort((o1, o2) -> ThreadDumpParser.getInterestLevel(o2) - ThreadDumpParser.getInterestLevel(o1));
    }

    @Nullable
    private static String findLockedOwnableSynchronizers(String stackTrace) {
        if (!stackTrace.contains(ourLockedOwnableSynchronizersHeader)) {
            return null;
        }
        Matcher m = ourLockedOwnableSynchronizersPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    private static String findWaitingForLock(String stackTrace) {
        Matcher m = ourWaitingForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(2);
        }
        m = ourParkingToWaitForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static int getInterestLevel(ThreadState state) {
        if (state.isEmptyStackTrace()) {
            return -10;
        }
        if (state.isKnownJDKThread()) {
            return -5;
        }
        if (state.isSleeping()) {
            return -2;
        }
        if (state.getOperation() == ThreadOperation.SOCKET) {
            return -1;
        }
        return state.getStackDepth();
    }

    static boolean isKnownJdkThread(@NotNull String stackTrace) {
        if (stackTrace == null) {
            ThreadDumpParser.$$$reportNull$$$0(1);
        }
        return stackTrace.contains("java.lang.ref.Reference$ReferenceHandler.run") || stackTrace.contains("java.lang.ref.Finalizer$FinalizerThread.run") || stackTrace.contains("sun.awt.AWTAutoShutdown.run") || stackTrace.contains("sun.java2d.Disposer.run") || stackTrace.contains("sun.awt.windows.WToolkit.eventLoop") || stackTrace.contains("jdk.internal.ref.CleanerImpl.run") || ourIdleTimerThreadPattern.matcher(stackTrace).find() || ourIdleSwingTimerThreadPattern.matcher(stackTrace).find();
    }

    public static void inferThreadStateDetail(ThreadState threadState) {
        String javaThreadState = threadState.getJavaThreadState();
        @NonNls String stackTrace = threadState.getStackTrace();
        if (stackTrace.contains("java.net.PlainSocketImpl.socketAccept") || stackTrace.contains("java.net.PlainDatagramSocketImpl.receive") || stackTrace.contains("java.net.SocketInputStream.socketRead") || stackTrace.contains("java.net.PlainSocketImpl.socketConnect")) {
            threadState.setOperation(ThreadOperation.SOCKET);
        } else if (stackTrace.contains("java.io.FileInputStream.readBytes")) {
            threadState.setOperation(ThreadOperation.IO);
        } else if (stackTrace.contains("jdk.internal.vm.Continuation.run")) {
            if (Thread.State.WAITING.name().equals(javaThreadState)) {
                threadState.setOperation(ThreadOperation.CARRYING_VTHREAD);
            }
        } else if (stackTrace.contains("java.lang.Thread.sleep") && !Thread.State.RUNNABLE.name().equals(javaThreadState)) {
            threadState.setThreadStateDetail("sleeping");
        }
        if (threadState.isEDT()) {
            if (stackTrace.contains("java.awt.EventQueue.getNextEvent")) {
                threadState.setThreadStateDetail("idle");
            }
            int modality = 0;
            int pos = 0;
            while ((pos = stackTrace.indexOf(PUMP_EVENT, pos)) >= 0) {
                ++modality;
                pos += PUMP_EVENT.length();
            }
            threadState.setExtraState("modality level " + modality);
        }
        threadState.setOwnableSynchronizers(ThreadDumpParser.findLockedOwnableSynchronizers(threadState.getStackTrace()));
    }

    @Nullable
    private static ThreadState tryParseThreadStart(String line) {
        Matcher m = ourThreadStartPattern.matcher(line);
        if (m.find()) {
            ThreadState state = new ThreadState(m.group(1), m.group(3));
            if (line.contains(" daemon ")) {
                state.setDaemon(true);
            }
            if (line.contains(" virtual ")) {
                state.setVirtual(true);
            }
            return state;
        }
        m = ourForcedThreadStartPattern.matcher(line);
        if (m.matches()) {
            return new ThreadState(m.group(1), m.group(2));
        }
        m = ourJcmdThreadStartPattern.matcher(line);
        if (m.matches()) {
            ThreadState state = new ThreadState(m.group(1), "unknown");
            String suffix = m.group(2);
            state.setVirtual(suffix.contains(" virtual"));
            return state;
        }
        boolean daemon = line.contains(" [DAEMON]");
        if (daemon) {
            line = StringUtil.replace((String)line, (String)" [DAEMON]", (String)"");
        }
        if ((m = ThreadDumpParser.matchYourKit(line)) != null) {
            ThreadState state = new ThreadState(m.group(1), m.group(2));
            state.setDaemon(daemon);
            return state;
        }
        return null;
    }

    @Nullable
    private static Matcher matchYourKit(String line) {
        Matcher m;
        if (line.contains("[") && (m = ourYourkitThreadStartPattern.matcher(line)).matches()) {
            return m;
        }
        if (line.contains("CPU usage on sample:") && (m = ourYourkitThreadStartPattern2.matcher(line)).matches()) {
            return m;
        }
        return null;
    }

    private static boolean tryParseThreadState(String line, ThreadState threadState) {
        Matcher m = ourThreadStatePattern.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            threadState.setThreadStateDetail(m.group(2).trim());
            return true;
        }
        m = ourThreadStatePattern2.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            return true;
        }
        m = ourThreadStateCarryingVirtualPattern.matcher(line);
        if (m.find()) {
            threadState.setOperation(ThreadOperation.CARRYING_VTHREAD);
            return true;
        }
        return false;
    }

    public static String normalizeText(@NonNls String text2) {
        StringBuilder builder = new StringBuilder(text2.length());
        text2 = text2.replaceAll("(\\S[ \\t\\x0B\\f\\r]+)(at\\s+)", "$1\n$2");
        text2 = text2.replaceAll("(\\\\n|\\\\r|\\\\t)+(at\\s+)", "\n$2");
        String[] lines = text2.split("\n");
        boolean first = true;
        boolean inAuxInfo = false;
        for (String line : lines) {
            StringBuilder lastLine;
            if (!inAuxInfo && (line.startsWith("JNI global references") || line.trim().equals("Heap"))) {
                builder.append("\n");
                inAuxInfo = true;
            }
            if (inAuxInfo) {
                builder.append(ThreadDumpParser.trimSuffix(line)).append("\n");
                continue;
            }
            if (line.startsWith("at breakpoint")) {
                builder.append(" ").append(ThreadDumpParser.trimSuffix(line));
                continue;
            }
            if (!first && (ThreadDumpParser.mustHaveNewLineBefore(line) || StringUtil.endsWith((CharSequence)builder, (CharSequence)")"))) {
                if (!StringUtil.endsWith((CharSequence)builder, (CharSequence)"\n")) {
                    builder.append("\n");
                }
                if (line.startsWith("\"")) {
                    builder.append("\n");
                }
            }
            first = false;
            int i = builder.lastIndexOf("\n");
            CharSequence charSequence = lastLine = i == -1 ? builder : builder.subSequence(i + 1, builder.length());
            if (!line.matches("\\s+.*") && !lastLine.isEmpty() && (lastLine.toString().matches("\\s*at") || ContainerUtil.or((Object[])IMPORTANT_THREAD_DUMP_WORDS, word -> line.startsWith((String)word)))) {
                builder.append(" ");
            }
            builder.append(ThreadDumpParser.trimSuffix(line));
        }
        return builder.toString();
    }

    private static boolean mustHaveNewLineBefore(String line) {
        int nonWs = CharArrayUtil.shiftForward((CharSequence)line, (int)0, (String)" \t");
        if (nonWs < line.length()) {
            line = line.substring(nonWs);
        }
        if (line.startsWith("at")) {
            return true;
        }
        if (line.startsWith("Caused")) {
            return true;
        }
        if (line.startsWith("- locked")) {
            return true;
        }
        if (line.startsWith("- waiting")) {
            return true;
        }
        if (line.startsWith("- parking to wait")) {
            return true;
        }
        if (line.startsWith("java.lang.Thread.State")) {
            return true;
        }
        return line.startsWith("\"");
    }

    private static String trimSuffix(String line) {
        int len;
        for (len = line.length(); 0 < len && line.charAt(len - 1) <= ' '; --len) {
        }
        return len < line.length() ? line.substring(0, len) : line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/threadDumpParser/ThreadDumpParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/threadDumpParser/ThreadDumpParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownJdkThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private record ParsingResult(@NotNull List<ThreadState> threads, @Nullable StringBuilder coroutineDump) {
        @NotNull
        private final List<ThreadState> threads;

        private ParsingResult(@NotNull List<ThreadState> threads, @Nullable StringBuilder coroutineDump) {
            if (threads == null) {
                ParsingResult.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public List<ThreadState> threads() {
            List<ThreadState> list2 = this.threads;
            if (list2 == null) {
                ParsingResult.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threads";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/threadDumpParser/ThreadDumpParser$ParsingResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/threadDumpParser/ThreadDumpParser$ParsingResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "threads";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

