/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren;
    private volatile UsageNodePresentation myCachedPresentation;

    private GroupNode(@NotNull Node parent, @NotNull UsageGroup group, int ruleIndex) {
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(0);
        }
        if (group == null) {
            GroupNode.$$$reportNull$$$0(1);
        }
        this.myChildren = new SmartList();
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    private GroupNode() {
        this.myChildren = new SmartList();
        this.myRuleIndex = 0;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result2 = this.getGroup() == null ? "" : this.getGroup().getPresentableGroupText();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            return result2 + String.valueOf(ContainerUtil.getFirstItems(this.myChildren, (int)10));
        }
    }

    @NotNull
    List<Node> getChildren() {
        List<Node> list2 = this.myChildren;
        if (list2 == null) {
            GroupNode.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    List<Node> getSwingChildren() {
        Vector children = this.children;
        List list2 = (List)ObjectUtils.notNull((Object)children, Collections.emptyList());
        if (list2 == null) {
            GroupNode.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        if (group == null) {
            GroupNode.$$$reportNull$$$0(4);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(5);
        }
        GroupNode groupNode2 = this;
        // MONITORENTER : groupNode2
        GroupNode groupNode = this.insertGroupNode(group, ruleIndex, edtModelToSwingNodeChangesQueue);
        // MONITOREXIT : groupNode2
        if (groupNode != null) return groupNode;
        GroupNode.$$$reportNull$$$0(6);
        return groupNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private GroupNode insertGroupNode(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        if (group == null) {
            GroupNode.$$$reportNull$$$0(7);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(8);
        }
        GroupNode groupNode = this;
        // MONITORENTER : groupNode
        GroupNode newNode = new GroupNode(this, group, ruleIndex);
        int i = GroupNode.getNodeIndex(newNode, this.myChildren);
        if (i >= 0) {
            GroupNode groupNode2 = (GroupNode)this.myChildren.get(i);
            // MONITOREXIT : groupNode
            if (groupNode2 != null) return groupNode2;
            GroupNode.$$$reportNull$$$0(9);
            return groupNode2;
        }
        int insertionIndex = -i - 1;
        this.myChildren.add(insertionIndex, newNode);
        edtModelToSwingNodeChangesQueue.consume((Object)new UsageViewImpl.NodeChange(UsageViewImpl.NodeChangeType.ADDED, this, newNode));
        GroupNode groupNode3 = newNode;
        // MONITOREXIT : groupNode
        if (groupNode3 != null) return groupNode3;
        GroupNode.$$$reportNull$$$0(10);
        return groupNode3;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<? extends Node> children) {
        if (newNode == null) {
            GroupNode.$$$reportNull$$$0(11);
        }
        if (children == null) {
            GroupNode.$$$reportNull$$$0(12);
        }
        return Collections.binarySearch(children, newNode, COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        if (node == null) {
            GroupNode.$$$reportNull$$$0(13);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeIndex(node, this.getSwingChildren());
            if (index >= 0) {
                return;
            }
            index = -index - 1;
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ThreadingAssertions.assertEventDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(15);
        }
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeUsagesBulk(@NotNull Set<UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        if (usages == null) {
            GroupNode.$$$reportNull$$$0(16);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(17);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int removed = 0;
        SmartList removedNodes = new SmartList();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            int o = 0;
            List<Node> children = this.myChildren;
            for (int i = 0; i < children.size(); ++i) {
                Node child = children.get(i);
                if (usages.remove(child)) {
                    removedNodes.add(child);
                    ++removed;
                    continue;
                }
                if (child instanceof GroupNode) {
                    GroupNode groupNode2 = (GroupNode)child;
                    int delta = groupNode2.removeUsagesBulk(usages, treeModel);
                    if (delta <= 0) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        removedNodes.add(groupNode2);
                        if (i != o) {
                            children.set(o, child);
                        }
                        ++o;
                    }
                    if ((removed += delta) != usages.size()) continue;
                    break;
                }
                if (i != o) {
                    children.set(o, child);
                }
                ++o;
            }
            children.subList(o, children.size()).clear();
            if (!children.isEmpty()) {
                GroupNode.removeNodesFromParent(treeModel, this, (List<MutableTreeNode>)removedNodes);
            }
        }
        if (removed > 0 && (this.myRecursiveUsageCount -= removed) != 0) {
            treeModel.nodeChanged(this);
        }
        return removed;
    }

    @Contract(mutates="param3")
    private static void removeNodesFromParent(@NotNull DefaultTreeModel treeModel, @NotNull GroupNode parent, @NotNull List<MutableTreeNode> nodes) {
        int count;
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(19);
        }
        if (nodes == null) {
            GroupNode.$$$reportNull$$$0(20);
        }
        if ((count = nodes.size()) == 0) {
            return;
        }
        Object2IntOpenHashMap ordering = new Object2IntOpenHashMap(count);
        ordering.defaultReturnValue(-1);
        for (MutableTreeNode node : nodes) {
            ordering.put((Object)node, parent.getIndex(node));
        }
        nodes.sort(Comparator.comparingInt(arg_0 -> GroupNode.lambda$removeNodesFromParent$0((Object2IntMap)ordering, arg_0)));
        int[] indices = ordering.values().toIntArray();
        Arrays.sort(indices);
        for (int i = count - 1; i >= 0; --i) {
            parent.remove(indices[i]);
        }
        treeModel.nodesWereRemoved(parent, indices, nodes.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    UsageNode addOrGetUsage(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        UsageNode newNode;
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(21);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(22);
        }
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                UsageNode usageNode = mergedWith;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                if (usageNode == null) {
                    GroupNode.$$$reportNull$$$0(23);
                }
                return usageNode;
            }
            newNode = new UsageNode(this, usage);
            int i = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i >= 0) {
                newNode = (UsageNode)this.myChildren.get(i);
            } else {
                int insertionIndex = -i - 1;
                this.myChildren.add(insertionIndex, newNode);
            }
        }
        edtModelToSwingNodeChangesQueue.consume((Object)new UsageViewImpl.NodeChange(UsageViewImpl.NodeChangeType.ADDED, this, newNode));
        UsageNode usageNode = newNode;
        if (usageNode == null) {
            GroupNode.$$$reportNull$$$0(24);
        }
        return usageNode;
    }

    void incrementUsageCount(int i) {
        ThreadingAssertions.assertEventDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            groupNode.myRecursiveUsageCount += i;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    protected boolean isDataValid() {
        UsageGroup group = this.getGroup();
        return group == null || group.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (groupNode == null) {
            GroupNode.$$$reportNull$$$0(25);
        }
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myRecursiveUsageCount;
    }

    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    protected boolean canDataNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected String getNodeText() {
        String string = this.getGroup().getPresentableGroupText();
        if (string == null) {
            GroupNode.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list2 = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list2.add((GroupNode)n);
        }
        ArrayList<GroupNode> arrayList = list2;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list2 = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list2.add((UsageNode)n);
        }
        ArrayList<UsageNode> arrayList = list2;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public UsageNodePresentation getCachedPresentation() {
        return this.myCachedPresentation;
    }

    @Override
    protected void updateCachedPresentation() {
        UsageGroup group = this.getGroup();
        if (group == null || !group.isValid()) {
            return;
        }
        FileStatus fileStatus = group.getFileStatus();
        Color foregroundColor = fileStatus != null ? fileStatus.getColor() : null;
        Icon icon = group.getIcon();
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        TextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes();
        attributes.setForegroundColor(foregroundColor);
        chunks.add(new TextChunk(attributes, group.getPresentableGroupText()));
        this.myCachedPresentation = new UsageNodePresentation(icon, chunks.toArray(TextChunk.EMPTY_ARRAY), null);
    }

    @NotNull
    static Root createRoot() {
        return new Root();
    }

    private static /* synthetic */ int lambda$removeNodesFromParent$0(Object2IntMap ordering, MutableTreeNode key) {
        return ordering.getInt((Object)key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 9, 10, 23, 24, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 5: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtModelToSwingNodeChangesQueue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwingChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGroupNode";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetUsage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubGroups";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetGroup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertGroupNode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIndex";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTargetsNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryMerge";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeNodesFromParent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetUsage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 9, 10, 23, 24, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        NodeComparator() {
        }

        private static ClassIndex getClassIndex(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                NodeComparator.$$$reportNull$$$0(0);
            }
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            Object u2;
            int c;
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP ? (c = ((GroupNode)n1).compareTo((GroupNode)n2)) != 0 : classIdx1 == ClassIndex.USAGE && (c = ((UsageNode)n1).compareTo((UsageNode)n2)) != 0) {
                return c;
            }
            Object u1 = n1.getUserObject();
            if (Comparing.equal((Object)u1, (Object)(u2 = n2.getUserObject()))) {
                return 0;
            }
            return System.identityHashCode(u1) - System.identityHashCode(u2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode$NodeComparator", "getClassIndex"));
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }

    static class Root
    extends GroupNode {
        Root() {
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }

        @Override
        @NotNull
        protected String getNodeText() {
            return "";
        }
    }
}

