/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.TooManyUsagesUserAction;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.RangeBlinker;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class SearchForUsagesRunnable
implements Runnable {
    @NonNls
    private static final String SEARCH_IN_PROJECT_HREF_TARGET = "SearchInProject";
    @NonNls
    private static final String LARGE_FILES_HREF_TARGET = "LargeFiles";
    @NonNls
    private static final String SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET = "SHOW_PROJECT_FILE_OCCURRENCES";
    private final AtomicInteger myUsageCountWithoutDefinition;
    private final AtomicReference<Usage> myFirstUsage;
    @NotNull
    private final Project myProject;
    private final AtomicReference<UsageViewEx> myUsageViewRef;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] mySearchFor;
    private final Supplier<? extends UsageSearcher> mySearcherFactory;
    private final FindUsagesProcessPresentation myProcessPresentation;
    @NotNull
    private final SearchScope mySearchScopeToWarnOfFallingOutOf;
    private final UsageViewManager.UsageViewStateListener myListener;
    private final UsageViewManagerImpl myUsageViewManager;
    private final AtomicInteger myOutOfScopeUsages;
    private final AtomicLong myFirstItemFoundTS;
    private final AtomicBoolean myTooManyUsages;

    SearchForUsagesRunnable(@NotNull UsageViewManagerImpl usageViewManager, @NotNull Project project, @NotNull AtomicReference<UsageViewEx> usageViewRef, @NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] searchFor, @NotNull Supplier<? extends UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull SearchScope searchScopeToWarnOfFallingOutOf, @Nullable UsageViewManager.UsageViewStateListener listener2, @NotNull AtomicLong firstItemFoundTS, @NotNull AtomicBoolean tooManyUsages) {
        if (usageViewManager == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(1);
        }
        if (usageViewRef == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(3);
        }
        if (searcherFactory == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(4);
        }
        if (processPresentation == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(5);
        }
        if (searchScopeToWarnOfFallingOutOf == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(6);
        }
        if (firstItemFoundTS == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(7);
        }
        if (tooManyUsages == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(8);
        }
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(9);
        }
        this.myUsageCountWithoutDefinition = new AtomicInteger(0);
        this.myFirstUsage = new AtomicReference();
        this.myOutOfScopeUsages = new AtomicInteger();
        this.myProject = project;
        this.myUsageViewRef = usageViewRef;
        this.myPresentation = presentation;
        this.mySearchFor = searchFor;
        this.mySearcherFactory = searcherFactory;
        this.myProcessPresentation = processPresentation;
        this.mySearchScopeToWarnOfFallingOutOf = searchScopeToWarnOfFallingOutOf;
        this.myListener = listener2;
        this.myUsageViewManager = usageViewManager;
        this.myFirstItemFoundTS = firstItemFoundTS;
        this.myTooManyUsages = tooManyUsages;
    }

    @NotNull
    private static String createOptionsHtml(@NonNls UsageTarget @NotNull [] searchFor) {
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(10);
        }
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut(searchFor);
        HtmlBuilder builder = new HtmlBuilder().appendLink("FindOptions", UsageViewBundle.message("link.display.name.find.options", new Object[0]));
        if (shortcut != null) {
            builder.nbsp().append("(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")");
        }
        String string = builder.toString();
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String createSearchInProjectHtml() {
        String string = HtmlChunk.link((String)SEARCH_IN_PROJECT_HREF_TARGET, (String)UsageViewBundle.message("link.display.name.search.in.project", new Object[0])).toString();
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void notifyByFindBalloon(@Nullable HyperlinkListener listener2, @NotNull MessageType messageType, @NotNull List<String> lines, @NotNull Collection<String> unloadedModulesBelongingToScope) {
        Runnable searchIncludingProjectFileUsages;
        if (messageType == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(13);
        }
        if (lines == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(14);
        }
        if (unloadedModulesBelongingToScope == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(15);
        }
        UsageViewContentManager.getInstance(this.myProject);
        Collection<VirtualFile> largeFiles = this.myProcessPresentation.getLargeFiles();
        ArrayList<String> resultLines = new ArrayList<String>(lines);
        HyperlinkListener resultListener = listener2;
        if (!largeFiles.isEmpty()) {
            String shortMessage = "(<a href='LargeFiles'>" + UsageViewBundle.message("large.files.were.ignored", largeFiles.size()) + "</a>)";
            resultLines.add(shortMessage);
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, LARGE_FILES_HREF_TARGET, () -> {
                String detailedMessage = SearchForUsagesRunnable.detailedLargeFilesMessage(largeFiles);
                ArrayList<String> strings = new ArrayList<String>(lines);
                strings.add(detailedMessage);
                ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon("Find", messageType, SearchForUsagesRunnable.wrapInHtml(strings), AllIcons.Actions.Find, listener2);
            });
        }
        if ((searchIncludingProjectFileUsages = this.myProcessPresentation.searchIncludingProjectFileUsages()) != null) {
            resultLines.add(UsageViewBundle.message("message.occurrences.in.project.configuration.files.are.skipped", new Object[0]) + " <a href='SHOW_PROJECT_FILE_OCCURRENCES'>" + UsageViewBundle.message("message.include.them", new Object[0]) + "</a>");
            resultListener = SearchForUsagesRunnable.addHrefHandling(resultListener, SHOW_PROJECT_FILE_OCCURRENCES_HREF_TARGET, searchIncludingProjectFileUsages);
        }
        MessageType actualType = messageType;
        if (!unloadedModulesBelongingToScope.isEmpty()) {
            if (actualType == MessageType.INFO) {
                actualType = MessageType.WARNING;
            }
            resultLines.add(SearchForUsagesRunnable.mayHaveUsagesInUnloadedModulesMessage(unloadedModulesBelongingToScope));
        }
        ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon("Find", actualType, SearchForUsagesRunnable.wrapInHtml(resultLines), AllIcons.Actions.Find, resultListener);
    }

    @NotNull
    private @Unmodifiable Collection<String> getUnloadedModulesBelongingToScope() {
        Collection collection = (Collection)ReadAction.compute(() -> {
            if (!(this.mySearchScopeToWarnOfFallingOutOf instanceof GlobalSearchScope)) {
                return Collections.emptySet();
            }
            Collection unloadedInSearchScope = ((GlobalSearchScope)this.mySearchScopeToWarnOfFallingOutOf).getUnloadedModulesBelongingToScope();
            Set<UnloadedModuleDescription> unloadedInUseScope = this.getUnloadedModulesBelongingToUseScopes();
            Collection result2 = unloadedInUseScope != null ? ContainerUtil.intersection((Collection)unloadedInSearchScope, unloadedInUseScope) : unloadedInSearchScope;
            return ContainerUtil.map((Collection)result2, ModuleDescription::getName);
        });
        if (collection == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(16);
        }
        return collection;
    }

    private Set<UnloadedModuleDescription> getUnloadedModulesBelongingToUseScopes() {
        LinkedHashSet<UnloadedModuleDescription> resolveScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (UsageTarget target : this.mySearchFor) {
            if (!(target instanceof PsiElementUsageTarget)) {
                return null;
            }
            PsiElement element = ((PsiElementUsageTarget)target).getElement();
            if (element == null) {
                return null;
            }
            SearchScope useScope = element.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            resolveScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return resolveScope;
    }

    @NotNull
    private static HyperlinkListener addHrefHandling(final @Nullable HyperlinkListener listener2, final @NotNull String hrefTarget, final @NotNull Runnable handler) {
        if (hrefTarget == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(17);
        }
        if (handler == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(18);
        }
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getDescription().equals(hrefTarget)) {
                    handler.run();
                } else if (listener2 != null) {
                    listener2.hyperlinkUpdate(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/usages/impl/SearchForUsagesRunnable$1", "hyperlinkActivated"));
            }
        };
    }

    @NotNull
    @NlsSafe
    private static String wrapInHtml(@NotNull List<String> strings) {
        if (strings == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(19);
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.join(strings, (String)"<br>"));
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String detailedLargeFilesMessage(@NotNull Collection<? extends VirtualFile> largeFiles) {
        if (largeFiles == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(21);
        }
        String string = UsageViewBundle.message("files.are.too.large.large.and.cannot.be.scanned", largeFiles.size(), "<br> " + StringUtil.join((Collection)ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(largeFiles), (int)10), vFile -> SearchForUsagesRunnable.presentableFileInfo(vFile), (String)"<br> ") + "<br> ");
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String presentableFileInfo(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(23);
        }
        String string = SearchForUsagesRunnable.getPresentablePath(vFile) + "&nbsp;(" + UsageViewManagerImpl.presentableSize(UsageViewManagerImpl.getFileLength(vFile)) + ")";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String getPresentablePath(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(25);
        }
        String string = "'" + (String)ReadAction.compute(() -> ((VirtualFile)virtualFile).getPresentableUrl()) + "'";
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private HyperlinkListener createGotToOptionsListener(final UsageTarget @NotNull [] targets) {
        if (targets == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(27);
        }
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getDescription().equals("FindOptions")) {
                    FindManager.getInstance((Project)SearchForUsagesRunnable.this.myProject).showSettingsAndFindUsages((NavigationItem[])targets);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/usages/impl/SearchForUsagesRunnable$2", "hyperlinkActivated"));
            }
        };
    }

    @NotNull
    private HyperlinkListener createSearchInProjectListener() {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                PsiElement psiElement;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getDescription().equals(SearchForUsagesRunnable.SEARCH_IN_PROJECT_HREF_TARGET) && (psiElement = SearchForUsagesRunnable.getPsiElement(SearchForUsagesRunnable.this.mySearchFor)) != null) {
                    FindManager.getInstance((Project)SearchForUsagesRunnable.this.myProject).findUsagesInScope(psiElement, (SearchScope)GlobalSearchScope.projectScope((Project)SearchForUsagesRunnable.this.myProject));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/usages/impl/SearchForUsagesRunnable$3", "hyperlinkActivated"));
            }
        };
    }

    static PsiElement getPsiElement(UsageTarget @NotNull [] searchFor) {
        UsageTarget target;
        if (searchFor == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(28);
        }
        if (!((target = searchFor[0]) instanceof PsiElementUsageTarget)) {
            return null;
        }
        return (PsiElement)ReadAction.compute(((PsiElementUsageTarget)target)::getElement);
    }

    private static void flashUsageScriptaculously(@NotNull Usage usage) {
        if (usage == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(29);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo2UsageAdapter usageInfo = (UsageInfo2UsageAdapter)usage;
        Editor editor = usageInfo.openTextEditor(true);
        if (editor == null) {
            return;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, attributes, 6, null);
        ArrayList segments = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(segments);
        usageInfo.processRangeMarkers(processor);
        rangeBlinker.resetMarkers(segments);
        rangeBlinker.startBlinking();
    }

    private UsageViewEx getUsageView(@NotNull ProgressIndicator indicator, long startSearchStamp) {
        UsageViewEx existingUsageView;
        if (indicator == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(30);
        }
        if ((existingUsageView = this.myUsageViewRef.get()) != null) {
            return existingUsageView;
        }
        int usageCount = this.myUsageCountWithoutDefinition.get();
        if (usageCount == 0 || usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage() && System.currentTimeMillis() < startSearchStamp + 500L) {
            return null;
        }
        UsageView usageView = this.myUsageViewManager.createUsageView(this.mySearchFor, Usage.EMPTY_ARRAY, this.myPresentation, this.mySearcherFactory::get);
        if (this.myUsageViewRef.compareAndSet(null, (UsageViewEx)usageView)) {
            PsiElement element = SearchForUsagesRunnable.getPsiElement(this.mySearchFor);
            ReadAction.run(() -> this.lambda$getUsageView$3((UsageViewEx)usageView, element));
            usageView.associateProgress(indicator);
            usageView.setSearchInProgress(true);
            if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                this.openView((UsageViewEx)usageView);
            } else if (this.myListener != null) {
                SwingUtilities.invokeLater(() -> {
                    UsageViewEx uv;
                    if (!this.myProject.isDisposed() && (uv = this.myUsageViewRef.get()) != null) {
                        this.myListener.usageViewCreated(uv);
                    }
                });
            }
            Usage firstUsage = this.myFirstUsage.get();
            if (firstUsage != null) {
                ApplicationManager.getApplication().runReadAction(() -> SearchForUsagesRunnable.lambda$getUsageView$5((UsageViewEx)usageView, firstUsage));
            }
            return usageView;
        }
        Disposer.register((Disposable)this.myProject, (Disposable)usageView);
        ApplicationManager.getApplication().invokeLater(() -> SearchForUsagesRunnable.lambda$getUsageView$6((UsageViewEx)usageView), ModalityState.any(), this.myProject.getDisposed());
        return this.myUsageViewRef.get();
    }

    private void openView(@NotNull UsageViewEx usageView) {
        if (usageView == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(31);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myUsageViewManager.showUsageView(usageView, this.myPresentation);
            if (this.myListener != null) {
                this.myListener.usageViewCreated(usageView);
            }
            this.myUsageViewManager.showToolWindow(false);
        });
    }

    @Override
    public void run() {
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        this.searchUsages();
        this.endSearchForUsages();
        snapshot.logResponsivenessSinceCreation("Find Usages in " + this.myProject.getName(), "FindUsagesTotal");
    }

    private void searchUsages() {
        ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
        if (current == null) {
            throw new IllegalStateException("must run find usages under progress");
        }
        ProgressIndicator indicator = ProgressWrapper.unwrapAll((ProgressIndicator)current);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.assertUnderProgress((ProgressIndicator)indicator);
        }
        TooManyUsagesStatus.createFor((ProgressIndicator)indicator);
        UsageSearcher usageSearcher = this.mySearcherFactory.get();
        long startSearchStamp = System.currentTimeMillis();
        GlobalSearchScope everythingScope = GlobalSearchScope.everythingScope((Project)this.myProject);
        usageSearcher.generate((Processor<? super Usage>)((Processor)usage -> {
            boolean incrementCounter;
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (currentIndicator == null) {
                throw new IllegalStateException("must run find usages under progress");
            }
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll((ProgressIndicator)current);
            ProgressManager.checkCanceled();
            if (!UsageViewManagerImpl.isInScope(usage, this.mySearchScopeToWarnOfFallingOutOf, (SearchScope)everythingScope)) {
                this.myOutOfScopeUsages.incrementAndGet();
                return true;
            }
            boolean bl = incrementCounter = !UsageViewManager.isSelfUsage(usage, this.mySearchFor);
            if (incrementCounter) {
                int usageCount = this.myUsageCountWithoutDefinition.incrementAndGet();
                if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
                    this.myFirstUsage.compareAndSet((Usage)null, (Usage)usage);
                }
                this.myFirstItemFoundTS.compareAndSet(0L, System.nanoTime());
                UsageViewEx usageView = this.getUsageView(originalIndicator, startSearchStamp);
                TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.getFrom((ProgressIndicator)originalIndicator);
                if (usageCount > UsageLimitUtil.USAGES_LIMIT && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                    this.myTooManyUsages.set(true);
                    PsiElement element = SearchForUsagesRunnable.getPsiElement(this.mySearchFor);
                    Class elementClass = element == null ? null : element.getClass();
                    String scopeText = this.myPresentation.getScopeText();
                    Language language = element == null ? null : element.getLanguage();
                    Consumer<UsageLimitUtil.Result> onUserClicked = result2 -> UsageViewStatisticsCollector.logTooManyDialog(this.myProject, this.myUsageViewRef.get(), result2 == UsageLimitUtil.Result.ABORT ? TooManyUsagesUserAction.Aborted : TooManyUsagesUserAction.Continued, elementClass, scopeText, language);
                    UsageViewManagerImpl.showTooManyUsagesWarningLater(this.myProject, tooManyUsagesStatus, originalIndicator, usageView, () -> UsageViewBundle.message("find.excessive.usage.count.prompt", new Object[0]), onUserClicked);
                    UsageViewStatisticsCollector.logTooManyDialog(this.myProject, this.myUsageViewRef.get(), TooManyUsagesUserAction.Shown, elementClass, scopeText, language);
                }
                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                if (usageView != null) {
                    ApplicationManager.getApplication().runReadAction(() -> usageView.appendUsage((Usage)usage));
                }
            }
            return true;
        }));
        if (this.myProcessPresentation.isShowFindOptionsPrompt() && this.getUsageView(indicator, startSearchStamp) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.myUsageViewManager.showToolWindow(true), this.myProject.getDisposed());
        }
    }

    private void endSearchForUsages() {
        UsageViewEx usageView;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        int usageCount = this.myUsageCountWithoutDefinition.get();
        Collection<String> unloadedModulesBelongingToScope = this.getUnloadedModulesBelongingToScope();
        if (usageCount == 0) {
            if (this.myProcessPresentation.isShowNotFoundMessage()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProcessPresentation.isCanceled()) {
                        this.notifyByFindBalloon(null, MessageType.WARNING, Collections.singletonList(UsageViewBundle.message("message.usage.search.was.canceled", new Object[0])), unloadedModulesBelongingToScope);
                    } else {
                        ArrayList<String> lines = new ArrayList<String>();
                        lines.add(StringUtil.escapeXmlEntities((String)this.myPresentation.getSearchString()));
                        lines.add(UsageViewBundle.message("search.result.nothing.in.0", StringUtil.escapeXmlEntities((String)this.myPresentation.getScopeText())));
                        if (this.myOutOfScopeUsages.get() != 0) {
                            lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                        }
                        if (this.myProcessPresentation.isShowFindOptionsPrompt()) {
                            lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                        }
                        MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                        this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines, unloadedModulesBelongingToScope);
                    }
                }, ModalityState.nonModal(), this.myProject.getDisposed());
            }
        } else if (usageCount == 1 && !this.myProcessPresentation.isShowPanelIfOnlyOneUsage()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Usage usage = this.myFirstUsage.get();
                if (usage.canNavigate()) {
                    usage.navigate(true);
                    SearchForUsagesRunnable.flashUsageScriptaculously(usage);
                }
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(UsageViewBundle.message("message.only.one.usage.found", new Object[0]));
                if (this.myOutOfScopeUsages.get() != 0) {
                    lines.add(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf));
                }
                lines.add(SearchForUsagesRunnable.createOptionsHtml(this.mySearchFor));
                MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                this.notifyByFindBalloon(this.createGotToOptionsListener(this.mySearchFor), type, lines, unloadedModulesBelongingToScope);
            }, ModalityState.nonModal(), this.myProject.getDisposed());
        } else {
            HyperlinkListener hyperlinkListener;
            List<Object> lines;
            usageView = this.myUsageViewRef.get();
            usageView.searchFinished();
            if (this.myOutOfScopeUsages.get() == 0 || SearchForUsagesRunnable.getPsiElement(this.mySearchFor) == null) {
                lines = Collections.emptyList();
                hyperlinkListener = null;
            } else {
                lines = Arrays.asList(UsageViewManagerImpl.outOfScopeMessage(this.myOutOfScopeUsages.get(), this.mySearchScopeToWarnOfFallingOutOf), SearchForUsagesRunnable.createSearchInProjectHtml());
                hyperlinkListener = this.createSearchInProjectListener();
            }
            if (!this.myProcessPresentation.getLargeFiles().isEmpty() || this.myOutOfScopeUsages.get() != 0 || this.myProcessPresentation.searchIncludingProjectFileUsages() != null || !unloadedModulesBelongingToScope.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MessageType type = this.myOutOfScopeUsages.get() == 0 ? MessageType.INFO : MessageType.WARNING;
                    this.notifyByFindBalloon(hyperlinkListener, type, lines, unloadedModulesBelongingToScope);
                }, ModalityState.nonModal(), this.myProject.getDisposed());
            }
        }
        if ((usageView = this.myUsageViewRef.get()) != null) {
            usageView.waitForUpdateRequestsCompletion();
        }
        if (this.myListener != null) {
            this.myListener.findingUsagesFinished(usageView);
        }
    }

    @NotNull
    private static String mayHaveUsagesInUnloadedModulesMessage(@NotNull Collection<String> unloadedModules) {
        if (unloadedModules == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(32);
        }
        String modulesText = unloadedModules.size() > 1 ? UsageViewBundle.message("message.part.number.of.unloaded.modules", unloadedModules.size()) : UsageViewBundle.message("message.part.unloaded.module.0", Objects.requireNonNull((String)ContainerUtil.getFirstItem(unloadedModules)));
        String string = UsageViewBundle.message("message.occurrences.in.0.may.be.skipped.load.all.modules.and.repeat.the.search.to.get.complete.results", modulesText);
        if (string == null) {
            SearchForUsagesRunnable.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void lambda$getUsageView$6(UsageViewEx usageView) {
        Disposer.dispose((Disposable)usageView);
    }

    private static /* synthetic */ void lambda$getUsageView$5(UsageViewEx usageView, Usage firstUsage) {
        usageView.appendUsage(firstUsage);
    }

    private /* synthetic */ void lambda$getUsageView$3(UsageViewEx usageView, PsiElement element) throws RuntimeException {
        UsageViewStatisticsCollector.logSearchStarted(this.myProject, usageView, CodeNavigateSource.FindToolWindow, element, this.mySearchFor.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 16, 20, 22, 24, 26, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopeToWarnOfFallingOutOf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstItemFoundTS";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooManyUsages";
                break;
            }
            case 9: 
            case 10: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFor";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModulesBelongingToScope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hrefTarget";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "largeFiles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/SearchForUsagesRunnable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsHtml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchInProjectHtml";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "detailedLargeFilesMessage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableFileInfo";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsHtml";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 33: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notifyByFindBalloon";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addHrefHandling";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detailedLargeFilesMessage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "presentableFileInfo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createGotToOptionsListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "flashUsageScriptaculously";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getUsageView";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openView";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveUsagesInUnloadedModulesMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 16, 20, 22, 24, 26, 33 -> new IllegalStateException(string);
        };
    }
}

