/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.PackageGroupRuleProvider;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.DirectoryStructureGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.UsageScopeGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ActiveRules {
    public static UsageGroupingRule @NotNull [] getActiveRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings, @Nullable UsageViewPresentation presentation, boolean supportsNonCodeRule, boolean supportsScopesRule, boolean supportsModuleRule) {
        if (project == null) {
            ActiveRules.$$$reportNull$$$0(0);
        }
        if (usageViewSettings == null) {
            ActiveRules.$$$reportNull$$$0(1);
        }
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (supportsNonCodeRule && (presentation == null || !presentation.isDetachedMode() && presentation.isNonCodeUsageAvailable())) {
            rules.add(new NonCodeUsageGroupingRule(presentation));
        }
        if (supportsScopesRule && usageViewSettings.isGroupByScope()) {
            rules.add(new UsageScopeGroupingRule());
        }
        if (usageViewSettings.isGroupByUsageType()) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (supportsModuleRule && usageViewSettings.isGroupByModule()) {
            rules.add(new ModuleGroupingRule(project, usageViewSettings.isFlattenModules()));
        }
        if (usageViewSettings.isGroupByPackage() && !usageViewSettings.isGroupByDirectoryStructure()) {
            UsageGroupingRule rule = DirectoryGroupingRule.getInstance(project);
            if (presentation != null) {
                for (PackageGroupRuleProvider ruleProvider : PackageGroupRuleProvider.EP_NAME.getExtensionList()) {
                    UsageGroupingRule candidate = ruleProvider.getUsageGroupingRule(project, usageViewSettings, presentation.isDetachedMode());
                    if (candidate == null) continue;
                    rule = candidate;
                    break;
                }
            }
            rules.add(rule);
        }
        if (usageViewSettings.isGroupByDirectoryStructure()) {
            rules.add(new DirectoryStructureGroupingRule(project, usageViewSettings.isCompactMiddleDirectories()));
        }
        if (usageViewSettings.isGroupByFileStructure()) {
            for (FileStructureGroupRuleProvider ruleProvider : FileStructureGroupRuleProvider.EP_NAME.getExtensionList()) {
                ContainerUtil.addIfNotNull(rules, (Object)ruleProvider.getUsageGroupingRule(project, usageViewSettings));
            }
        } else {
            rules.add(new FileGroupingRule(project, usageViewSettings.getShowShortFilePath()));
        }
        UsageGroupingRule[] usageGroupingRuleArray = rules.toArray(UsageGroupingRule.EMPTY_ARRAY);
        if (usageGroupingRuleArray == null) {
            ActiveRules.$$$reportNull$$$0(2);
        }
        return usageGroupingRuleArray;
    }

    public static UsageGroupingRule @NotNull [] getAllRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings, @Nullable UsageViewPresentation presentation, boolean supportsNonCodeRule, boolean supportsScopesRule, boolean supportsModuleRule) {
        UsageGroupingRule rule;
        if (project == null) {
            ActiveRules.$$$reportNull$$$0(3);
        }
        if (usageViewSettings == null) {
            ActiveRules.$$$reportNull$$$0(4);
        }
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (supportsNonCodeRule) {
            rules.add(new NonCodeUsageGroupingRule(presentation));
        }
        if (supportsScopesRule) {
            rules.add(new UsageScopeGroupingRule());
        }
        rules.add(new UsageTypeGroupingRule());
        if (supportsModuleRule) {
            rules.add(new ModuleGroupingRule(project, usageViewSettings.isFlattenModules()));
        }
        UsageGroupingRule packageRule = DirectoryGroupingRule.getInstance(project);
        if (presentation != null) {
            for (Object ruleProvider : PackageGroupRuleProvider.EP_NAME.getExtensionList()) {
                rule = ruleProvider.getUsageGroupingRule(project, usageViewSettings, presentation.isDetachedMode());
                if (rule == null) continue;
                if (!(rule instanceof UsageGroupingRuleEx)) {
                    rule = new PackageGroupingRuleExWrapper(rule);
                }
                packageRule = rule;
                break;
            }
        }
        rules.add(packageRule);
        rules.add(new DirectoryStructureGroupingRule(project, usageViewSettings.isCompactMiddleDirectories()));
        for (Object ruleProvider : FileStructureGroupRuleProvider.EP_NAME.getExtensionList()) {
            rule = ruleProvider.getUsageGroupingRule(project, usageViewSettings);
            if (rule == null) continue;
            if (!(rule instanceof UsageGroupingRuleEx)) {
                rule = new FileStructureGroupingRuleExWrapper(rule);
            }
            rules.add(rule);
        }
        rules.add(new FileGroupingRule(project, usageViewSettings.getShowShortFilePath()));
        UsageGroupingRule[] usageGroupingRuleArray = rules.toArray(UsageGroupingRule.EMPTY_ARRAY);
        if (usageGroupingRuleArray == null) {
            ActiveRules.$$$reportNull$$$0(5);
        }
        return usageGroupingRuleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/rules/ActiveRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/rules/ActiveRules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveRules";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActiveRules";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllRules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    private static final class PackageGroupingRuleExWrapper
    extends GroupingRuleExWrapper {
        private PackageGroupingRuleExWrapper(@NotNull UsageGroupingRule rule) {
            if (rule == null) {
                PackageGroupingRuleExWrapper.$$$reportNull$$$0(0);
            }
            super(rule);
        }

        @Override
        @NotNull
        public String getGroupingActionId() {
            return "UsageGrouping.DirectoryStructure";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/usages/impl/rules/ActiveRules$PackageGroupingRuleExWrapper", "<init>"));
        }
    }

    private static final class FileStructureGroupingRuleExWrapper
    extends GroupingRuleExWrapper {
        private FileStructureGroupingRuleExWrapper(@NotNull UsageGroupingRule rule) {
            if (rule == null) {
                FileStructureGroupingRuleExWrapper.$$$reportNull$$$0(0);
            }
            super(rule);
        }

        @Override
        @NotNull
        public String getGroupingActionId() {
            return "UsageGrouping.FileStructure";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/usages/impl/rules/ActiveRules$FileStructureGroupingRuleExWrapper", "<init>"));
        }
    }

    private static abstract class GroupingRuleExWrapper
    implements UsageGroupingRuleEx {
        private final UsageGroupingRule myGroupingRule;

        protected GroupingRuleExWrapper(@NotNull UsageGroupingRule rule) {
            if (rule == null) {
                GroupingRuleExWrapper.$$$reportNull$$$0(0);
            }
            this.myGroupingRule = rule;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myGroupingRule.getClass().getName();
            if (string == null) {
                GroupingRuleExWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public @Unmodifiable List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
            if (usage == null) {
                GroupingRuleExWrapper.$$$reportNull$$$0(2);
            }
            if (targets == null) {
                GroupingRuleExWrapper.$$$reportNull$$$0(3);
            }
            List<UsageGroup> list2 = this.myGroupingRule.getParentGroupsFor(usage, targets);
            if (list2 == null) {
                GroupingRuleExWrapper.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        public int getRank() {
            return this.myGroupingRule.getRank();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rule";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ActiveRules$GroupingRuleExWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ActiveRules$GroupingRuleExWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentGroupsFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentGroupsFor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4 -> new IllegalStateException(string);
            };
        }
    }
}

