/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.ResettableListIterator;

public class LoopingListIterator
implements ResettableListIterator {
    private List list;
    private ListIterator iterator;

    public LoopingListIterator(List list2) {
        if (list2 == null) {
            throw new NullPointerException("The list must not be null");
        }
        this.list = list2;
        this.reset();
    }

    public boolean hasNext() {
        return !this.list.isEmpty();
    }

    public Object next() {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasNext()) {
            this.reset();
        }
        return this.iterator.next();
    }

    public int nextIndex() {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasNext()) {
            return 0;
        }
        return this.iterator.nextIndex();
    }

    public boolean hasPrevious() {
        return !this.list.isEmpty();
    }

    public Object previous() {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasPrevious()) {
            Object result2 = null;
            while (this.iterator.hasNext()) {
                result2 = this.iterator.next();
            }
            this.iterator.previous();
            return result2;
        }
        return this.iterator.previous();
    }

    public int previousIndex() {
        if (this.list.isEmpty()) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasPrevious()) {
            return this.list.size() - 1;
        }
        return this.iterator.previousIndex();
    }

    public void remove() {
        this.iterator.remove();
    }

    public void add(Object obj2) {
        this.iterator.add(obj2);
    }

    public void set(Object obj2) {
        this.iterator.set(obj2);
    }

    public void reset() {
        this.iterator = this.list.listIterator();
    }

    public int size() {
        return this.list.size();
    }
}

