/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteDb;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010JD\u0010\u0011\u001a\u00020\u001226\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00120\u0014H\u0086\b\u00f8\u0001\u0000JO\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a26\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u0002H\u001a0\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\rJ\u0013\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lorg/jetbrains/sqlite/SafeStatementPointer;", "", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "pointer", "", "<init>", "(Lorg/jetbrains/sqlite/SqliteConnection;J)V", "value", "", "isClosed", "()Z", "close", "", "db", "Lorg/jetbrains/sqlite/SqliteDb;", "close$intellij_platform_sqlite", "safeRunInt", "", "task", "Lkotlin/Function2;", "Lorg/jetbrains/sqlite/NativeDB;", "Lkotlin/ParameterName;", "name", "statementPointer", "safeRun", "T", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "ensureOpen", "equals", "other", "hashCode", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSafeStatementPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeStatementPointer.kt\norg/jetbrains/sqlite/SafeStatementPointer\n+ 2 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n67#2,6:71\n67#2,6:77\n1#3:83\n*S KotlinDebug\n*F\n+ 1 SafeStatementPointer.kt\norg/jetbrains/sqlite/SafeStatementPointer\n*L\n39#1:71,6\n52#1:77,6\n*E\n"})
public final class SafeStatementPointer {
    @NotNull
    private final SqliteConnection connection;
    @JvmField
    public final long pointer;
    private volatile boolean isClosed;

    public SafeStatementPointer(@NotNull SqliteConnection connection, long pointer) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.pointer = pointer;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$intellij_platform_sqlite(@NotNull SqliteDb db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        if (this.isClosed) {
            return;
        }
        try {
            int status = db.finalize(this, this.pointer);
            if (status != 0 && status != 21) {
                throw SqliteDb.newException$default(db, status, null, 2, null);
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int safeRunInt(@NotNull Function2<? super NativeDB, ? super Long, Integer> task2) {
        int n;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        boolean $i$f$safeRunInt = false;
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            this.ensureOpen();
            n = ((Number)task2.invoke((Object)db, (Object)this.pointer)).intValue();
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T safeRun(@NotNull Function2<? super SqliteDb, ? super Long, ? extends T> task2) {
        Object object;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        boolean $i$f$safeRun = false;
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            this.ensureOpen();
            object = task2.invoke((Object)db, (Object)this.pointer);
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return (T)object;
    }

    public final void ensureOpen() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "The statement pointer is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        SafeStatementPointer that = (SafeStatementPointer)other;
        return this.pointer == that.pointer;
    }

    public int hashCode() {
        return Long.hashCode(this.pointer);
    }
}

