/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.ContentRootChangeListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.project.ProjectKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy;", "Lcom/intellij/openapi/vcs/impl/DefaultVcsRootPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getDefaultVcsRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "MyModulesListener", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    public ModuleDefaultVcsRootPolicy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        project.getMessageBus().connect().subscribe(WorkspaceModelTopics.CHANGED, (Object)new MyModulesListener());
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultVcsRoots() {
        Set result2 = new LinkedHashSet();
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            VirtualFile ideaDir;
            result2.add(baseDir);
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            Path directoryStorePath = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            if (directoryStorePath != null && (ideaDir = LocalFileSystem.getInstance().findFileByNioFile(directoryStorePath)) != null) {
                result2.add(ideaDir);
            }
        }
        CollectionsKt.addAll((Collection)result2, (Sequence)((Sequence)ActionsKt.runReadAction(() -> ModuleDefaultVcsRootPolicy.getDefaultVcsRoots$lambda$0(this))));
        return result2;
    }

    private static final VirtualFile getDefaultVcsRoots$lambda$0$0(ContentRootEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
    }

    private static final boolean getDefaultVcsRoots$lambda$0$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInLocalFileSystem();
    }

    private static final boolean getDefaultVcsRoots$lambda$0$2(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    private static final Sequence getDefaultVcsRoots$lambda$0(ModuleDefaultVcsRootPolicy this$0) {
        Project project = this$0.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)WorkspaceModel.Companion.getInstance(project).getCurrentSnapshot().entities(ContentRootEntity.class), ModuleDefaultVcsRootPolicy::getDefaultVcsRoots$lambda$0$0), ModuleDefaultVcsRootPolicy::getDefaultVcsRoots$lambda$0$1), ModuleDefaultVcsRootPolicy::getDefaultVcsRoots$lambda$0$2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy$MyModulesListener;", "Lcom/intellij/openapi/vcs/impl/ContentRootChangeListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy;)V", "contentRootsChanged", "", "removed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "added", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    extends ContentRootChangeListener {
        public MyModulesListener() {
            super(true);
        }

        @Override
        public void contentRootsChanged(@NotNull List<? extends VirtualFile> removed, @NotNull List<? extends VirtualFile> added) {
            Intrinsics.checkNotNullParameter(removed, (String)"removed");
            Intrinsics.checkNotNullParameter(added, (String)"added");
            ModuleDefaultVcsRootPolicy.this.scheduleMappedRootsUpdate();
            ModuleDefaultVcsRootPolicy.this.scheduleRootsChangeProcessing((Collection<VirtualFile>)removed, (Collection<VirtualFile>)added);
        }
    }
}

