/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.testFramework.classic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.testFramework.classic.ClassicTerminalTestBufferWatcher;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0004J\u001c\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestShellSession;", "", "shellCommand", "", "", "widget", "Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "<init>", "(Ljava/util/List;Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;)V", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getWidget", "()Lorg/jetbrains/plugins/terminal/ShellTerminalWidget;", "watcher", "Lorg/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestBufferWatcher;", "executeCommand", "", "awaitScreenLinesEndWith", "expectedScreenLines", "timeoutMillis", "", "awaitScreenLinesAre", "awaitBufferCondition", "condition", "Ljava/util/function/BooleanSupplier;", "screenLines", "getScreenLines", "()Ljava/lang/String;", "Companion", "intellij.terminal"})
@ApiStatus.Experimental
public final class ClassicTerminalTestShellSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShellTerminalWidget widget;
    @NotNull
    private final ClassicTerminalTestBufferWatcher watcher;

    public ClassicTerminalTestShellSession(@Nullable List<String> shellCommand, @NotNull ShellTerminalWidget widget) {
        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
        this.widget = widget;
        this.watcher = new ClassicTerminalTestBufferWatcher(this.widget.getTerminalTextBuffer(), this.widget.getTerminal());
        ClassicTerminalTestShellSession.Companion.start(shellCommand, this.widget);
    }

    @NotNull
    public final ShellTerminalWidget getWidget() {
        return this.widget;
    }

    public ClassicTerminalTestShellSession(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this(null, new ShellTerminalWidget(project, new JBTerminalSystemSettingsProvider(), parentDisposable));
    }

    public final void executeCommand(@NotNull String shellCommand) throws IOException {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.widget.executeCommand(shellCommand);
    }

    public final void awaitScreenLinesEndWith(@NotNull List<String> expectedScreenLines, int timeoutMillis) {
        Intrinsics.checkNotNullParameter(expectedScreenLines, (String)"expectedScreenLines");
        this.watcher.awaitScreenLinesEndWith(expectedScreenLines, timeoutMillis);
    }

    public final void awaitScreenLinesAre(@NotNull List<String> expectedScreenLines, int timeoutMillis) {
        Intrinsics.checkNotNullParameter(expectedScreenLines, (String)"expectedScreenLines");
        this.watcher.awaitScreenLinesAre(expectedScreenLines, timeoutMillis);
    }

    public final void awaitBufferCondition(@NotNull BooleanSupplier condition, int timeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.watcher.awaitBuffer(condition, timeoutMillis);
    }

    @NotNull
    public final String getScreenLines() {
        String string = this.watcher.getScreenLines();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScreenLines(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestShellSession$Companion;", "", "<init>", "()V", "start", "", "shellCommand", "", "", "terminalWidget", "Lcom/intellij/terminal/JBTerminalWidget;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nClassicTerminalTestShellSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicTerminalTestShellSession.kt\norg/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestShellSession$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 ClassicTerminalTestShellSession.kt\norg/jetbrains/plugins/terminal/testFramework/classic/ClassicTerminalTestShellSession$Companion\n*L\n81#1:100\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void start(List<String> shellCommand, JBTerminalWidget terminalWidget) {
            LocalTerminalDirectRunner localTerminalDirectRunner = LocalTerminalDirectRunner.createTerminalRunner(terminalWidget.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)localTerminalDirectRunner, (String)"createTerminalRunner(...)");
            LocalTerminalDirectRunner runner = localTerminalDirectRunner;
            ShellStartupOptions baseOptions = ShellStartupOptionsKt.shellStartupOptions(terminalWidget.getProject().getBasePath(), (Function1<? super ShellStartupOptions.Builder, Unit>)((Function1)arg_0 -> Companion.start$lambda$0(shellCommand, arg_0)));
            TermSize initialTermSize = new TermSize(80, 50);
            Path workingDirectory = Files.createTempDirectory("intellij-terminal-working-dir", new FileAttribute[0]);
            ShellStartupOptions configuredOptions = runner.configureStartupOptions(baseOptions).builder().modify((Function1<? super ShellStartupOptions.Builder, Unit>)((Function1)arg_0 -> Companion.start$lambda$1(initialTermSize, workingDirectory, arg_0))).build();
            TtyConnector ttyConnector = runner.createTtyConnector(configuredOptions);
            Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"createTtyConnector(...)");
            TtyConnector connector = ttyConnector;
            Process process = ((PtyProcessTtyConnector)connector).getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            Process process2 = process;
            terminalWidget.asNewWidget().connectToTty(connector, initialTermSize);
            Disposer.register((Disposable)((Disposable)terminalWidget), () -> Companion.start$lambda$2(connector, workingDirectory));
            if (SystemInfo.isWindows) {
                String msg = "On Windows, the bundled ConPTY in required for test stability";
                if (!(process2 instanceof WinConPtyProcess)) {
                    throw new IllegalStateException(msg + ", but got " + process2.getClass());
                }
                if (!((WinConPtyProcess)process2).isBundledConPtyLibrary()) {
                    throw new IllegalStateException(msg);
                }
            }
        }

        private static final Unit start$lambda$0(List $shellCommand, ShellStartupOptions.Builder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setShellCommand($shellCommand);
            return Unit.INSTANCE;
        }

        private static final Unit start$lambda$1(TermSize $initialTermSize, Path $workingDirectory, ShellStartupOptions.Builder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setInitialTermSize($initialTermSize);
            it.setWorkingDirectory(((Object)$workingDirectory).toString());
            return Unit.INSTANCE;
        }

        private static final void start$lambda$2(TtyConnector $connector, Path $workingDirectory) {
            try {
                ((PtyProcessTtyConnector)$connector).close();
            }
            catch (Throwable t) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ClassicTerminalTestShellSession.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Error closing TtyConnector", t);
            }
            NioFiles.deleteRecursively((Path)$workingDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

