/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.testFramework.completion.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.terminal.completion.spec.ShellCommandExecutor;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.terminal.completion.spec.ShellCommandSpec;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellDataGeneratorProcessExecutor;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellFileSystemSupport;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellDataGeneratorProcessExecutorImpl;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellFileSystemSupportImpl;
import org.jetbrains.plugins.terminal.testFramework.completion.ShellCompletionTestFixture;
import org.jetbrains.plugins.terminal.testFramework.completion.ShellCompletionTestFixtureBuilder;
import org.jetbrains.plugins.terminal.testFramework.completion.impl.DummyShellCommandExecutor;
import org.jetbrains.plugins.terminal.testFramework.completion.impl.ShellCompletionTestFixtureImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u001c\u0010\u0017\u001a\u00020\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\u001a\u001a\u00020\u00012\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u001c\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u001dJ@\u0010\u001e\u001a\u00020\u000121\u0010\u001f\u001a-\b\u0001\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0012\u0006\u0012\u0004\u0018\u00010&0 H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0012H\u0016J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0014H\u0016J\b\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/testFramework/completion/impl/ShellCompletionTestFixtureBuilderImpl;", "Lorg/jetbrains/plugins/terminal/testFramework/completion/ShellCompletionTestFixtureBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "curDirectory", "", "envVariables", "", "isReworkedTerminal", "", "commandSpecs", "", "Lcom/intellij/terminal/completion/spec/ShellCommandSpec;", "generatorCommandsRunner", "Lcom/intellij/terminal/completion/spec/ShellCommandExecutor;", "generatorProcessExecutor", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellDataGeneratorProcessExecutor;", "fileSystemSupport", "Lorg/jetbrains/plugins/terminal/block/completion/spec/ShellFileSystemSupport;", "setCurrentDirectory", "directory", "setEnvVariables", "envVars", "setIsReworkedTerminal", "mockCommandSpecs", "specs", "", "([Lcom/intellij/terminal/completion/spec/ShellCommandSpec;)Lorg/jetbrains/plugins/terminal/testFramework/completion/ShellCompletionTestFixtureBuilder;", "mockShellCommandResults", "mock", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "command", "Lkotlin/coroutines/Continuation;", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "", "(Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/plugins/terminal/testFramework/completion/ShellCompletionTestFixtureBuilder;", "mockProcessesExecutor", "executor", "mockFileSystemSupport", "support", "build", "Lorg/jetbrains/plugins/terminal/testFramework/completion/ShellCompletionTestFixture;", "intellij.terminal"})
@TestOnly
public final class ShellCompletionTestFixtureBuilderImpl
implements ShellCompletionTestFixtureBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private String curDirectory;
    @NotNull
    private Map<String, String> envVariables;
    private boolean isReworkedTerminal;
    @Nullable
    private List<? extends ShellCommandSpec> commandSpecs;
    @NotNull
    private ShellCommandExecutor generatorCommandsRunner;
    @Nullable
    private ShellDataGeneratorProcessExecutor generatorProcessExecutor;
    @Nullable
    private ShellFileSystemSupport fileSystemSupport;

    public ShellCompletionTestFixtureBuilderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.curDirectory = string;
        this.envVariables = MapsKt.emptyMap();
        this.isReworkedTerminal = true;
        this.generatorCommandsRunner = DummyShellCommandExecutor.INSTANCE;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder setCurrentDirectory(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.curDirectory = directory;
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder setEnvVariables(@NotNull Map<String, String> envVars) {
        Intrinsics.checkNotNullParameter(envVars, (String)"envVars");
        this.envVariables = envVars;
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder setIsReworkedTerminal(boolean isReworkedTerminal) {
        this.isReworkedTerminal = isReworkedTerminal;
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder mockCommandSpecs(ShellCommandSpec ... specs) {
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        this.commandSpecs = ArraysKt.toList((Object[])specs);
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder mockShellCommandResults(@NotNull Function2<? super String, ? super Continuation<? super ShellCommandResult>, ? extends Object> mock) {
        Intrinsics.checkNotNullParameter(mock, (String)"mock");
        this.generatorCommandsRunner = new ShellCommandExecutor(mock){
            final /* synthetic */ Function2<String, Continuation<? super ShellCommandResult>, Object> $mock;
            {
                this.$mock = $mock;
            }

            public Object runShellCommand(String directory, String command2, Continuation<? super ShellCommandResult> $completion) {
                return this.$mock.invoke((Object)command2, $completion);
            }
        };
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder mockProcessesExecutor(@NotNull ShellDataGeneratorProcessExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.generatorProcessExecutor = executor;
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixtureBuilder mockFileSystemSupport(@NotNull ShellFileSystemSupport support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        this.fileSystemSupport = support;
        return this;
    }

    @Override
    @NotNull
    public ShellCompletionTestFixture build() {
        ShellFileSystemSupport shellFileSystemSupport;
        ShellDataGeneratorProcessExecutor processExecutor;
        EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)this.project);
        ShellDataGeneratorProcessExecutor shellDataGeneratorProcessExecutor = this.generatorProcessExecutor;
        if (shellDataGeneratorProcessExecutor == null) {
            shellDataGeneratorProcessExecutor = processExecutor = (ShellDataGeneratorProcessExecutor)new ShellDataGeneratorProcessExecutorImpl(eelDescriptor, this.envVariables);
        }
        if ((shellFileSystemSupport = this.fileSystemSupport) == null) {
            shellFileSystemSupport = new ShellFileSystemSupportImpl(eelDescriptor);
        }
        ShellFileSystemSupport fileSystemSupport = shellFileSystemSupport;
        return new ShellCompletionTestFixtureImpl(this.project, this.curDirectory, this.envVariables, this.isReworkedTerminal, this.commandSpecs, this.generatorCommandsRunner, processExecutor, fileSystemSupport);
    }
}

