/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.impl.frontend;

import com.intellij.execution.RunContentDescriptorIdImpl;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManagerProxy;
import com.intellij.execution.rpc.ExecutionEnvironmentProxyDto;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProxy;
import com.intellij.execution.runners.RunnerAndConfigurationSettingsProxy;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.impl.frontend.FakeFrontendRunDashboardConfiguration;
import com.intellij.platform.execution.impl.frontend.FrontendFrontendExecutionEnvironmentProxyCoroutineScope;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\r\u0010\u0015\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/execution/impl/frontend/FrontendExecutionEnvironmentProxy;", "Lcom/intellij/execution/runners/ExecutionEnvironmentProxy;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "dto", "Lcom/intellij/execution/rpc/ExecutionEnvironmentProxyDto;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/execution/rpc/ExecutionEnvironmentProxyDto;)V", "icon", "Ljavax/swing/Icon;", "rerunIcon", "isStartingStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "", "getFakeRunConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isShowInDashboard", "getContentDescriptorToolWindowId", "", "getRunProfileName", "Lcom/intellij/openapi/util/NlsSafe;", "getRunConfigurationTypeId", "getIcon", "getRerunIcon", "getRunnerAndConfigurationSettingsProxy", "Lcom/intellij/execution/runners/RunnerAndConfigurationSettingsProxy;", "getContentToReuse", "Lcom/intellij/execution/ui/RunContentDescriptor;", "isStarting", "isStartingFlow", "Lkotlinx/coroutines/flow/Flow;", "performRestart", "", "getExecutionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.platform.execution.impl.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendExecutionEnvironmentProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendExecutionEnvironmentProxy.kt\ncom/intellij/platform/execution/impl/frontend/FrontendExecutionEnvironmentProxy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,125:1\n1#2:126\n30#3,2:127\n*S KotlinDebug\n*F\n+ 1 FrontendExecutionEnvironmentProxy.kt\ncom/intellij/platform/execution/impl/frontend/FrontendExecutionEnvironmentProxy\n*L\n92#1:127,2\n*E\n"})
final class FrontendExecutionEnvironmentProxy
implements ExecutionEnvironmentProxy {
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutionEnvironmentProxyDto dto;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Icon rerunIcon;
    @NotNull
    private final StateFlow<Boolean> isStartingStateFlow;

    public FrontendExecutionEnvironmentProxy(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull ExecutionEnvironmentProxyDto dto) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        this.project = project;
        this.dto = dto;
        this.icon = IconIdKt.icon((IconId)this.dto.getIcon());
        this.rerunIcon = IconIdKt.icon((IconId)this.dto.getRerunIcon());
        this.isStartingStateFlow = FlowKt.stateIn((Flow)this.dto.isStarting().toFlow(), (CoroutineScope)cs, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)this.dto.isStartingInitial());
    }

    private final RunConfiguration getFakeRunConfiguration() {
        String typeId = this.dto.getRunConfigurationTypeId();
        return (RunConfiguration)new FakeFrontendRunDashboardConfiguration(this.project, this.dto.getRunProfileName(), typeId);
    }

    public boolean isShowInDashboard() {
        RunConfiguration configuration = this.getFakeRunConfiguration();
        return RunDashboardManagerProxy.Companion.getInstance(this.project).isShowInDashboard(configuration);
    }

    @Nullable
    public String getContentDescriptorToolWindowId() {
        RunConfiguration configuration = this.getFakeRunConfiguration();
        return RunContentManager.getInstance((Project)this.project).getContentDescriptorToolWindowId(configuration);
    }

    @NotNull
    public String getRunProfileName() {
        return this.dto.getRunProfileName();
    }

    @NotNull
    public String getRunConfigurationTypeId() {
        return this.dto.getRunConfigurationTypeId();
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public Icon getRerunIcon() {
        return this.rerunIcon;
    }

    @Nullable
    public RunnerAndConfigurationSettingsProxy getRunnerAndConfigurationSettingsProxy() {
        return null;
    }

    @Nullable
    public RunContentDescriptor getContentToReuse() {
        Object v2;
        block2: {
            RunContentDescriptorIdImpl runContentDescriptorIdImpl = this.dto.getEnvironmentContentToReuseDescriptorId();
            if (runContentDescriptorIdImpl == null) {
                return null;
            }
            RunContentDescriptorIdImpl descriptorId = runContentDescriptorIdImpl;
            Collection collection = RunContentManager.getInstance((Project)this.project).getRunContentDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRunContentDescriptors(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                RunContentDescriptor it = (RunContentDescriptor)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)descriptorId)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    public boolean isStarting() {
        return (Boolean)this.isStartingStateFlow.getValue();
    }

    @NotNull
    public Flow<Boolean> isStartingFlow() {
        return (Flow)this.isStartingStateFlow;
    }

    public void performRestart() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<FrontendFrontendExecutionEnvironmentProxyCoroutineScope> serviceClass$iv = FrontendFrontendExecutionEnvironmentProxyCoroutineScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((FrontendFrontendExecutionEnvironmentProxyCoroutineScope)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendExecutionEnvironmentProxy this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendExecutionEnvironmentProxy.access$getDto$p(this.this$0).getRestartRequest().send((Object)Unit.INSTANCE, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.dto.getExecutionEnvironment();
    }

    public static final /* synthetic */ ExecutionEnvironmentProxyDto access$getDto$p(FrontendExecutionEnvironmentProxy $this) {
        return $this.dto;
    }
}

