/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ExternalSystemRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Object action22;
        if (e == null) {
            ExternalSystemRunConfigurationMenu.$$$reportNull$$$0(0);
        }
        for (Object action22 : this.getChildActionsOrStubs()) {
            if (!(action22 instanceof ExecuteExternalSystemRunConfigurationAction)) continue;
            this.remove((AnAction)action22);
        }
        Project project = e.getProject();
        List selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1 || !((action22 = selectedNodes.get(0)) instanceof RunConfigurationNode)) {
            return;
        }
        RunConfigurationNode runConfigurationNode = (RunConfigurationNode)action22;
        RunnerAndConfigurationSettings settings = runConfigurationNode.getSettings();
        if (settings == null || project == null) {
            return;
        }
        ProjectSystemId projectSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        ArrayList<Executor> executors = new ArrayList<Executor>();
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (executor instanceof ExecutorGroup) {
                executors.addAll(((ExecutorGroup)executor).childExecutors());
                continue;
            }
            executors.add(executor);
        }
        int i2 = executors.size();
        while (--i2 >= 0) {
            Executor executor;
            executor = (Executor)executors.get(i2);
            if (!executor.isApplicable(project)) continue;
            ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
            ExecuteExternalSystemRunConfigurationAction action3 = new ExecuteExternalSystemRunConfigurationAction(executor, runner != null, project, projectSystemId, settings);
            this.addAction(action3, Constraints.FIRST);
        }
        super.update(e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExternalSystemRunConfigurationMenu.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ExecuteExternalSystemRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final Project myProject;
        private final RunnerAndConfigurationSettings mySettings;
        private final ProjectSystemId mySystemId;

        ExecuteExternalSystemRunConfigurationAction(Executor executor, boolean enabled, Project project, ProjectSystemId projectSystemId, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.myProject = project;
            this.mySettings = settings;
            this.mySystemId = projectSystemId;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                ExecuteExternalSystemRunConfigurationAction.$$$reportNull$$$0(0);
            }
            if (this.myEnabled) {
                ExternalSystemActionsCollector.trigger(this.myProject, this.mySystemId, this, event);
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)this.myExecutor);
                RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.mySettings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteExternalSystemRunConfigurationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myEnabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ExecuteExternalSystemRunConfigurationAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu$ExecuteExternalSystemRunConfigurationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemRunConfigurationMenu$ExecuteExternalSystemRunConfigurationAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

