/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.issue.quickfix;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/issue/quickfix/ReimportQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "myProjectPath", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ReimportQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String myProjectPath;
    @NotNull
    private final ProjectSystemId systemId;
    @NotNull
    private final String id;

    public ReimportQuickFix(@NotNull String myProjectPath, @NotNull ProjectSystemId systemId) {
        Intrinsics.checkNotNullParameter((Object)myProjectPath, (String)"myProjectPath");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        this.myProjectPath = myProjectPath;
        this.systemId = systemId;
        this.id = "reimport";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture<Void> completableFuture = ExternalSystemUtil.requestImport(project, this.myProjectPath, this.systemId);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"requestImport(...)");
        return completableFuture;
    }
}

