/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class ExternalSystemNotificationManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemNotificationManager.class);
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final Set<Notification> myNotifications;
    @NotNull
    private final Map<Key, Notification> myUniqueNotifications;
    @NotNull
    private final Set<ProjectSystemId> initializedExternalSystem;
    @NotNull
    private final MessageCounter myMessageCounter;

    public ExternalSystemNotificationManager(@NotNull Project project) {
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myNotifications = ConcurrentCollectionFactory.createConcurrentSet();
        this.myUniqueNotifications = new ConcurrentHashMap<Key, Notification>();
        this.initializedExternalSystem = ConcurrentCollectionFactory.createConcurrentSet();
        this.myMessageCounter = new MessageCounter();
        this.myUpdateQueue = new MergingUpdateQueue(String.valueOf(this.getClass()) + " updates", 500, true, null, (Disposable)this, null, false);
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(1);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = (ExternalSystemNotificationManager)project.getService(ExternalSystemNotificationManager.class);
        if (externalSystemNotificationManager == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(2);
        }
        return externalSystemNotificationManager;
    }

    @Nullable
    public static NotificationData createNotification(@NlsContexts.NotificationTitle @NotNull String title, @NotNull Throwable error, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull String externalProjectPath, @NotNull DataContext dataContext) {
        if (title == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(3);
        }
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(6);
        }
        if (externalProjectPath == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(8);
        }
        return ExternalSystemNotificationManager.doCreateNotification(title, error, externalSystemId, project, dataContext, (extension, notificationData) -> extension.customize((NotificationData)notificationData, project, externalProjectPath, error));
    }

    @Nullable
    private static NotificationData doCreateNotification(@NlsContexts.NotificationTitle @NotNull String title, @NotNull Throwable error, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull DataContext dataContext, @NotNull BiConsumer<ExternalSystemNotificationExtension, NotificationData> customise) {
        if (title == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(9);
        }
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(10);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(11);
        }
        if (project == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(13);
        }
        if (customise == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(14);
        }
        if (ExternalSystemNotificationManager.isInternalError(error, externalSystemId)) {
            return null;
        }
        String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String filePath = null;
        Integer line = null;
        Integer column2 = null;
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof LocationAwareExternalSystemException) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = (LocationAwareExternalSystemException)unwrapped;
            filePath = locationAwareExternalSystemException.getFilePath();
            line = locationAwareExternalSystemException.getLine();
            column2 = locationAwareExternalSystemException.getColumn();
        }
        NotificationData notificationData = new NotificationData(title, message, notificationCategory, NotificationSource.PROJECT_SYNC, filePath, (Integer)ObjectUtils.notNull((Object)line, (Object)-1), (Integer)ObjectUtils.notNull((Object)column2, (Object)-1), false);
        if (unwrapped instanceof BuildIssueException) {
            BuildIssue buildIssue = ((BuildIssueException)((Object)unwrapped)).getBuildIssue();
            for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
                notificationData.setListener(quickFix.getId(), (notification, event) -> quickFix.runQuickFix(project, dataContext));
            }
            notificationData.setNavigatable(buildIssue.getNavigatable(project));
            return notificationData;
        }
        for (ExternalSystemNotificationExtension extension : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId targetExternalSystemId = extension.getTargetExternalSystemId();
            if (!externalSystemId.equals((Object)targetExternalSystemId) && !targetExternalSystemId.equals((Object)ProjectSystemId.IDE)) continue;
            customise.accept(extension, notificationData);
        }
        return notificationData;
    }

    private static boolean isInternalError(@NotNull Throwable error, @NotNull ProjectSystemId externalSystemId) {
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(15);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(16);
        }
        if (RemoteUtil.unwrap((Throwable)error) instanceof BuildIssueException) {
            return false;
        }
        return ExternalSystemNotificationExtension.EP_NAME.getExtensionList().stream().anyMatch(extension -> externalSystemId.equals((Object)extension.getTargetExternalSystemId()) && extension.isInternalError(error));
    }

    public boolean isNotificationActive(@NotNull Key<String> notificationKey) {
        Notification notification;
        if (notificationKey == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(17);
        }
        return (notification = this.myUniqueNotifications.get(notificationKey)) != null && !notification.isExpired();
    }

    public void showNotification(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(18);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(19);
        }
        this.showNotification(externalSystemId, notificationData, null);
    }

    public void showNotification(final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationData notificationData, final @Nullable Key<String> notificationKey) {
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(20);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(21);
        }
        Disposer.register((Disposable)this, (Disposable)notificationData);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (notificationData.getNotificationCategory() == NotificationCategory.INFO) {
                LOG.debug(notificationData.getMessage());
            } else {
                LOG.warn(notificationData.getMessage());
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PrintStream out = notificationData.getNotificationCategory() == NotificationCategory.INFO ? System.out : System.err;
            out.println(notificationData.getMessage());
            return;
        }
        if (notificationKey != null && this.isNotificationActive(notificationKey)) {
            return;
        }
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Application app = ApplicationManager.getApplication();
                Runnable action2 = () -> {
                    ExternalProjectsView externalProjectsView;
                    if (!ExternalSystemNotificationManager.this.initializedExternalSystem.contains(externalSystemId)) {
                        app.runWriteAction(() -> {
                            if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowContentInitialized(project, externalSystemId);
                            ExternalSystemNotificationManager.this.initializedExternalSystem.add(externalSystemId);
                        });
                    }
                    if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                        return;
                    }
                    NotificationGroup group = notificationData.getBalloonGroup() == null ? ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(externalSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null) : notificationData.getBalloonGroup();
                    if (group == null) {
                        return;
                    }
                    Notification notification = group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType()).setListener(notificationData.getListener());
                    if (notificationKey == null) {
                        ExternalSystemNotificationManager.this.myNotifications.add(notification);
                    } else {
                        Notification oldNotification = ExternalSystemNotificationManager.this.myUniqueNotifications.put(notificationKey, notification);
                        if (oldNotification != null) {
                            oldNotification.expire();
                        }
                    }
                    if (notificationData.isBalloonNotification()) {
                        ExternalSystemNotificationManager.this.applyNotification(notification);
                    } else {
                        ExternalSystemNotificationManager.this.addMessage(notification, externalSystemId, notificationData);
                    }
                };
                app.invokeLater(action2, ModalityState.defaultModalityState(), project.getDisposed());
            }
        });
    }

    @Deprecated
    public void clearNotifications(final @Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(22);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(23);
        }
        this.myMessageCounter.remove(groupName, notificationSource, externalSystemId);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project = ExternalSystemNotificationManager.this.myProject;
                Iterator<Notification> iterator = ExternalSystemNotificationManager.this.myNotifications.iterator();
                while (iterator.hasNext()) {
                    Notification notification = iterator.next();
                    if (groupName != null && !groupName.equals(notification.getGroupId())) continue;
                    notification.expire();
                    iterator.remove();
                }
                SmartList toRemove = new SmartList();
                ExternalSystemNotificationManager.this.myUniqueNotifications.forEach((arg_0, arg_1) -> 2.lambda$run$0(groupName, (List)toRemove, arg_0, arg_1));
                toRemove.forEach(ExternalSystemNotificationManager.this.myUniqueNotifications::remove);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
                if (toolWindow == null) {
                    return;
                }
                MessageView messageView = MessageView.getInstance((Project)project);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    for (Content content : messageView.getContentManager().getContents()) {
                        if (content.isPinned() || !contentIdPair.equals(content.getUserData(CONTENT_ID_KEY))) continue;
                        if (groupName == null) {
                            messageView.getContentManager().removeContent(content, true);
                            continue;
                        }
                        assert (content.getComponent() instanceof NewEditableErrorTreeViewPanel);
                        NewEditableErrorTreeViewPanel errorTreeView = (NewEditableErrorTreeViewPanel)content.getComponent();
                        ErrorViewStructure errorViewStructure = errorTreeView.getErrorViewStructure();
                        errorViewStructure.removeGroup(groupName);
                    }
                });
            }

            private static /* synthetic */ void lambda$run$0(String groupName2, List toRemove, Key key, Notification notification) {
                if (groupName2 == null || groupName2.equals(notification.getGroupId())) {
                    notification.expire();
                    toRemove.add(key);
                }
            }
        });
    }

    private void addMessage(@NotNull Notification notification, @NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        int guiColumn;
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(24);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(25);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(26);
        }
        VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        String groupName = virtualFile != null ? virtualFile.getPresentableUrl() : notificationData.getTitle();
        this.myMessageCounter.increment(groupName, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), externalSystemId);
        int line = notificationData.getLine() - 1;
        int column2 = notificationData.getColumn() - 1;
        if (virtualFile == null) {
            column2 = -1;
            line = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int n = guiColumn = column2 < 0 ? 0 : column2 + 1;
        if (this.isDisposedOrNotOpen()) {
            return;
        }
        assert (this.myProject != null);
        Project project = this.myProject;
        Navigatable navigatable = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile != null ? new OpenFileDescriptor(project, virtualFile, line, column2) : NonNavigatable.INSTANCE);
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        String[] message = notificationData.getMessage().split("\n");
        String exportPrefix = NewErrorTreeViewPanel.createExportPrefix((int)guiLine);
        String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix((int)guiLine, (int)guiColumn);
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean activate = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
            NewErrorTreeViewPanel errorTreeView = this.prepareMessagesView(externalSystemId, notificationData.getNotificationSource(), activate);
            GroupingElement groupingElement = errorTreeView.getErrorViewStructure().getGroupingElement(groupName, null, virtualFile);
            NotificationMessageElement navigatableMessageElement = notificationData.hasLinks() && !ScreenReader.isActive() ? new EditableNotificationMessageElement(notification, kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix) : new NotificationMessageElement(kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix);
            errorTreeView.getErrorViewStructure().addNavigatableMessage(groupName, (NavigatableMessageElement)navigatableMessageElement);
            errorTreeView.updateTree();
        });
    }

    private void applyNotification(@NotNull Notification notification) {
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(27);
        }
        if (!this.isDisposedOrNotOpen()) {
            notification.notify(this.myProject);
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationSource notificationSource, boolean activateView) {
        NewEditableErrorTreeViewPanel errorTreeView;
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(28);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String contentDisplayName = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, externalSystemId);
        Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        Content targetContent = this.findContent((Pair<NotificationSource, ProjectSystemId>)contentIdPair, contentDisplayName);
        assert (this.myProject != null);
        MessageView messageView = MessageView.getInstance((Project)this.myProject);
        if (targetContent == null || !contentIdPair.equals(targetContent.getUserData(CONTENT_ID_KEY))) {
            errorTreeView = new NewEditableErrorTreeViewPanel(this.myProject, null, true, true, null);
            targetContent = ContentFactory.getInstance().createContent((JComponent)errorTreeView, contentDisplayName, true);
            targetContent.putUserData(CONTENT_ID_KEY, (Object)contentIdPair);
            messageView.getContentManager().addContent(targetContent);
            Disposer.register((Disposable)targetContent, (Disposable)errorTreeView);
        } else {
            assert (targetContent.getComponent() instanceof NewEditableErrorTreeViewPanel);
            errorTreeView = (NewEditableErrorTreeViewPanel)targetContent.getComponent();
        }
        messageView.getContentManager().setSelectedContent(targetContent);
        ToolWindow tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Messages");
        if (activateView && tw != null && !tw.isActive()) {
            tw.activate(null, false);
        }
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel = errorTreeView;
        if (newEditableErrorTreeViewPanel == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(30);
        }
        return newEditableErrorTreeViewPanel;
    }

    @Nullable
    private Content findContent(@NotNull Pair<NotificationSource, ProjectSystemId> contentIdPair, @NotNull String contentDisplayName) {
        if (contentIdPair == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(31);
        }
        if (contentDisplayName == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(32);
        }
        Content targetContent = null;
        assert (this.myProject != null);
        MessageView messageView = MessageView.getInstance((Project)this.myProject);
        for (Content content : messageView.getContentManager().getContents()) {
            if (!contentIdPair.equals(content.getUserData(CONTENT_ID_KEY)) || !StringUtil.equals((CharSequence)content.getDisplayName(), (CharSequence)contentDisplayName) || content.isPinned()) continue;
            targetContent = content;
        }
        return targetContent;
    }

    @NotNull
    @Nls
    private static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(33);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(34);
        }
        String string = ExternalSystemBundle.message((String)(switch (notificationSource) {
            default -> throw new MatchException(null, null);
            case NotificationSource.PROJECT_SYNC -> "notification.messages.project.sync.tab.name";
            case NotificationSource.TASK_EXECUTION -> "notification.messages.task.execution.tab.name";
        }), (Object[])new Object[]{externalSystemId.getReadableName()});
        if (string == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(35);
        }
        return string;
    }

    public void dispose() {
        this.myProject = null;
        this.myNotifications.clear();
        this.myUniqueNotifications.clear();
        this.initializedExternalSystem.clear();
    }

    private boolean isDisposedOrNotOpen() {
        return this.myProject == null || this.myProject.isDisposed() || !this.myProject.isOpen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 30, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customise";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationKey";
                break;
            }
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 22: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentIdPair";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessagesView";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 30: 
            case 35: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNotification";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInternalError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationActive";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearNotifications";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyNotification";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessagesView";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 30, 35 -> new IllegalStateException(string);
        };
    }
}

