/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\u0006\u0010\u0014\u001a\u00020\fJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/evaluate/XExpressionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "historyId", "", "title", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "expression", "Lcom/intellij/xdebugger/XExpression;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/xdebugger/XSourcePosition;Lcom/intellij/xdebugger/XExpression;)V", "myInputComponent", "Lcom/intellij/xdebugger/impl/evaluate/EvaluationInputComponent;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getExpression", "getDimensionServiceKey", "intellij.platform.debugger.impl"})
public class XExpressionDialog
extends DialogWrapper {
    @NotNull
    private final EvaluationInputComponent myInputComponent;

    public XExpressionDialog(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull String historyId, @NlsContexts.DialogTitle @NotNull String title, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorsProvider, (String)"editorsProvider");
        Intrinsics.checkNotNullParameter((Object)historyId, (String)"historyId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(project);
        this.myInputComponent = new ExpressionInputComponent(project, editorsProvider, historyId, sourcePosition, expression, this.myDisposable, false);
        this.setTitle(title);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myInputComponent.getMainComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myInputComponent.getInputEditor().getPreferredFocusedComponent();
    }

    @NotNull
    public final XExpression getExpression() {
        XDebuggerEditorBase xDebuggerEditorBase = this.myInputComponent.getInputEditor();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerEditorBase, (String)"getInputEditor(...)");
        XDebuggerEditorBase editor = xDebuggerEditorBase;
        editor.saveTextInHistory();
        XExpression xExpression = editor.getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)xExpression, (String)"getExpression(...)");
        return xExpression;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "#debugger.expression.dialog";
    }
}

