/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.rpc.models;

import com.intellij.xdebugger.impl.rpc.models.EntityTransformer;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\n\u001a\u00028\u00012\u0006\u0010\u000b\u001a\u00028\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/rpc/models/ScopeBoundStorage;", "Entity", "", "EntityModel", "transformer", "Lcom/intellij/xdebugger/impl/rpc/models/EntityTransformer;", "<init>", "(Lcom/intellij/xdebugger/impl/rpc/models/EntityTransformer;)V", "groupToModelMap", "Ljava/util/concurrent/ConcurrentHashMap;", "getOrStore", "value", "createModel", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clear", "", "intellij.platform.debugger.impl"})
final class ScopeBoundStorage<Entity, EntityModel> {
    @NotNull
    private final EntityTransformer<Entity> transformer;
    @NotNull
    private final ConcurrentHashMap<Object, EntityModel> groupToModelMap;

    public ScopeBoundStorage(@NotNull EntityTransformer<Entity> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        this.transformer = transformer;
        this.groupToModelMap = new ConcurrentHashMap();
    }

    @NotNull
    public final EntityModel getOrStore(@NotNull Entity value, @NotNull Function0<? extends EntityModel> createModel) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(createModel, (String)"createModel");
        Object object = this.groupToModelMap.computeIfAbsent(this.transformer.transform(value), arg_0 -> ScopeBoundStorage.getOrStore$lambda$1(arg_0 -> ScopeBoundStorage.getOrStore$lambda$0(createModel, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (EntityModel)object;
    }

    public final void clear() {
        this.groupToModelMap.clear();
    }

    private static final Object getOrStore$lambda$0(Function0 $createModel, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $createModel.invoke();
    }

    private static final Object getOrStore$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }
}

