/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextViewer
extends EditorTextField {
    private static final String CONTEXT_MENU_GROUP_ID = "TextViewerEditorPopupMenu";
    private final boolean myEmbeddedIntoDialogWrapper;

    public TextViewer(@NotNull String initialText, @NotNull Project project) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(1);
        }
        this(initialText, project, true);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(2);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(3);
        }
        this(initialText, project, (FileType)FileTypes.PLAIN_TEXT, viewer);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project, FileType fileType) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(5);
        }
        this(initialText, project, fileType, true);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project, FileType fileType, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(6);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(7);
        }
        this(TextViewer.createDocument(initialText, viewer), project, true, fileType, viewer);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean viewer) {
        if (document == null) {
            TextViewer.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(9);
        }
        this(document, project, embeddedIntoDialogWrapper, (FileType)FileTypes.PLAIN_TEXT, viewer);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, FileType fileType, boolean viewer) {
        if (document == null) {
            TextViewer.$$$reportNull$$$0(10);
        }
        if (project == null) {
            TextViewer.$$$reportNull$$$0(11);
        }
        super(document, project, fileType, viewer, false);
        this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
        this.setFontInheritedFromLAF(false);
        this.setCaretPosition(0);
    }

    private static Document createDocument(@NotNull String initialText, boolean viewer) {
        if (initialText == null) {
            TextViewer.$$$reportNull$$$0(12);
        }
        if (TextViewer.needSlashRSupport(initialText, viewer)) {
            return EditorFactory.getInstance().createDocument((CharSequence)initialText, true, false);
        }
        return EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)initialText));
    }

    public void setText(@Nullable String text) {
        if (text != null) {
            if (TextViewer.needSlashRSupport(text, this.isViewer())) {
                Editor editor;
                if (!((DocumentImpl)this.getDocument()).setAcceptSlashR(true) && (editor = this.getEditor()) instanceof EditorEx) {
                    ((EditorEx)editor).reinitSettings();
                }
            } else {
                text = StringUtil.convertLineSeparators((String)text);
            }
        }
        super.setText(text);
    }

    private static boolean needSlashRSupport(String text, boolean viewer) {
        return !viewer && text.contains("\r");
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHorizontalScrollbarVisible(true);
        editor.setCaretEnabled(true);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
        editor.getComponent().setPreferredSize(null);
        editor.getSettings().setUseSoftWraps(true);
        editor.setContextMenuGroupId(CONTEXT_MENU_GROUP_ID);
        editor.setColorsScheme(editor.createBoundColorSchemeDelegate(DebuggerUIUtil.getColorScheme()));
        EditorEx editorEx = editor;
        if (editorEx == null) {
            TextViewer.$$$reportNull$$$0(13);
        }
        return editorEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/TextViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/TextViewer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

