/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.SshApiBundle;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConnectionConfigPatchConverter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.gateway.ssh.deploy.c;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(value="sshConfig")
public class SshConfig
implements Cloneable {
    public static final int DEFAULT_PORT = 22;
    @NonNls
    public static final String DEFAULT_KEY_PATH;
    private static final int DEFAULT_INVALID_PORT = -1;
    @NotNull
    private String myId;
    private boolean isProjectLevel;
    @NotNull
    private String myHost;
    @NotNull
    private String myLiteralPort;
    private int myPort;
    @Deprecated
    @NotNull
    private String myLiteralLocalPort;
    @Deprecated
    private int myLocalPort;
    @NotNull
    private String myUsername;
    @NotNull
    private AuthType myAuthType;
    @NotNull
    private String myKeyPath;
    @NotNull
    private NameFormat myNameFormat;
    @Nullable
    @NlsSafe
    private String myCustomName;
    @Nullable
    private SshConnectionConfigPatch myConnectionConfigPatch;
    @Attribute(value="useOpenSSHConfig")
    @NotNull
    private String mySerializedUseOpenSSHConfig;
    private static String[] a;
    private static final long b;
    private static final String[] c;
    private static final String[] d;
    private static final Map e;

    @Attribute(value="id")
    @NotNull
    @NonNls
    public String getId() {
        String string;
        long l = b ^ 0x3B0985B3A914L;
        try {
            string = this.myId;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setId(@NotNull String id) {
        long l = b ^ 0x508ED2E7B037L;
        try {
            if (id == null) {
                SshConfig.$$$reportNull$$$0(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        this.myId = id;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setProjectLevel(boolean projectLevel) {
        this.isProjectLevel = projectLevel;
    }

    @Attribute(value="host")
    @NotNull
    @NlsSafe
    public String getHost() {
        String string;
        long l = b ^ 0xE5848C46824L;
        try {
            string = this.myHost;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setHost(@Nullable String host2) {
        this.myHost = StringUtil.notNullize((String)host2);
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = Math.max(port, -1);
        this.myLiteralPort = String.valueOf(this.myPort);
    }

    @Attribute(value="port")
    @NotNull
    @NlsSafe
    public String getLiteralPort() {
        String string;
        long l = b ^ 0x3F5361EEB7D3L;
        try {
            string = this.myLiteralPort;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setLiteralPort(@Nullable String literalPort) {
        this.myLiteralPort = StringUtil.notNullize((String)literalPort);
        this.myPort = SshConfig.parseSshPort(literalPort);
    }

    @Deprecated
    @Attribute(value="localPort")
    @NotNull
    public String getLiteralLocalPort() {
        String string;
        long l = b ^ 0x3759B6E99F07L;
        try {
            string = this.myLiteralLocalPort;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(4);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Deprecated
    public void setLiteralLocalPort(@Nullable String literalLocalPort) {
        this.myLiteralLocalPort = StringUtil.notNullize((String)literalLocalPort);
        this.myLocalPort = SshConfig.parseSshPort(literalLocalPort);
    }

    @Deprecated
    @Transient
    public int getLocalPort() {
        return this.myLocalPort;
    }

    @Deprecated
    public void setLocalPort(int localPort) {
        this.myLocalPort = Math.max(localPort, -1);
        this.myLiteralLocalPort = String.valueOf(this.myLocalPort);
    }

    @Attribute(value="username")
    @NlsSafe
    @NotNull
    public String getUsername() {
        String string;
        long l = b ^ 0x1B682F123B34L;
        try {
            string = this.myUsername;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(5);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.myUsername = StringUtil.notNullize((String)username);
    }

    @Attribute(value="authType")
    @NotNull
    public AuthType getAuthType() {
        AuthType authType;
        long l = b ^ 0x2DB34B9C6EA2L;
        try {
            authType = this.myAuthType;
            if (authType == null) {
                SshConfig.$$$reportNull$$$0(6);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        long l = b ^ 0x2C8D374FD6B8L;
        try {
            if (authType == null) {
                SshConfig.$$$reportNull$$$0(7);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        this.myAuthType = authType;
    }

    @Attribute(value="keyPath")
    @NotNull
    public String getKeyPath() {
        String string;
        long l = b ^ 0x1E5C61E27584L;
        try {
            string = this.myKeyPath;
            if (string == null) {
                SshConfig.$$$reportNull$$$0(8);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.myKeyPath = StringUtil.notNullize((String)keyPath);
    }

    @Transient
    public boolean isOpenSshConfigUsageForced() {
        boolean bl;
        block6: {
            block7: {
                boolean bl2;
                block8: {
                    block9: {
                        long l = b ^ 0x2D92FC5D9353L;
                        String[] stringArray = SshConfig.h();
                        try {
                            try {
                                try {
                                    bl = StringUtil.isEmpty((String)this.mySerializedUseOpenSSHConfig);
                                    if (stringArray != null) break block6;
                                    if (!bl) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                bl2 = PlatformUtils.isDataGrip();
                                if (stringArray != null) break block8;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            if (bl2) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
                return bl2;
            }
            bl = Boolean.parseBoolean(this.mySerializedUseOpenSSHConfig);
        }
        return bl;
    }

    @Transient
    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.mySerializedUseOpenSSHConfig = String.valueOf(useOpenSSHConfig);
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConnectionConfigPatch;
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConnectionConfigPatch = patch;
    }

    public void mergeKeyPath(@Nullable String keyPath) {
        boolean bl;
        block3: {
            block4: {
                long l = b ^ 0x6BE11B0B84CAL;
                String[] stringArray = SshConfig.h();
                try {
                    bl = StringUtil.isEmpty((String)this.myKeyPath);
                    if (stringArray != null) break block3;
                    if (bl) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                return;
            }
            bl = StringUtil.isEmpty((String)keyPath);
        }
        if (bl) {
            return;
        }
        this.myKeyPath = keyPath;
    }

    @Transient
    @NotNull
    public String getName() {
        String string;
        long l = b ^ 0x7E0733C4EB74L;
        try {
            string = this.myNameFormat.getName(this);
            if (string == null) {
                SshConfig.$$$reportNull$$$0(9);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Deprecated
    @Attribute(value="nameFormat")
    @NotNull
    public NameFormat getSerializedNameFormat() {
        NameFormat nameFormat;
        long l = b ^ 0x2EB41498EC15L;
        try {
            nameFormat = this.myNameFormat;
            if (nameFormat == null) {
                SshConfig.$$$reportNull$$$0(10);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return nameFormat;
    }

    @Deprecated
    public void setSerializedNameFormat(@Nullable NameFormat nameFormat) {
        NameFormat nameFormat2;
        block2: {
            block3: {
                long l = b ^ 0x3BF7FCC228E9L;
                String[] stringArray = SshConfig.h();
                try {
                    SshConfig sshConfig = this;
                    nameFormat2 = nameFormat;
                    if (stringArray != null) break block2;
                    if (nameFormat2 != null) break block3;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                nameFormat2 = NameFormat.INITIAL;
                break block2;
            }
            nameFormat2 = nameFormat;
        }
        sshConfig.myNameFormat = nameFormat2;
    }

    @Deprecated
    @Attribute(value="customName")
    @Nullable
    public String getSerializedCustomName() {
        return this.myCustomName;
    }

    @Deprecated
    public void setSerializedCustomName(@Nullable String customName) {
        this.myCustomName = StringUtil.nullize((String)customName, (boolean)true);
    }

    public void setCustomName(@Nullable String customName) {
        block8: {
            block9: {
                block11: {
                    block10: {
                        long l = b ^ 0x4EB17C8C10E2L;
                        customName = StringUtil.nullize((String)customName, (boolean)true);
                        String[] stringArray = SshConfig.h();
                        try {
                            SshConfig sshConfig;
                            try {
                                try {
                                    try {
                                        if (stringArray != null) break block8;
                                        if (customName != null) break block9;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw SshConfig.a(illegalStateException);
                                    }
                                    this.myCustomName = null;
                                    sshConfig = this;
                                    if (stringArray != null) break block10;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                if (sshConfig.myNameFormat != NameFormat.CUSTOM) break block11;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig = this;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    sshConfig.myNameFormat = NameFormat.DESCRIPTIVE;
                }
                return;
            }
            this.setNonemptyCustomName(customName);
        }
    }

    public void mergeCustomName(@Nullable String customName) {
        block11: {
            String string;
            block9: {
                String[] stringArray;
                block10: {
                    long l = b ^ 0x2F8534C8518AL;
                    stringArray = SshConfig.h();
                    try {
                        try {
                            try {
                                string = this.myCustomName;
                                if (stringArray != null) break block9;
                                if (string == null) break block10;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            if (this.myNameFormat != NameFormat.CUSTOM) break block10;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                customName = StringUtil.nullize((String)customName, (boolean)true);
                try {
                    if (stringArray != null) break block11;
                    string = customName;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            if (string == null) {
                return;
            }
            this.setNonemptyCustomName(customName);
        }
    }

    private void setNonemptyCustomName(@NotNull String customName) {
        block11: {
            String string;
            String[] stringArray;
            block8: {
                block9: {
                    long l = b ^ 0x49B0C2F5F957L;
                    stringArray = SshConfig.h();
                    try {
                        try {
                            string = customName;
                            if (stringArray != null) break block8;
                            if (string != null) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        SshConfig.$$$reportNull$$$0(11);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                string = customName;
            }
            try {
                block10: {
                    try {
                        if (!string.equals(NameFormat.DESCRIPTIVE.getName(this))) break block10;
                        this.myCustomName = null;
                        this.myNameFormat = NameFormat.DESCRIPTIVE;
                        if (stringArray == null) break block11;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                this.myCustomName = customName;
                this.myNameFormat = NameFormat.CUSTOM;
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    @Nullable
    public String getCustomName() {
        String string;
        block6: {
            block5: {
                SshConfig sshConfig;
                block4: {
                    long l = b ^ 0x5DCDCC613312L;
                    String[] stringArray = SshConfig.h();
                    try {
                        try {
                            sshConfig = this;
                            if (stringArray != null) break block4;
                            if (sshConfig.myNameFormat != NameFormat.CUSTOM) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConfig = this;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                string = sshConfig.myCustomName;
                break block6;
            }
            string = null;
        }
        return string;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String string;
        long l = b ^ 0x7736606A29C9L;
        try {
            string = this.myNameFormat.getPresentableShortName(this);
            if (string == null) {
                SshConfig.$$$reportNull$$$0(12);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @Nls
    @Nullable
    public String getPresentableAddition() {
        return this.myNameFormat.getPresentableAddition(this);
    }

    @Nls
    @NotNull
    public String getPresentableFullName() {
        String string;
        long l = b ^ 0x26394C9C172DL;
        try {
            string = this.getPresentableShortName();
            if (string == null) {
                SshConfig.$$$reportNull$$$0(13);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    @NotNull
    public AuthData getAuthDataFromForPasswordSafe() {
        AuthData authData;
        long l = b ^ 0x5D99DC0F1456L;
        AuthData authData2 = new AuthData();
        String[] stringArray = SshConfig.h();
        switch (this.myAuthType) {
            case PASSWORD: {
                Pair<Credentials, Boolean> pair = this.getPasswordCredentialsFromPasswordSafe();
                authData2.setPasswordAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                if (stringArray == null) break;
            }
            case KEY_PAIR: {
                Pair<Credentials, Boolean> pair = this.getPassphraseCredentialsFromPasswordSafe();
                authData2.setKeyAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                break;
            }
        }
        try {
            authData = authData2;
            if (authData == null) {
                SshConfig.$$$reportNull$$$0(14);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return authData;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Credentials getCredentials() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        boolean bl;
        String[] stringArray;
        block68: {
            SshConfig sshConfig;
            block67: {
                SshConfig sshConfig2;
                block66: {
                    block65: {
                        block64: {
                            block63: {
                                boolean bl2;
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                block58: {
                                                    Object object;
                                                    block56: {
                                                        block57: {
                                                            Object object2;
                                                            block54: {
                                                                block55: {
                                                                    long l = b ^ 0x4807F178045FL;
                                                                    stringArray = SshConfig.h();
                                                                    try {
                                                                        try {
                                                                            object2 = this;
                                                                            if (stringArray != null) break block54;
                                                                            if (object2 != o) break block55;
                                                                            return true;
                                                                        }
                                                                        catch (IllegalStateException illegalStateException) {
                                                                            throw SshConfig.a(illegalStateException);
                                                                        }
                                                                    }
                                                                    catch (IllegalStateException illegalStateException) {
                                                                        throw SshConfig.a(illegalStateException);
                                                                    }
                                                                }
                                                                object2 = o;
                                                            }
                                                            try {
                                                                try {
                                                                    try {
                                                                        if (object2 == null) return false;
                                                                        object = this.getClass();
                                                                        if (stringArray != null) break block56;
                                                                    }
                                                                    catch (IllegalStateException illegalStateException) {
                                                                        throw SshConfig.a(illegalStateException);
                                                                    }
                                                                    if (object == o.getClass()) break block57;
                                                                    return false;
                                                                }
                                                                catch (IllegalStateException illegalStateException) {
                                                                    throw SshConfig.a(illegalStateException);
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw SshConfig.a(illegalStateException);
                                                            }
                                                        }
                                                        object = o;
                                                    }
                                                    sshConfig = (SshConfig)object;
                                                    try {
                                                        try {
                                                            bl2 = this.isProjectLevel;
                                                            if (stringArray != null) break block58;
                                                            if (bl2 != sshConfig.isProjectLevel) return false;
                                                        }
                                                        catch (IllegalStateException illegalStateException) {
                                                            throw SshConfig.a(illegalStateException);
                                                        }
                                                        bl2 = this.myId.equals(sshConfig.myId);
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw SshConfig.a(illegalStateException);
                                                    }
                                                }
                                                try {
                                                    try {
                                                        if (stringArray != null) break block59;
                                                        if (!bl2) return false;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw SshConfig.a(illegalStateException);
                                                    }
                                                    bl2 = this.myHost.equals(sshConfig.myHost);
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw SshConfig.a(illegalStateException);
                                                }
                                            }
                                            try {
                                                try {
                                                    if (stringArray != null) break block60;
                                                    if (!bl2) return false;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw SshConfig.a(illegalStateException);
                                                }
                                                bl2 = this.myLiteralPort.equals(sshConfig.myLiteralPort);
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                        }
                                        try {
                                            try {
                                                if (stringArray != null) break block61;
                                                if (!bl2) return false;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                            bl2 = this.myLiteralLocalPort.equals(sshConfig.myLiteralLocalPort);
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw SshConfig.a(illegalStateException);
                                        }
                                    }
                                    try {
                                        try {
                                            try {
                                                if (stringArray != null) break block62;
                                                if (!bl2) return false;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw SshConfig.a(illegalStateException);
                                            }
                                            sshConfig2 = this;
                                            if (stringArray != null) break block63;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw SshConfig.a(illegalStateException);
                                        }
                                        bl2 = sshConfig2.myUsername.equals(sshConfig.myUsername);
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw SshConfig.a(illegalStateException);
                                    }
                                }
                                if (!bl2) return false;
                                sshConfig2 = this;
                            }
                            try {
                                try {
                                    if (stringArray != null) break block64;
                                    if (sshConfig2.myAuthType != sshConfig.myAuthType) return false;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw SshConfig.a(illegalStateException);
                                }
                                sshConfig2 = this;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                        }
                        try {
                            try {
                                if (stringArray != null) break block65;
                                if (!sshConfig2.myKeyPath.equals(sshConfig.myKeyPath)) return false;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig2 = this;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    try {
                        try {
                            if (stringArray != null) break block66;
                            if (sshConfig2.myNameFormat != sshConfig.myNameFormat) return false;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConfig2 = this;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                try {
                    try {
                        bl = sshConfig2.mySerializedUseOpenSSHConfig.equals(sshConfig.mySerializedUseOpenSSHConfig);
                        if (stringArray != null) break block67;
                        if (!bl) return false;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    bl = Objects.equals(this.myCustomName, sshConfig.myCustomName);
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            try {
                try {
                    if (stringArray != null) break block68;
                    if (!bl) return false;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                bl = Objects.equals(this.myConnectionConfigPatch, sshConfig.myConnectionConfigPatch);
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
        try {
            if (stringArray != null) return bl;
            if (!bl) return false;
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
    }

    public int hashCode() {
        long l = b ^ 0x18C935FC8A8EL;
        String[] stringArray = SshConfig.h();
        int n = Objects.hash(new Object[]{this.getId(), this.isProjectLevel(), this.getHost(), this.getLiteralPort(), this.getLiteralLocalPort(), this.getAuthType(), this.getKeyPath(), this.getUsername(), this.myNameFormat, this.myCustomName, this.isOpenSshConfigUsageForced(), this.getConnectionConfigPatch()});
        if (stringArray != null) {
            int n2 = ShellArgument.g();
            ShellArgument.h(++n2);
        }
        return n;
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentials remoteCredentials;
        long l = b ^ 0xAEDF0821FFBL;
        try {
            remoteCredentials = this.copyToCredentials(this.getAuthDataFromForPasswordSafe());
            if (remoteCredentials == null) {
                SshConfig.$$$reportNull$$$0(15);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return remoteCredentials;
    }

    @NotNull
    public RemoteCredentials copyToCredentials(@NotNull AuthData data) {
        RemoteCredentialsHolder remoteCredentialsHolder;
        block11: {
            int n;
            block10: {
                long l = b ^ 0x50B39119BAF9L;
                String[] stringArray = SshConfig.h();
                try {
                    if (data == null) {
                        SshConfig.$$$reportNull$$$0(16);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                RemoteCredentialsHolder remoteCredentialsHolder2 = new RemoteCredentialsHolder();
                try {
                    try {
                        remoteCredentialsHolder2.setHost(this.getHost());
                        remoteCredentialsHolder2.setLiteralPort(this.getLiteralPort());
                        remoteCredentialsHolder2.setAuthType(this.getAuthType());
                        remoteCredentialsHolder2.setUserName(this.getUsername());
                        remoteCredentialsHolder2.setPassword(data.getPassword());
                        remoteCredentialsHolder2.setPassphrase(data.getPassphrase());
                        remoteCredentialsHolder2.setStorePassword(data.isSavePassword());
                        remoteCredentialsHolder2.setStorePassphrase(data.isSavePassphrase());
                        remoteCredentialsHolder2.setPrivateKeyFile(this.getKeyPath());
                        remoteCredentialsHolder = remoteCredentialsHolder2;
                        n = this.isOpenSshConfigUsageForced();
                        if (stringArray != null) break block10;
                        remoteCredentialsHolder.setOpenSshConfigUsageForced(n != 0);
                        remoteCredentialsHolder2.setConnectionConfigPatch(this.getConnectionConfigPatch());
                        remoteCredentialsHolder = remoteCredentialsHolder2;
                        if (remoteCredentialsHolder != null) break block11;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    n = 17;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            SshConfig.$$$reportNull$$$0(n);
        }
        try {
            if (ShellArgument.h() == 0) {
                SshConfig.h(new String[3]);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return remoteCredentialsHolder;
    }

    @NotNull
    public static SshConfig create(boolean projectLevel, String host2, int port, String username, AuthType authType, @Nullable String keyPath) {
        SshConfig sshConfig;
        block5: {
            int n;
            block4: {
                long l = b ^ 0x53E214FBEFAFL;
                String[] stringArray = SshConfig.h();
                SshConfig sshConfig2 = new SshConfig(true);
                sshConfig2.setProjectLevel(projectLevel);
                sshConfig2.setHost(host2);
                String[] stringArray2 = stringArray;
                try {
                    try {
                        sshConfig = sshConfig2;
                        n = port;
                        if (stringArray2 != null) break block4;
                        sshConfig.setPort(n);
                        sshConfig2.setUsername(username);
                        sshConfig2.setAuthType(authType);
                        sshConfig2.setKeyPath(keyPath);
                        sshConfig = sshConfig2;
                        if (sshConfig != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    n = 18;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            SshConfig.$$$reportNull$$$0(n);
        }
        return sshConfig;
    }

    @Deprecated
    public SshConfig() {
        this(false);
    }

    public SshConfig(boolean latestFormat) {
        long l = b ^ 0x7F37410B7E77L;
        this.myHost = "";
        this.myLiteralPort = "";
        this.myPort = -1;
        this.myLiteralLocalPort = "";
        this.myLocalPort = -1;
        this.myUsername = "";
        this.myAuthType = AuthType.KEY_PAIR;
        this.myKeyPath = "";
        this.mySerializedUseOpenSSHConfig = "";
        this.myId = UUID.randomUUID().toString();
        this.myNameFormat = latestFormat ? NameFormat.DESCRIPTIVE : NameFormat.INITIAL;
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPasswordCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.PASSWORD);
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPassphraseCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.KEY_PAIR);
    }

    public void eraseAuthDataFromPasswordSafe() {
        block6: {
            long l = b ^ 0x32239D5B6A2AL;
            AuthType[] authTypeArray = AuthType.values();
            int n = authTypeArray.length;
            String[] stringArray = SshConfig.h();
            for (int i = 0; i < n; ++i) {
                AuthType authType = authTypeArray[i];
                try {
                    try {
                        if (stringArray != null) break block6;
                        if (authType == AuthType.OPEN_SSH) {
                            continue;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                PasswordSafe.getInstance().set(SshConfig.createAttributes(this, false, authType), null, false);
                if (stringArray == null) continue;
            }
            this.eraseConfigPatchAuthDataFromPasswordSafe();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveAuthDataToPasswordSafe(@NotNull AuthData data) {
        var2_2 = SshConfig.b ^ 31534715223564L;
        var4_3 = SshConfig.h();
        try {
            if (data == null) {
                SshConfig.$$$reportNull$$$0(19);
            }
        }
        catch (IllegalStateException v0) {
            throw SshConfig.a(v0);
        }
        var5_4 = null;
        var6_5 = false;
        var7_6 = null;
        var8_7 = false;
        switch (1.$SwitchMap$com$intellij$remote$AuthType[this.getAuthType().ordinal()]) {
            case 1: {
                var9_8 = data.getPassword();
                try {
                    v1 = data.isSavePassword();
                    if (var4_3 != null) ** GOTO lbl27
                    if (!v1) {
                    }
                    ** GOTO lbl26
                }
                catch (IllegalStateException v2) {
                    throw SshConfig.a(v2);
                }
                v1 = true;
                ** GOTO lbl27
lbl26:
                // 1 sources

                v1 = false;
lbl27:
                // 3 sources

                var6_5 = v1;
                try {
                    v3 = var9_8 == null ? null : new Credentials(null, var9_8);
                }
                catch (IllegalStateException v4) {
                    throw SshConfig.a(v4);
                }
                var5_4 = v3;
                break;
            }
            case 2: {
                var9_9 = data.getPassphrase();
                try {
                    v5 = data.isSavePassphrase();
                    if (var4_3 != null) ** GOTO lbl47
                    if (!v5) {
                    }
                    ** GOTO lbl46
                }
                catch (IllegalStateException v6) {
                    throw SshConfig.a(v6);
                }
                v5 = true;
                ** GOTO lbl47
lbl46:
                // 1 sources

                v5 = false;
lbl47:
                // 3 sources

                var8_7 = v5;
                try {
                    v7 = var9_9 == null ? null : new Credentials(null, var9_9);
                }
                catch (IllegalStateException v8) {
                    throw SshConfig.a(v8);
                }
                var7_6 = v7;
                break;
            }
            default: {
                return;
            }
        }
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, var6_5, AuthType.PASSWORD), var5_4, var6_5);
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, var8_7, AuthType.KEY_PAIR), var7_6, var8_7);
        this.saveConfigPatchCredentialsToPasswordSafe(this.myConnectionConfigPatch);
    }

    public void setConnectionConfigPatchAuthData() {
        block12: {
            SshConfig sshConfig;
            block13: {
                SshConnectionConfigPatch sshConnectionConfigPatch;
                block11: {
                    long l = b ^ 0x437201EA1ACAL;
                    String[] stringArray = SshConfig.h();
                    try {
                        try {
                            try {
                                sshConnectionConfigPatch = this.myConnectionConfigPatch;
                                if (stringArray != null) break block11;
                                if (sshConnectionConfigPatch == null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            sshConfig = this;
                            if (stringArray != null) break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                        sshConnectionConfigPatch = sshConfig.myConnectionConfigPatch;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                }
                try {
                    if (sshConnectionConfigPatch.getProxyParams() == null) break block12;
                    sshConfig = this;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            Credentials credentials = sshConfig.getConfigPatchAuthDataCredentialsFromPasswordSafe(this.myConnectionConfigPatch.getProxyParams());
            try {
                if (credentials != null) {
                    this.setConfigPatchAuthData(this.myConnectionConfigPatch.getProxyParams(), credentials);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    private CredentialAttributes createConnectionConfigPatchAttributes(SshConnectionConfigPatch.ProxyParams proxyParams) {
        long l = b ^ 0x5A8C40DC4159L;
        String string = CredentialAttributesKt.generateServiceName((String)((Object)SshConfig.a("w", (int)3791, (long)(0x2DA2F723CA5A7935L ^ l))), (String)(SshConfig.makeNotEmpty(proxyParams.getProxyHost(), (String)((Object)SshConfig.a("w", (int)17152, (long)(0x4195204F188534FBL ^ l)))) + ":" + SshConfig.makeNotEmpty(String.valueOf(proxyParams.getProxyPort()), (String)((Object)SshConfig.a("w", (int)16884, (long)(0x78B888111C86360CL ^ l)))) + " " + this.getId()));
        return new CredentialAttributes(string, null, false);
    }

    private void saveConfigPatchAuthDataToPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        long l = b ^ 0x1D7F2CD08AFBL;
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = proxyParams.getAuthData();
        try {
            if (proxyAuthData != null) {
                PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(proxyParams), new Credentials(proxyAuthData.getUsername(), proxyAuthData.getPassword()));
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
    }

    private void eraseConfigPatchAuthDataFromPasswordSafe() {
        block8: {
            SshConnectionConfigPatch sshConnectionConfigPatch;
            block7: {
                long l = b ^ 0x2E694DAE63B2L;
                String[] stringArray = SshConfig.h();
                try {
                    try {
                        sshConnectionConfigPatch = this.myConnectionConfigPatch;
                        if (stringArray != null) break block7;
                        if (sshConnectionConfigPatch == null) break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    sshConnectionConfigPatch = this.myConnectionConfigPatch;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            try {
                if (sshConnectionConfigPatch.getProxyParams() != null) {
                    PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(this.myConnectionConfigPatch.getProxyParams()), null);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw SshConfig.a(illegalStateException);
            }
        }
    }

    private Credentials getConfigPatchAuthDataCredentialsFromPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        return PasswordSafe.getInstance().get(this.createConnectionConfigPatchAttributes(proxyParams));
    }

    /*
     * Unable to fully structure code
     */
    private void setConfigPatchAuthData(SshConnectionConfigPatch.ProxyParams proxyParams, Credentials proxyCredentials) {
        block9: {
            block7: {
                var3_3 = SshConfig.b ^ 130764046772062L;
                var6_4 = proxyParams.getAuthData();
                var5_5 = SshConfig.h();
                if (var6_4 == null) break block9;
                var7_6 = proxyCredentials.getUserName();
                var8_7 = proxyCredentials.getPasswordAsString();
                try {
                    v0 = var7_6;
                    if (var5_5 != null) break block7;
                    if (v0 != null) {
                    }
                    ** GOTO lbl26
                }
                catch (IllegalStateException v1) {
                    throw SshConfig.a(v1);
                }
                v0 = var8_7;
            }
            try {
                block8: {
                    try {
                        if (v0.isEmpty()) break block8;
                        var6_4.setUsername(var7_6);
                        var6_4.setPassword(var8_7);
                        if (var5_5 == null) break block9;
                    }
                    catch (IllegalStateException v2) {
                        throw SshConfig.a(v2);
                    }
                }
                proxyParams.setAuthData(null);
            }
            catch (IllegalStateException v3) {
                throw SshConfig.a(v3);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveConfigPatchCredentialsToPasswordSafe(SshConnectionConfigPatch patch) {
        block15: {
            block17: {
                block16: {
                    block14: {
                        var2_2 = SshConfig.b ^ 96983571797825L;
                        var4_3 = SshConfig.h();
                        try {
                            v0 = patch;
                            if (var4_3 != null) break block14;
                            if (v0 == null) break block15;
                        }
                        catch (IllegalStateException v1) {
                            throw SshConfig.a(v1);
                        }
                        v0 = patch;
                    }
                    try {
                        try {
                            v2 = v0.getProxyParams();
                            if (var4_3 != null) break block16;
                            if (v2 == null) break block15;
                        }
                        catch (IllegalStateException v3) {
                            throw SshConfig.a(v3);
                        }
                        v2 = patch.getProxyParams();
                    }
                    catch (IllegalStateException v4) {
                        throw SshConfig.a(v4);
                    }
                }
                var5_4 = v2.getAuthData();
                try {
                    try {
                        if (var4_3 != null) break block17;
                        if (var5_4 != null) {
                        }
                        ** GOTO lbl41
                    }
                    catch (IllegalStateException v5) {
                        throw SshConfig.a(v5);
                    }
                    this.saveConfigPatchAuthDataToPasswordSafe(patch.getProxyParams());
                }
                catch (IllegalStateException v6) {
                    throw SshConfig.a(v6);
                }
            }
            try {
                if (var4_3 == null) break block15;
lbl41:
                // 2 sources

                this.eraseConfigPatchAuthDataFromPasswordSafe();
            }
            catch (IllegalStateException v7) {
                throw SshConfig.a(v7);
            }
        }
    }

    @NotNull
    public PresentableId createPresentableId() {
        PresentableId presentableId;
        long l = b ^ 0x2DBB8F78D443L;
        try {
            presentableId = Objects.requireNonNull(PresentableId.createId((String)this.getId(), (String)this.getName()));
            if (presentableId == null) {
                SshConfig.$$$reportNull$$$0(20);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return presentableId;
    }

    public SshConfigVisibility getVisibility() {
        SshConfigVisibility sshConfigVisibility;
        long l = b ^ 0x6F64914B9FE4L;
        try {
            sshConfigVisibility = this.isProjectLevel ? SshConfigVisibility.Project : SshConfigVisibility.App;
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return sshConfigVisibility;
    }

    public SshConfig clone() {
        SshConfig sshConfig;
        try {
            sshConfig = (SshConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        return sshConfig;
    }

    public String toString() {
        long l = b ^ 0x568C94782C86L;
        String string = String.valueOf(this.myConnectionConfigPatch);
        String string2 = this.mySerializedUseOpenSSHConfig;
        String string3 = String.valueOf((Object)this.myNameFormat);
        String string4 = this.myKeyPath;
        String string5 = String.valueOf(this.myAuthType);
        String string6 = this.myUsername;
        int n = this.myLocalPort;
        String string7 = this.myLiteralLocalPort;
        int n2 = this.myPort;
        String string8 = this.myLiteralPort;
        String string9 = this.myHost;
        boolean bl = this.isProjectLevel;
        String string10 = this.myId;
        return (String)((Object)SshConfig.a("w", (int)2612, (long)(0x19DEBA2895741012L ^ l))) + string10 + (String)((Object)SshConfig.a("w", (int)22917, (long)(0x63227C6A0CA3C3A4L ^ l))) + bl + (String)((Object)SshConfig.a("w", (int)14039, (long)(0x55BBE90B8B752CF7L ^ l))) + string9 + (String)((Object)SshConfig.a("w", (int)25719, (long)(0x55FA86DE93D6FE54L ^ l))) + string8 + (String)((Object)SshConfig.a("w", (int)22545, (long)(0x554B0F2740DCC233L ^ l))) + n2 + (String)((Object)SshConfig.a("w", (int)2299, (long)(0x4DE7892EA3A592D6L ^ l))) + string7 + (String)((Object)SshConfig.a("w", (int)18519, (long)(0x2FF56C926DE7527BL ^ l))) + n + (String)((Object)SshConfig.a("w", (int)19143, (long)(0x1AB76F8EF523D0E8L ^ l))) + string6 + (String)((Object)SshConfig.a("w", (int)19560, (long)(0x5D88B347BC405646L ^ l))) + string5 + (String)((Object)SshConfig.a("w", (int)15708, (long)(0x39861213C7C1A775L ^ l))) + string4 + (String)((Object)SshConfig.a("w", (int)8380, (long)(0x6B00F7DB688E3A94L ^ l))) + string3 + (String)((Object)SshConfig.a("w", (int)26414, (long)(0x167693F25019FD05L ^ l))) + string2 + (String)((Object)SshConfig.a("w", (int)10178, (long)(0x53731531E47BDE8L ^ l))) + string + "}";
    }

    @NotNull
    private static Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(SshConfig server, @NotNull AuthType authType) {
        boolean bl;
        Credentials credentials;
        block14: {
            CredentialAttributes credentialAttributes;
            block13: {
                AuthType authType2;
                String[] stringArray;
                long l;
                block11: {
                    block12: {
                        l = b ^ 0x7032F0B10F32L;
                        stringArray = SshConfig.h();
                        try {
                            try {
                                authType2 = authType;
                                if (stringArray != null) break block11;
                                if (authType2 != null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(21);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    authType2 = authType;
                }
                try {
                    if (authType2 == AuthType.OPEN_SSH) {
                        throw new IllegalStateException((String)((Object)SshConfig.a("w", (int)14138, (long)(0x593FFDE237D88EBBL ^ l))) + String.valueOf(authType));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                credentialAttributes = SshConfig.createAttributes(server, false, authType);
                credentials = PasswordSafe.getInstance().get(credentialAttributes);
                if (credentials != null) break block13;
                bl = true;
                if (stringArray == null) break block14;
            }
            bl = PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(credentialAttributes, credentials);
        }
        return new Pair((Object)credentials, (Object)bl);
    }

    /*
     * Exception decompiling
     */
    private static CredentialAttributes createAttributes(SshConfig config, Boolean isPasswordMemoryOnly, @NotNull AuthType authType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static String makeNotEmpty(@Nullable String value, @NotNull String defaultValue) {
        String string;
        String string2;
        block13: {
            block14: {
                String[] stringArray;
                block11: {
                    block12: {
                        long l = b ^ 0x23E3AC7F3D4L;
                        stringArray = SshConfig.h();
                        try {
                            try {
                                string2 = defaultValue;
                                if (stringArray != null) break block11;
                                if (string2 != null) break block12;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(23);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    string2 = value;
                }
                try {
                    try {
                        if (stringArray != null) break block13;
                        if (!StringUtil.isEmpty((String)string2)) break block14;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw SshConfig.a(illegalStateException);
                    }
                    string2 = defaultValue;
                    break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
            }
            string2 = value;
        }
        try {
            string = string2;
            if (string2 == null) {
                SshConfig.$$$reportNull$$$0(24);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw SshConfig.a(illegalStateException);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void parseContent(@NotNull String name, @NotNull SshConfig config) {
        block64: {
            block68: {
                block66: {
                    block65: {
                        block62: {
                            block61: {
                                block60: {
                                    block58: {
                                        block56: {
                                            block57: {
                                                block54: {
                                                    block55: {
                                                        block52: {
                                                            block53: {
                                                                block50: {
                                                                    block51: {
                                                                        var2_2 = SshConfig.b ^ 72746043871384L;
                                                                        var4_3 = SshConfig.h();
                                                                        try {
                                                                            if (name == null) {
                                                                                SshConfig.$$$reportNull$$$0(25);
                                                                            }
                                                                        }
                                                                        catch (IllegalStateException v0) {
                                                                            throw SshConfig.a(v0);
                                                                        }
                                                                        try {
                                                                            if (config == null) {
                                                                                SshConfig.$$$reportNull$$$0(26);
                                                                            }
                                                                        }
                                                                        catch (IllegalStateException v1) {
                                                                            throw SshConfig.a(v1);
                                                                        }
                                                                        var5_4 = SshConfig.cutPiece(name, '@', (String)SshConfig.a("w", (int)26041, (long)(6832905690853065621L ^ var2_2)));
                                                                        try {
                                                                            v2 /* !! */  = var5_4;
                                                                            if (var4_3 != null) break block50;
                                                                            if (v2 /* !! */  != null) break block51;
                                                                        }
                                                                        catch (IllegalStateException v3) {
                                                                            throw SshConfig.a(v3);
                                                                        }
                                                                        return;
                                                                    }
                                                                    name = (String)var5_4.getFirst();
                                                                    config.setUsername((String)var5_4.getSecond());
                                                                    v2 /* !! */  = var5_4 = SshConfig.cutPiece(name, ':', (String)SshConfig.a("w", (int)13011, (long)(551866759690949885L ^ var2_2)));
                                                                }
                                                                try {
                                                                    if (var4_3 != null) break block52;
                                                                    if (v2 /* !! */  != null) break block53;
                                                                }
                                                                catch (IllegalStateException v4) {
                                                                    throw SshConfig.a(v4);
                                                                }
                                                                return;
                                                            }
                                                            v2 /* !! */  = var5_4.getFirst();
                                                        }
                                                        name = (String)v2 /* !! */ ;
                                                        config.setHost((String)var5_4.getSecond());
                                                        var5_5 = false;
                                                        var6_6 = SshConfig.cutPiece(name, ':', (String)SshConfig.a("w", (int)22896, (long)(6497770022141296477L ^ var2_2)));
                                                        try {
                                                            v5 /* !! */  = var6_6;
                                                            if (var4_3 != null) break block54;
                                                            if (v5 /* !! */  == null) break block55;
                                                        }
                                                        catch (IllegalStateException v6) {
                                                            throw SshConfig.a(v6);
                                                        }
                                                        var5_5 = true;
                                                        name = (String)var6_6.getFirst();
                                                        config.setLiteralPort((String)var6_6.getSecond());
                                                    }
                                                    v5 /* !! */  = var6_6 = SshConfig.cutPiece(name, ' ', (String)SshConfig.a("w", (int)22896, (long)(6497770022141296477L ^ var2_2)));
                                                }
                                                try {
                                                    if (var4_3 != null) break block56;
                                                    if (v5 /* !! */  != null) break block57;
                                                }
                                                catch (IllegalStateException v7) {
                                                    throw SshConfig.a(v7);
                                                }
                                                return;
                                            }
                                            v5 /* !! */  = var6_6.getFirst();
                                        }
                                        name = (String)v5 /* !! */ ;
                                        try {
                                            block59: {
                                                try {
                                                    try {
                                                        if (var4_3 != null) break block58;
                                                        if (!var5_5) break block59;
                                                    }
                                                    catch (IllegalStateException v8) {
                                                        throw SshConfig.a(v8);
                                                    }
                                                    config.setLiteralLocalPort((String)var6_6.getSecond());
                                                    if (var4_3 == null) break block60;
                                                }
                                                catch (IllegalStateException v9) {
                                                    throw SshConfig.a(v9);
                                                }
                                            }
                                            config.setLiteralPort((String)var6_6.getSecond());
                                        }
                                        catch (IllegalStateException v10) {
                                            throw SshConfig.a(v10);
                                        }
                                    }
                                    config.setLiteralLocalPort("");
                                }
                                try {
                                    try {
                                        v11 = SshConfig.a("w", (int)2514, (long)(5108565274331983857L ^ var2_2)).equals(name);
                                        if (var4_3 != null) break block61;
                                        if (!v11) {
                                        }
                                        ** GOTO lbl110
                                    }
                                    catch (IllegalStateException v12) {
                                        throw SshConfig.a(v12);
                                    }
                                    v11 = SshConfig.a("w", (int)10420, (long)(5948755294766632598L ^ var2_2)).equals(name);
                                }
                                catch (IllegalStateException v13) {
                                    throw SshConfig.a(v13);
                                }
                            }
                            try {
                                block63: {
                                    try {
                                        try {
                                            if (var4_3 != null) break block62;
                                            if (!v11) break block63;
                                        }
                                        catch (IllegalStateException v14) {
                                            throw SshConfig.a(v14);
                                        }
lbl110:
                                        // 2 sources

                                        config.setAuthType(AuthType.PASSWORD);
                                        if (var4_3 == null) break block64;
                                    }
                                    catch (IllegalStateException v15) {
                                        throw SshConfig.a(v15);
                                    }
                                }
                                v11 = SshConfig.a("w", (int)1518, (long)(2649870890470777807L ^ var2_2)).equals(name);
                            }
                            catch (IllegalStateException v16) {
                                throw SshConfig.a(v16);
                            }
                        }
                        try {
                            try {
                                if (var4_3 != null) break block65;
                                if (!v11) {
                                }
                                ** GOTO lbl142
                            }
                            catch (IllegalStateException v17) {
                                throw SshConfig.a(v17);
                            }
                            v11 = SshConfig.a("w", (int)22628, (long)(6682611397848596036L ^ var2_2)).equals(name);
                        }
                        catch (IllegalStateException v18) {
                            throw SshConfig.a(v18);
                        }
                    }
                    try {
                        block67: {
                            try {
                                try {
                                    if (var4_3 != null) break block66;
                                    if (!v11) break block67;
                                }
                                catch (IllegalStateException v19) {
                                    throw SshConfig.a(v19);
                                }
lbl142:
                                // 2 sources

                                config.setAuthType(AuthType.KEY_PAIR);
                                if (var4_3 == null) break block64;
                            }
                            catch (IllegalStateException v20) {
                                throw SshConfig.a(v20);
                            }
                        }
                        v11 = SshConfig.a("w", (int)11757, (long)(1211745405741829066L ^ var2_2)).equals(name);
                    }
                    catch (IllegalStateException v21) {
                        throw SshConfig.a(v21);
                    }
                }
                try {
                    try {
                        if (var4_3 != null) break block68;
                        if (!v11) {
                        }
                        ** GOTO lbl168
                    }
                    catch (IllegalStateException v22) {
                        throw SshConfig.a(v22);
                    }
                    v11 = SshConfig.a("w", (int)17534, (long)(3609724194609095256L ^ var2_2)).equals(name);
                }
                catch (IllegalStateException v23) {
                    throw SshConfig.a(v23);
                }
            }
            try {
                if (!v11) break block64;
lbl168:
                // 2 sources

                config.setAuthType(AuthType.OPEN_SSH);
            }
            catch (IllegalStateException v24) {
                throw SshConfig.a(v24);
            }
        }
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> cutPiece(@NotNull String text, char separator, @Nullable String defaultValue) {
        String string;
        int n;
        block13: {
            String string2;
            block12: {
                String string3;
                String[] stringArray;
                block10: {
                    block11: {
                        long l = b ^ 0x7ECD51FB57DAL;
                        stringArray = SshConfig.h();
                        try {
                            try {
                                string3 = text;
                                if (stringArray != null) break block10;
                                if (string3 != null) break block11;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw SshConfig.a(illegalStateException);
                            }
                            SshConfig.$$$reportNull$$$0(27);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw SshConfig.a(illegalStateException);
                        }
                    }
                    string3 = text;
                }
                n = string3.indexOf(separator);
                try {
                    if (n < 0) {
                        return null;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                string = text.substring(0, n);
                try {
                    string2 = defaultValue;
                    if (stringArray != null) break block12;
                    if (string2 == null) break block13;
                }
                catch (IllegalStateException illegalStateException) {
                    throw SshConfig.a(illegalStateException);
                }
                string2 = defaultValue;
            }
            if (string2.equals(string)) {
                string = null;
            }
        }
        return new Pair((Object)text.substring(n + 1), (Object)string);
    }

    public static int parseSshPort(@Nullable String port) {
        return Math.max(StringUtil.parseInt((String)port, (int)-1), -1);
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void $$$reportNull$$$0(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 42[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void h(String[] stringArray) {
        a = stringArray;
    }

    public static String[] h() {
        return a;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            block10: {
                SshConfig.b = com.jetbrains.gateway.ssh.deploy.c.a(2665244401760678299L, -9081461210498992552L, MethodHandles.lookup().lookupClass()).a(75234179303900L);
                SshConfig.e = new HashMap<K, V>(13);
                SshConfig.h(null);
                var0 = SshConfig.b ^ 101964874107754L;
                var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                v0 = SecretKeyFactory.getInstance("DES");
                v1 = new byte[8];
                v2 = v1;
                v1[0] = (byte)(var0 >>> 56);
                for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                    v2 = v2;
                    v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                }
                var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                var9_3 = new String[69];
                var7_4 = 0;
                var6_5 = "8\u00dc\u00ef>\u0092S\u00a5L\u00d1N\u00beH\u0016\u00be\u008d\t\u008f\u00cdK1\u0089\u00ae5f\u001fw\u00ea'C\u00df`\u001c\u001a-\u0097q*\u0084\u00a2Q\u0010-\u00ea\u00b1\u00e0F8\u00a7\u00fe>v\u0090\u0083-\u00b0\u00f8\u0019\u0010\u00f0\u00fd\u00af\u00f5\u00c4\u00a3\u00d5t\u00d0u\u00d3\u0005&\u00ac-\u00cc(\u00f0\u00a9\u00d0\u00da\u00a38y\u0094\u0005\u00d2\u00af\u00d6\u0004\u0091\u00c9\u00c0\u0001\u0012\u00b0\u009fo\u00fd\u00e1\u0003L\u0005d\u00bbm\u00c9\u0080V\u00dc\u00e5Z\u0006:-\u00e3C(a\u0090\u00ce\u00ff\u00ccT\u00f4P\u00bd\fg\u0080\u00f1\"}\u00cc4T\u00bf\u001e\u0004\u00a3\u00f0^Z\u00f9I\u008b\u00a0\u00b3X0'?D\u009b\u00b3\u00c4\u00f02 \u0087\u00aaw\u001e\u00a9\u00cb\u00b6\u00c1\u008e\u00d1\u0005n\u00ca\u00a6@\u00ca\u008b\u00de\u0093\u008bn\u0085V\u00b3\u0013\u00d4\u00b3\u00e1\f\u00b7\u00a9 0\u00fb\u00fc}\u00d5\u00ab\u00a9\u00c7\u00d8\u00cc<\u0013\u00db\tws|\u00c3\u00fc\u0017\u00f75\u008czhW\u00f9[[\u00b5E\u00ce\te5\u00a7\u00e9\u00f97~\u00e3\u00b1T6\u00ecUm\u0082| \u0098c\u00bd\u00c0\u00c4\u008f6\u0012l\u00c84\u008e\u00f4yM\u0098\u0012\u00f2\u00c5x\u00fa\u0088\u00dffR\u00c3v\u00c8\u00e8\u00c9\u00bco(\u00be\u0083|\u00f9\u00bbS0\u00d3\u009e\u00b6'!\u00c1\u00a0\u00e3\u009b\u00cd\u00bc\\t;'\u0007\u00c6rsV+\u00e5V\u0086\u00ff\u00d6\u00f9abBF\u008a\u00b1 t +U\u0016\u001b\u00fe\u00e8\u00ce\u00fb\u00a9h\u00bd\u00fe+\u00e4Z\u00f1\u00e8\u00f5\u0002\u00a6\u00ecSZ-\u00e5\u00e3q\u0091\u00c3o pJ\u00daC\u0006G\u00b0U\u001a\u00d9\u000b\u00ea\u00ba\u00c5L\u008cG]\u00fd\u00c1\u00af\u00a0OD\u00ac\u00b8x\u00f9\u00d08\u00b0\u00cb o\u00a3\u001f\u00e2,\u0016s|\u0090\u009a\n\u009e\u008a\u0090\u00eem\u0084xk<\u00e1O\u00c47\u00ebuS}z\u00e5\ty\u0018$bK\u00a8\u00f6A\u009b\u00af|9\bIA\u00c0\u00909\u000b\u00faJ'X\u009b\u00cf4(\u00cf\u00fbU\u007f\u0086/W\u00d5\u00b9\u008b\u0097\u00acU\u00ae\u009c\u00b2\u00c4\u00ea\u0014\u00cc\"\u009b&\u00cd\u00f2I@\u00f1\u00a8e\u00d7\u0005\u00fbH\u00d8@So\u00fca0A`\u00bb\u00ec\u0097\u00bb\u00ad?e\u00dd%\u0089!\u00de\u00ef\u00d8\u00ee6i`\u008b\u00f4(w\u00d5$\u00c9\u00ef\u00adli\u00b8\u0098\u009bk\u00ebli,\u000b[x\u0006s4\u0000GX8\u008a\u00b58\u00f1V\u00c5\u00ee}A\u00b6is\u0080o\u00af\u00b3\u00ecP\u00eb\u0000a\u0094\u00aeP\u00d1>'\u00a0\u00b7K\u00a1\u00c0\u00ab<\u0002H\b@{\u000fx\u00f5Y\u0016\"\u00c3\u00a5b\t\u00f4\u00ad\u00be;\u00ad*\u0081(d\u00b5\u00dd\u00e6\u0003f\u00c3r\u00eab<\u00d8\u001a\u00aagK\u0017\u00e6f\u0005\u00c6\u00b9\u000b \u00c4\u0017\u00db\t\ti^\u00f9\u009a\u00b3\u00a8\u00ae\u00de\u00de$\u001c sI\u00ee\u00ee\u00cd\u00ae\u0097r6\u0006\"\u00a7\u00b3\u00b2t\u00b6\u00f8t(\u001aqm`\u00deq\u00f2\u0085\u00dc\u0095\u001d\u00ec\u0091\u0018\u000b:\u00ffS\u00a5\u00c0S\u00aa\u00eb\n\u001b\u00d8\u008dv\u0005\u00e7&\u00e9R\u00b5\u00f9<\"\u00c80\u009e\u00f4\u00ce\u0086\u0000\u000e;\u0015\u00a9\u00d27\u00e4-\u00c7\u00cd\u0099\u00df\u00938\u00ec(\u0094\u00a6%\u00d0\u00b1Lc\u00173c\u0082:\u0007\u008dGEeg\u00d0\n\u008b\u00fb\u00b1\u008dv\u0086\u00af W\u00far\u00b7Z\u00c7\u008e\u0004\u00b6\u0012\u00a0\u00c9[\u0003>\u00cd\u00a7[\u00ce\u008f\u00a8\u0015\u00ed\u00f1Yw\u0097\u0090l$\u00c3\u00e1\u0010\u00b2\u00a2_|s\u008d\u0080\u00e0\u00d9\u00ee\u00e9\u00e9\u0005\u00bc\u0004\u0099\u0010\u00cb\u00eeOj\u00b9^\u00c5\u00e3;\u00bf\u0005\u00bb\u00c0\u00ffM\u00ef \u00110\u00d3:\u00df\u0092f\u00b2\u0091a\u001e8_\u009b)\u00e4\u0017\u00ad\n\u00efu\u00d0\u000e\u00e5W\u00cd\n\u000f\u00ed\u008bzT\u0010\u00aa\u00b2\u0098\u007fT\u00dd\u00dd\u00d2\u00c9,\u00b0\u00ecy\u00e1$\u008b\u0018\u00d2%l\u00f8\u007f\u00ddN\u00c8\u0015;Q\u00ea\u00d8\"$\u0000\u00c4\u00b6\u00b4\u0019H\u00deU\u00ed\u0010\u00ba\u00d4\u0095`\u0094\u008dK\u00ef\u00d5)\u00d3\u00ab<\u0004\u00be\u00e7\u0010\u009e*\u0003L\u0092\u00eb!\u008b\u0090\u00f0D\u0083+\u0018\u0019!\u0010\u00ca\u00d2\u0091\u00de\u00e3\u00a2D\u00dd\u00d21\u009bTCG\u0003'\u0010\u0012\u0004\u00e4\u00e4L\u00f7\u009fv\u00a6\u00d5\u00a4\u00ce\u0015\u0087\u00c0\u00a6P\u0083$\u00dffg\u0087\u0097\u00c5\u00a8\u0000_\u00de.\u00f4\u00e4\u0093n\u00f2_4Z\u0083\u00b5\u00d4\u00d3\u00a3F\u00dc\f\u00121\u00f8\u00ce\u00ef\u0096\u0086\u00c8\u00cbN\u0001W\u00be\u00c8\u001du\u00d5\u00c2RL\u00ac)&I\u00f4-g\u0010r\u00de\u00b0w\u00a1?I\u009a\u00ea'\u00c9\f\u0081B\u00f5Z\u00ba\u00d7\u00e9S\u008d\u00ad\u0005h\u00f6\u00c4\u00ba\u00e7\u00b0\u0003\u001aI\u009a\u00c5\u00ce\u00ac@V3\u0003\u00d4\u00bb\u0011\u009b\u00ffQ\u00cb\u00ce\u00ba\u009aILh\u00bc\u00b50\u0096\u0018Xm\u00d4\u00a0\u0098\u00b8:\u009aqZ-\u009b\u00af\u00c9/\u0019\u00b8\u0007\u00f0*\u00a5v\u00ebU\u0013\u00d2g\u001e\u0081#e\u00bct\u00d3x`\n\u0003\u0081\u00f2\u00c8K\u00f0\u00b6\u0099,V\"\u00c3\u00e5\u0081\u000b\u0000f^\u00a0\u00c8\u0094\u0087\u00c67B\u0081\u00c4qf\u0081\u0090TcH\u00bf\u00ee\u00da\u00b1\u00afjJ\u00da\u00a7Ti\u00f4I\u00b5\u00dcl\u001a>\u001eZ\u00d7R\u00e8\u0091\u00ae\u00f5\u008b*hD\u00b2\u00df\u0093\u001a\u00aa\u00df\u001b\u008aco\u00f8\u0015\u00aa4\u00efp\u00b7\u00d5\u0001\u00a3\bc\u00b4\u008f\u00ef\u00ba\u00df\u00bf\u00b7\u0093\u00a2\u001ayC\u00e0UW{}t\u00d2\u00d8\u0010\u00ca.\u00e4y\u00c3i\u0083p.\u00b5X'\u00f6\u00eb\u00d4\u00a6 \u0017\u00d6\u0087\u00d0\u00ef\u00a9y\u0085$\u0004\u001a\u00f8\u00a5\u00d8\u00c1J\u00a01\u0000c\u009aHx\u00c8i\u00f1\u007f0(J\u00cd\u008b\u0018\u00cf\u00eb\u00e1s\u0017C\u00fb\u00fe\u00dd\u0007\u00f2\u00fc\u00fe+\u00dd\u008c\u00d2>jqV+;\u00a7\u0010\u0002\u00e1\u0018\u00c96*1|\u0099\u0096\u0018J\u00ef.\u0092; \r\u00d0.`\u0005%Q\u0092(\u00ee\u00e1\nX\u00b2\u0001u\u00f9\u001dl\u0012\u00b5M3\u009f`7\u00da\u008c\u0013\u00a2\u00a54\u0010\u00e4\u001c\u00e2(\u00b8\u00a3\u00fe\u00e1\u00e2U(C\u00ee\u0084\u00a1X\u0010\u001b\u0083&\u009b\u008c\u00eb\u008f\u001b\u008eq\u0004\u00c0\u0082\u00b4\u0097]\u0010\u00e4\u009f}<\u000b\u00d8\u00b7@5\u0090\u00bd/qo\u00ddn\u0010\u00abC\u000e`\u009f}\u007f\u00f5\u00ff\u00b0\u0001[\u00dc\u00ac\u00ce\u00f2H\u00b9\u0001\u00af\u001d\u0087&\u00eb\u00b7!\u00f8\u00ebX\u007f\u00c9?\u0017\u008e\u00d5\u00d5\u00c3\u0089_Z\u008d/\u00cc\u00b8\u00fd\u00b1R\u00a7\u0095\u0093z\u00a6\u00ddC\u00a5n\u000b#\f\u0018\u00b8<\u0013\u00b6^c\u00f08\u00cd<2\u00d3\u0096\u00f4\u00d6m\u00dbk\u00d4\u00e0\u00df\u00dc\u00e7\u00c1\u00d9\u0089\u00e2\u00b6\u000b\u0010\u007fi.\u00a0\u00df\u00ab\u0095\u008c\u0098?\u001e.\u0099\u0004\u00fe\u00a9 a>\u00adjU\u00b1\u00b4:\u00e5\u00801\u00d5;\u00a7ii\u0001r\u00af\u0019\u00b5\r2r\u00c8Ps\u00e9\"\t\u0096\u00b1(\u00bc\u00dd\u0087\u008eKK\u00e3\u00b8E\u00e3\u00ce\u00f9p\u00b7/\u00ea\u0010\u00e8\u00a2s\u009e\u00a1z\u00e2\u00c9\u00d0\u00ef\u00b4\u0094\u00c37G\u00b2\u00d5V\u00e2\u00ea\u00ba\u00fcW\u0018\u0000\u009d\u0006~\u00c7\u0092\u008d\u00cc\u00dazg\u0012\u0091\u0094b?\u00ce\u0017\u00de&\u00e4y\u001an @7\u001e\"\u000f\u00ae\u00c9\u00f3\u001b\u00a9!w\u001e\u0086\u00a1^e\f\u00cfrhC\u00da\u00bb\u0013\u00fd\u00f1\u0016\\\u00b3\u00cd]\u0018\u00ae>!\u00ea\u009f.r\u00de\u00d8\u00dd\b\u00a9m\u008dr\u001aq\u00a8;\u00a4\u00a6\u00afw\u00b3\u0010A\u0003\u008a\u00a6\u00d3\u0096_\u009d$\u0004\u00ef\u00d2\u00832Y\u00e1(\u00ba=]\u00b0\u0083Qgz!\u00da\f\u00b7\u0094\u00dfR\u00be\u00cc\u00dd\u00fd\u0013\b\u00adLh\u00a3~s\u00de\u00d3Ks\u00d7\u001e\u00f6w\u00ac\u00fa\u008c+\u00d00?\u00ca\u00bb\u00da\u0098rwi\u00a2\u00b6\u00fd\u009dpv\u0001\u0001Y\u00c4\u00c4\u0019\u00c0\u0084\t\u009fd9\u00fa;\u00c6\u008c\u0012T\u00ccY\u0010F\u000b\u00ad\u0081/\u0018\u00bb\u00f3\u0013\u008e\u00d8\u00d4\u00ef(\u00ae\u00c3\u00b6\u0011A\u00dd\u0005\u00d8\u00a9TL\\\u00b0\u000f7\u001f\u00ecq\u000e\u00fa\u00dc\u0002\u00cb\rIZt\u00e5\u000eShy\u009bcx#\u0098\f1\u00a806\u00b4\u00c2\u00f1\u00c0\u00ba={\u00d4\u00b7\u009e\u00dd\u000b\u000f\u00d1; \u00b5\b\u0086\u0099\u00d8T\u00b4\u00d6uo\u00c2\u0086\u00a4\u00f9-\u00c7SM\u00df\u0084Ge\u00aa~\u00e2\u00f0P\u00dc\u00d1A!(\u009d\u00db\u0007\u0080\u001c\u00ab\u00a9\u00b4[\u00ab\u0016U7\u00f3\u00bf\u00f0o\u0006\u007f\u00bf\u00d7\b\"\u0094\u00d6If\u007f$\u00ca,jb\u00de\u00fb\u0002_4=\u00ee\u0010\u00ca\u00c4M\u0001bL\u0013\u00c4\u00f5\u00a6\u0099\u00ab\u0019D\u00bc\u00ae(;\u0080Y\"\r9\u001c\u00a6u\u001e\u00db^\u00e7\u001b<\u00e6\u00e5\u00ac13Z\u00a96F4\u009e~\u009e\u00cbe=X\u00df\u00baB+\u00c6\u00a09\u0001 \u00b1\u00da\u00a10\u0010X\u00a1\u0081\u008c\u00cd9\n\u008fh\u00bf\u0010<\u00e7Zy\u00c7+\u00b0\u00a6\u0016\u00e5f\u00f1u\u008d\u0013z\u0010)r\u0004\u00dc\u001em\u00ae@#\u00a2\u00c2\u00fec\u00cc\u0004\u008a \u008e\u00c8q\u00b4R\u00a5N1t\u00ad\u00d6\u00eeX\u00fc<Z2\u00db\u0005\u00f4\u0094\u007f\u0098\u001e\u00ef\u00e3\u00918C\u009d\u00cc\u000b(a#\u00f8\u0081\u00ca\u009b&\u0086\u00b1\u00fd\u00fc\u009d\u00f93>e\u009e\u00ae\u00b7\u00d6_i\u00d9\u00f9\u001a\u00fd(t\u0012\u00dau\u00dc\u001d\u0003U\u00f0ga\u000e\u00fd(\u00bct\u00ac\u0084\u00e1\u00f6\u0088\u00f6`\u00ae\b3\u00f7C\u00f0\u00a9{\u00f2\u00a0\u008d\u00f9U!\u00d3\u00c9\u0002\u0005`\u0016\u0089yV\u0090\u0011\u009d\u0004\u008c\u00cc\u00bd\u00ad8:\u0006\u0013Frz\u00e26\u0017#\u008aIN6\u00a8\u0085\u00f8\u0093\u001bx\u000b\u00d7\u008f\u00fa\u0082\u008c\u00a1\u00bf\u00ba\u0012\u00d8\u000b\u008bH'Y\u0095Vjb\u0017#\u0010s\u008b0'\u00eb\u00b5\u0087\u0010m\u0015\u00df\u0010\u00878\u009c\u00d3\u00c7e:\u0094\u00e3\u008e\t\u00e2QcYLY\u0098'j(\u008c\u00f33\u0007\u00fc\u0096%es\u0087\r\u009e\r\u00cb\u0014\u008cB!rp\u009e\u0013\u00c6g\u00d8\u00ce\u00c7\u00d3\u00db\u0093\u0014\u000b\u00b8\u00ccpr5(\f\u00a4\u00f3i\u00a1 `$\u00d0\u00e8\u0097\u00a5\u009d\u0015=\b$\u00a6\u00f5MT|\u0000\u00ea;{\u00f00\u00db5\n\u008fS\u00b8\u000e\u00d6-n\u00d4h \u00d8\u001a\u00a7\u00b2P\u0081Mm\u00e1i\u00ba1\u008e\u0017\u00e9=\u00b0b#\u00a9$\u00db\u00a0c\u0015*\u00ad\u00a1o\u00a1f\u00f4 cs\u00d8t\u00bd\u00a3=\u0011\u00d7\u00e9\b\u00d1\u00c7x\u00a7m\u0019\u00ff\u00b2\u00c5\u00e3ZJ\u00dd\u00d6\u00af\u00fb\u009c\u00a7\u00d6\u0096\u00fa";
                var8_6 = "8\u00dc\u00ef>\u0092S\u00a5L\u00d1N\u00beH\u0016\u00be\u008d\t\u008f\u00cdK1\u0089\u00ae5f\u001fw\u00ea'C\u00df`\u001c\u001a-\u0097q*\u0084\u00a2Q\u0010-\u00ea\u00b1\u00e0F8\u00a7\u00fe>v\u0090\u0083-\u00b0\u00f8\u0019\u0010\u00f0\u00fd\u00af\u00f5\u00c4\u00a3\u00d5t\u00d0u\u00d3\u0005&\u00ac-\u00cc(\u00f0\u00a9\u00d0\u00da\u00a38y\u0094\u0005\u00d2\u00af\u00d6\u0004\u0091\u00c9\u00c0\u0001\u0012\u00b0\u009fo\u00fd\u00e1\u0003L\u0005d\u00bbm\u00c9\u0080V\u00dc\u00e5Z\u0006:-\u00e3C(a\u0090\u00ce\u00ff\u00ccT\u00f4P\u00bd\fg\u0080\u00f1\"}\u00cc4T\u00bf\u001e\u0004\u00a3\u00f0^Z\u00f9I\u008b\u00a0\u00b3X0'?D\u009b\u00b3\u00c4\u00f02 \u0087\u00aaw\u001e\u00a9\u00cb\u00b6\u00c1\u008e\u00d1\u0005n\u00ca\u00a6@\u00ca\u008b\u00de\u0093\u008bn\u0085V\u00b3\u0013\u00d4\u00b3\u00e1\f\u00b7\u00a9 0\u00fb\u00fc}\u00d5\u00ab\u00a9\u00c7\u00d8\u00cc<\u0013\u00db\tws|\u00c3\u00fc\u0017\u00f75\u008czhW\u00f9[[\u00b5E\u00ce\te5\u00a7\u00e9\u00f97~\u00e3\u00b1T6\u00ecUm\u0082| \u0098c\u00bd\u00c0\u00c4\u008f6\u0012l\u00c84\u008e\u00f4yM\u0098\u0012\u00f2\u00c5x\u00fa\u0088\u00dffR\u00c3v\u00c8\u00e8\u00c9\u00bco(\u00be\u0083|\u00f9\u00bbS0\u00d3\u009e\u00b6'!\u00c1\u00a0\u00e3\u009b\u00cd\u00bc\\t;'\u0007\u00c6rsV+\u00e5V\u0086\u00ff\u00d6\u00f9abBF\u008a\u00b1 t +U\u0016\u001b\u00fe\u00e8\u00ce\u00fb\u00a9h\u00bd\u00fe+\u00e4Z\u00f1\u00e8\u00f5\u0002\u00a6\u00ecSZ-\u00e5\u00e3q\u0091\u00c3o pJ\u00daC\u0006G\u00b0U\u001a\u00d9\u000b\u00ea\u00ba\u00c5L\u008cG]\u00fd\u00c1\u00af\u00a0OD\u00ac\u00b8x\u00f9\u00d08\u00b0\u00cb o\u00a3\u001f\u00e2,\u0016s|\u0090\u009a\n\u009e\u008a\u0090\u00eem\u0084xk<\u00e1O\u00c47\u00ebuS}z\u00e5\ty\u0018$bK\u00a8\u00f6A\u009b\u00af|9\bIA\u00c0\u00909\u000b\u00faJ'X\u009b\u00cf4(\u00cf\u00fbU\u007f\u0086/W\u00d5\u00b9\u008b\u0097\u00acU\u00ae\u009c\u00b2\u00c4\u00ea\u0014\u00cc\"\u009b&\u00cd\u00f2I@\u00f1\u00a8e\u00d7\u0005\u00fbH\u00d8@So\u00fca0A`\u00bb\u00ec\u0097\u00bb\u00ad?e\u00dd%\u0089!\u00de\u00ef\u00d8\u00ee6i`\u008b\u00f4(w\u00d5$\u00c9\u00ef\u00adli\u00b8\u0098\u009bk\u00ebli,\u000b[x\u0006s4\u0000GX8\u008a\u00b58\u00f1V\u00c5\u00ee}A\u00b6is\u0080o\u00af\u00b3\u00ecP\u00eb\u0000a\u0094\u00aeP\u00d1>'\u00a0\u00b7K\u00a1\u00c0\u00ab<\u0002H\b@{\u000fx\u00f5Y\u0016\"\u00c3\u00a5b\t\u00f4\u00ad\u00be;\u00ad*\u0081(d\u00b5\u00dd\u00e6\u0003f\u00c3r\u00eab<\u00d8\u001a\u00aagK\u0017\u00e6f\u0005\u00c6\u00b9\u000b \u00c4\u0017\u00db\t\ti^\u00f9\u009a\u00b3\u00a8\u00ae\u00de\u00de$\u001c sI\u00ee\u00ee\u00cd\u00ae\u0097r6\u0006\"\u00a7\u00b3\u00b2t\u00b6\u00f8t(\u001aqm`\u00deq\u00f2\u0085\u00dc\u0095\u001d\u00ec\u0091\u0018\u000b:\u00ffS\u00a5\u00c0S\u00aa\u00eb\n\u001b\u00d8\u008dv\u0005\u00e7&\u00e9R\u00b5\u00f9<\"\u00c80\u009e\u00f4\u00ce\u0086\u0000\u000e;\u0015\u00a9\u00d27\u00e4-\u00c7\u00cd\u0099\u00df\u00938\u00ec(\u0094\u00a6%\u00d0\u00b1Lc\u00173c\u0082:\u0007\u008dGEeg\u00d0\n\u008b\u00fb\u00b1\u008dv\u0086\u00af W\u00far\u00b7Z\u00c7\u008e\u0004\u00b6\u0012\u00a0\u00c9[\u0003>\u00cd\u00a7[\u00ce\u008f\u00a8\u0015\u00ed\u00f1Yw\u0097\u0090l$\u00c3\u00e1\u0010\u00b2\u00a2_|s\u008d\u0080\u00e0\u00d9\u00ee\u00e9\u00e9\u0005\u00bc\u0004\u0099\u0010\u00cb\u00eeOj\u00b9^\u00c5\u00e3;\u00bf\u0005\u00bb\u00c0\u00ffM\u00ef \u00110\u00d3:\u00df\u0092f\u00b2\u0091a\u001e8_\u009b)\u00e4\u0017\u00ad\n\u00efu\u00d0\u000e\u00e5W\u00cd\n\u000f\u00ed\u008bzT\u0010\u00aa\u00b2\u0098\u007fT\u00dd\u00dd\u00d2\u00c9,\u00b0\u00ecy\u00e1$\u008b\u0018\u00d2%l\u00f8\u007f\u00ddN\u00c8\u0015;Q\u00ea\u00d8\"$\u0000\u00c4\u00b6\u00b4\u0019H\u00deU\u00ed\u0010\u00ba\u00d4\u0095`\u0094\u008dK\u00ef\u00d5)\u00d3\u00ab<\u0004\u00be\u00e7\u0010\u009e*\u0003L\u0092\u00eb!\u008b\u0090\u00f0D\u0083+\u0018\u0019!\u0010\u00ca\u00d2\u0091\u00de\u00e3\u00a2D\u00dd\u00d21\u009bTCG\u0003'\u0010\u0012\u0004\u00e4\u00e4L\u00f7\u009fv\u00a6\u00d5\u00a4\u00ce\u0015\u0087\u00c0\u00a6P\u0083$\u00dffg\u0087\u0097\u00c5\u00a8\u0000_\u00de.\u00f4\u00e4\u0093n\u00f2_4Z\u0083\u00b5\u00d4\u00d3\u00a3F\u00dc\f\u00121\u00f8\u00ce\u00ef\u0096\u0086\u00c8\u00cbN\u0001W\u00be\u00c8\u001du\u00d5\u00c2RL\u00ac)&I\u00f4-g\u0010r\u00de\u00b0w\u00a1?I\u009a\u00ea'\u00c9\f\u0081B\u00f5Z\u00ba\u00d7\u00e9S\u008d\u00ad\u0005h\u00f6\u00c4\u00ba\u00e7\u00b0\u0003\u001aI\u009a\u00c5\u00ce\u00ac@V3\u0003\u00d4\u00bb\u0011\u009b\u00ffQ\u00cb\u00ce\u00ba\u009aILh\u00bc\u00b50\u0096\u0018Xm\u00d4\u00a0\u0098\u00b8:\u009aqZ-\u009b\u00af\u00c9/\u0019\u00b8\u0007\u00f0*\u00a5v\u00ebU\u0013\u00d2g\u001e\u0081#e\u00bct\u00d3x`\n\u0003\u0081\u00f2\u00c8K\u00f0\u00b6\u0099,V\"\u00c3\u00e5\u0081\u000b\u0000f^\u00a0\u00c8\u0094\u0087\u00c67B\u0081\u00c4qf\u0081\u0090TcH\u00bf\u00ee\u00da\u00b1\u00afjJ\u00da\u00a7Ti\u00f4I\u00b5\u00dcl\u001a>\u001eZ\u00d7R\u00e8\u0091\u00ae\u00f5\u008b*hD\u00b2\u00df\u0093\u001a\u00aa\u00df\u001b\u008aco\u00f8\u0015\u00aa4\u00efp\u00b7\u00d5\u0001\u00a3\bc\u00b4\u008f\u00ef\u00ba\u00df\u00bf\u00b7\u0093\u00a2\u001ayC\u00e0UW{}t\u00d2\u00d8\u0010\u00ca.\u00e4y\u00c3i\u0083p.\u00b5X'\u00f6\u00eb\u00d4\u00a6 \u0017\u00d6\u0087\u00d0\u00ef\u00a9y\u0085$\u0004\u001a\u00f8\u00a5\u00d8\u00c1J\u00a01\u0000c\u009aHx\u00c8i\u00f1\u007f0(J\u00cd\u008b\u0018\u00cf\u00eb\u00e1s\u0017C\u00fb\u00fe\u00dd\u0007\u00f2\u00fc\u00fe+\u00dd\u008c\u00d2>jqV+;\u00a7\u0010\u0002\u00e1\u0018\u00c96*1|\u0099\u0096\u0018J\u00ef.\u0092; \r\u00d0.`\u0005%Q\u0092(\u00ee\u00e1\nX\u00b2\u0001u\u00f9\u001dl\u0012\u00b5M3\u009f`7\u00da\u008c\u0013\u00a2\u00a54\u0010\u00e4\u001c\u00e2(\u00b8\u00a3\u00fe\u00e1\u00e2U(C\u00ee\u0084\u00a1X\u0010\u001b\u0083&\u009b\u008c\u00eb\u008f\u001b\u008eq\u0004\u00c0\u0082\u00b4\u0097]\u0010\u00e4\u009f}<\u000b\u00d8\u00b7@5\u0090\u00bd/qo\u00ddn\u0010\u00abC\u000e`\u009f}\u007f\u00f5\u00ff\u00b0\u0001[\u00dc\u00ac\u00ce\u00f2H\u00b9\u0001\u00af\u001d\u0087&\u00eb\u00b7!\u00f8\u00ebX\u007f\u00c9?\u0017\u008e\u00d5\u00d5\u00c3\u0089_Z\u008d/\u00cc\u00b8\u00fd\u00b1R\u00a7\u0095\u0093z\u00a6\u00ddC\u00a5n\u000b#\f\u0018\u00b8<\u0013\u00b6^c\u00f08\u00cd<2\u00d3\u0096\u00f4\u00d6m\u00dbk\u00d4\u00e0\u00df\u00dc\u00e7\u00c1\u00d9\u0089\u00e2\u00b6\u000b\u0010\u007fi.\u00a0\u00df\u00ab\u0095\u008c\u0098?\u001e.\u0099\u0004\u00fe\u00a9 a>\u00adjU\u00b1\u00b4:\u00e5\u00801\u00d5;\u00a7ii\u0001r\u00af\u0019\u00b5\r2r\u00c8Ps\u00e9\"\t\u0096\u00b1(\u00bc\u00dd\u0087\u008eKK\u00e3\u00b8E\u00e3\u00ce\u00f9p\u00b7/\u00ea\u0010\u00e8\u00a2s\u009e\u00a1z\u00e2\u00c9\u00d0\u00ef\u00b4\u0094\u00c37G\u00b2\u00d5V\u00e2\u00ea\u00ba\u00fcW\u0018\u0000\u009d\u0006~\u00c7\u0092\u008d\u00cc\u00dazg\u0012\u0091\u0094b?\u00ce\u0017\u00de&\u00e4y\u001an @7\u001e\"\u000f\u00ae\u00c9\u00f3\u001b\u00a9!w\u001e\u0086\u00a1^e\f\u00cfrhC\u00da\u00bb\u0013\u00fd\u00f1\u0016\\\u00b3\u00cd]\u0018\u00ae>!\u00ea\u009f.r\u00de\u00d8\u00dd\b\u00a9m\u008dr\u001aq\u00a8;\u00a4\u00a6\u00afw\u00b3\u0010A\u0003\u008a\u00a6\u00d3\u0096_\u009d$\u0004\u00ef\u00d2\u00832Y\u00e1(\u00ba=]\u00b0\u0083Qgz!\u00da\f\u00b7\u0094\u00dfR\u00be\u00cc\u00dd\u00fd\u0013\b\u00adLh\u00a3~s\u00de\u00d3Ks\u00d7\u001e\u00f6w\u00ac\u00fa\u008c+\u00d00?\u00ca\u00bb\u00da\u0098rwi\u00a2\u00b6\u00fd\u009dpv\u0001\u0001Y\u00c4\u00c4\u0019\u00c0\u0084\t\u009fd9\u00fa;\u00c6\u008c\u0012T\u00ccY\u0010F\u000b\u00ad\u0081/\u0018\u00bb\u00f3\u0013\u008e\u00d8\u00d4\u00ef(\u00ae\u00c3\u00b6\u0011A\u00dd\u0005\u00d8\u00a9TL\\\u00b0\u000f7\u001f\u00ecq\u000e\u00fa\u00dc\u0002\u00cb\rIZt\u00e5\u000eShy\u009bcx#\u0098\f1\u00a806\u00b4\u00c2\u00f1\u00c0\u00ba={\u00d4\u00b7\u009e\u00dd\u000b\u000f\u00d1; \u00b5\b\u0086\u0099\u00d8T\u00b4\u00d6uo\u00c2\u0086\u00a4\u00f9-\u00c7SM\u00df\u0084Ge\u00aa~\u00e2\u00f0P\u00dc\u00d1A!(\u009d\u00db\u0007\u0080\u001c\u00ab\u00a9\u00b4[\u00ab\u0016U7\u00f3\u00bf\u00f0o\u0006\u007f\u00bf\u00d7\b\"\u0094\u00d6If\u007f$\u00ca,jb\u00de\u00fb\u0002_4=\u00ee\u0010\u00ca\u00c4M\u0001bL\u0013\u00c4\u00f5\u00a6\u0099\u00ab\u0019D\u00bc\u00ae(;\u0080Y\"\r9\u001c\u00a6u\u001e\u00db^\u00e7\u001b<\u00e6\u00e5\u00ac13Z\u00a96F4\u009e~\u009e\u00cbe=X\u00df\u00baB+\u00c6\u00a09\u0001 \u00b1\u00da\u00a10\u0010X\u00a1\u0081\u008c\u00cd9\n\u008fh\u00bf\u0010<\u00e7Zy\u00c7+\u00b0\u00a6\u0016\u00e5f\u00f1u\u008d\u0013z\u0010)r\u0004\u00dc\u001em\u00ae@#\u00a2\u00c2\u00fec\u00cc\u0004\u008a \u008e\u00c8q\u00b4R\u00a5N1t\u00ad\u00d6\u00eeX\u00fc<Z2\u00db\u0005\u00f4\u0094\u007f\u0098\u001e\u00ef\u00e3\u00918C\u009d\u00cc\u000b(a#\u00f8\u0081\u00ca\u009b&\u0086\u00b1\u00fd\u00fc\u009d\u00f93>e\u009e\u00ae\u00b7\u00d6_i\u00d9\u00f9\u001a\u00fd(t\u0012\u00dau\u00dc\u001d\u0003U\u00f0ga\u000e\u00fd(\u00bct\u00ac\u0084\u00e1\u00f6\u0088\u00f6`\u00ae\b3\u00f7C\u00f0\u00a9{\u00f2\u00a0\u008d\u00f9U!\u00d3\u00c9\u0002\u0005`\u0016\u0089yV\u0090\u0011\u009d\u0004\u008c\u00cc\u00bd\u00ad8:\u0006\u0013Frz\u00e26\u0017#\u008aIN6\u00a8\u0085\u00f8\u0093\u001bx\u000b\u00d7\u008f\u00fa\u0082\u008c\u00a1\u00bf\u00ba\u0012\u00d8\u000b\u008bH'Y\u0095Vjb\u0017#\u0010s\u008b0'\u00eb\u00b5\u0087\u0010m\u0015\u00df\u0010\u00878\u009c\u00d3\u00c7e:\u0094\u00e3\u008e\t\u00e2QcYLY\u0098'j(\u008c\u00f33\u0007\u00fc\u0096%es\u0087\r\u009e\r\u00cb\u0014\u008cB!rp\u009e\u0013\u00c6g\u00d8\u00ce\u00c7\u00d3\u00db\u0093\u0014\u000b\u00b8\u00ccpr5(\f\u00a4\u00f3i\u00a1 `$\u00d0\u00e8\u0097\u00a5\u009d\u0015=\b$\u00a6\u00f5MT|\u0000\u00ea;{\u00f00\u00db5\n\u008fS\u00b8\u000e\u00d6-n\u00d4h \u00d8\u001a\u00a7\u00b2P\u0081Mm\u00e1i\u00ba1\u008e\u0017\u00e9=\u00b0b#\u00a9$\u00db\u00a0c\u0015*\u00ad\u00a1o\u00a1f\u00f4 cs\u00d8t\u00bd\u00a3=\u0011\u00d7\u00e9\b\u00d1\u00c7x\u00a7m\u0019\u00ff\u00b2\u00c5\u00e3ZJ\u00dd\u00d6\u00af\u00fb\u009c\u00a7\u00d6\u0096\u00fa".length();
                var5_7 = 40;
                var4_8 = -1;
lbl21:
                // 2 sources

                while (true) {
                    v3 = ++var4_8;
                    v4 = var6_5.substring(v3, v3 + var5_7);
                    v5 = -1;
                    break block10;
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = SshConfig.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    var6_5 = "\u00f5\u00ea\u0093\u00e3Ht\u00962\r\u00a2\u0004\u00f4\t\u00ff\u0091\u008b\u008a\n\"\u008f\u00f0I\u00f3\u00d0\u0018'\u00bd\u00d7&\u00d1j\u00f7\u00e6\u0083B\u00dcp\u00a2N\u0085\"L\u00f4j\u0005X\u00be+\u00a6";
                    var8_6 = "\u00f5\u00ea\u0093\u00e3Ht\u00962\r\u00a2\u0004\u00f4\t\u00ff\u0091\u008b\u008a\n\"\u008f\u00f0I\u00f3\u00d0\u0018'\u00bd\u00d7&\u00d1j\u00f7\u00e6\u0083B\u00dcp\u00a2N\u0085\"L\u00f4j\u0005X\u00be+\u00a6".length();
                    var5_7 = 24;
                    var4_8 = -1;
lbl35:
                    // 2 sources

                    while (true) {
                        v6 = ++var4_8;
                        v4 = var6_5.substring(v6, v6 + var5_7);
                        v5 = 0;
                        break block10;
                        break;
                    }
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    var9_3[var7_4++] = SshConfig.a(var10_9).intern();
                    if ((var4_8 += var5_7) < var8_6) {
                        var5_7 = var6_5.charAt(var4_8);
                        ** continue;
                    }
                    break block11;
                    break;
                }
            }
            var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
            switch (v5) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl52:
                // 1 sources

                ** continue;
            }
        }
        SshConfig.c = var9_3;
        SshConfig.d = new String[69];
        SshConfig.DEFAULT_KEY_PATH = SshConfig.a("w", (int)130, (long)(4792623936650214671L ^ var0));
    }

    private static IllegalStateException a(IllegalStateException illegalStateException) {
        return illegalStateException;
    }

    private static String a(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c2;
            int n3 = 0xFF & byArray[i];
            if (n3 < 192) {
                cArray[n++] = (char)n3;
                continue;
            }
            if (n3 < 224) {
                c2 = (char)((char)(n3 & 0x1F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
                continue;
            }
            if (i >= n2 - 2) continue;
            c2 = (char)((char)(n3 & 0xF) << 12);
            n3 = byArray[++i];
            c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
            n3 = byArray[++i];
            c2 = (char)(c2 | (char)(n3 & 0x3F));
            cArray[n++] = c2;
        }
        return new String(cArray, 0, n);
    }

    private static String a(int n, long l) {
        int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x1307;
        if (d[n2] == null) {
            Object[] objectArray;
            try {
                Long l2 = Thread.currentThread().getId();
                objectArray = (Object[])e.get(l2);
                if (objectArray == null) {
                    objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                    e.put(l2, objectArray);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig", exception);
            }
            byte[] byArray = new byte[8];
            byArray[0] = (byte)(l >>> 56);
            for (int i = 1; i < 8; ++i) {
                byArray[i] = (byte)(l << i * 8 >>> 56);
            }
            DESKeySpec dESKeySpec = new DESKeySpec(byArray);
            SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
            ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
            byte[] byArray2 = c[n2].getBytes("ISO-8859-1");
            SshConfig.d[n2] = SshConfig.a(((Cipher)objectArray[0]).doFinal(byArray2));
        }
        return d[n2];
    }

    private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
        int n = (Integer)objectArray[0];
        long l = (Long)objectArray[1];
        String string2 = SshConfig.a(n, l);
        MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
        mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
        return string2;
    }

    private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
        MutableCallSite mutableCallSite = new MutableCallSite(methodType);
        try {
            mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
        }
        catch (Exception exception) {
            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig" + " : " + string + " : " + methodType.toString(), exception);
        }
        return mutableCallSite;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(SshConfig.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static abstract sealed class NameFormat
    extends Enum<NameFormat> {
        public static final /* enum */ NameFormat INITIAL;
        public static final /* enum */ NameFormat DESCRIPTIVE;
        public static final /* enum */ NameFormat CUSTOM;
        private static final /* synthetic */ NameFormat[] $VALUES;
        private static final long a;
        private static final String[] c;
        private static final String[] d;
        private static final Map e;

        public static NameFormat[] values() {
            return (NameFormat[])$VALUES.clone();
        }

        public static NameFormat valueOf(String name) {
            return Enum.valueOf(NameFormat.class, name);
        }

        @NonNls
        @NotNull
        public abstract String getName(@NotNull SshConfig var1);

        @Nls
        @NotNull
        public abstract String getPresentableShortName(@NotNull SshConfig var1);

        @Nls
        @Nullable
        public abstract String getPresentableAddition(@NotNull SshConfig var1);

        @NotNull
        private static String getBasicDescription(@NotNull SshConfig config) {
            String string;
            Object object;
            String string2;
            String string3;
            String string4;
            block15: {
                int n;
                block13: {
                    block14: {
                        SshConfig sshConfig;
                        String[] stringArray;
                        long l;
                        block11: {
                            block12: {
                                l = a ^ 0x4979206D30A8L;
                                stringArray = SshConfig.h();
                                try {
                                    try {
                                        sshConfig = config;
                                        if (stringArray != null) break block11;
                                        if (sshConfig != null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw NameFormat.a(illegalArgumentException);
                                    }
                                    NameFormat.$$$reportNull$$$0(0);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw NameFormat.a(illegalArgumentException);
                                }
                            }
                            sshConfig = config;
                        }
                        try {
                            try {
                                string4 = SshConfig.makeNotEmpty(sshConfig.getUsername(), (String)((Object)NameFormat.a("r", (int)25549, (long)(0x2984A0FA47363C5DL ^ l))));
                                string3 = SshConfig.makeNotEmpty(config.getHost(), (String)((Object)NameFormat.a("r", (int)31633, (long)(0x31C0684B91032400L ^ l))));
                                string2 = SshConfig.makeNotEmpty(config.getLiteralPort(), (String)((Object)NameFormat.a("r", (int)20384, (long)(0x245C4AA07F909032L ^ l))));
                                n = config.getLocalPort();
                                if (stringArray != null) break block13;
                                if (n != -1) break block14;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw NameFormat.a(illegalArgumentException);
                            }
                            object = "";
                            break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw NameFormat.a(illegalArgumentException);
                        }
                    }
                    n = config.getLocalPort();
                }
                object = ":" + n;
            }
            try {
                string = string4 + "@" + string3 + ":" + string2 + (String)object;
                if (string == null) {
                    NameFormat.$$$reportNull$$$0(1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw NameFormat.a(illegalArgumentException);
            }
            return string;
        }

        private static /* synthetic */ NameFormat[] $values() {
            return new NameFormat[]{INITIAL, DESCRIPTIVE, CUSTOM};
        }

        /*
         * Unable to fully structure code
         */
        static {
            block11: {
                block10: {
                    NameFormat.a = com.jetbrains.gateway.ssh.deploy.c.a(5031382710196315357L, 9178901028090066957L, MethodHandles.lookup().lookupClass()).a(8672956495091L);
                    var9 = NameFormat.a ^ 100364965315685L;
                    NameFormat.e = new HashMap<K, V>(13);
                    var0_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                    v0 = SecretKeyFactory.getInstance("DES");
                    v1 = new byte[8];
                    v2 = v1;
                    v1[0] = (byte)(var9 >>> 56);
                    for (var1_2 = 1; var1_2 < 8; ++var1_2) {
                        v2 = v2;
                        v2[var1_2] = (byte)(var9 << var1_2 * 8 >>> 56);
                    }
                    var0_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                    var7_3 = new String[13];
                    var5_4 = 0;
                    var4_5 = "L\u00d4M\u001aY\u001d\u0001\u009cm#N%\u00e8\u001d@\u0087A\r\u00d9\u0097\u00f7\u00d85\u00c2r\u001alf\u0089\u0084\u00b5\u0095\u0010\u00be\u00efW}\u00bc\u001e\u00b59\u00ceoQ\u0081\u00fc\u008b\u0087\u00a1\u0010\u00e6\u00ad\u00b5\u00acSs\u00fbs\u0002\u00d9\u00ed\u00a1Z\u00a9c\u0000\u0010\\\u00a5\u00a7\u00b7\b\u00c9e\u00d9y\u0016\u00b5\u00b6%V\u008c\u00e6\u0018\u0085I\u00dc\u0099<(\u0018U\u00e1\u00b6\u00a1\u00df\u00b7\u00d0\u008e\n\u00c1s\u009aqbfW\u0083\u0010\u00b9\u00d2\u00b0\u00b9\u00e1\u0096'\u0094\u00aa\u00ac\u00c5\"\u00c8V\u0015HhVj\u0084\u00cd\u0016\u00be\u00c9\u00104\u0017x\u00fd\u00a8\u00fc\u0083\u00a9>\u0005\u00f6\u00cag\u00c2Z\u0016W{\u00e3\u00fa\u00e8y\u0097\u001e\u00e9\u000f>s\u008f\u00e8\u00bc\u00d6\u0085:L\u0085J7\u00ac;ad\u00e9D\u00a3\u00a22\u00c1\u0092o\u0082:\u0097)\u0083\u00d1\u00f3\u00a7\u00c6\u00dd6\u0007p.\u00fek\u0090\u00d7\u00b9\u00ffz3\u00b7\u00b3\u0002\u00een\u0089 \u00d7W\u0095&uQRU\u009a\u0001\u0005\u00ca\u00f5\u008d\u00da2\u0088P\u00f6\u00cb\u00fc\u00a8\u00b7\u00a7@\t\u0002\u00d4\u00e8\u00bf\u001b\u0083c\u00e2\u0014\u00b5+=;P\u00ac\u000f2]%\u00ceB\u00b3\u0012\u0010y\u00c1\u00c9S\u00ca\u00d1G9u\u00c7,R\u00b3\u00e9\u0099\u00f3\u00c68\u00d5*\u00bd\u0086r\u00ec\u00e8\u00d39o\u00e9\t\u0006\"(\u00e1\u009f\u00c5N\u0097\u00d5\u009e\u00cb\u0006\u0091\u0086\u008e\u008e\u00bdT\u0010us\u0099C\u00e2\u00b3\u0099Y\u0012\u00c0jelI\u00a7\u00f2`D\f\u00e9\u009e\u00df-\u0099F3\u00f6!\u00bbx\u00b0Q\u00c6t\u00b2\u009b`oW#\u0081%\u0083\u00dc\u0083\u00bc\u0098I\u00b8\u0098\u009es(\u0017\u00e21\u00ebgQa\u00c0\u00ceI\u00cbA\u001a\u00e2Ag\u00a3\u00f3d\u00f9\u0080\u00a4\u00c8\u00da\u0088o\u00d5LbC^\u001b8\u001cuD\u00a5\n=\u0012\u009d\u00dcp\u00f2\u008c\n\u008b5\bL\u00d9f\u00c2~\u00df7[:n\u00abXx\u00d73\u00b7}\u00b9R\u00c0\u0080\u00e6\u00a2\u0096\u00e2\u0010\u00ba\u0092\u00a0\u00be\t\u009a\u009e\u00f39\u0086\u008b-e[#U\u00b2\u0087&5\u00c9\u008e\u00e4\u00d0\u00aff\u00b8r\u0093\u0005\u00a0\u00a0 \u00e1\u0013>\u00a9il\u00a1\u0003\u00ef\u00e5\u001d\u0018\u0082\u00ca9\u00a7J\u001e`4\u00da\u001f\u009b\u00b3i\u001a\u0003\u0006\u00b2\u00ab\u00bc6\u00a7\u00d6\u00f2\u00d2\u0097O\u0084\"6";
                    var6_6 = "L\u00d4M\u001aY\u001d\u0001\u009cm#N%\u00e8\u001d@\u0087A\r\u00d9\u0097\u00f7\u00d85\u00c2r\u001alf\u0089\u0084\u00b5\u0095\u0010\u00be\u00efW}\u00bc\u001e\u00b59\u00ceoQ\u0081\u00fc\u008b\u0087\u00a1\u0010\u00e6\u00ad\u00b5\u00acSs\u00fbs\u0002\u00d9\u00ed\u00a1Z\u00a9c\u0000\u0010\\\u00a5\u00a7\u00b7\b\u00c9e\u00d9y\u0016\u00b5\u00b6%V\u008c\u00e6\u0018\u0085I\u00dc\u0099<(\u0018U\u00e1\u00b6\u00a1\u00df\u00b7\u00d0\u008e\n\u00c1s\u009aqbfW\u0083\u0010\u00b9\u00d2\u00b0\u00b9\u00e1\u0096'\u0094\u00aa\u00ac\u00c5\"\u00c8V\u0015HhVj\u0084\u00cd\u0016\u00be\u00c9\u00104\u0017x\u00fd\u00a8\u00fc\u0083\u00a9>\u0005\u00f6\u00cag\u00c2Z\u0016W{\u00e3\u00fa\u00e8y\u0097\u001e\u00e9\u000f>s\u008f\u00e8\u00bc\u00d6\u0085:L\u0085J7\u00ac;ad\u00e9D\u00a3\u00a22\u00c1\u0092o\u0082:\u0097)\u0083\u00d1\u00f3\u00a7\u00c6\u00dd6\u0007p.\u00fek\u0090\u00d7\u00b9\u00ffz3\u00b7\u00b3\u0002\u00een\u0089 \u00d7W\u0095&uQRU\u009a\u0001\u0005\u00ca\u00f5\u008d\u00da2\u0088P\u00f6\u00cb\u00fc\u00a8\u00b7\u00a7@\t\u0002\u00d4\u00e8\u00bf\u001b\u0083c\u00e2\u0014\u00b5+=;P\u00ac\u000f2]%\u00ceB\u00b3\u0012\u0010y\u00c1\u00c9S\u00ca\u00d1G9u\u00c7,R\u00b3\u00e9\u0099\u00f3\u00c68\u00d5*\u00bd\u0086r\u00ec\u00e8\u00d39o\u00e9\t\u0006\"(\u00e1\u009f\u00c5N\u0097\u00d5\u009e\u00cb\u0006\u0091\u0086\u008e\u008e\u00bdT\u0010us\u0099C\u00e2\u00b3\u0099Y\u0012\u00c0jelI\u00a7\u00f2`D\f\u00e9\u009e\u00df-\u0099F3\u00f6!\u00bbx\u00b0Q\u00c6t\u00b2\u009b`oW#\u0081%\u0083\u00dc\u0083\u00bc\u0098I\u00b8\u0098\u009es(\u0017\u00e21\u00ebgQa\u00c0\u00ceI\u00cbA\u001a\u00e2Ag\u00a3\u00f3d\u00f9\u0080\u00a4\u00c8\u00da\u0088o\u00d5LbC^\u001b8\u001cuD\u00a5\n=\u0012\u009d\u00dcp\u00f2\u008c\n\u008b5\bL\u00d9f\u00c2~\u00df7[:n\u00abXx\u00d73\u00b7}\u00b9R\u00c0\u0080\u00e6\u00a2\u0096\u00e2\u0010\u00ba\u0092\u00a0\u00be\t\u009a\u009e\u00f39\u0086\u008b-e[#U\u00b2\u0087&5\u00c9\u008e\u00e4\u00d0\u00aff\u00b8r\u0093\u0005\u00a0\u00a0 \u00e1\u0013>\u00a9il\u00a1\u0003\u00ef\u00e5\u001d\u0018\u0082\u00ca9\u00a7J\u001e`4\u00da\u001f\u009b\u00b3i\u001a\u0003\u0006\u00b2\u00ab\u00bc6\u00a7\u00d6\u00f2\u00d2\u0097O\u0084\"6".length();
                    var3_7 = 32;
                    var2_8 = -1;
lbl20:
                    // 2 sources

                    while (true) {
                        v3 = ++var2_8;
                        v4 = var4_5.substring(v3, v3 + var3_7);
                        v5 = -1;
                        break block10;
                        break;
                    }
lbl25:
                    // 1 sources

                    while (true) {
                        var7_3[var5_4++] = NameFormat.a(var8_9).intern();
                        if ((var2_8 += var3_7) < var6_6) {
                            var3_7 = var4_5.charAt(var2_8);
                            ** continue;
                        }
                        var4_5 = "\u00a9k\u00ad\u00f6\u0006\u00c5\u0017\u00dcz\u00c0 \u0006\u00f6mA\u00e2a\u0013\u00ba\u00ee\u00ae\u0085.\u00ac\u0006\u00b9s\u00a8\u0005+\u0001\u0004\u00ec\u00a1\u0088\u00a2>tdV(/\u001e\u00a2\u00ae*\u00ae\u00c2\u00e1>\u00afq<\u00ad\u00e7o\u0010w\u00a9-WtG\u0084\u0082g.\u0099\u0096\u0098\u00fb\u00fd\u00be\u0097\u00df0\u00ae6\u001b\"\u00dc";
                        var6_6 = "\u00a9k\u00ad\u00f6\u0006\u00c5\u0017\u00dcz\u00c0 \u0006\u00f6mA\u00e2a\u0013\u00ba\u00ee\u00ae\u0085.\u00ac\u0006\u00b9s\u00a8\u0005+\u0001\u0004\u00ec\u00a1\u0088\u00a2>tdV(/\u001e\u00a2\u00ae*\u00ae\u00c2\u00e1>\u00afq<\u00ad\u00e7o\u0010w\u00a9-WtG\u0084\u0082g.\u0099\u0096\u0098\u00fb\u00fd\u00be\u0097\u00df0\u00ae6\u001b\"\u00dc".length();
                        var3_7 = 40;
                        var2_8 = -1;
lbl34:
                        // 2 sources

                        while (true) {
                            v6 = ++var2_8;
                            v4 = var4_5.substring(v6, v6 + var3_7);
                            v5 = 0;
                            break block10;
                            break;
                        }
                        break;
                    }
lbl39:
                    // 1 sources

                    while (true) {
                        var7_3[var5_4++] = NameFormat.a(var8_9).intern();
                        if ((var2_8 += var3_7) < var6_6) {
                            var3_7 = var4_5.charAt(var2_8);
                            ** continue;
                        }
                        break block11;
                        break;
                    }
                }
                var8_9 = var0_1.doFinal(v4.getBytes("ISO-8859-1"));
                switch (v5) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl51:
                    // 1 sources

                    ** continue;
                }
            }
            NameFormat.c = var7_3;
            NameFormat.d = new String[13];
            NameFormat.INITIAL = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                /*
                 * Exception decompiling
                 */
                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    long l = b ^ 0x44C7272269B1L;
                    try {
                        if (config == null) {
                            1.$$$reportNull$$$0(2);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    try {
                        string = DESCRIPTIVE.getPresentableShortName(config);
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    String string;
                    long l = b ^ 0x1BA6F1234342L;
                    try {
                        if (config == null) {
                            1.$$$reportNull$$$0(4);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    try {
                        string = DESCRIPTIVE.getPresentableAddition(config);
                        if (string == null) {
                            1.$$$reportNull$$$0(5);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 1.a(matchException);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            1.b = com.jetbrains.gateway.ssh.deploy.c.a(-2784314130708834583L, 119629950660544045L, MethodHandles.lookup().lookupClass()).a(220855872555692L);
                            1.h = new HashMap<K, V>(13);
                            var0 = 1.b ^ 38024925634534L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[12];
                            var7_4 = 0;
                            var6_5 = "\u0090\u00a0\u008f\u00b1\\\u009a\u00c2\f\u00d0\u00de\u0087#\u00ef\f?5`k\u0010\u0003\u00a4\u00c3\u00f6\u00d0\u00a8\u0015H) \u00b6\u0011]\u000f9'Z$\u00b5^S\u00949<\u00edPq\u00ba`\u00bf`u}\u008eCQ\u00cft\u008de-?\u00b6\u00da\u00c0\u00b4aL\u0089\f\u0013f;\u00ceP\u00ee(\u00ec\u00c6!]'`\u0013\u0006\u00e0\u00a2\u00deP\u00cfn\u00celB\u0015\u00fc\u009e.\u00bb\u0006\u0006\u00be.s\u00efqM\u00101\u0082f\u0003\u00f3#H\r\u00d8\u0093T\u0086z.\u00b4\u00f9\u0091\u00865\u00dc\u00e3\tn\u007fjH\u0089\u00a3\u0081(@\u00d9\u00dd\u00af\u00de\u00b3\u00bf!\u0015\u0016\u001a\u00bf\u00af\u00c1k\u000e\u009b\u00d1\u0092\u001e],\u000e\u00b0U\u00f4\u00feqf\u009f\u00f4_l\"$C\u00ebQ\u008d\u0006\u00a6Bfy\u00ab\u009d\"W\u00b3\u00100]\b\u00bda\u0096s\u00859D\u0083\u00034B\u008f\u00a6X_\u00a4\u00be\u00a7h\u00b9\u00f0|\u00e5\u0007\u00de\u00da\b\u0088\u00fb\u00c0z\u001a \n\u001b\u0090\u0086\u00b9.\u009d\u0084\u0017\u00bfd\u00b3\u00cb\u00b2hUKG\u00a9*\f\u00b6s@\u00b7\u00b4YP\u0094\u00edm\u0083n>\u00b0\u00f4\u000f\u00e1J\u00c4\u00a7\u008c5X\u00b2g3b\u00b1\u0083j\u00dfT\u0088\u008d\u00d0]\u0095o|\u00c9a\u00efN\u001fH\u00a0\u00dd\u000fX$\u001c\u0087\u00c1\u00cc{6.\u00f0\u009fI\u008aI\u00a8q\u00c0\u00f8\u00f0\u00c6.G\u0098D+\u00abjFN\u00bc]x\u00e1\u009a\f)?\u00bd\u00c2\u00ce(\u00b3\u00f9O\u00e4VY+\u0003\u00de\u00betxrxP\u00c2\u00eag\b\u0000\u00c3\u001d\u0011\u008f\u00e2G\u0082\u0083\u0092\u00dcD\u00ce\u00a0\u00ae\u00af=4\u000fh\u00c8\u009e\u00f9\u0087+QU`\u009e\u0010Mk\u00dd\u00c3T\u00af\u00d1-E\u00ba/\u00b7=vG\u0015(\u008d~M\u0014QVi\u0099\u0088b\u009cS<\u0083T\u00cb\u0006L\u008c6\u0005C\u00a3R\u00ad<\u0006g\u00c7\u00fc\u00e6\u0080\u008f\u0080\u0094\u00f0\\0g\u00a1(@\u009eO|]\u00b2\u00d27\u0007\u00a5\\\u00c5\u00b1\u000bg\u001f\u00b2 '0A\u00aa\u0088\u00c7\u00a8\u00ed\u000e\u00da\u00bb\u00c8k^\t\u00e4\u008a\u0004\u0001&\u0019:\u0010\u00b9\u00d1%\u00f4\u0019O!2\u0093\n\u00bb\u00cf\u00f9lL-";
                            var8_6 = "\u0090\u00a0\u008f\u00b1\\\u009a\u00c2\f\u00d0\u00de\u0087#\u00ef\f?5`k\u0010\u0003\u00a4\u00c3\u00f6\u00d0\u00a8\u0015H) \u00b6\u0011]\u000f9'Z$\u00b5^S\u00949<\u00edPq\u00ba`\u00bf`u}\u008eCQ\u00cft\u008de-?\u00b6\u00da\u00c0\u00b4aL\u0089\f\u0013f;\u00ceP\u00ee(\u00ec\u00c6!]'`\u0013\u0006\u00e0\u00a2\u00deP\u00cfn\u00celB\u0015\u00fc\u009e.\u00bb\u0006\u0006\u00be.s\u00efqM\u00101\u0082f\u0003\u00f3#H\r\u00d8\u0093T\u0086z.\u00b4\u00f9\u0091\u00865\u00dc\u00e3\tn\u007fjH\u0089\u00a3\u0081(@\u00d9\u00dd\u00af\u00de\u00b3\u00bf!\u0015\u0016\u001a\u00bf\u00af\u00c1k\u000e\u009b\u00d1\u0092\u001e],\u000e\u00b0U\u00f4\u00feqf\u009f\u00f4_l\"$C\u00ebQ\u008d\u0006\u00a6Bfy\u00ab\u009d\"W\u00b3\u00100]\b\u00bda\u0096s\u00859D\u0083\u00034B\u008f\u00a6X_\u00a4\u00be\u00a7h\u00b9\u00f0|\u00e5\u0007\u00de\u00da\b\u0088\u00fb\u00c0z\u001a \n\u001b\u0090\u0086\u00b9.\u009d\u0084\u0017\u00bfd\u00b3\u00cb\u00b2hUKG\u00a9*\f\u00b6s@\u00b7\u00b4YP\u0094\u00edm\u0083n>\u00b0\u00f4\u000f\u00e1J\u00c4\u00a7\u008c5X\u00b2g3b\u00b1\u0083j\u00dfT\u0088\u008d\u00d0]\u0095o|\u00c9a\u00efN\u001fH\u00a0\u00dd\u000fX$\u001c\u0087\u00c1\u00cc{6.\u00f0\u009fI\u008aI\u00a8q\u00c0\u00f8\u00f0\u00c6.G\u0098D+\u00abjFN\u00bc]x\u00e1\u009a\f)?\u00bd\u00c2\u00ce(\u00b3\u00f9O\u00e4VY+\u0003\u00de\u00betxrxP\u00c2\u00eag\b\u0000\u00c3\u001d\u0011\u008f\u00e2G\u0082\u0083\u0092\u00dcD\u00ce\u00a0\u00ae\u00af=4\u000fh\u00c8\u009e\u00f9\u0087+QU`\u009e\u0010Mk\u00dd\u00c3T\u00af\u00d1-E\u00ba/\u00b7=vG\u0015(\u008d~M\u0014QVi\u0099\u0088b\u009cS<\u0083T\u00cb\u0006L\u008c6\u0005C\u00a3R\u00ad<\u0006g\u00c7\u00fc\u00e6\u0080\u008f\u0080\u0094\u00f0\\0g\u00a1(@\u009eO|]\u00b2\u00d27\u0007\u00a5\\\u00c5\u00b1\u000bg\u001f\u00b2 '0A\u00aa\u0088\u00c7\u00a8\u00ed\u000e\u00da\u00bb\u00c8k^\t\u00e4\u008a\u0004\u0001&\u0019:\u0010\u00b9\u00d1%\u00f4\u0019O!2\u0093\n\u00bb\u00cf\u00f9lL-".length();
                            var5_7 = 16;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 1.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "\u001aU\u00b5\u00c3\u009aF\u00d1\u00e5\u0090\u00c2\u0017\u001d\u001bgv\u00b3\u00bf\u00ec+\u00c4(\u00f0\u00d1\u0084\u0012s\u00a1<\u00a3/P\u00e9\u0080u\u00825\u00b1\u00b6\u00ab\b(\u00d4\u00a3\u00dbG\n\u0016U1KD\\v\u00be\u0007\u00c1.\u00dc?\u00ff\u00d7\u0018c|\n\u00aec\u008f\u0097>\u0084y\u00b8\u0015\u0086\u001f:\u0011\u00a8\u001bS";
                                var8_6 = "\u001aU\u00b5\u00c3\u009aF\u00d1\u00e5\u0090\u00c2\u0017\u001d\u001bgv\u00b3\u00bf\u00ec+\u00c4(\u00f0\u00d1\u0084\u0012s\u00a1<\u00a3/P\u00e9\u0080u\u00825\u00b1\u00b6\u00ab\b(\u00d4\u00a3\u00dbG\n\u0016U1KD\\v\u00be\u0007\u00c1.\u00dc?\u00ff\u00d7\u0018c|\n\u00aec\u008f\u0097>\u0084y\u00b8\u0015\u0086\u001f:\u0011\u00a8\u001bS".length();
                                var5_7 = 40;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 1.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    1.f = var9_3;
                    1.g = new String[12];
                }

                private static MatchException a(MatchException matchException) {
                    return matchException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x2D11;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$1", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        1.g[n2] = 1.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 1.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$1" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.DESCRIPTIVE = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                /*
                 * Exception decompiling
                 */
                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    block33: {
                        int n;
                        block31: {
                            block32: {
                                String[] stringArray;
                                block29: {
                                    String string2;
                                    block30: {
                                        long l;
                                        block27: {
                                            String string3;
                                            block28: {
                                                block25: {
                                                    String string4;
                                                    block26: {
                                                        SshConfig sshConfig;
                                                        block23: {
                                                            block24: {
                                                                l = b ^ 0x7CA3515E98F7L;
                                                                stringArray = SshConfig.h();
                                                                try {
                                                                    try {
                                                                        sshConfig = config;
                                                                        if (stringArray != null) break block23;
                                                                        if (sshConfig != null) break block24;
                                                                    }
                                                                    catch (MatchException matchException) {
                                                                        throw 2.a(matchException);
                                                                    }
                                                                    2.$$$reportNull$$$0(2);
                                                                }
                                                                catch (MatchException matchException) {
                                                                    throw 2.a(matchException);
                                                                }
                                                            }
                                                            sshConfig = config;
                                                        }
                                                        string4 = sshConfig.getUsername();
                                                        string3 = config.getHost();
                                                        string2 = config.getLiteralPort();
                                                        try {
                                                            try {
                                                                object4 = string4;
                                                                if (stringArray != null) break block25;
                                                                if (!StringUtil.isEmpty((String)object4)) break block26;
                                                            }
                                                            catch (MatchException matchException) {
                                                                throw 2.a(matchException);
                                                            }
                                                            object4 = "<" + SshApiBundle.message((String)((Object)2.b("m", (int)1112, (long)(0x5D8B4247835FA986L ^ l))), new Object[0]) + ">";
                                                            break block25;
                                                        }
                                                        catch (MatchException matchException) {
                                                            throw 2.a(matchException);
                                                        }
                                                    }
                                                    object4 = string4;
                                                }
                                                try {
                                                    try {
                                                        object3 = string3;
                                                        if (stringArray != null) break block27;
                                                        if (!StringUtil.isEmpty((String)object3)) break block28;
                                                    }
                                                    catch (MatchException matchException) {
                                                        throw 2.a(matchException);
                                                    }
                                                    object3 = "<" + SshApiBundle.message((String)((Object)2.b("m", (int)16242, (long)(0x3DF88478BD2312ABL ^ l))), new Object[0]) + ">";
                                                    break block27;
                                                }
                                                catch (MatchException matchException) {
                                                    throw 2.a(matchException);
                                                }
                                            }
                                            object3 = string3;
                                        }
                                        try {
                                            try {
                                                object2 = string2;
                                                if (stringArray != null) break block29;
                                                if (!StringUtil.isEmpty((String)object2)) break block30;
                                            }
                                            catch (MatchException matchException) {
                                                throw 2.a(matchException);
                                            }
                                            object2 = "<" + SshApiBundle.message((String)((Object)2.b("m", (int)19222, (long)(0x66455986F8CDE6CEL ^ l))), new Object[0]) + ">";
                                            break block29;
                                        }
                                        catch (MatchException matchException) {
                                            throw 2.a(matchException);
                                        }
                                    }
                                    object2 = string2;
                                }
                                try {
                                    try {
                                        n = config.getLocalPort();
                                        if (stringArray != null) break block31;
                                        if (n != -1) break block32;
                                    }
                                    catch (MatchException matchException) {
                                        throw 2.a(matchException);
                                    }
                                    object = "";
                                    break block33;
                                }
                                catch (MatchException matchException) {
                                    throw 2.a(matchException);
                                }
                            }
                            n = config.getLocalPort();
                        }
                        object = ":" + n;
                    }
                    try {
                        string = (String)object4 + "@" + (String)object3 + ":" + (String)object2 + (String)object;
                        if (string == null) {
                            2.$$$reportNull$$$0(3);
                        }
                    }
                    catch (MatchException matchException) {
                        throw 2.a(matchException);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                @Nls
                @NotNull
                public String getPresentableAddition(@NotNull SshConfig config) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            2.b = com.jetbrains.gateway.ssh.deploy.c.a(2809454272930693943L, -7645664294414803528L, MethodHandles.lookup().lookupClass()).a(198231443071969L);
                            2.h = new HashMap<K, V>(13);
                            var0 = 2.b ^ 116338862919720L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[20];
                            var7_4 = 0;
                            var6_5 = "v\u00ebn\u00cf6\u0098\u009e\u00e0a\u00c7>\u0092\u008a\u00aa\u0096\u00cdw\u00c5TD\u00b1\u00e2\f\u00fe#\u009e\u0095\u0012\u001c{B\u00cb\u0010\u00b9j\u00960\u00b4\u0014v\u0088C\u00c8\u00b7\u00ca\u00dd\u00c8\u00c2\u00fe\u0010lq\u0001a\u00b2S\u001d\u00f7\u00c3q\u0091\u00a5\u00e0\r8\u00c1Xz\u001be\u00d96z\u0018[\u0080\u0083M\u00e6\u00ed~\u00d7\u009f\u0018\u008f\u00ff\u0085@\u0084;\u0091\u0019v\u000b\u000e\u00d5\u00cfz\u00c6B+\u0005(\u008dG\u0085\u0090\u00ea@\u001e\u0099L\u00af\u008e\u0095\u00c0UV\u00fcx\u00d8\u00e4v`\u0088\u00e0\u00fd\u00d7\u00a9\u0013\u0014\u00cf\u00ec\u0086\u000e\u00cbI\u00a0\u00e4&\u00bd\u008a\u00b7r\r/\u00fe%\u001b\u00ae\u00d7\"\u0081\u00be\u009fX\u00dc2,\u009d\u009fP\u00f0\u0017\u001fR\u0007\u00ecS{\u0085\u0083\u00a0\u00f0\u0005_8\u00d3u\u00e0\u0099\u008bL\u00fa\u00c3B.]\u00a6\u00f9U\u00cc\u00d8\u008b\u00e3#q\u0098Y\u00d3D\u00b4\u0014\u00d6\u001dL(\u00dd3\u00f3fJq\u000e#\u00c4\u00a8\u00a2\u007f\u00b6\u00c9r\u00d5-A^\u00ac\u00d1_\u00c9\u00d1'\f\u008f\u00a8\u0000/D\u0097\u00803H\u00e6=H\b\u00dcJ\u00dc\u00fd>v\u0002\u0098\u0002\u00b6\u00ec\u00f8u\u0080\u00ef\u000b\"\u00b4\u00c1\u00f6\u0084\u00c0\u0097N\u0005\u00e6\u00ef])\u00b0r\u00d5\u0011\u0095O\u00e0g\u001c/\u00e2{u\u00ca8\u008d\u0094\u00aa\u000b\u00ec\u00ed\u00c1(\u00a6\u00f5\u00f7\u00b5\u00a3\u0096}\u00cav\u00afG\u00e9O9\u00cdG\u0092\u009c[H\u00f1\u0086U\u00a3\u00e7.\u00f6q$\u0011Z\u008d\u001c\u00df(XW\u00db\u0004\u00df\u0006;6ql\u0093-\u0003~\u00bc\u00a6\u00e6\\\u00d0/)\u00da!\u00d3\u00f2\u00fb\u009a0\u00b4\u00ebQ\u0082\u00a7\u00cc\u00ef6\b\u0085\u00be\u00da\u0003\u00ca\u0002\u009fU\u00b8U\u0003`FD\u00cd#N\u00b6\u00adV@\u0016c\u007fEV\r\u00ae\u00ec\u007fub\u007f\u0088@Q\u0019\u00a5\u00c2%3\u00ea\u00c4 \u00ef\u00ac\u00e2\u00c6\u00f3\u0099n\u00f8\u001c\u00c98\u0088\u008bZ@\b\u0003F\u00c9\u00ec\u00b1\u00177\u00c5\u0080\u0097\u0082\u009e\u0080\u00d5\u00e7\u00c3\u00a5\u0015Vr~ ;\u00db\u0092H\u00b9\u00c6\u0082D\u00e7\u0001\u00c7W\u0001\u00f8=\u0003@\u0090;\u00d2\u00c7kJ\u00cc\u00fa!Nr\u00b1\u00dce/\u00c1\u00abNx\u001d#\u00a4\u00d1\u009b\u00c7~%F\u0011\u00e9\u00c5j]YS\u001f\u00c7\u00cc&b\u00a8\u00df\u00ea\u008d\u00d8)\u0003O\u00c9\u00f1\u00be\u001f\u00d0\u00ec\u00bc\u00bfL4\u0016`056\u00da\u00b7\u0003\u00a3o\u00e8\u0012%\u00ca\u0083\u0006\u00c1\u00cc4\u008b\u0017H5Rk\fR\u00b9\u0016<\u00af\u00b68\u00d9\u0092j8\u00aa\u0089\u00a2\u00feJ\u00a8\u00c3\u00f1\u00e5\u00a1\u0006\"E\u00b3\u00a5\u00b5`\u00f00\u00ffF7\u00828B>f\u00a5\u0014\u00a6\u00d2R\u00d37\u00f5?h\u00c2 F`\u0082^*\u00d3\u00be#&;\u00d9\u0016\u001c\u00fa\u00b54\u00fc\u00c7\u00b8\u0081\b\u00e6H2g\u00aa\u00f4\u00c3UU\u00d1\u00bb\u008a6>o\u00ad\u00fea:\u00ffg\u009a6\u00e3\u009f\u009f\u0018,\u00f0\u00e8\u00f6\u00f5\u00df\u00b0\u009a\u00fb\u00e6\u0087\u00ceU\u00f2$\u0084\u0015\u0016\u009e\u00ad4o\u00e3\u00ec\u0004?\u008ekIT^\u0089\u0006\u00c6N\u00bb]8\u00dfz\u00e37\u0002\u00a0\u00d7\u00d3\u0089\u0010\u00f4\u00d4\u001d7C-)Tq/\u00cc\u0094\u001f\u00c5\u00a9\u00aaP\u007f[\u00ed\u00d8)N\u0096\u0095\u00f9\u0005\u00d6\u008c\u00fc\u001c\u00b3E\u00e8\u00ee\u00e5\u00a4\u001f#\u0085\u001d\u00b9.2\u00da\u00d4\u00d2\u0015L\u0080\u0013\u009e3\u00af\u00c80j\u00d7I#\u00e3\u00c1\u00e0\u00f1D5|\u00c9\u00d1\f\u00e7\u000b\u000e\u00f4\u00cbA+u\u00de\u0007\u00c6uhh.\u00c3B\u00f9\u0010\u0010\u0086\"T\u0001r\u00a8L`\u00aa\u00f3fr\u00c6\u00b1\u0015\u00a5_s\u00e9\u00de\u0016\u00ed\u0000\u008e\u00ec|O\u00ddt\u00fb{0P\u00b7u\u0019\u0095\u00e1-\u00d0\u00b8@\u0082\u00a1-\r\u0084\u0093\u00ea\u00d2\u00e9\u009a\\L9\u008d\u008a+\u00a7\u00f1\u00c9\u00f8l\u00f8\u0097n\u0080zt\u00d7N\u00c8\u0007\u00e3\u00de,\u00fa\u0010\u00ba6\u0005?\r\u00da\u00a7\u00a6#\u0084}\u0005&\u0012\u0006d#^ml\u00ef\u001e\u00e9d\u00e8U\u0010v\u0006\u00dc\u0006\u00d5*\u00fb\u001a-\u00f6\u00f81G\u00d8\u00180(V\u00f5^\u00ca\u00a3\u0010\u00b3\u00bf[\u0012\u00992*\u00f5\"\u0003\u00a8VC\u00bb\u00daz\u00eb\u0091\u00c1D\u00de\u00b2\\dI-p\u0013?\t\u00cd\b\u00a6((\u00d3{\u00e8\u0091[:\u00eb\u00f9\u0011\u00b2\u0005\u00f8V\u00f0\u0081\u00b2\u00b8\u0005\u001a\u00df\u0001q\u0010M\u00ef\u0094\u0081To\u00f6D5'\u000e'\u000f\u00cat\u009e_\u0010\u009a\u0096\u0095o\u00f3\u0095l\u0082=\u0097\u00dc\u00f1\u00e8^/\u00c4";
                            var8_6 = "v\u00ebn\u00cf6\u0098\u009e\u00e0a\u00c7>\u0092\u008a\u00aa\u0096\u00cdw\u00c5TD\u00b1\u00e2\f\u00fe#\u009e\u0095\u0012\u001c{B\u00cb\u0010\u00b9j\u00960\u00b4\u0014v\u0088C\u00c8\u00b7\u00ca\u00dd\u00c8\u00c2\u00fe\u0010lq\u0001a\u00b2S\u001d\u00f7\u00c3q\u0091\u00a5\u00e0\r8\u00c1Xz\u001be\u00d96z\u0018[\u0080\u0083M\u00e6\u00ed~\u00d7\u009f\u0018\u008f\u00ff\u0085@\u0084;\u0091\u0019v\u000b\u000e\u00d5\u00cfz\u00c6B+\u0005(\u008dG\u0085\u0090\u00ea@\u001e\u0099L\u00af\u008e\u0095\u00c0UV\u00fcx\u00d8\u00e4v`\u0088\u00e0\u00fd\u00d7\u00a9\u0013\u0014\u00cf\u00ec\u0086\u000e\u00cbI\u00a0\u00e4&\u00bd\u008a\u00b7r\r/\u00fe%\u001b\u00ae\u00d7\"\u0081\u00be\u009fX\u00dc2,\u009d\u009fP\u00f0\u0017\u001fR\u0007\u00ecS{\u0085\u0083\u00a0\u00f0\u0005_8\u00d3u\u00e0\u0099\u008bL\u00fa\u00c3B.]\u00a6\u00f9U\u00cc\u00d8\u008b\u00e3#q\u0098Y\u00d3D\u00b4\u0014\u00d6\u001dL(\u00dd3\u00f3fJq\u000e#\u00c4\u00a8\u00a2\u007f\u00b6\u00c9r\u00d5-A^\u00ac\u00d1_\u00c9\u00d1'\f\u008f\u00a8\u0000/D\u0097\u00803H\u00e6=H\b\u00dcJ\u00dc\u00fd>v\u0002\u0098\u0002\u00b6\u00ec\u00f8u\u0080\u00ef\u000b\"\u00b4\u00c1\u00f6\u0084\u00c0\u0097N\u0005\u00e6\u00ef])\u00b0r\u00d5\u0011\u0095O\u00e0g\u001c/\u00e2{u\u00ca8\u008d\u0094\u00aa\u000b\u00ec\u00ed\u00c1(\u00a6\u00f5\u00f7\u00b5\u00a3\u0096}\u00cav\u00afG\u00e9O9\u00cdG\u0092\u009c[H\u00f1\u0086U\u00a3\u00e7.\u00f6q$\u0011Z\u008d\u001c\u00df(XW\u00db\u0004\u00df\u0006;6ql\u0093-\u0003~\u00bc\u00a6\u00e6\\\u00d0/)\u00da!\u00d3\u00f2\u00fb\u009a0\u00b4\u00ebQ\u0082\u00a7\u00cc\u00ef6\b\u0085\u00be\u00da\u0003\u00ca\u0002\u009fU\u00b8U\u0003`FD\u00cd#N\u00b6\u00adV@\u0016c\u007fEV\r\u00ae\u00ec\u007fub\u007f\u0088@Q\u0019\u00a5\u00c2%3\u00ea\u00c4 \u00ef\u00ac\u00e2\u00c6\u00f3\u0099n\u00f8\u001c\u00c98\u0088\u008bZ@\b\u0003F\u00c9\u00ec\u00b1\u00177\u00c5\u0080\u0097\u0082\u009e\u0080\u00d5\u00e7\u00c3\u00a5\u0015Vr~ ;\u00db\u0092H\u00b9\u00c6\u0082D\u00e7\u0001\u00c7W\u0001\u00f8=\u0003@\u0090;\u00d2\u00c7kJ\u00cc\u00fa!Nr\u00b1\u00dce/\u00c1\u00abNx\u001d#\u00a4\u00d1\u009b\u00c7~%F\u0011\u00e9\u00c5j]YS\u001f\u00c7\u00cc&b\u00a8\u00df\u00ea\u008d\u00d8)\u0003O\u00c9\u00f1\u00be\u001f\u00d0\u00ec\u00bc\u00bfL4\u0016`056\u00da\u00b7\u0003\u00a3o\u00e8\u0012%\u00ca\u0083\u0006\u00c1\u00cc4\u008b\u0017H5Rk\fR\u00b9\u0016<\u00af\u00b68\u00d9\u0092j8\u00aa\u0089\u00a2\u00feJ\u00a8\u00c3\u00f1\u00e5\u00a1\u0006\"E\u00b3\u00a5\u00b5`\u00f00\u00ffF7\u00828B>f\u00a5\u0014\u00a6\u00d2R\u00d37\u00f5?h\u00c2 F`\u0082^*\u00d3\u00be#&;\u00d9\u0016\u001c\u00fa\u00b54\u00fc\u00c7\u00b8\u0081\b\u00e6H2g\u00aa\u00f4\u00c3UU\u00d1\u00bb\u008a6>o\u00ad\u00fea:\u00ffg\u009a6\u00e3\u009f\u009f\u0018,\u00f0\u00e8\u00f6\u00f5\u00df\u00b0\u009a\u00fb\u00e6\u0087\u00ceU\u00f2$\u0084\u0015\u0016\u009e\u00ad4o\u00e3\u00ec\u0004?\u008ekIT^\u0089\u0006\u00c6N\u00bb]8\u00dfz\u00e37\u0002\u00a0\u00d7\u00d3\u0089\u0010\u00f4\u00d4\u001d7C-)Tq/\u00cc\u0094\u001f\u00c5\u00a9\u00aaP\u007f[\u00ed\u00d8)N\u0096\u0095\u00f9\u0005\u00d6\u008c\u00fc\u001c\u00b3E\u00e8\u00ee\u00e5\u00a4\u001f#\u0085\u001d\u00b9.2\u00da\u00d4\u00d2\u0015L\u0080\u0013\u009e3\u00af\u00c80j\u00d7I#\u00e3\u00c1\u00e0\u00f1D5|\u00c9\u00d1\f\u00e7\u000b\u000e\u00f4\u00cbA+u\u00de\u0007\u00c6uhh.\u00c3B\u00f9\u0010\u0010\u0086\"T\u0001r\u00a8L`\u00aa\u00f3fr\u00c6\u00b1\u0015\u00a5_s\u00e9\u00de\u0016\u00ed\u0000\u008e\u00ec|O\u00ddt\u00fb{0P\u00b7u\u0019\u0095\u00e1-\u00d0\u00b8@\u0082\u00a1-\r\u0084\u0093\u00ea\u00d2\u00e9\u009a\\L9\u008d\u008a+\u00a7\u00f1\u00c9\u00f8l\u00f8\u0097n\u0080zt\u00d7N\u00c8\u0007\u00e3\u00de,\u00fa\u0010\u00ba6\u0005?\r\u00da\u00a7\u00a6#\u0084}\u0005&\u0012\u0006d#^ml\u00ef\u001e\u00e9d\u00e8U\u0010v\u0006\u00dc\u0006\u00d5*\u00fb\u001a-\u00f6\u00f81G\u00d8\u00180(V\u00f5^\u00ca\u00a3\u0010\u00b3\u00bf[\u0012\u00992*\u00f5\"\u0003\u00a8VC\u00bb\u00daz\u00eb\u0091\u00c1D\u00de\u00b2\\dI-p\u0013?\t\u00cd\b\u00a6((\u00d3{\u00e8\u0091[:\u00eb\u00f9\u0011\u00b2\u0005\u00f8V\u00f0\u0081\u00b2\u00b8\u0005\u001a\u00df\u0001q\u0010M\u00ef\u0094\u0081To\u00f6D5'\u000e'\u000f\u00cat\u009e_\u0010\u009a\u0096\u0095o\u00f3\u0095l\u0082=\u0097\u00dc\u00f1\u00e8^/\u00c4".length();
                            var5_7 = 32;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 2.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "\u00dc\u00e5>\u0014\u0087gC\u00fbG\u00e0\u0095\n\u00cavY\b\u0015a\u0014]\u00d5\u00eeoMs-\u00dc\u000f\u00f9\u00d9\u00a1\u00d6(\u000b\u00b4\u00bey\u00bb\u00fc\u009b\u00f5\u00d0\u0017\u00c9\u0085\u0097x\u001f>Z\u00b0\u00edS\u00e7\u00ce^5\u0001F\u009c\u00b6\u0017|\u008e\"\u0019\u0016,+\u00de9\u00be\u00c6";
                                var8_6 = "\u00dc\u00e5>\u0014\u0087gC\u00fbG\u00e0\u0095\n\u00cavY\b\u0015a\u0014]\u00d5\u00eeoMs-\u00dc\u000f\u00f9\u00d9\u00a1\u00d6(\u000b\u00b4\u00bey\u00bb\u00fc\u009b\u00f5\u00d0\u0017\u00c9\u0085\u0097x\u001f>Z\u00b0\u00edS\u00e7\u00ce^5\u0001F\u009c\u00b6\u0017|\u008e\"\u0019\u0016,+\u00de9\u00be\u00c6".length();
                                var5_7 = 32;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 2.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    2.f = var9_3;
                    2.g = new String[20];
                }

                private static MatchException a(MatchException matchException) {
                    return matchException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x4B3D;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$2", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        2.g[n2] = 2.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 2.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$2" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.CUSTOM = new NameFormat(){
                private static final long b;
                private static final String[] f;
                private static final String[] g;
                private static final Map h;

                @Override
                @NonNls
                @NotNull
                public String getName(@NotNull SshConfig config) {
                    String string;
                    String string2;
                    block15: {
                        block16: {
                            String string3;
                            block17: {
                                SshConfig sshConfig;
                                String[] stringArray;
                                block13: {
                                    block14: {
                                        long l = b ^ 0x406EA3E045BDL;
                                        stringArray = SshConfig.h();
                                        try {
                                            try {
                                                sshConfig = config;
                                                if (stringArray != null) break block13;
                                                if (sshConfig != null) break block14;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw 3.b(illegalArgumentException);
                                            }
                                            3.$$$reportNull$$$0(0);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                    }
                                    sshConfig = config;
                                }
                                try {
                                    try {
                                        try {
                                            string2 = sshConfig.myCustomName;
                                            if (stringArray != null) break block15;
                                            if (string2 == null) break block16;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        string3 = config.myCustomName;
                                        if (string3 != null) break block17;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                    3.$$$reportNull$$$0(1);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                            }
                            return string3;
                        }
                        string2 = DESCRIPTIVE.getName(config);
                    }
                    try {
                        string = string2;
                        if (string2 == null) {
                            3.$$$reportNull$$$0(2);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 3.b(illegalArgumentException);
                    }
                    return string;
                }

                @Override
                @Nls
                @NotNull
                public String getPresentableShortName(@NotNull SshConfig config) {
                    String string;
                    String string2;
                    block15: {
                        block16: {
                            String string3;
                            block17: {
                                SshConfig sshConfig;
                                String[] stringArray;
                                block13: {
                                    block14: {
                                        long l = b ^ 0x52EB83FDB7B8L;
                                        stringArray = SshConfig.h();
                                        try {
                                            try {
                                                sshConfig = config;
                                                if (stringArray != null) break block13;
                                                if (sshConfig != null) break block14;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw 3.b(illegalArgumentException);
                                            }
                                            3.$$$reportNull$$$0(3);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                    }
                                    sshConfig = config;
                                }
                                try {
                                    try {
                                        try {
                                            string2 = sshConfig.myCustomName;
                                            if (stringArray != null) break block15;
                                            if (string2 == null) break block16;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        string3 = config.myCustomName;
                                        if (string3 != null) break block17;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                    3.$$$reportNull$$$0(4);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                            }
                            return string3;
                        }
                        string2 = DESCRIPTIVE.getPresentableShortName(config);
                    }
                    try {
                        string = string2;
                        if (string2 == null) {
                            3.$$$reportNull$$$0(5);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 3.b(illegalArgumentException);
                    }
                    return string;
                }

                @Override
                @Nls
                @Nullable
                public String getPresentableAddition(@NotNull SshConfig config) {
                    String string;
                    block10: {
                        block11: {
                            SshConfig sshConfig;
                            String[] stringArray;
                            block8: {
                                block9: {
                                    long l = b ^ 0xD8A55FC9D4BL;
                                    stringArray = SshConfig.h();
                                    try {
                                        try {
                                            sshConfig = config;
                                            if (stringArray != null) break block8;
                                            if (sshConfig != null) break block9;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw 3.b(illegalArgumentException);
                                        }
                                        3.$$$reportNull$$$0(6);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw 3.b(illegalArgumentException);
                                    }
                                }
                                sshConfig = config;
                            }
                            try {
                                try {
                                    string = sshConfig.myCustomName;
                                    if (stringArray != null) break block10;
                                    if (string == null) break block11;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw 3.b(illegalArgumentException);
                                }
                                return null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw 3.b(illegalArgumentException);
                            }
                        }
                        string = DESCRIPTIVE.getPresentableAddition(config);
                    }
                    return string;
                }

                /*
                 * Exception decompiling
                 */
                private static /* synthetic */ void $$$reportNull$$$0(int var0) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SWITCH]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block11: {
                        block10: {
                            3.b = com.jetbrains.gateway.ssh.deploy.c.a(5135457538475862392L, -945223807910073747L, MethodHandles.lookup().lookupClass()).a(264164273811382L);
                            3.h = new HashMap<K, V>(13);
                            var0 = 3.b ^ 107887887031132L;
                            var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                            v0 = SecretKeyFactory.getInstance("DES");
                            v1 = new byte[8];
                            v2 = v1;
                            v1[0] = (byte)(var0 >>> 56);
                            for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                                v2 = v2;
                                v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                            }
                            var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                            var9_3 = new String[10];
                            var7_4 = 0;
                            var6_5 = "5?E\u00a6\u00e5\u0006^c\u009ff\u009c\u0005*Kn\fL\u0087KL\fz\u0018f\u00e5 \u0000\u0087\u0010\u0000\u00ee\u00e9\u00e8\u009c@\u009c;\u0017\u007fm'\u00ef\u00a4\u000f\u00d1I\u00d6\u00bb\u0093\u00d2\u00f9o~!\u00cb\u00929R\u001a\u0018\u001em\u00a7\u00f1\u00ee\u00bc\u00c0gu\u0087r7V\u00b2\u00d7V\u000f<\u0001\u00c2\u00ad\u00ce4\u00068\u00a7\u00f2\u000b@\u001c\u00cd\u00c6\u00ec\u00d9[\u00e0\u00b4\u00b3\u000b\u00dabE\u001d\u0080PQ\u008b\u00d3\u008a\u00c3F%\u00f2\u0096\u00e0\u00b1\u00c0\u000e\u009b]dr%B\u0012\u00d1\u009c\u00b0\u0084h\u00e6\u008ePwP\u0012Z\u00cfK\u00deQ$\u00fc\u00e0\u0094e\u00be\u00e9\u00c1(Z_\u0014\u0007\u000f(\t\u00fdp\u00d3q\u0095y0R\u00cb\u009bcF\u00b4\u00f2\u00e4\u00c8\u00ff1\u0017\u00e4N\u0086\u00b6\u0088\u00b6\u000bM\t\u0010\u0098\u008a\u00d3\u00cfB\u00ba\u00d3\u0010\u00f9\u00aej\u000f\u00b7\u0007\u00d1\u008eXs\u0092\u001e\u00a9\u00b0\u008bN/+7O\u0000Rd\u0007v\u00a5\u008d\u00ba\u00e2\u00d5\u001e\u00a3\u00afK\u00ae\u00d2\u00c45\"Q\u00bdw\u00ad\u0014YawZ\u00a4\u0090\u00f1\u008a\u00aeLje&`&B\u000b\u00d3\u00f7H\u0011f\u00df4m\u00f7N\u00e3\u0019\u00da\u0090m\u00f7\u0002k\u0089\u00ad>\u00e7\u00d8\u00f7\u00e6;2\u00ff\u00e6\u00bc(\u0002\u008a\u00deL\u0092X.\u00e7\u00d0\u00d3_8\u0081\u00f1\u0019F\u00049\u0088\u00f2\u008c\u00c1*\u00c1\u00de\u0095\u00fa\u0097\u00e8<\u00e1\u001f\u00ce\u000e7M|\u00e3F\u0091l\u00c6o\u00ea- \u001bz\u001d\u00f9^5\u00ce7.\u00e6((\u0018A\u00f7r?\u00c3\u008ety\u008a\u0004\u00d7|D\u00c1\u0080\u00e9\u00b4\fL$\u00a9\u00a3\u00a1\u000b\u00aa\u00e8\u00f7\u00bf.\u00a7\u0011\u00b2<'i\u0010\u00ec\u00f22w\u0001\u00f9!K\u00de\u00ee`G\u0082@\u00a46(?\fr\u00f1\u0000\u00b9a-\u0012 \u0092\u0096\u008e6\u009e\u00fc\u00b9\u00b1\u00f9F\u00d4<P\u0016;\t\r\u00fc\u00a8\u0095!&@v\u0085C\u0003J\u001e\u0016\u0010\u00cdx\u0001\u0083\u00f9?\u00c8l\u008c\u0092\u00fd\u009d\fe\u00cf\u00fb";
                            var8_6 = "5?E\u00a6\u00e5\u0006^c\u009ff\u009c\u0005*Kn\fL\u0087KL\fz\u0018f\u00e5 \u0000\u0087\u0010\u0000\u00ee\u00e9\u00e8\u009c@\u009c;\u0017\u007fm'\u00ef\u00a4\u000f\u00d1I\u00d6\u00bb\u0093\u00d2\u00f9o~!\u00cb\u00929R\u001a\u0018\u001em\u00a7\u00f1\u00ee\u00bc\u00c0gu\u0087r7V\u00b2\u00d7V\u000f<\u0001\u00c2\u00ad\u00ce4\u00068\u00a7\u00f2\u000b@\u001c\u00cd\u00c6\u00ec\u00d9[\u00e0\u00b4\u00b3\u000b\u00dabE\u001d\u0080PQ\u008b\u00d3\u008a\u00c3F%\u00f2\u0096\u00e0\u00b1\u00c0\u000e\u009b]dr%B\u0012\u00d1\u009c\u00b0\u0084h\u00e6\u008ePwP\u0012Z\u00cfK\u00deQ$\u00fc\u00e0\u0094e\u00be\u00e9\u00c1(Z_\u0014\u0007\u000f(\t\u00fdp\u00d3q\u0095y0R\u00cb\u009bcF\u00b4\u00f2\u00e4\u00c8\u00ff1\u0017\u00e4N\u0086\u00b6\u0088\u00b6\u000bM\t\u0010\u0098\u008a\u00d3\u00cfB\u00ba\u00d3\u0010\u00f9\u00aej\u000f\u00b7\u0007\u00d1\u008eXs\u0092\u001e\u00a9\u00b0\u008bN/+7O\u0000Rd\u0007v\u00a5\u008d\u00ba\u00e2\u00d5\u001e\u00a3\u00afK\u00ae\u00d2\u00c45\"Q\u00bdw\u00ad\u0014YawZ\u00a4\u0090\u00f1\u008a\u00aeLje&`&B\u000b\u00d3\u00f7H\u0011f\u00df4m\u00f7N\u00e3\u0019\u00da\u0090m\u00f7\u0002k\u0089\u00ad>\u00e7\u00d8\u00f7\u00e6;2\u00ff\u00e6\u00bc(\u0002\u008a\u00deL\u0092X.\u00e7\u00d0\u00d3_8\u0081\u00f1\u0019F\u00049\u0088\u00f2\u008c\u00c1*\u00c1\u00de\u0095\u00fa\u0097\u00e8<\u00e1\u001f\u00ce\u000e7M|\u00e3F\u0091l\u00c6o\u00ea- \u001bz\u001d\u00f9^5\u00ce7.\u00e6((\u0018A\u00f7r?\u00c3\u008ety\u008a\u0004\u00d7|D\u00c1\u0080\u00e9\u00b4\fL$\u00a9\u00a3\u00a1\u000b\u00aa\u00e8\u00f7\u00bf.\u00a7\u0011\u00b2<'i\u0010\u00ec\u00f22w\u0001\u00f9!K\u00de\u00ee`G\u0082@\u00a46(?\fr\u00f1\u0000\u00b9a-\u0012 \u0092\u0096\u008e6\u009e\u00fc\u00b9\u00b1\u00f9F\u00d4<P\u0016;\t\r\u00fc\u00a8\u0095!&@v\u0085C\u0003J\u001e\u0016\u0010\u00cdx\u0001\u0083\u00f9?\u00c8l\u008c\u0092\u00fd\u009d\fe\u00cf\u00fb".length();
                            var5_7 = 104;
                            var4_8 = -1;
lbl20:
                            // 2 sources

                            while (true) {
                                v3 = ++var4_8;
                                v4 = var6_5.substring(v3, v3 + var5_7);
                                v5 = -1;
                                break block10;
                                break;
                            }
lbl25:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 3.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                var6_5 = "\u00e4P\u00fd\u001ed\u00e3\u0088\u00e5i\u00bc\u00d1j(\u00a9\u0017\u0016v.1;}i\u00e6\u0080\u00f2\u00f7\u0095\u00de\u00c1f3\u0099\u009b8\u00f8\u0095h\u00ad[\u00b8(PN\u009b9\u00ef\u00a6\u00eef~\u00e07\u00a4\u00f3\u00e5,\u00bcU!\u00a7\u00b6\u00faK\u001c\b\u00ac!b.~\u00d8M\u00f6\u00cf\u00bc\u00fb2fu-\u00c8";
                                var8_6 = "\u00e4P\u00fd\u001ed\u00e3\u0088\u00e5i\u00bc\u00d1j(\u00a9\u0017\u0016v.1;}i\u00e6\u0080\u00f2\u00f7\u0095\u00de\u00c1f3\u0099\u009b8\u00f8\u0095h\u00ad[\u00b8(PN\u009b9\u00ef\u00a6\u00eef~\u00e07\u00a4\u00f3\u00e5,\u00bcU!\u00a7\u00b6\u00faK\u001c\b\u00ac!b.~\u00d8M\u00f6\u00cf\u00bc\u00fb2fu-\u00c8".length();
                                var5_7 = 40;
                                var4_8 = -1;
lbl34:
                                // 2 sources

                                while (true) {
                                    v6 = ++var4_8;
                                    v4 = var6_5.substring(v6, v6 + var5_7);
                                    v5 = 0;
                                    break block10;
                                    break;
                                }
                                break;
                            }
lbl39:
                            // 1 sources

                            while (true) {
                                var9_3[var7_4++] = 3.b(var10_9).intern();
                                if ((var4_8 += var5_7) < var8_6) {
                                    var5_7 = var6_5.charAt(var4_8);
                                    ** continue;
                                }
                                break block11;
                                break;
                            }
                        }
                        var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                        switch (v5) {
                            default: {
                                ** continue;
                            }
                            ** case 0:
lbl51:
                            // 1 sources

                            ** continue;
                        }
                    }
                    3.f = var9_3;
                    3.g = new String[10];
                }

                private static IllegalArgumentException b(IllegalArgumentException illegalArgumentException) {
                    return illegalArgumentException;
                }

                private static String b(byte[] byArray) {
                    int n = 0;
                    int n2 = byArray.length;
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        char c2;
                        int n3 = 0xFF & byArray[i];
                        if (n3 < 192) {
                            cArray[n++] = (char)n3;
                            continue;
                        }
                        if (n3 < 224) {
                            c2 = (char)((char)(n3 & 0x1F) << 6);
                            n3 = byArray[++i];
                            c2 = (char)(c2 | (char)(n3 & 0x3F));
                            cArray[n++] = c2;
                            continue;
                        }
                        if (i >= n2 - 2) continue;
                        c2 = (char)((char)(n3 & 0xF) << 12);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                        n3 = byArray[++i];
                        c2 = (char)(c2 | (char)(n3 & 0x3F));
                        cArray[n++] = c2;
                    }
                    return new String(cArray, 0, n);
                }

                private static String b(int n, long l) {
                    int n2 = n ^ (int)(l & 0x7FFFL) ^ 0xDFB;
                    if (g[n2] == null) {
                        Object[] objectArray;
                        try {
                            Long l2 = Thread.currentThread().getId();
                            objectArray = (Object[])h.get(l2);
                            if (objectArray == null) {
                                objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                                h.put(l2, objectArray);
                            }
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$3", exception);
                        }
                        byte[] byArray = new byte[8];
                        byArray[0] = (byte)(l >>> 56);
                        for (int i = 1; i < 8; ++i) {
                            byArray[i] = (byte)(l << i * 8 >>> 56);
                        }
                        DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                        SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                        ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                        byte[] byArray2 = f[n2].getBytes("ISO-8859-1");
                        3.g[n2] = 3.b(((Cipher)objectArray[0]).doFinal(byArray2));
                    }
                    return g[n2];
                }

                private static Object b(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
                    int n = (Integer)objectArray[0];
                    long l = (Long)objectArray[1];
                    String string2 = 3.b(n, l);
                    MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
                    mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
                    return string2;
                }

                private static CallSite b(MethodHandles.Lookup lookup, String string, MethodType methodType) {
                    MutableCallSite mutableCallSite = new MutableCallSite(methodType);
                    try {
                        mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat$3" + " : " + string + " : " + methodType.toString(), exception);
                    }
                    return mutableCallSite;
                }
            };
            NameFormat.$VALUES = NameFormat.$values();
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void $$$reportNull$$$0(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }

        private static String a(byte[] byArray) {
            int n = 0;
            int n2 = byArray.length;
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c2;
                int n3 = 0xFF & byArray[i];
                if (n3 < 192) {
                    cArray[n++] = (char)n3;
                    continue;
                }
                if (n3 < 224) {
                    c2 = (char)((char)(n3 & 0x1F) << 6);
                    n3 = byArray[++i];
                    c2 = (char)(c2 | (char)(n3 & 0x3F));
                    cArray[n++] = c2;
                    continue;
                }
                if (i >= n2 - 2) continue;
                c2 = (char)((char)(n3 & 0xF) << 12);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
            }
            return new String(cArray, 0, n);
        }

        private static String a(int n, long l) {
            int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x4C59;
            if (d[n2] == null) {
                Object[] objectArray;
                try {
                    Long l2 = Thread.currentThread().getId();
                    objectArray = (Object[])e.get(l2);
                    if (objectArray == null) {
                        objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                        e.put(l2, objectArray);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat", exception);
                }
                byte[] byArray = new byte[8];
                byArray[0] = (byte)(l >>> 56);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l << i * 8 >>> 56);
                }
                DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                byte[] byArray2 = c[n2].getBytes("ISO-8859-1");
                NameFormat.d[n2] = NameFormat.a(((Cipher)objectArray[0]).doFinal(byArray2));
            }
            return d[n2];
        }

        private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
            int n = (Integer)objectArray[0];
            long l = (Long)objectArray[1];
            String string2 = NameFormat.a(n, l);
            MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
            mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
            return string2;
        }

        private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
            MutableCallSite mutableCallSite = new MutableCallSite(methodType);
            try {
                mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$NameFormat" + " : " + string + " : " + methodType.toString(), exception);
            }
            return mutableCallSite;
        }

        /*
         * Works around MethodHandle LDC.
         */
        static MethodHandle cfr_ldc_0() {
            try {
                return MethodHandles.lookup().findStatic(NameFormat.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
            }
            catch (NoSuchMethodException | IllegalAccessException except) {
                throw new IllegalArgumentException(except);
            }
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public static class AuthData
    implements Cloneable {
        private String myPassword;
        private boolean mySavePassword;
        private String myPassphrase;
        private boolean mySavePassphrase;
        private static final long a;
        private static final String[] b;
        private static final String[] c;
        private static final Map d;

        @Contract(value="!null, null->fail")
        public void setPasswordAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            block7: {
                boolean bl;
                AuthData authData;
                block8: {
                    block9: {
                        String[] stringArray;
                        block6: {
                            long l = a ^ 0x3AC835776204L;
                            String[] stringArray2 = SshConfig.h();
                            this.clean();
                            stringArray = stringArray2;
                            try {
                                try {
                                    if (stringArray != null) break block6;
                                    if (credentials == null) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                                this.setPassword(credentials.getPasswordAsString());
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            authData = this;
                            bl = memoryOnly;
                            if (stringArray != null) break block8;
                            if (bl) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                authData.setSavePassword(bl);
            }
        }

        @Contract(value="!null, null->fail")
        public void setKeyAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            block7: {
                boolean bl;
                AuthData authData;
                block8: {
                    block9: {
                        String[] stringArray;
                        block6: {
                            long l = a ^ 0x7419B0D6C925L;
                            String[] stringArray2 = SshConfig.h();
                            this.clean();
                            stringArray = stringArray2;
                            try {
                                try {
                                    if (stringArray != null) break block6;
                                    if (credentials == null) break block7;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                                this.setPassphrase(credentials.getPasswordAsString());
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            authData = this;
                            bl = memoryOnly;
                            if (stringArray != null) break block8;
                            if (bl) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                authData.setSavePassphrase(bl);
            }
        }

        private void clean() {
            this.myPassword = null;
            this.mySavePassword = false;
            this.myPassphrase = null;
            this.mySavePassphrase = false;
        }

        public boolean equals(Object o) {
            boolean bl;
            block33: {
                block30: {
                    String[] stringArray;
                    block32: {
                        AuthData authData;
                        block31: {
                            boolean bl2;
                            block29: {
                                Object object;
                                block27: {
                                    block28: {
                                        Object object2;
                                        block24: {
                                            block25: {
                                                long l = a ^ 0x1909EEC75A2L;
                                                stringArray = SshConfig.h();
                                                try {
                                                    try {
                                                        object2 = this;
                                                        if (stringArray != null) break block24;
                                                        if (object2 != o) break block25;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw AuthData.a(illegalStateException);
                                                    }
                                                    return true;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw AuthData.a(illegalStateException);
                                                }
                                            }
                                            object2 = o;
                                        }
                                        try {
                                            block26: {
                                                try {
                                                    try {
                                                        if (object2 == null) break block26;
                                                        object = this.getClass();
                                                        if (stringArray != null) break block27;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw AuthData.a(illegalStateException);
                                                    }
                                                    if (object == o.getClass()) break block28;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw AuthData.a(illegalStateException);
                                                }
                                            }
                                            return false;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw AuthData.a(illegalStateException);
                                        }
                                    }
                                    object = o;
                                }
                                authData = (AuthData)object;
                                try {
                                    try {
                                        try {
                                            bl = this.mySavePassword;
                                            bl2 = authData.mySavePassword;
                                            if (stringArray != null) break block29;
                                            if (bl != bl2) break block30;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw AuthData.a(illegalStateException);
                                        }
                                        bl = this.mySavePassphrase;
                                        if (stringArray != null) break block31;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw AuthData.a(illegalStateException);
                                    }
                                    bl2 = authData.mySavePassphrase;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw AuthData.a(illegalStateException);
                                }
                            }
                            try {
                                if (bl != bl2) break block30;
                                bl = Objects.equals(this.myPassword, authData.myPassword);
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                        }
                        try {
                            try {
                                if (stringArray != null) break block32;
                                if (!bl) break block30;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw AuthData.a(illegalStateException);
                            }
                            bl = Objects.equals(this.myPassphrase, authData.myPassphrase);
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                    }
                    try {
                        if (stringArray != null) break block33;
                        if (!bl) break block30;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                    bl = true;
                    break block33;
                }
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return Objects.hash(this.getPassword(), this.isSavePassword(), this.getPassphrase(), this.isSavePassphrase());
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isSavePassword() {
            return this.mySavePassword;
        }

        public void setSavePassword(boolean savePassword) {
            this.mySavePassword = savePassword;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public void setPassphrase(String passphrase) {
            this.myPassphrase = passphrase;
        }

        public boolean isSavePassphrase() {
            return this.mySavePassphrase;
        }

        public void setSavePassphrase(boolean savePassphrase) {
            this.mySavePassphrase = savePassphrase;
        }

        public AuthData clone() {
            try {
                return (AuthData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        /*
         * Exception decompiling
         */
        public boolean hasNoCredentials(@NotNull AuthType authType, @NotNull String keyPath) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @NotNull
        public static AuthData create(@Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase) {
            AuthData authData;
            block5: {
                int n;
                block4: {
                    long l = a ^ 0x8FC99E81F0AL;
                    AuthData authData2 = new AuthData();
                    authData2.setPassword(password);
                    String[] stringArray = SshConfig.h();
                    authData2.setSavePassword(savePassword);
                    authData2.setPassphrase(passphrase);
                    String[] stringArray2 = stringArray;
                    try {
                        try {
                            authData = authData2;
                            n = savePassphrase;
                            if (stringArray2 != null) break block4;
                            authData.setSavePassphrase(n != 0);
                            authData = authData2;
                            if (authData != null) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        n = 2;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                }
                AuthData.$$$reportNull$$$0(n);
            }
            return authData;
        }

        @NotNull
        public static AuthData create(@NotNull RemoteCredentials credentials) {
            RemoteCredentials remoteCredentials;
            block4: {
                block5: {
                    long l = a ^ 0x5C01EE07E334L;
                    String[] stringArray = SshConfig.h();
                    try {
                        try {
                            remoteCredentials = credentials;
                            if (stringArray != null) break block4;
                            if (remoteCredentials != null) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw AuthData.a(illegalStateException);
                        }
                        AuthData.$$$reportNull$$$0(3);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw AuthData.a(illegalStateException);
                    }
                }
                remoteCredentials = credentials;
            }
            return AuthData.create(remoteCredentials.getPassword(), credentials.getPassphrase(), credentials.isStorePassword(), credentials.isStorePassphrase());
        }

        /*
         * Exception decompiling
         */
        @NotNull
        public static AuthData create(@NotNull AuthType authType, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void $$$reportNull$$$0(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Unable to fully structure code
         */
        static {
            block11: {
                block10: {
                    AuthData.a = com.jetbrains.gateway.ssh.deploy.c.a(-3079512215666913026L, 7003629025972015076L, MethodHandles.lookup().lookupClass()).a(226814958497952L);
                    AuthData.d = new HashMap<K, V>(13);
                    var0 = AuthData.a ^ 119064401331158L;
                    var2_1 = Cipher.getInstance("DES/CBC/PKCS5Padding");
                    v0 = SecretKeyFactory.getInstance("DES");
                    v1 = new byte[8];
                    v2 = v1;
                    v1[0] = (byte)(var0 >>> 56);
                    for (var3_2 = 1; var3_2 < 8; ++var3_2) {
                        v2 = v2;
                        v2[var3_2] = (byte)(var0 << var3_2 * 8 >>> 56);
                    }
                    var2_1.init(2, (Key)v0.generateSecret(new DESKeySpec(v2)), new IvParameterSpec(new byte[8]));
                    var9_3 = new String[10];
                    var7_4 = 0;
                    var6_5 = "~\u00b4\u00f6\u001d\u0097@3,\u008bv|:\u0086\u00e9\u00fc\u000f\u00bd\u00af\u00e0X\u0084'A\u00ba\u00c7\n.\u00faBA\u00f3h\u0094\u0094=f\u00b9\u00c1^`\u000bE\u0003\u000eZ\u0081\u00d88>\u00ca\u0090C\u0018\u00fe\u000b:5\u0094\u0002 \u00d4p\u0004Rt\u00a13HNK5\b\u00bdN\u00ed\u0006\u001c-\u00ab\u00d0\\\u00a2iVs\u00b4\u008d;\u00ceM\u00b5\u0080\u00b1\u00d7\u00f4\u0003P\u001f\u009f\u00df\u000f;\fp\u00cc\"\u0081f]\u0002\u0083\u008c\u00a4\u009c\u001c\u00e0\f\u00f5\f\u00ce\u00d3xj>*a\u00a1s\u00e5g\u0094\u00c47\u00f6ZL\"-\u0088\u00c3\u00d79\u001bU^\u0001\u008e\u00a5|\u0015Unm\u009efc\u00c3\u00c4[U\u009d\u00fb{\u00c1\u00db\u00e8\u00ff\u00f5^\u00ed\u00d4\u00a6\u001cA`xn \u00ddp\u0011o\u00ad\u00ba\u0001W\u001e\u001e\u0015\u00f4\u0000\u0084oI\u008a\u00d3s\r'/\u00c5\u00ba\u008b|\u0014\u00d6cb\u00b7\u00fa\u0010\u0013\u0089\u00e0\u00125\u009f\u008a\u000b\u0093\u00ff\u00a1\\x\u008f\u008a\u000eX\u00da+\u0003U=\u00e8\u00b2,\u00e2\u0094\u0002\u00a9\u0097d\u00d4|b\u008b\u00a4Z\u0093\u0018\u00bb\u00c8\u00bdp)\u001b\u001e\u00f9M:\"\u00ac\f\r>\u00dd\u0095\u00ae\u00b6)\u00cb\u00d5X\u000e\u001a\u009e\u001dJ\u00e1\u001d\u00b8\u00ba\u0082\u00ec\u00e2^\u000e\u00c4\u00c9\b \u00fe\u00d5\u001e\u009d\u00ec\u00fd\u008c\u008c>G\u0014L+\u0088\u00b4\u0092\u0099&\u00a6\u00dc>\r\u001bhc \u008c\u00a6\u00bc\u00c2Q\u0002\u00aa\n\u0086\u0001:\u00b4\u00b8E\u00d5\u00b78\u00ab\u00f9\u00db\u001b'\u00a5\u0012\u0007\u00f7\u00ba\u00ca\u0098\u0083\u0004\u00d5X\u00c7\u00c2\u00f9\u00eb3\u0086\u00df\u0018:L\u00ec}\r\u00a26\u00e7\u00dc\u007f\u00ec\u00f7\u0087\u0087-\u00e0^O\u00bd#\u0086\u00f8\u001c\f\u00de\u00dc\u0014\u0010\u00a2\u00ed\u00ef\u00c4\u0098m\u00b1\u00c2\u00c3\u00bbJ\u0017\u0017R\u00ec\u0011$\u00b3\u00f3\u00b7V\u00dc\u00d1\u00a5\u009cK\u001e\u00af\u0005\u00fa\u00db\u00d8\u0088\u00dc1>\u0000\bV\u00d9\u00a9vD$\u00d2\u00de#\u0098\u0096\u00e6\u0082\u00ee\u0010\u00bb#\u0085\u00ef\u00d3>\u00de\u00af\u00c5OG\u00dc\u0017\u0016\u0007u";
                    var8_6 = "~\u00b4\u00f6\u001d\u0097@3,\u008bv|:\u0086\u00e9\u00fc\u000f\u00bd\u00af\u00e0X\u0084'A\u00ba\u00c7\n.\u00faBA\u00f3h\u0094\u0094=f\u00b9\u00c1^`\u000bE\u0003\u000eZ\u0081\u00d88>\u00ca\u0090C\u0018\u00fe\u000b:5\u0094\u0002 \u00d4p\u0004Rt\u00a13HNK5\b\u00bdN\u00ed\u0006\u001c-\u00ab\u00d0\\\u00a2iVs\u00b4\u008d;\u00ceM\u00b5\u0080\u00b1\u00d7\u00f4\u0003P\u001f\u009f\u00df\u000f;\fp\u00cc\"\u0081f]\u0002\u0083\u008c\u00a4\u009c\u001c\u00e0\f\u00f5\f\u00ce\u00d3xj>*a\u00a1s\u00e5g\u0094\u00c47\u00f6ZL\"-\u0088\u00c3\u00d79\u001bU^\u0001\u008e\u00a5|\u0015Unm\u009efc\u00c3\u00c4[U\u009d\u00fb{\u00c1\u00db\u00e8\u00ff\u00f5^\u00ed\u00d4\u00a6\u001cA`xn \u00ddp\u0011o\u00ad\u00ba\u0001W\u001e\u001e\u0015\u00f4\u0000\u0084oI\u008a\u00d3s\r'/\u00c5\u00ba\u008b|\u0014\u00d6cb\u00b7\u00fa\u0010\u0013\u0089\u00e0\u00125\u009f\u008a\u000b\u0093\u00ff\u00a1\\x\u008f\u008a\u000eX\u00da+\u0003U=\u00e8\u00b2,\u00e2\u0094\u0002\u00a9\u0097d\u00d4|b\u008b\u00a4Z\u0093\u0018\u00bb\u00c8\u00bdp)\u001b\u001e\u00f9M:\"\u00ac\f\r>\u00dd\u0095\u00ae\u00b6)\u00cb\u00d5X\u000e\u001a\u009e\u001dJ\u00e1\u001d\u00b8\u00ba\u0082\u00ec\u00e2^\u000e\u00c4\u00c9\b \u00fe\u00d5\u001e\u009d\u00ec\u00fd\u008c\u008c>G\u0014L+\u0088\u00b4\u0092\u0099&\u00a6\u00dc>\r\u001bhc \u008c\u00a6\u00bc\u00c2Q\u0002\u00aa\n\u0086\u0001:\u00b4\u00b8E\u00d5\u00b78\u00ab\u00f9\u00db\u001b'\u00a5\u0012\u0007\u00f7\u00ba\u00ca\u0098\u0083\u0004\u00d5X\u00c7\u00c2\u00f9\u00eb3\u0086\u00df\u0018:L\u00ec}\r\u00a26\u00e7\u00dc\u007f\u00ec\u00f7\u0087\u0087-\u00e0^O\u00bd#\u0086\u00f8\u001c\f\u00de\u00dc\u0014\u0010\u00a2\u00ed\u00ef\u00c4\u0098m\u00b1\u00c2\u00c3\u00bbJ\u0017\u0017R\u00ec\u0011$\u00b3\u00f3\u00b7V\u00dc\u00d1\u00a5\u009cK\u001e\u00af\u0005\u00fa\u00db\u00d8\u0088\u00dc1>\u0000\bV\u00d9\u00a9vD$\u00d2\u00de#\u0098\u0096\u00e6\u0082\u00ee\u0010\u00bb#\u0085\u00ef\u00d3>\u00de\u00af\u00c5OG\u00dc\u0017\u0016\u0007u".length();
                    var5_7 = 96;
                    var4_8 = -1;
lbl20:
                    // 2 sources

                    while (true) {
                        v3 = ++var4_8;
                        v4 = var6_5.substring(v3, v3 + var5_7);
                        v5 = -1;
                        break block10;
                        break;
                    }
lbl25:
                    // 1 sources

                    while (true) {
                        var9_3[var7_4++] = AuthData.a(var10_9).intern();
                        if ((var4_8 += var5_7) < var8_6) {
                            var5_7 = var6_5.charAt(var4_8);
                            ** continue;
                        }
                        var6_5 = "\u00c6@\u00f7\u0085\u00913\u00fd)#\u00d5\u0093W\u00f8!l\u0099$\u00b8\u0084\u0002\u0096\u0093\u009d\u0084\u008cwk\u00c0\u0081\u00a8\u0092\u009f5\u0013\u00e2\u00fc-':o\u0010\u00b2\u00bc\u00bf0\u00aemD\u009bs\u0018\u00bd\u0090\u009d'\u0084\u0001";
                        var8_6 = "\u00c6@\u00f7\u0085\u00913\u00fd)#\u00d5\u0093W\u00f8!l\u0099$\u00b8\u0084\u0002\u0096\u0093\u009d\u0084\u008cwk\u00c0\u0081\u00a8\u0092\u009f5\u0013\u00e2\u00fc-':o\u0010\u00b2\u00bc\u00bf0\u00aemD\u009bs\u0018\u00bd\u0090\u009d'\u0084\u0001".length();
                        var5_7 = 40;
                        var4_8 = -1;
lbl34:
                        // 2 sources

                        while (true) {
                            v6 = ++var4_8;
                            v4 = var6_5.substring(v6, v6 + var5_7);
                            v5 = 0;
                            break block10;
                            break;
                        }
                        break;
                    }
lbl39:
                    // 1 sources

                    while (true) {
                        var9_3[var7_4++] = AuthData.a(var10_9).intern();
                        if ((var4_8 += var5_7) < var8_6) {
                            var5_7 = var6_5.charAt(var4_8);
                            ** continue;
                        }
                        break block11;
                        break;
                    }
                }
                var10_9 = var2_1.doFinal(v4.getBytes("ISO-8859-1"));
                switch (v5) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl51:
                    // 1 sources

                    ** continue;
                }
            }
            AuthData.b = var9_3;
            AuthData.c = new String[10];
        }

        private static IllegalStateException a(IllegalStateException illegalStateException) {
            return illegalStateException;
        }

        private static String a(byte[] byArray) {
            int n = 0;
            int n2 = byArray.length;
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                char c2;
                int n3 = 0xFF & byArray[i];
                if (n3 < 192) {
                    cArray[n++] = (char)n3;
                    continue;
                }
                if (n3 < 224) {
                    c2 = (char)((char)(n3 & 0x1F) << 6);
                    n3 = byArray[++i];
                    c2 = (char)(c2 | (char)(n3 & 0x3F));
                    cArray[n++] = c2;
                    continue;
                }
                if (i >= n2 - 2) continue;
                c2 = (char)((char)(n3 & 0xF) << 12);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F) << 6);
                n3 = byArray[++i];
                c2 = (char)(c2 | (char)(n3 & 0x3F));
                cArray[n++] = c2;
            }
            return new String(cArray, 0, n);
        }

        private static String a(int n, long l) {
            int n2 = n ^ (int)(l & 0x7FFFL) ^ 0x628;
            if (c[n2] == null) {
                Object[] objectArray;
                try {
                    Long l2 = Thread.currentThread().getId();
                    objectArray = (Object[])d.get(l2);
                    if (objectArray == null) {
                        objectArray = new Object[]{Cipher.getInstance("DES/CBC/PKCS5Padding"), SecretKeyFactory.getInstance("DES"), new IvParameterSpec(new byte[8])};
                        d.put(l2, objectArray);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$AuthData", exception);
                }
                byte[] byArray = new byte[8];
                byArray[0] = (byte)(l >>> 56);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l << i * 8 >>> 56);
                }
                DESKeySpec dESKeySpec = new DESKeySpec(byArray);
                SecretKey secretKey = ((SecretKeyFactory)objectArray[1]).generateSecret(dESKeySpec);
                ((Cipher)objectArray[0]).init(2, (Key)secretKey, (IvParameterSpec)objectArray[2]);
                byte[] byArray2 = b[n2].getBytes("ISO-8859-1");
                AuthData.c[n2] = AuthData.a(((Cipher)objectArray[0]).doFinal(byArray2));
            }
            return c[n2];
        }

        private static Object a(MethodHandles.Lookup lookup, MutableCallSite mutableCallSite, String string, Object[] objectArray) {
            int n = (Integer)objectArray[0];
            long l = (Long)objectArray[1];
            String string2 = AuthData.a(n, l);
            MethodHandle methodHandle = MethodHandles.constant(String.class, string2);
            mutableCallSite.setTarget(MethodHandles.dropArguments(methodHandle, 0, new Class[]{Integer.TYPE, Long.TYPE}));
            return string2;
        }

        private static CallSite a(MethodHandles.Lookup lookup, String string, MethodType methodType) {
            MutableCallSite mutableCallSite = new MutableCallSite(methodType);
            try {
                mutableCallSite.setTarget(MethodHandles.explicitCastArguments(MethodHandles.insertArguments(cfr_ldc_0().asCollector(Object[].class, methodType.parameterCount()), 0, lookup, mutableCallSite, string), methodType));
            }
            catch (Exception exception) {
                throw new RuntimeException("com/intellij/ssh/config/unified/SshConfig$AuthData" + " : " + string + " : " + methodType.toString(), exception);
            }
            return mutableCallSite;
        }

        /*
         * Works around MethodHandle LDC.
         */
        static MethodHandle cfr_ldc_0() {
            try {
                return MethodHandles.lookup().findStatic(AuthData.class, "a", MethodType.fromMethodDescriptorString("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/invoke/MutableCallSite;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null));
            }
            catch (NoSuchMethodException | IllegalAccessException except) {
                throw new IllegalArgumentException(except);
            }
        }
    }
}

