/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBusKt;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0016J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ#\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0000\u00a2\u0006\u0004\b\"\u0010#J1\u0010$\u001a\u00020\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u000e\u0010%\u001a\n\u0012\u0006\b\u0000\u0012\u00020!0\n2\u0006\u0010&\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b'J\u0019\u0010(\u001a\u00020\u00122\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020\u000f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 H\u0000\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010.\u001a\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 H\u0000\u00a2\u0006\u0004\b/\u00100J\u0006\u00101\u001a\u00020\u0012J\u0006\u00102\u001a\u00020\u0012J\u0018\u00103\u001a\u00020\u00122\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030605J\b\u00107\u001a\u00020\u0012H\u0007J\r\u00108\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b9R:\u0010\t\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u00010\r\u00a2\u0006\u0002\b\f0\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "hasChildren", "", "hasChildren$intellij_platform_core", "addChild", "", "bus", "onChildBusDisposed", "childBus", "onChildBusDisposed$intellij_platform_core", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "topic", "Lcom/intellij/util/messages/Topic;", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "computeSubscribers", "", "", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "doComputeSubscribers", "result", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "notifyConnectionTerminated", "topicAndHandlerPairs", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "clearSubscriberCache", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "removeEmptyConnectionsRecursively", "clearPublisherCache", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "clearAllSubscriberCache", "disposeChildren", "disposeChildren$intellij_platform_core", "intellij.platform.core"})
@VisibleForTesting
@ApiStatus.Internal
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    @NotNull
    private final List<MessageBusImpl> childBuses;

    public CompositeMessageBus(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentBus, (String)"parentBus");
        super(owner, parentBus);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
    }

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
    }

    @Override
    public final boolean hasChildren$intellij_platform_core() {
        return !((Collection)this.childBuses).isEmpty();
    }

    public final void addChild(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        CompositeMessageBusKt.access$childrenListChanged(this);
        this.childBuses.add(bus);
    }

    public final void onChildBusDisposed$intellij_platform_core(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter((Object)childBus, (String)"childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public final <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                if (!(this.parentBus == null)) {
                    boolean bl = false;
                    String string = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string.toString());
                }
                messagePublisher = new ToDirectChildrenMessagePublisher<L>(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public final Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers$intellij_platform_core(topic);
        }
        return objectArray;
    }

    @Override
    public final void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result, boolean subscribeLazyListeners) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        super.doComputeSubscribers$intellij_platform_core(topic, result, subscribeLazyListeners);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers$intellij_platform_core(topic, result, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    @Override
    public final void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    @Override
    public final boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated$intellij_platform_core(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$1(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$0(topicAndHandlerPairs, arg_0), arg_0));
        return false;
    }

    @Override
    public final void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        super.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
    }

    @Override
    public final void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        for (MessageBusImpl bus : this.childBuses) {
            bus.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public final void clearPublisherCache() {
        super.clearPublisherCache();
        for (MessageBusImpl childBus : this.childBuses) {
            if (childBus instanceof CompositeMessageBus) {
                ((CompositeMessageBus)childBus).clearPublisherCache();
                continue;
            }
            childBus.publisherCache.clear();
        }
    }

    @Override
    public final void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super.disconnectPluginConnections(predicate);
        for (MessageBusImpl bus : this.childBuses) {
            bus.disconnectPluginConnections(predicate);
        }
    }

    @Override
    @TestOnly
    public final void clearAllSubscriberCache() {
        super.clearAllSubscriberCache();
        for (MessageBusImpl bus : this.childBuses) {
            bus.subscriberCache.clear();
        }
    }

    @Override
    public final void disposeChildren$intellij_platform_core() {
        for (MessageBusImpl childBus : this.childBuses) {
            Disposer.dispose((Disposable)((Disposable)childBus));
        }
    }

    private static final boolean notifyConnectionTerminated$lambda$0(Object[] $topicAndHandlerPairs, Message it) {
        Intrinsics.checkNotNull((Object)it);
        return CompositeMessageBusKt.access$nullizeHandlersFromMessage(it, $topicAndHandlerPairs);
    }

    private static final boolean notifyConnectionTerminated$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

