/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.statistics.VcsLogIndexCollectorState;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "INDEXING_TIME", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "IS_PAUSED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "INDEXING_TIME_BY_ROOT", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "", "INDEX_DISABLED", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getSharedSettings", "Lcom/intellij/vcs/log/impl/VcsLogSharedSettings;", "getIndexCollector", "Lcom/intellij/vcs/log/statistics/VcsLogIndexCollector;", "getGroup", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogIndexStatisticsCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogIndexStatisticsCollectors.kt\ncom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,153:1\n58#2:154\n58#2:155\n*S KotlinDebug\n*F\n+ 1 VcsLogIndexStatisticsCollectors.kt\ncom/intellij/vcs/log/statistics/VcsLogIndexProjectStatisticsCollector\n*L\n85#1:154\n87#1:155\n*E\n"})
public final class VcsLogIndexProjectStatisticsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("vcs.log.index.project", 5, null, 4, null);
    @NotNull
    private final EventId1<Integer> INDEXING_TIME = this.GROUP.registerEvent("indexing.time.minutes", (EventField)EventFields.Count);
    @NotNull
    private final BooleanEventField IS_PAUSED = EventFields.Boolean((String)"is_paused");
    @NotNull
    private final EventId3<String, Long, Boolean> INDEXING_TIME_BY_ROOT = this.GROUP.registerEvent("indexing.time.by.root", (EventField)EventFields.AnonymizedPath, (EventField)EventFields.DurationMs, (EventField)this.IS_PAUSED);
    @NotNull
    private final EventId1<Boolean> INDEX_DISABLED = this.GROUP.registerEvent("index.disabled.in.project", (EventField)EventFields.Boolean((String)"value"));

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Set usages;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!TrustedProjects.isProjectTrusted((Project)project)) {
                return SetsKt.emptySet();
            }
            usages = new LinkedHashSet();
            Object object = this.getIndexCollector(project);
            if (object != null && (object = ((VcsLogIndexCollector)object).getState()) != null) {
                Object indexCollectorState = object;
                boolean bl = false;
                int indexingTime = (int)TimeUnit.MILLISECONDS.toMinutes(((VcsLogIndexCollectorState)((Object)indexCollectorState)).getIndexTime());
                usages.add(this.INDEXING_TIME.metric((Object)indexingTime));
                for (Map.Entry<String, Long> entry : ((VcsLogIndexCollectorState)((Object)indexCollectorState)).getIndexTimeByRoot().entrySet()) {
                    String rootPath = entry.getKey();
                    long time = ((Number)entry.getValue()).longValue();
                    usages.add(this.INDEXING_TIME_BY_ROOT.metric((Object)rootPath, (Object)time, (Object)VcsLogBigRepositoriesList.getInstance().isBig(rootPath)));
                }
            }
            VcsLogSharedSettings vcsLogSharedSettings = this.getSharedSettings(project);
            if (vcsLogSharedSettings == null) break block4;
            VcsLogSharedSettings sharedSettings = vcsLogSharedSettings;
            boolean bl = false;
            if (!sharedSettings.isIndexSwitchedOn()) {
                usages.add(this.INDEX_DISABLED.metric((Object)true));
            }
        }
        return usages;
    }

    private final VcsLogSharedSettings getSharedSettings(Project project) {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
        boolean $i$f$serviceIfCreated = false;
        return (VcsLogSharedSettings)$this$serviceIfCreated$iv.getServiceIfCreated(VcsLogSharedSettings.class);
    }

    private final VcsLogIndexCollector getIndexCollector(Project project) {
        ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
        boolean $i$f$serviceIfCreated = false;
        return (VcsLogIndexCollector)$this$serviceIfCreated$iv.getServiceIfCreated(VcsLogIndexCollector.class);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

