/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.utils.DockerEngineUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\b\u0010\r\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"INADDR_ANY", "", "HOST_DOCKER_INTERNAL_DNS_NAME", "HOST_GATEWAY", "DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOCALHOST", "getDockerNetworkInterface", "configuration", "Lcom/intellij/docker/DockerCloudConfiguration;", "getHostAddress", "getDockerForLinuxHostAddress", "getNetworkInterfaceHostAddress", "networkInterfaceName", "getDockerForMacHostAddress", "getDockerForWindowsHostAddress", "getInterfaceHostAddress", "iterable", "", "Ljava/net/InterfaceAddress;", "getDockerEngineAddress", "getExplicitHostDockerInternalMappingIfRequired", "", "intellij.clouds.docker"})
@JvmName(name="DockerNetworkUtil")
public final class DockerNetworkUtil {
    @NotNull
    public static final String INADDR_ANY = "0.0.0.0";
    @NotNull
    private static final String HOST_DOCKER_INTERNAL_DNS_NAME = "host.docker.internal";
    @NotNull
    private static final String HOST_GATEWAY = "host-gateway";
    @NotNull
    private static final String DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME = "docker0";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String LOCALHOST = "localhost";

    @NotNull
    public static final String getDockerNetworkInterface(@NotNull DockerCloudConfiguration configuration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        if (DockerEngineUtil.isUnixSocket(configuration) && SystemInfo.isLinux) {
            String dockerBridgeHostAddress = DockerNetworkUtil.getNetworkInterfaceHostAddress(DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME);
            if (dockerBridgeHostAddress != null) {
                LOG.debug("Using " + dockerBridgeHostAddress + " host address taken from docker0 network interface");
                string = dockerBridgeHostAddress;
            } else {
                LOG.debug("Network interface docker0 could not be found, using localhost interface on the host machine to listen for the connections from processes inside the Docker container");
                string = LOCALHOST;
            }
        } else {
            string = LOCALHOST;
        }
        return string;
    }

    @NotNull
    public static final String getHostAddress(@NotNull DockerCloudConfiguration configuration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        if (DockerEngineUtil.isUnixSocket(configuration)) {
            if (SystemInfo.isWindows) {
                throw new IllegalStateException("Unix domain socket " + configuration.getApiUrl() + " is not supported on Windows");
            }
            string = SystemInfo.isMac ? DockerNetworkUtil.getDockerForMacHostAddress() : DockerNetworkUtil.getDockerForLinuxHostAddress();
        } else if (SystemInfo.isWindows) {
            string = DockerNetworkUtil.getDockerForWindowsHostAddress();
        } else {
            LOG.info("Host address cannot be determined for " + configuration.getApiUrl() + " Docker connection. Falling back to host.docker.internal.");
            string = HOST_DOCKER_INTERNAL_DNS_NAME;
        }
        return string;
    }

    private static final String getDockerForLinuxHostAddress() {
        String string;
        String dockerBridgeHostAddress = DockerNetworkUtil.getNetworkInterfaceHostAddress(DOCKER_FOR_LINUX_NETWORK_INTERFACE_NAME);
        if (dockerBridgeHostAddress != null) {
            LOG.debug("Using " + dockerBridgeHostAddress + " host machine address taken from docker0 network interface");
            string = dockerBridgeHostAddress;
        } else {
            LOG.debug("Network interface docker0 could not be found, using host.docker.internal hostname to establish connections to the host machine from the Docker container");
            string = HOST_DOCKER_INTERNAL_DNS_NAME;
        }
        return string;
    }

    private static final String getNetworkInterfaceHostAddress(String networkInterfaceName) {
        NetworkInterface networkInterface = NetworkInterface.getByName(networkInterfaceName);
        if (networkInterface == null) {
            return null;
        }
        NetworkInterface networkInterface2 = networkInterface;
        List<InterfaceAddress> list = networkInterface2.getInterfaceAddresses();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInterfaceAddresses(...)");
        String string = DockerNetworkUtil.getInterfaceHostAddress((Iterable<? extends InterfaceAddress>)list);
        if (string == null) {
            throw new IllegalStateException("Host address for network interface " + networkInterfaceName + " is absent");
        }
        return string;
    }

    private static final String getDockerForMacHostAddress() {
        LOG.debug("Using host.docker.internal host machine address available for Docker for Mac 18.03+");
        return HOST_DOCKER_INTERNAL_DNS_NAME;
    }

    @NotNull
    public static final String getDockerForWindowsHostAddress() {
        LOG.debug("Using host.docker.internal host machine address available for Docker Desktop for Windows 18.03+");
        return HOST_DOCKER_INTERNAL_DNS_NAME;
    }

    private static final String getInterfaceHostAddress(Iterable<? extends InterfaceAddress> iterable) {
        String resultAddress = null;
        for (InterfaceAddress interfaceAddress : iterable) {
            if (interfaceAddress.getBroadcast() != null) {
                return interfaceAddress.getAddress().getHostAddress();
            }
            resultAddress = interfaceAddress.getAddress().getHostAddress();
        }
        return resultAddress;
    }

    @Nullable
    public static final String getDockerEngineAddress(@NotNull DockerCloudConfiguration configuration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        String apiUrl = configuration.getApiUrl();
        if (DockerEngineUtil.isUnixSocket(configuration)) {
            if (SystemInfo.isWindows) {
                throw new IllegalStateException("Unix domain socket " + apiUrl + " is not supported on Windows");
            }
            string = null;
        } else {
            string = new URI(apiUrl).getHost();
        }
        return string;
    }

    @NotNull
    public static final Map<String, String> getExplicitHostDockerInternalMappingIfRequired(@NotNull DockerCloudConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        return SystemInfo.isLinux && DockerEngineUtil.isUnixSocket(configuration) ? MapsKt.mapOf((Pair)TuplesKt.to((Object)HOST_DOCKER_INTERNAL_DNS_NAME, (Object)HOST_GATEWAY)) : MapsKt.emptyMap();
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.docker.engine.DockerNetworkUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

