/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.uploader;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.LogSystemCollector;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.StatsConnectionSettings;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.uploader.EventLogUploaderOptions;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import com.intellij.internal.statistic.uploader.util.ExtraHTTPHeadersParser;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.jetbrains.fus.reporting.MetadataStorage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.full.IllegalCallableAccessException;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002J$\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J+\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ9\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\f2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\u00020\n2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\b0'j\b\u0012\u0004\u0012\u00020\b`(2\u0006\u0010)\u001a\u00020 H\u0002J0\u0010*\u001a\u00020\n2\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\b0'j\b\u0012\u0004\u0012\u00020\b`(2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0002J\u001e\u0010-\u001a\u00020\b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000200H\u0002J\u0014\u00102\u001a\u00020\b2\n\u00103\u001a\u0006\u0012\u0002\b\u000304H\u0002J\b\u00105\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020#H\u0002J\b\u00107\u001a\u00020#H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/internal/statistic/eventLog/uploader/EventLogExternalUploader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPLOADER_MAIN_CLASS", "", "logPreviousExternalUploadResult", "", "providers", "", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "logPreviousExternalUploadResultByRecorder", "eventLogSystemCollector", "Lcom/intellij/internal/statistic/eventLog/EventLogSystemCollector;", "events", "Lcom/intellij/internal/statistic/uploader/events/ExternalSystemEvent;", "startExternalUpload", "recordersProviders", "isTestConfig", "", "isTestSendEndpoint", "prepareUploadCommand", "", "recorders", "applicationInfo", "Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;", "(Ljava/util/List;Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;)[Ljava/lang/String;", "createExternalUploadCommand", "configs", "Lcom/intellij/internal/statistic/eventLog/EventLogSendConfig;", "classpath", "tempDir", "Ljava/io/File;", "(Lcom/intellij/internal/statistic/eventLog/EventLogApplicationInfo;Ljava/util/List;Ljava/lang/String;Ljava/io/File;)[Ljava/lang/String;", "addRecorderConfiguration", "args", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "config", "addArgument", "name", "value", "joinAsClasspath", "libCopies", "uploaderCopy", "Ljava/nio/file/Path;", "findUploader", "findLibraryByClass", "clazz", "Ljava/lang/Class;", "findJavaHome", "getOrCreateTempDir", "getTempFile", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nEventLogExternalUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogExternalUploader.kt\ncom/intellij/internal/statistic/eventLog/uploader/EventLogExternalUploader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n777#2:249\n873#2,2:250\n1586#2:252\n1661#2,3:253\n1915#2,2:256\n777#2:258\n873#2,2:259\n1915#2,2:261\n1915#2,2:263\n1915#2,2:265\n1586#2:267\n1661#2,3:268\n1586#2:271\n1661#2,3:272\n*S KotlinDebug\n*F\n+ 1 EventLogExternalUploader.kt\ncom/intellij/internal/statistic/eventLog/uploader/EventLogExternalUploader\n*L\n39#1:249\n39#1:250,2\n39#1:252\n39#1:253,3\n48#1:256,2\n84#1:258\n84#1:259,2\n90#1:261,2\n94#1:263,2\n104#1:265,2\n110#1:267\n110#1:268,3\n189#1:271\n189#1:272,3\n*E\n"})
public final class EventLogExternalUploader {
    @NotNull
    public static final EventLogExternalUploader INSTANCE = new EventLogExternalUploader();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String UPLOADER_MAIN_CLASS = "com.intellij.internal.statistic.uploader.EventLogUploader";

    private EventLogExternalUploader() {
    }

    /*
     * WARNING - void declaration
     */
    public final void logPreviousExternalUploadResult(@NotNull List<? extends StatisticsEventLoggerProvider> providers) {
        void $this$mapTo$iv$iv;
        StatisticsEventLoggerProvider it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Iterable $this$filter$iv = providers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isSendEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (StatisticsEventLoggerProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEventLogSystemLogger$intellij_platform_statistics());
        }
        List enableEventLogSystemCollectors = (List)destination$iv$iv;
        if (enableEventLogSystemCollectors.isEmpty()) {
            return;
        }
        try {
            File tempDir = this.getTempFile();
            if (tempDir.exists()) {
                List<ExternalSystemEvent> list = ExternalEventsLogger.parseEvents(tempDir);
                Intrinsics.checkNotNullExpressionValue(list, (String)"parseEvents(...)");
                List<ExternalSystemEvent> events = list;
                Iterable $this$forEach$iv = enableEventLogSystemCollectors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EventLogSystemCollector it2 = (EventLogSystemCollector)element$iv;
                    boolean bl = false;
                    INSTANCE.logPreviousExternalUploadResultByRecorder(it2, events);
                }
            }
            FilesKt.deleteRecursively((File)tempDir);
        }
        catch (Exception e) {
            LOG.warn("Statistics. External uploader. Failed reading previous upload result: " + e.getMessage());
        }
    }

    private final void logPreviousExternalUploadResultByRecorder(EventLogSystemCollector eventLogSystemCollector, List<? extends ExternalSystemEvent> events) {
        for (ExternalSystemEvent externalSystemEvent : events) {
            String eventRecorderId;
            Intrinsics.checkNotNullExpressionValue((Object)externalSystemEvent.getRecorderId(), (String)"getRecorderId(...)");
            if (!Intrinsics.areEqual((Object)eventRecorderId, (Object)eventLogSystemCollector.getGroup().getRecorder()) && !Intrinsics.areEqual((Object)eventRecorderId, (Object)"ALL")) continue;
            ExternalSystemEvent externalSystemEvent2 = externalSystemEvent;
            if (externalSystemEvent2 instanceof ExternalUploadStartedEvent) {
                eventLogSystemCollector.logStartingExternalSend(((ExternalUploadStartedEvent)externalSystemEvent).getTimestamp());
                continue;
            }
            if (externalSystemEvent2 instanceof ExternalUploadSendEvent) {
                List<Integer> errors;
                List<String> files;
                Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)externalSystemEvent).getSuccessfullySentFiles(), (String)"getSuccessfullySentFiles(...)");
                Intrinsics.checkNotNullExpressionValue(((ExternalUploadSendEvent)externalSystemEvent).getErrors(), (String)"getErrors(...)");
                eventLogSystemCollector.logFilesSend(((ExternalUploadSendEvent)externalSystemEvent).getTotal(), ((ExternalUploadSendEvent)externalSystemEvent).getSucceed(), ((ExternalUploadSendEvent)externalSystemEvent).getFailed(), true, files, errors);
                continue;
            }
            if (externalSystemEvent2 instanceof ExternalUploadFinishedEvent) {
                eventLogSystemCollector.logExternalSendFinished(((ExternalUploadFinishedEvent)externalSystemEvent).getError(), ((ExternalUploadFinishedEvent)externalSystemEvent).getTimestamp());
                continue;
            }
            if (!(externalSystemEvent2 instanceof ExternalSystemErrorEvent)) continue;
            String string = ((ExternalSystemErrorEvent)externalSystemEvent).getErrorClass();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorClass(...)");
            eventLogSystemCollector.logLoadingConfigFailed(string, ((ExternalSystemErrorEvent)externalSystemEvent).getTimestamp());
        }
    }

    public final void startExternalUpload(@NotNull List<? extends StatisticsEventLoggerProvider> recordersProviders, boolean isTestConfig, boolean isTestSendEndpoint) {
        StatisticsEventLoggerProvider it;
        Iterable $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(recordersProviders, (String)"recordersProviders");
        EventPair[] $this$filter$iv = (EventPair[])recordersProviders;
        boolean $i$f$filter = false;
        EventPair[] eventPairArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            StatisticsEventLoggerProvider it2 = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it2.isSendEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enabledEventLoggerProviders = (List)destination$iv$iv;
        if (enabledEventLoggerProviders.isEmpty()) {
            LOG.info("Statistics. Don't start external uploader because sending logs is disabled for all recorders");
            $this$filter$iv = new EventPair[]{LogSystemCollector.INSTANCE.getSendingForAllRecordersDisabledField().with(true)};
            LogSystemCollector.INSTANCE.getExternalUploaderLaunched().log($this$filter$iv);
            return;
        }
        Iterable $this$forEach$iv2 = enabledEventLoggerProviders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            StatisticsEventLoggerProvider it3 = (StatisticsEventLoggerProvider)element$iv;
            boolean bl = false;
            it3.getEventLogSystemLogger$intellij_platform_statistics().logExternalSendCommandCreationStarted();
        }
        EventLogInternalApplicationInfo application = new EventLogInternalApplicationInfo(isTestConfig, isTestSendEndpoint);
        try {
            Object[] command = this.prepareUploadCommand(enabledEventLoggerProviders, application);
            $this$forEach$iv = enabledEventLoggerProviders;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StatisticsEventLoggerProvider)element$iv;
                boolean bl = false;
                it.getEventLogSystemLogger$intellij_platform_statistics().logExternalSendCommandCreationFinished(null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Statistics. Starting external uploader: '" + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "'");
            }
            Runtime.getRuntime().exec((String[])command);
            LOG.info("Statistics. Started external process for uploading event log");
        }
        catch (EventLogUploadException e) {
            $this$forEach$iv = enabledEventLoggerProviders;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StatisticsEventLoggerProvider)element$iv;
                boolean bl = false;
                it.getEventLogSystemLogger$intellij_platform_statistics().logExternalSendCommandCreationFinished(e.getErrorType());
            }
            LOG.info("Statistics. External uploader error: " + e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String[] prepareUploadCommand(List<? extends StatisticsEventLoggerProvider> recorders, EventLogApplicationInfo applicationInfo) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = recorders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)item$iv$iv;
            Object[] objectArray = destination$iv$iv;
            boolean bl = false;
            objectArray.add(EventLogInternalSendConfig.createByRecorder(it.getRecorderId(), false));
        }
        List sendConfigs = (List)destination$iv$iv;
        if (sendConfigs.isEmpty()) {
            throw new EventLogUploadException("Statistics. External uploader. No available logs to send", EventLogUploadException.EventLogUploadErrorType.NO_LOGS);
        }
        File tempDir = this.getOrCreateTempDir();
        Path uploader = this.findUploader();
        destination$iv$iv = new String[]{this.findLibraryByClass(Continuation.class), this.findLibraryByClass(NotNull.class), this.findLibraryByClass(JsonParser.class), this.findLibraryByClass(JsonNode.class), this.findLibraryByClass(JsonView.class), this.findLibraryByClass(KotlinFeature.class), this.findLibraryByClass(IllegalCallableAccessException.class), this.findLibraryByClass(EventGroupsFilterRules.class), this.findLibraryByClass(StatsConnectionSettings.class), this.findLibraryByClass(MetadataStorage.class), this.findLibraryByClass(Json.class), this.findLibraryByClass(StringFormat.class)};
        Set libPaths = SetsKt.setOf((Object[])destination$iv$iv);
        String classpath = this.joinAsClasspath(CollectionsKt.toList((Iterable)libPaths), uploader);
        return this.createExternalUploadCommand(applicationInfo, sendConfigs, classpath, tempDir);
    }

    @NotNull
    public final String[] createExternalUploadCommand(@NotNull EventLogApplicationInfo applicationInfo, @NotNull List<? extends EventLogSendConfig> configs, @NotNull String classpath, @NotNull File tempDir) {
        Intrinsics.checkNotNullParameter((Object)applicationInfo, (String)"applicationInfo");
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        ArrayList<String> args = new ArrayList<String>();
        String java = this.findJavaHome();
        ((Collection)args).add(new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath());
        this.addArgument(args, "-cp", classpath);
        ((Collection)args).add("-Djava.io.tmpdir=" + tempDir.getPath());
        ((Collection)args).add(UPLOADER_MAIN_CLASS);
        String[] stringArray = new String[]{"token"};
        this.addArgument(args, "--ide-token", ((Object)Paths.get(PathManager.getSystemPath(), stringArray).toAbsolutePath()).toString());
        this.addArgument(args, "--recorders", CollectionsKt.joinToString$default((Iterable)configs, (CharSequence)";", null, null, (int)0, null, EventLogExternalUploader::createExternalUploadCommand$lambda$0, (int)30, null));
        for (EventLogSendConfig eventLogSendConfig : configs) {
            this.addRecorderConfiguration(args, eventLogSendConfig);
        }
        String string = applicationInfo.getRegionalCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRegionalCode(...)");
        this.addArgument(args, "--regional-code", string);
        String string2 = applicationInfo.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        this.addArgument(args, "--product", string2);
        String string3 = applicationInfo.getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProductVersion(...)");
        this.addArgument(args, "--product-version", string3);
        this.addArgument(args, "--baseline-version", String.valueOf(applicationInfo.getBaselineVersion()));
        this.addArgument(args, "--user-agent", applicationInfo.getConnectionSettings().provideUserAgent());
        String string4 = ExtraHTTPHeadersParser.serialize(applicationInfo.getConnectionSettings().provideExtraHeaders());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"serialize(...)");
        this.addArgument(args, "--extra-headers", string4);
        if (applicationInfo.isInternal()) {
            ((Collection)args).add("--internal");
        }
        if (applicationInfo.isTestSendEndpoint()) {
            ((Collection)args).add("--test-send-endpoint");
        }
        if (applicationInfo.isTestConfig()) {
            ((Collection)args).add("--test-config");
        }
        if (applicationInfo.isEAP()) {
            ((Collection)args).add("--eap");
        }
        String[] stringArray2 = ArrayUtil.toStringArray((Collection)args);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"toStringArray(...)");
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRecorderConfiguration(ArrayList<String> args, EventLogSendConfig config) {
        void $this$mapTo$iv$iv;
        String recorderIdLowerCase = Strings.toLowerCase((String)config.getRecorderId());
        this.addArgument(args, "--device-" + recorderIdLowerCase, config.getDeviceId());
        this.addArgument(args, "--bucket-" + recorderIdLowerCase, String.valueOf(config.getBucket()));
        this.addArgument(args, "--machine-" + recorderIdLowerCase, config.getMachineId().getId());
        this.addArgument(args, "--id-revision-" + recorderIdLowerCase, String.valueOf(config.getMachineId().getRevision()));
        Iterable $this$map$iv = config.getFilesToSendProvider().getFilesToSend();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EventLogFile eventLogFile = (EventLogFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        List filesToSend = (List)destination$iv$iv;
        String string = "--files-" + recorderIdLowerCase;
        Iterable iterable2 = filesToSend;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
        this.addArgument(args, string, CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null));
        this.addArgument(args, "--escape-" + recorderIdLowerCase, String.valueOf(config.isEscapingEnabled()));
    }

    private final void addArgument(ArrayList<String> args, String name, String value) {
        ((Collection)args).add(name);
        ((Collection)args).add(value);
    }

    private final String joinAsClasspath(List<String> libCopies, Path uploaderCopy) {
        if (libCopies.isEmpty()) {
            return ((Object)uploaderCopy).toString();
        }
        Iterable iterable = libCopies;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String libClassPath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        return libClassPath + File.pathSeparator + uploaderCopy;
    }

    private final Path findUploader() {
        Path uploader;
        if (PluginManagerCore.isRunningFromSources()) {
            String[] stringArray = new String[]{"out/artifacts/statistics-uploader.jar"};
            v0 = Paths.get(PathManager.getHomePath(), stringArray);
        } else {
            v0 = uploader = PathManager.getJarForClass(EventLogUploaderOptions.class);
        }
        if (uploader == null || !Files.isRegularFile(uploader, new LinkOption[0])) {
            throw new EventLogUploadException("Statistics. External uploader. Cannot find uploader jar", EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return uploader;
    }

    private final String findLibraryByClass(Class<?> clazz) {
        Path library = PathManager.getJarForClass(clazz);
        if (library == null || !Files.isRegularFile(library, new LinkOption[0])) {
            throw new EventLogUploadException("Statistics. External uploader. Cannot find jar for " + clazz, EventLogUploadException.EventLogUploadErrorType.NO_UPLOADER);
        }
        return ((Object)library).toString();
    }

    private final String findJavaHome() {
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }

    private final File getOrCreateTempDir() {
        File tempDir = this.getTempFile();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new EventLogUploadException("Statistics. External uploader. Cannot create temp directory: " + tempDir, EventLogUploadException.EventLogUploadErrorType.NO_TEMP_FOLDER);
        }
        return tempDir;
    }

    private final File getTempFile() {
        return new File(PathManager.getTempPath(), "statistics-uploader");
    }

    private static final CharSequence createExternalUploadCommand$lambda$0(EventLogSendConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRecorderId();
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

