/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0001\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u000b*\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0006H\u0007\u001a\u001c\u0010\r\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0001\u001a\"\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a(\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0006H\u0007\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u0001\u001a\u0014\u0010!\u001a\u00020\"*\u00020\u00012\b\b\u0002\u0010#\u001a\u00020\"\u001a\u0012\u0010$\u001a\u00020\u0001*\u00020\u00012\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0001*\u00020\u00012\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u000b*\u00020\u00012\u0006\u0010%\u001a\u00020\u0001\u001aF\u0010(\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)*\u00020\u00012'\u0010*\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00010,\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/\u0012\u0004\u0012\u0002H)0+H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100\u001ak\u0010(\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)*\u00020\u00012#\b\b\u00101\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00060+2'\u0010*\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00010,\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(/\u0012\u0004\u0012\u0002H)0+H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103\u001a1\u00104\u001a\b\u0012\u0004\u0012\u00020\u0001052!\u00101\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b-\u0012\b\b.\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00060+H\u0001\u001a\u000e\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u0001\u001a\f\u00108\u001a\u00020\u0011*\u00020\u0001H\u0007\u001a\f\u00109\u001a\u00020\u0006*\u00020\u0001H\u0007\u001a\f\u0010:\u001a\u00020\u0006*\u00020\u0001H\u0007\u001a\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0001H\u0007\u001a\u0014\u0010;\u001a\u00020\u0006*\u00020\u00012\u0006\u0010<\u001a\u00020\u0001H\u0007\u001a\f\u0010=\u001a\u00020\t*\u00020\u0001H\u0007\u001a\f\u0010>\u001a\u00020\u0001*\u00020\u0001H\u0007\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00018G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006?"}, d2={"createDirectories", "Ljava/nio/file/Path;", "createParentDirectories", "outputStream", "Ljava/io/OutputStream;", "append", "", "safeOutputStream", "inputStreamIfExists", "Ljava/io/InputStream;", "delete", "", "recursively", "deleteWithParentsIfEmpty", "root", "isFile", "systemIndependentPath", "", "getSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "readChars", "", "write", "data", "", "offset", "", "size", "charset", "Ljava/nio/charset/Charset;", "createParentDirs", "basicAttributesIfExists", "Ljava/nio/file/attribute/BasicFileAttributes;", "fileSizeSafe", "", "fallback", "move", "target", "copy", "copyRecursively", "directoryStreamIfExists", "R", "task", "Lkotlin/Function1;", "Ljava/nio/file/DirectoryStream;", "Lkotlin/ParameterName;", "name", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "filter", "path", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "makeFilter", "Ljava/nio/file/DirectoryStream$Filter;", "generateRandomPath", "parentDirectory", "readText", "exists", "isDirectory", "isAncestor", "child", "inputStream", "createFile", "intellij.platform.util.ex"})
@SourceDebugExtension(value={"SMAP\npath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 path.kt\ncom/intellij/util/io/PathKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class PathKt {
    @NotNull
    public static final Path createDirectories(@NotNull Path $this$createDirectories) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectories, (String)"<this>");
        Path path = NioFiles.createDirectories((Path)$this$createDirectories);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        return path;
    }

    @NotNull
    public static final Path createParentDirectories(@NotNull Path $this$createParentDirectories) {
        Intrinsics.checkNotNullParameter((Object)$this$createParentDirectories, (String)"<this>");
        Path path = NioFiles.createParentDirectories((Path)$this$createParentDirectories);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createParentDirectories(...)");
        return path;
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        Path path = $this$outputStream.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        if (append) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            OutputStream outputStream = Files.newOutputStream($this$outputStream, openOptionArray);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            return outputStream;
        }
        OutputStream outputStream = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        return outputStream;
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        Path path = $this$outputStream.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        OutputStream outputStream = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        return outputStream;
    }

    @NotNull
    public static final OutputStream safeOutputStream(@NotNull Path $this$safeOutputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$safeOutputStream, (String)"<this>");
        return (OutputStream)new SafeFileOutputStream(PathKt.createParentDirectories($this$safeOutputStream));
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $this$inputStreamIfExists) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)$this$inputStreamIfExists, (String)"<this>");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream2 = Files.newInputStream($this$inputStreamIfExists, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
            inputStream = inputStream2;
        }
        catch (NoSuchFileException noSuchFileException) {
            inputStream = null;
        }
        return inputStream;
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete, boolean recursively) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        if (recursively) {
            NioFiles.deleteRecursively((Path)$this$delete);
        } else {
            Files.delete($this$delete);
        }
    }

    public static /* synthetic */ void delete$default(Path path, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        PathKt.delete(path, bl);
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $this$deleteWithParentsIfEmpty, @NotNull Path root, boolean isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteWithParentsIfEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            PathKt.delete$default($this$deleteWithParentsIfEmpty, false, 1, null);
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
        for (Path parent = isFile ? $this$deleteWithParentsIfEmpty.getParent() : null; parent != null && !Intrinsics.areEqual((Object)parent, (Object)root); parent = parent.getParent()) {
            try {
                Files.delete(parent);
                continue;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path, path2, bl);
    }

    @ApiStatus.Obsolete
    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"<this>");
        return PathsKt.getInvariantSeparatorsPathString((Path)$this$systemIndependentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readChars(@NotNull Path $this$readChars) {
        Intrinsics.checkNotNullParameter((Object)$this$readChars, (String)"<this>");
        Closeable closeable = Files.newByteChannel($this$readChars, new OpenOption[0]);
        Throwable throwable = null;
        try {
            CharSequence charSequence;
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl = false;
            int size = (int)channel.size();
            Closeable closeable2 = Channels.newReader(channel, Charsets.UTF_8.newDecoder(), size);
            Throwable throwable2 = null;
            try {
                Reader reader = (Reader)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)reader);
                charSequence = IoKt.readCharSequence((Reader)reader, (int)size);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data, int offset, int size) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Path path = $this$write.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        Closeable closeable = Files.newOutputStream($this$write, new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(data, offset, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $this$write;
    }

    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull byte[] data) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Path path = $this$write.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        Files.write($this$write, data, new OpenOption[0]);
        return $this$write;
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data, @NotNull Charset charset, boolean createParentDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (createParentDirs) {
            Path path = $this$write.getParent();
            if (path != null) {
                PathKt.createDirectories(path);
            }
        }
        Files.writeString($this$write, data, charset, new OpenOption[0]);
        return $this$write;
    }

    public static /* synthetic */ Path write$default(Path path, CharSequence charSequence, Charset charset, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return PathKt.write(path, charSequence, charset, bl);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $this$basicAttributesIfExists) {
        BasicFileAttributes basicFileAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$basicAttributesIfExists, (String)"<this>");
        try {
            basicFileAttributes = Files.readAttributes($this$basicAttributesIfExists, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileSystemException fileSystemException) {
            basicFileAttributes = null;
        }
        return basicFileAttributes;
    }

    public static final long fileSizeSafe(@NotNull Path $this$fileSizeSafe, long fallback) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$fileSizeSafe, (String)"<this>");
        try {
            l = Files.size($this$fileSizeSafe);
        }
        catch (FileSystemException fileSystemException) {
            l = fallback;
        }
        return l;
    }

    public static /* synthetic */ long fileSizeSafe$default(Path path, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return PathKt.fileSizeSafe(path, l);
    }

    @NotNull
    public static final Path move(@NotNull Path $this$move, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$move, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = target.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path path2 = Files.move($this$move, target, copyOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"move(...)");
        return path2;
    }

    @NotNull
    public static final Path copy(@NotNull Path $this$copy, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = target.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path path2 = Files.copy($this$copy, target, copyOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"copy(...)");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursively(@NotNull Path $this$copyRecursively, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = target.getParent();
        if (path != null) {
            PathKt.createDirectories(path);
        }
        AutoCloseable autoCloseable = Files.walk($this$copyRecursively, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            stream.forEach(arg_0 -> PathKt.copyRecursively$lambda$0$1(arg_0 -> PathKt.copyRecursively$lambda$0$0(target, $this$copyRecursively, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"<this>");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Object object2;
            object = Files.newDirectoryStream($this$directoryStreamIfExists);
            Throwable throwable = null;
            try {
                object2 = task.invoke(object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $this$directoryStreamIfExists, @NotNull Function1<? super Path, Boolean> filter, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$directoryStreamIfExists, (String)"<this>");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Object object2;
            object = Files.newDirectoryStream($this$directoryStreamIfExists, PathKt.makeFilter(filter));
            Throwable throwable = null;
            try {
                object2 = task.invoke(object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        return (R)object;
    }

    @PublishedApi
    @NotNull
    public static final DirectoryStream.Filter<Path> makeFilter(@NotNull Function1<? super Path, Boolean> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return arg_0 -> PathKt.makeFilter$lambda$0(filter, arg_0);
    }

    @NotNull
    public static final Path generateRandomPath(@NotNull Path parentDirectory) throws IOException {
        LinkOption[] linkOptionArray;
        Path path;
        Intrinsics.checkNotNullParameter((Object)parentDirectory, (String)"parentDirectory");
        Path path2 = parentDirectory.resolve(UUID.randomUUID().toString());
        int i = 0;
        while (true) {
            path = path2;
            Intrinsics.checkNotNull((Object)path);
            linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || i >= 5) break;
            path2 = parentDirectory.resolve(UUID.randomUUID().toString());
            ++i;
        }
        path = path2;
        Intrinsics.checkNotNull((Object)path);
        linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Couldn't generate unique random path.");
        }
        path = path2;
        Intrinsics.checkNotNull((Object)path);
        return path;
    }

    @Deprecated(message="Use kotlin.io.path.readText", level=DeprecationLevel.ERROR)
    @NotNull
    public static final String readText(@NotNull Path $this$readText) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readText, (String)"<this>");
        return PathsKt.readText$default((Path)$this$readText, null, (int)1, null);
    }

    @Deprecated(message="Use kotlin.io.path.exists", level=DeprecationLevel.ERROR)
    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists($this$exists, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Deprecated(message="Use kotlin.io.path.isDirectory", level=DeprecationLevel.ERROR)
    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory($this$isDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Deprecated(message="Use kotlin.io.path.isRegularFile", level=DeprecationLevel.ERROR)
    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile($this$isFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    @Deprecated(message="Trivial, just inline", level=DeprecationLevel.ERROR)
    public static final boolean isAncestor(@NotNull Path $this$isAncestor, @NotNull Path child) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return child.startsWith($this$isAncestor);
    }

    @Deprecated(message="Use kotlin.io.path.inputStream", level=DeprecationLevel.ERROR)
    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$inputStream, (String)"<this>");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$inputStream, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    @Deprecated(message="Use `kotlin.io.path.createFile` with `com.intellij.util.io.createParentDirectories`", level=DeprecationLevel.ERROR)
    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createFile(PathKt.createParentDirectories($this$createFile), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createFile(...)");
        return path;
    }

    @JvmOverloads
    public static final void delete(@NotNull Path $this$delete) {
        Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"<this>");
        PathKt.delete$default($this$delete, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return PathKt.write$default($this$write, data, charset, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path write(@NotNull Path $this$write, @NotNull CharSequence data) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return PathKt.write$default($this$write, data, null, false, 6, null);
    }

    private static final Unit copyRecursively$lambda$0$0(Path $target, Path $this_copyRecursively, Path file) {
        Files.copy(file, $target.resolve($this_copyRecursively.relativize(file)), new CopyOption[0]);
        return Unit.INSTANCE;
    }

    private static final void copyRecursively$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean makeFilter$lambda$0(Function1 $filter, Path it) {
        Intrinsics.checkNotNull((Object)it);
        return (Boolean)$filter.invoke((Object)it);
    }
}

