/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStoreManager;
import com.intellij.credentialStore.ProviderType;
import com.intellij.openapi.util.SystemInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/CredentialStoreManagerImpl;", "Lcom/intellij/credentialStore/CredentialStoreManager;", "<init>", "()V", "isSupported", "", "provider", "Lcom/intellij/credentialStore/ProviderType;", "availableProviders", "", "defaultProvider", "intellij.platform.credentialStore"})
@ApiStatus.Internal
public class CredentialStoreManagerImpl
implements CredentialStoreManager {
    @Override
    public boolean isSupported(@NotNull ProviderType provider) {
        Intrinsics.checkNotNullParameter((Object)((Object)provider), (String)"provider");
        return provider == ProviderType.KEYCHAIN ? (SystemInfo.isLinux || SystemInfo.isMac) && this.availableProviders().contains((Object)provider) : this.availableProviders().contains((Object)provider);
    }

    @Override
    @NotNull
    public List<ProviderType> availableProviders() {
        ProviderType[] providerTypeArray = new ProviderType[]{ProviderType.MEMORY_ONLY, ProviderType.KEYCHAIN, ProviderType.KEEPASS};
        return CollectionsKt.listOf((Object[])providerTypeArray);
    }

    @Override
    @NotNull
    public ProviderType defaultProvider() {
        return SystemInfo.isWindows ? ProviderType.KEEPASS : ProviderType.KEYCHAIN;
    }
}

