/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.specialPaths;

import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/diagnostic/specialPaths/SpecialPathEntry;", "", "name", "", "originalPath", "kind", "Lcom/intellij/diagnostic/specialPaths/SpecialPathEntry$Kind;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/diagnostic/specialPaths/SpecialPathEntry$Kind;)V", "getName", "()Ljava/lang/String;", "getOriginalPath", "getKind", "()Lcom/intellij/diagnostic/specialPaths/SpecialPathEntry$Kind;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Kind", "intellij.platform.ide"})
@ApiStatus.Internal
public final class SpecialPathEntry {
    @NotNull
    private final String name;
    @NotNull
    private final String originalPath;
    @NotNull
    private final Kind kind;
    @Nullable
    private final Path path;

    public SpecialPathEntry(@NotNull String name, @NotNull String originalPath, @NotNull Kind kind) {
        Path path;
        SpecialPathEntry specialPathEntry;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.name = name;
        this.originalPath = originalPath;
        this.kind = kind;
        SpecialPathEntry specialPathEntry2 = this;
        try {
            specialPathEntry = specialPathEntry2;
            path = Path.of(FileUtil.toSystemDependentName((String)this.originalPath), new String[0]);
        }
        catch (Throwable throwable) {
            specialPathEntry = specialPathEntry2;
            path = null;
        }
        specialPathEntry.path = path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getOriginalPath() {
        return this.originalPath;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @Nullable
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.originalPath;
    }

    @NotNull
    public final Kind component3() {
        return this.kind;
    }

    @NotNull
    public final SpecialPathEntry copy(@NotNull String name, @NotNull String originalPath, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return new SpecialPathEntry(name, originalPath, kind);
    }

    public static /* synthetic */ SpecialPathEntry copy$default(SpecialPathEntry specialPathEntry, String string, String string2, Kind kind, int n, Object object) {
        if ((n & 1) != 0) {
            string = specialPathEntry.name;
        }
        if ((n & 2) != 0) {
            string2 = specialPathEntry.originalPath;
        }
        if ((n & 4) != 0) {
            kind = specialPathEntry.kind;
        }
        return specialPathEntry.copy(string, string2, kind);
    }

    @NotNull
    public String toString() {
        return "SpecialPathEntry(name=" + this.name + ", originalPath=" + this.originalPath + ", kind=" + this.kind + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.originalPath.hashCode();
        result2 = result2 * 31 + this.kind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpecialPathEntry)) {
            return false;
        }
        SpecialPathEntry specialPathEntry = (SpecialPathEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)specialPathEntry.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.originalPath, (Object)specialPathEntry.originalPath)) {
            return false;
        }
        return this.kind == specialPathEntry.kind;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/specialPaths/SpecialPathEntry$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "File", "Folder", "intellij.platform.ide"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind File = new Kind();
        public static final /* enum */ Kind Folder = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.File, Kind.Folder};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

