/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.EmptyIcon;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuickSwitchSchemeAction
extends AnAction
implements DumbAware {
    private static final Condition<? super AnAction> DEFAULT_PRESELECT_ACTION = a -> a.getTemplatePresentation().getIcon() != AllIcons.Actions.Forward;
    @ApiStatus.Internal
    public static final Icon ourNotCurrentAction = IconLoader.createLazy(() -> EmptyIcon.create((int)AllIcons.Actions.Forward.getIconWidth(), (int)AllIcons.Actions.Forward.getIconHeight()));
    protected String myActionPlace;
    private final boolean myShowPopupWithNoActions;

    protected QuickSwitchSchemeAction() {
        this(false);
    }

    protected QuickSwitchSchemeAction(boolean showPopupWithNoActions) {
        this.myShowPopupWithNoActions = showPopupWithNoActions;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillActions(project, group, e.getDataContext());
        this.showPopup(e, group);
    }

    protected abstract void fillActions(Project var1, @NotNull DefaultActionGroup var2, @NotNull DataContext var3);

    private void showPopup(AnActionEvent e, DefaultActionGroup group) {
        int count = group.getChildrenCount();
        if (!this.myShowPopupWithNoActions && count == 0) {
            return;
        }
        JBPopupFactory.ActionSelectionAid aid = this.getAidMethod();
        if (aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING && ((count = (int)Arrays.stream(group.getChildren(e)).filter(child -> !(child instanceof Separator)).count()) < 11 || count > 36)) {
            aid = JBPopupFactory.ActionSelectionAid.NUMBERING;
        }
        this.showPopup(e, this.createPopup(e, group, aid));
    }

    @ApiStatus.Internal
    @NotNull
    protected ListPopup createPopup(AnActionEvent e, DefaultActionGroup group, JBPopupFactory.ActionSelectionAid aid) {
        ListPopup popup2;
        ListPopup listPopup = popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.getPopupTitle(e), (ActionGroup)group, e.getDataContext(), aid, true, null, -1, this.preselectAction(), this.myActionPlace);
        if (listPopup == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @Nullable
    protected Condition<? super AnAction> preselectAction() {
        return DEFAULT_PRESELECT_ACTION;
    }

    protected void showPopup(AnActionEvent e, ListPopup popup2) {
        Project project = e.getProject();
        if (project != null) {
            popup2.showCenteredInCurrentWindow(project);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    protected JBPopupFactory.ActionSelectionAid getAidMethod() {
        return Registry.is((String)"ide.quick.switch.alpha.numbering", (boolean)false) ? JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING : JBPopupFactory.ActionSelectionAid.NUMBERING;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    protected String getPopupTitle(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(3);
        }
        return e.getPresentation().getText();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickSwitchSchemeAction.$$$reportNull$$$0(4);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.PROJECT) != null && this.isEnabled());
    }

    protected boolean isEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/QuickSwitchSchemeAction";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/QuickSwitchSchemeAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

