/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropActionHandler;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDSupportBuilder;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragSourceDropEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DnDSupport
implements DnDTarget,
DnDSource,
DnDDropHandler.WithResult,
Disposable {
    private final JComponent myComponent;
    private final Function<? super DnDActionInfo, ? extends DnDDragStartBean> myBeanProvider;
    private final Function<? super DnDActionInfo, ? extends DnDImage> myImageProvider;
    @Nullable
    private final DnDDropHandler.WithResult myHandler;
    @Nullable
    private final DnDTargetChecker myChecker;
    private final Runnable myDropEndedCallback;
    private final DnDDropActionHandler myDropActionHandler;
    private final Runnable myCleanUpCallback;
    private final boolean myAsTarget;
    private final boolean myAsSource;

    private DnDSupport(JComponent component, Function<? super DnDActionInfo, ? extends DnDDragStartBean> beanProvider, Function<? super DnDActionInfo, ? extends DnDImage> imageProvider, DnDDropHandler.WithResult handler, DnDTargetChecker checker, Runnable dropEndedCallback, Disposable parent, DnDDropActionHandler dropActionHandler, Runnable cleanUpCallback, boolean asTarget, boolean asSource, boolean asNativeTarget) {
        this.myComponent = component;
        this.myBeanProvider = beanProvider;
        this.myImageProvider = imageProvider;
        this.myHandler = handler;
        this.myChecker = checker;
        this.myDropEndedCallback = dropEndedCallback;
        this.myDropActionHandler = dropActionHandler;
        this.myCleanUpCallback = cleanUpCallback;
        this.myAsTarget = asTarget;
        this.myAsSource = asSource;
        if (this.myAsTarget) {
            DnDManager.getInstance().registerTarget((DnDTarget)(asNativeTarget ? new DnDNativeTargetWrapper(this) : this), this.myComponent);
        }
        if (this.myAsSource) {
            DnDManager.getInstance().registerSource(this, this.myComponent);
        }
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
    }

    public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            DnDSupport.$$$reportNull$$$0(0);
        }
        return this.myBeanProvider != null && this.myAsSource && this.myBeanProvider.fun((Object)new DnDActionInfo(action, dragOrigin)) != null;
    }

    public DnDDragStartBean startDragging(DnDAction action, @NotNull Point dragOrigin) {
        if (dragOrigin == null) {
            DnDSupport.$$$reportNull$$$0(1);
        }
        return (DnDDragStartBean)this.myBeanProvider.fun((Object)new DnDActionInfo(action, dragOrigin));
    }

    @Nullable
    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin, @NotNull DnDDragStartBean bean) {
        DnDImage image;
        if (bean == null) {
            DnDSupport.$$$reportNull$$$0(2);
        }
        if (this.myImageProvider != null && (image = (DnDImage)this.myImageProvider.fun((Object)new DnDActionInfo(action, dragOrigin))) != null) {
            Point point = image.getPoint();
            return Pair.create((Object)image.getImage(), (Object)(point == null ? dragOrigin : point));
        }
        return null;
    }

    public void dragDropEnd(@Nullable DnDEvent dragEvent, @Nullable DragSourceDropEvent dropEvent) {
        if (this.myDropEndedCallback != null) {
            this.myDropEndedCallback.run();
        }
    }

    public void dropActionChanged(int gestureModifiers) {
        if (this.myDropActionHandler != null) {
            this.myDropActionHandler.dropActionChanged(gestureModifiers);
        }
    }

    public boolean update(DnDEvent event) {
        if (this.myChecker == null) {
            event.setDropPossible(true);
            return false;
        }
        return this.myChecker.update(event);
    }

    public boolean tryDrop(DnDEvent aEvent) {
        return this.myHandler == null || this.myHandler.tryDrop(aEvent);
    }

    public void cleanUpOnLeave() {
        if (this.myCleanUpCallback != null) {
            this.myCleanUpCallback.run();
        }
    }

    public void dispose() {
        if (this.myAsSource) {
            DnDManager.getInstance().unregisterSource(this, this.myComponent);
        }
        if (this.myAsTarget) {
            DnDManager.getInstance().unregisterTarget(this, this.myComponent);
        }
    }

    @NotNull
    public static DnDSupportBuilder createBuilder(@NotNull JComponent component) {
        if (component == null) {
            DnDSupport.$$$reportNull$$$0(3);
        }
        final JComponent myComponent = component;
        final Ref asTarget = Ref.create((Object)true);
        final Ref asSource = Ref.create((Object)true);
        final Ref asNativeTarget = Ref.create((Object)false);
        final Ref imageProvider = Ref.create(null);
        final Ref beanProvider = Ref.create(null);
        final Ref dropEnded = Ref.create(null);
        final Ref disposable = Ref.create(null);
        final Ref dropHandler = Ref.create(null);
        final Ref targetChecker = Ref.create(null);
        final Ref dropActionHandler = Ref.create(null);
        final Ref cleanUp = Ref.create(null);
        return new DnDSupportBuilder(){

            @Override
            public DnDSupportBuilder disableAsTarget() {
                asTarget.set((Object)false);
                return this;
            }

            @Override
            public DnDSupportBuilder disableAsSource() {
                asSource.set((Object)false);
                return this;
            }

            @Override
            public DnDSupportBuilder enableAsNativeTarget() {
                asNativeTarget.set((Object)true);
                return this;
            }

            @Override
            public DnDSupportBuilder setImageProvider(Function<? super DnDActionInfo, ? extends DnDImage> fun) {
                imageProvider.set(fun);
                return this;
            }

            @Override
            public DnDSupportBuilder setBeanProvider(Function<? super DnDActionInfo, ? extends DnDDragStartBean> fun) {
                beanProvider.set(fun);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropHandler(DnDDropHandler handler) {
                return this.setDropHandlerWithResult(e -> {
                    WriteIntentReadAction.run(() -> handler.drop(e));
                    return true;
                });
            }

            @Override
            public DnDSupportBuilder setDropHandlerWithResult(DnDDropHandler.WithResult handler) {
                dropHandler.set((Object)handler);
                return this;
            }

            @Override
            public DnDSupportBuilder setTargetChecker(DnDTargetChecker checker) {
                targetChecker.set((Object)checker);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropActionHandler(DnDDropActionHandler handler) {
                dropActionHandler.set((Object)handler);
                return this;
            }

            @Override
            public DnDSupportBuilder setDisposableParent(Disposable parent) {
                disposable.set((Object)parent);
                return this;
            }

            @Override
            public DnDSupportBuilder setCleanUpOnLeaveCallback(Runnable callback) {
                cleanUp.set((Object)callback);
                return this;
            }

            @Override
            public DnDSupportBuilder setDropEndedCallback(Runnable callback) {
                dropEnded.set((Object)callback);
                return this;
            }

            @Override
            public void install() {
                new DnDSupport(myComponent, (Function<? super DnDActionInfo, ? extends DnDDragStartBean>)((Function)beanProvider.get()), (Function<? super DnDActionInfo, ? extends DnDImage>)((Function)imageProvider.get()), (DnDDropHandler.WithResult)dropHandler.get(), (DnDTargetChecker)targetChecker.get(), (Runnable)dropEnded.get(), (Disposable)disposable.get(), (DnDDropActionHandler)dropActionHandler.get(), (Runnable)cleanUp.get(), (Boolean)asTarget.get(), (Boolean)asSource.get(), (Boolean)asNativeTarget.get());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragOrigin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/dnd/DnDSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canStartDragging";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startDragging";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDraggedImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuilder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DnDNativeTargetWrapper
    implements DnDNativeTarget,
    DnDDropHandler.WithResult {
        @NotNull
        private final DnDSupport myTarget;

        private DnDNativeTargetWrapper(@NotNull DnDSupport target) {
            if (target == null) {
                DnDNativeTargetWrapper.$$$reportNull$$$0(0);
            }
            this.myTarget = target;
        }

        public void cleanUpOnLeave() {
            this.myTarget.cleanUpOnLeave();
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            this.myTarget.updateDraggedImage(image, dropPoint, imageOffset);
        }

        public boolean tryDrop(DnDEvent event) {
            return this.myTarget.tryDrop(event);
        }

        public boolean update(DnDEvent event) {
            return this.myTarget.update(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/dnd/DnDSupport$DnDNativeTargetWrapper", "<init>"));
        }
    }
}

