/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.BitUtil;
import java.util.ArrayList;
import javax.swing.KeyStroke;

public final class CommonShortcuts {
    public static final ShortcutSet ALT_ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 512));
    public static final ShortcutSet ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0));
    @Deprecated(forRemoval=true)
    public static final ShortcutSet CTRL_ENTER = new CustomShortcutSet(KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128));
    @Deprecated(forRemoval=true)
    public static final ShortcutSet INSERT = new CustomShortcutSet(CommonShortcuts.getInsertKeystroke());
    @Deprecated(forRemoval=true)
    public static final ShortcutSet DELETE = new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0));
    public static final ShortcutSet ESCAPE = new CustomShortcutSet(KeyStroke.getKeyStroke(27, 0));
    public static final ShortcutSet DOUBLE_CLICK_1 = new CustomShortcutSet(new Shortcut[]{new MouseShortcut(1, 0, 2)});
    public static final ShortcutSet MOVE_UP = CustomShortcutSet.fromString((String[])new String[]{"alt UP"});
    public static final ShortcutSet MOVE_DOWN = CustomShortcutSet.fromString((String[])new String[]{"alt DOWN"});

    private CommonShortcuts() {
    }

    public static ShortcutSet getNewForDialogs() {
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (Shortcut shortcut : CommonShortcuts.getNew().getShortcuts()) {
            if (CommonShortcuts.isCtrlEnter(shortcut)) continue;
            shortcuts.add(shortcut);
        }
        return new CustomShortcutSet(shortcuts.toArray(Shortcut.EMPTY_ARRAY));
    }

    private static boolean isCtrlEnter(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            KeyStroke keyStroke = ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            return keyStroke.getKeyCode() == 10 && BitUtil.isSet((int)keyStroke.getModifiers(), (int)2);
        }
        return false;
    }

    public static KeyStroke getInsertKeystroke() {
        return ClientSystemInfo.isMac() ? KeyStroke.getKeyStroke(78, 128) : KeyStroke.getKeyStroke(155, 0);
    }

    public static ShortcutSet getCopy() {
        return KeymapUtil.getActiveKeymapShortcuts("$Copy");
    }

    public static ShortcutSet getPaste() {
        return KeymapUtil.getActiveKeymapShortcuts("$Paste");
    }

    public static ShortcutSet getRerun() {
        return KeymapUtil.getActiveKeymapShortcuts("Rerun");
    }

    public static ShortcutSet getEditSource() {
        return KeymapUtil.getActiveKeymapShortcuts("EditSource");
    }

    public static ShortcutSet getViewSource() {
        return KeymapUtil.getActiveKeymapShortcuts("ViewSource");
    }

    public static ShortcutSet getNew() {
        return KeymapUtil.getActiveKeymapShortcuts("NewElement");
    }

    public static ShortcutSet getDuplicate() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorDuplicate");
    }

    public static ShortcutSet getMove() {
        return KeymapUtil.getActiveKeymapShortcuts("Move");
    }

    public static ShortcutSet getRename() {
        return KeymapUtil.getActiveKeymapShortcuts("RenameElement");
    }

    public static ShortcutSet getDiff() {
        return KeymapUtil.getActiveKeymapShortcuts("Diff.ShowDiff");
    }

    public static ShortcutSet getFind() {
        return KeymapUtil.getActiveKeymapShortcuts("Find");
    }

    public static ShortcutSet getContextHelp() {
        return KeymapUtil.getActiveKeymapShortcuts("ContextHelp");
    }

    public static ShortcutSet getCloseActiveWindow() {
        return KeymapUtil.getActiveKeymapShortcuts("CloseContent");
    }

    public static ShortcutSet getMoveUp() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorUp");
    }

    public static ShortcutSet getMoveDown() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorDown");
    }

    public static ShortcutSet getMovePageUp() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorPageUp");
    }

    public static ShortcutSet getMovePageDown() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorPageDown");
    }

    public static ShortcutSet getMoveHome() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorLineStart");
    }

    public static ShortcutSet getMoveEnd() {
        return KeymapUtil.getActiveKeymapShortcuts("EditorLineEnd");
    }

    public static ShortcutSet getRecentFiles() {
        return KeymapUtil.getActiveKeymapShortcuts("RecentFiles");
    }

    public static ShortcutSet getDelete() {
        return KeymapUtil.getActiveKeymapShortcuts("$Delete");
    }

    public static ShortcutSet getCtrlEnter() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(10, ClientSystemInfo.isMac() ? 256 : 128));
    }

    public static ShortcutSet getInsert() {
        return new CustomShortcutSet(CommonShortcuts.getInsertKeystroke());
    }
}

